/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import javax.naming.NamingException;
import oracle.jldif.util.LDIFLoadTool;
import oracle.jldif.util.UtilException;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.LDAP;
import oracle.opatch.opatchfafmw.LDIF;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.rb.RB;

final class DeployLDIF
implements Operation {
    DeployLDIF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(FMWContext c2) {
        boolean isError = false;
        String errorMsg = "";
        String name = "";
        try {
            LDAP lp = c2.getLDAPInformation();
            String host = lp.getHostName();
            int port = lp.getPort();
            String bindDN = lp.getBindDN();
            String password = lp.getPassword();
            boolean sslMode = lp.isSSLMode();
            LDIF lf = c2.getLDiff();
            Logger.logi(lp.toString());
            String filePath = lf.getPath();
            name = lf.getName();
            Logger.logi(lf.toString());
            try {
                LDIFLoadTool ltool = new LDIFLoadTool();
                ltool.loadLdifFile(host, port, bindDN, password, filePath, false);
            }
            catch (NamingException ne) {
                Logger.loge(ne);
                isError = true;
                errorMsg = ne.getMessage();
            }
            catch (UtilException ue) {
                Logger.loge((Exception)((Object)ue));
                isError = true;
                errorMsg = ue.getMessage();
            }
            catch (Throwable t) {
                RuntimeException fe = new RuntimeException(t.getMessage());
                fe.setStackTrace(t.getStackTrace());
                Logger.loge(fe);
                isError = true;
                errorMsg = fe.getMessage();
            }
            if (!isError) return;
        }
        catch (Throwable throwable) {
            if (!isError) throw throwable;
            Logger.error(RB.Entry.ERROR_IN_DEPLOYING_LDIF_DATA_FILE, name, errorMsg);
            throw throwable;
        }
        Logger.error(RB.Entry.ERROR_IN_DEPLOYING_LDIF_DATA_FILE, name, errorMsg);
    }
}

