/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.util.ArrayList;
import java.util.Set;
import oracle.opatch.OPatchException;
import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.FMWException;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchfafmw.rb.RB;
import oracle.opatch.opatchsdk.OPatchFAStep;

final class CheckServerLifeCycle
implements Operation {
    CheckServerLifeCycle() {
    }

    @Override
    public void run(FMWContext c2) {
        OPatchStepAdapter prereqStep = null;
        Set<String> servers = c2.getTargets().getTargets();
        ArrayList<String> list = null;
        StringBuffer buff = null;
        Domain d2 = c2.getDomain();
        try {
            d2.checkNMCredential();
        }
        catch (FMWException e2) {
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_NODE_MANAGER_CREDENTIALS);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check the credentials of the Node manager");
            prereqStep.setErrorMessage(e2.getMessage());
            prereqStep.setExceptionObject(new RuntimeException(e2));
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            throw e2;
        }
        if (Logger.debug) {
            Logger.debug("Running CheckServerLifeCycle for Servers " + servers.toString());
        }
        for (String server : servers) {
            try {
                d2.connectedToNM(server);
            }
            catch (OPatchException e3) {
                if (list == null) {
                    list = new ArrayList<String>(5);
                }
                list.add(server);
                if (buff == null) {
                    buff = new StringBuffer();
                }
                buff.append(e3.getMessage() + "\n");
            }
        }
        if (list != null) {
            String errorMsg = Logger.getString(RB.Entry.CHECK_SERVER_LIFE_CYCLE_FAILED, ((Object)list).toString(), buff.toString(), c2.getLogFileLocation());
            prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_SERVER_STATE_FROM_NODE_MANAGER);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Check Server state from Node Manager \"" + ((Object)list).toString() + "\"");
            prereqStep.setErrorMessage(errorMsg);
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            Logger.error(RB.Entry.CHECK_SERVER_LIFE_CYCLE_FAILED, ((Object)list).toString(), buff.toString(), c2.getLogFileLocation());
        }
    }
}

