/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchfafmw;

import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import oracle.as.biapps.patch.framework.opatch.OpatchEntryPoint;
import oracle.opatch.opatchfafmw.BIP;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.Logger;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.Operation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.wrappers.WrapperFactory;

final class CheckBIPDeploy
implements Operation {
    CheckBIPDeploy() {
    }

    @Override
    public void run(FMWContext c2) {
        String oh = c2.getOracleHome();
        String patchLoc = c2.getPatchLocation();
        String patchID = c2.getPatchID();
        String[] copyListRelativeToOracleHome = new String[c2.getBIP().size()];
        String biHome = "";
        Logger.logi("[BIP] BIP Deploy List to prereq: ");
        int count = 0;
        for (BIP bi : c2.getBIP()) {
            copyListRelativeToOracleHome[count] = bi.getRelativePath();
            biHome = bi.getBIHome();
            Logger.logi(bi.toString());
            ++count;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            Logger.logi("Copy path relative to OH: " + copyListRelativeToOracleHome[i2]);
        }
        Logger.logi("[BIP] Oracle home : " + oh);
        Logger.logi("[BIP] Patch archive root : " + patchLoc);
        Logger.logi("[BIP] Patch ID : " + patchID);
        Properties p2 = c2.getInterviewProperties();
        if (p2 == null) {
            Logger.logi("[BIP] Since property object is null, there are no interview elements defined in automation.xml");
        }
        Path oracleHome = WrapperFactory.getNioServiceWrapper().getPath(oh, new String[0]);
        Path explodedPatchArchiveRoot = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]);
        Path biHomeObj = WrapperFactory.getNioServiceWrapper().getPath(biHome, new String[0]);
        try {
            OpatchEntryPoint.checkDeploymentCanProceed((File)biHomeObj.toFile(), (File)explodedPatchArchiveRoot.toFile(), (String[])copyListRelativeToOracleHome, (String)patchID, (Properties)p2);
        }
        catch (Throwable t) {
            String errorMsg = "";
            if (t instanceof ClassNotFoundException || t instanceof NoClassDefFoundError) {
                errorMsg = "Class \"" + t.getMessage() + "\" is not found. Please check if runtime classpaths are properly set.";
            }
            Logger.logi("[BIP DEPLOY PREREQ ERROR] " + t.getMessage());
            OPatchStepAdapter prereqStep = new OPatchStepAdapter(OPatchFAStep.CHECK_BIP_DEPLOYMENT_CAN_PROCEED);
            RuntimeException re = new RuntimeException(t);
            prereqStep.setSuccess(false);
            prereqStep.setStepDescription("Prereq to check if BIP deploy can be done.");
            prereqStep.setErrorMessage(re.getMessage() + errorMsg);
            prereqStep.setExceptionObject(re);
            c2.getContextBuilder().setFailedPrereqStep(prereqStep);
            Logger.loge(re);
            throw re;
        }
    }
}

