/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchext;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import oracle.opatch.opatchlogger.OLogger;

public class SecurePrompter {
    public static final char[] readResponse(String prompt) {
        return SecurePrompter.readResponse(prompt, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final char[] readResponse(String prompt, String defaultVal, boolean isVisible) throws RuntimeException {
        try {
            String promptStr = ":> ";
            if (defaultVal != null) {
                promptStr = "(" + defaultVal + "):> ";
            }
            if (isVisible) {
                OLogger.printOnConsole(prompt + promptStr);
                BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
                String output = stdin.readLine();
                if (output.equals("") && defaultVal != null) {
                    output = defaultVal;
                }
                OLogger.justlog(OLogger.INFO, prompt + promptStr + output);
                return output.toCharArray();
            }
            StreamMasker masker = new StreamMasker(System.out, prompt + promptStr);
            Thread threadMasking = new Thread(masker);
            int firstByte = -1;
            PushbackInputStream inStream = null;
            try {
                threadMasking.start();
                inStream = new PushbackInputStream(System.in);
                firstByte = inStream.read();
            }
            finally {
                masker.stopMasking();
            }
            try {
                threadMasking.join();
            }
            catch (InterruptedException e2) {
                throw new RuntimeException("Interrupt occurred when reading information");
            }
            if (firstByte == -1) {
                throw new RuntimeException("Console input ended unexpectedly");
            }
            if (System.out.checkError()) {
                throw new RuntimeException("Console password prompt output error");
            }
            inStream.unread(firstByte);
            char[] inPut = SecurePrompter.readLineSecure(inStream);
            if (inPut == null || inPut.length == 0) {
                return defaultVal != null ? defaultVal.toCharArray() : null;
            }
            return inPut;
        }
        catch (IOException e3) {
            throw new RuntimeException("I/O error occurred when reading console response.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final char[] readLineSecure(PushbackInputStream inStream) throws RuntimeException {
        char[] cArray;
        block12: {
            if (inStream == null) {
                throw new RuntimeException("readLineSecure inStream is null");
            }
            char[] buffer = null;
            try {
                buffer = new char[128];
                int offset = 0;
                block9: while (true) {
                    int c2 = inStream.read();
                    switch (c2) {
                        case -1: 
                        case 10: {
                            break block9;
                        }
                        case 13: {
                            int c22 = inStream.read();
                            if (c22 == 10 || c22 == -1) break block9;
                            inStream.unread(c22);
                            break block9;
                        }
                        default: {
                            buffer = SecurePrompter.checkBuffer(buffer, offset);
                            buffer[offset++] = (char)c2;
                            continue block9;
                        }
                    }
                    break;
                }
                char[] result = new char[offset];
                System.arraycopy(buffer, 0, result, 0, offset);
                cArray = result;
                if (buffer == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (buffer != null) {
                        Arrays.fill(buffer, ' ');
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new RuntimeException("I/O error occurred when reading password");
                }
            }
            Arrays.fill(buffer, ' ');
        }
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final char[] checkBuffer(char[] buffer, int offset) throws RuntimeException {
        if (buffer == null) {
            throw new RuntimeException("checkBuffer buffer is null");
        }
        if (offset < 0) {
            throw new RuntimeException("checkBuffer offset is negative");
        }
        if (offset < buffer.length) {
            return buffer;
        }
        try {
            char[] bufferNew = new char[offset + 128];
            System.arraycopy(buffer, 0, bufferNew, 0, buffer.length);
            char[] cArray = bufferNew;
            return cArray;
        }
        finally {
            Arrays.fill(buffer, ' ');
        }
    }

    private static final class StreamMasker
    extends Thread {
        private static final String BLANKS = StreamMasker.repeatChars(' ', 10);
        private String m_promptOverwrite;
        private String m_setCursorToStart;
        private volatile boolean m_doMasking;

        public StreamMasker(PrintStream outPrint, String prompt) throws RuntimeException {
            if (outPrint == null) {
                throw new RuntimeException("StreamMasker outPrint is null");
            }
            if (prompt == null) {
                throw new RuntimeException("StreamMasker prompt is null");
            }
            if (prompt.indexOf(13) != -1) {
                throw new RuntimeException("StreamMasker prompt contains a CR");
            }
            if (prompt.indexOf(10) != -1) {
                throw new RuntimeException("StreamMasker prompt contains a NL");
            }
            OLogger.justlog(OLogger.INFO, prompt);
            this.m_setCursorToStart = StreamMasker.repeatChars('\b', prompt.length() + BLANKS.length());
            this.m_promptOverwrite = this.m_setCursorToStart + prompt + BLANKS + this.m_setCursorToStart + prompt;
        }

        @Override
        public void run() throws RuntimeException {
            int priorityOriginal = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.m_doMasking = true;
                while (this.m_doMasking) {
                    OLogger.printOnConsole(this.m_promptOverwrite);
                    if (System.out.checkError()) {
                        throw new RuntimeException("Console output error writing prompt");
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priorityOriginal);
                        return;
                    }
                }
                OLogger.printOnConsole(this.m_setCursorToStart);
            }
            finally {
                Thread.currentThread().setPriority(priorityOriginal);
            }
        }

        public void stopMasking() {
            this.m_doMasking = false;
        }

        private static String repeatChars(char c2, int length) throws RuntimeException {
            if (length < 0) {
                throw new RuntimeException("repeatChars length is negative");
            }
            StringBuffer sb = new StringBuffer(length);
            for (int i2 = 0; i2 < length; ++i2) {
                sb.append(c2);
            }
            return sb.toString();
        }
    }
}

