/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchactions;

import java.io.File;
import java.util.ArrayList;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObjectUtil;

public class configfileAction
extends PatchAction {
    String configFileName;
    String configComponentType;
    String configServiceName;
    String configDocType;

    public configfileAction(PatchComponent pc, ArrayList argNames, ArrayList argValues, Integer lineNumber) throws NullPointerException, Exception, RuntimeException {
        super(pc, lineNumber);
        String fileName = null;
        String compType = null;
        String serviceName = null;
        String docType = null;
        if (argNames.size() != argValues.size()) {
            throw new RuntimeException("Unknown arguments passed for configfileAction");
        }
        for (int i2 = 0; i2 < argNames.size(); ++i2) {
            String arg = (String)argNames.get(i2);
            String val = (String)argValues.get(i2);
            if (arg.equals("file_name")) {
                fileName = val;
            }
            if (arg.equals("component_type")) {
                compType = val;
            }
            if (arg.equals("service_name")) {
                serviceName = val;
            }
            if (!arg.equals("document_type")) continue;
            docType = val;
        }
        if (fileName == null || compType == null || serviceName == null || docType == null) {
            String errMsg = "The config file action is null";
            if (fileName == null) {
                errMsg = errMsg + "The file name is null";
            }
            if (compType == null) {
                errMsg = errMsg + "The component type is null";
            }
            if (serviceName == null) {
                errMsg = errMsg + "The service name is null";
            }
            if (docType == null) {
                errMsg = errMsg + "The document type is null ";
            }
            NullPointerException ne = new NullPointerException(errMsg);
            throw ne;
        }
        this.configFileName = PatchObjectUtil.getPlatformDependentPath(fileName);
        this.configComponentType = compType;
        this.configServiceName = serviceName;
        this.configDocType = docType;
    }

    @Override
    public String getChildPath() {
        return this.configFileName;
    }

    @Override
    public String getParentFilePath(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append(this.configFileName);
        return buff.toString();
    }

    @Override
    public String getActionName() {
        return "configfileAction";
    }

    @Override
    public String getActionDesc() {
        return "Update the MAS configuration with the given file.";
    }

    @Override
    public boolean isNewFile(String oracleHomePath, String cookedPatchID, boolean beforeApply) {
        return true;
    }

    public String getFileName() {
        return this.configFileName;
    }

    public String getDocumentType() {
        return this.configDocType;
    }

    public String getServiceName() {
        return this.configServiceName;
    }

    public String getComponentType() {
        return this.configComponentType;
    }
}

