/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.nio;

import java.util.Objects;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;

public class CommitAbortWrapper {
    private String commandName;
    private int exitCode = 254;
    private boolean manualClose = false;
    private static final String[] commitCommandNameArray = new String[]{"apply", "napply", "rollback", "nrollback"};

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(int exitCode) {
        this.exitCode = exitCode;
    }

    public boolean isManualClose() {
        return this.manualClose;
    }

    public void setManualClose(boolean manualClose) {
        this.manualClose = manualClose;
    }

    public void reset() {
        this.commandName = null;
        this.exitCode = 254;
        this.manualClose = false;
    }

    public String toString() {
        boolean isCommit = this.isCommitCommand() && !OPatchEnv.isReport() && (this.exitCode == 0 || this.exitCode == 8 || this.manualClose);
        String commitLog = isCommit ? "Commit delta changes to cas repo" : "Skip committing delta changes to cas repo";
        OLogger.justlog(OLogger.INFO, commitLog);
        boolean isAbort = !isCommit;
        return String.valueOf(isAbort);
    }

    public boolean isCommitCommand() {
        for (String name : commitCommandNameArray) {
            if (!Objects.equals(name, this.commandName)) continue;
            return true;
        }
        return false;
    }
}

