/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchutil.OPatchUtilHelper;

public class RebuildComposite {
    private NApplyData data;
    private OneOffEntry[] patchesToApply;

    public RebuildComposite(NApplyData data) {
        this.data = data;
    }

    public void getFinal(String oracleHomePath, NApplyData data) {
        this.rebuild(oracleHomePath, data);
        this.getFinalList(data);
    }

    public void rebuild(String oracleHomePath, NApplyData data) {
        OneOffEntry[] apOneOffs = data.getApOneOffs();
        OneOffEntry[] compositeSubArray = data.getCompositeSubArray();
        this.patchesToApply = data.getPatchesToApply();
        try {
            StringBuffer buff = new StringBuffer("Get the patch objects and the patch locs of each patch to be applied.");
            OLogger.debug(buff);
            if (data.isComposite()) {
                int l2;
                ArrayList<OneOffEntry> oneOffsToGo = new ArrayList<OneOffEntry>();
                for (l2 = 0; l2 < this.patchesToApply.length; ++l2) {
                    if (this.patchesToApply[l2].getIsComposite()) continue;
                    oneOffsToGo.add(this.patchesToApply[l2]);
                }
                this.patchesToApply = new OneOffEntry[oneOffsToGo.size() + compositeSubArray.length];
                apOneOffs = new OneOffEntry[this.patchesToApply.length];
                for (l2 = 0; l2 < compositeSubArray.length; ++l2) {
                    this.patchesToApply[l2] = compositeSubArray[l2];
                    apOneOffs[l2] = this.patchesToApply[l2];
                }
                for (l2 = 0; l2 < oneOffsToGo.size(); ++l2) {
                    this.patchesToApply[l2 + compositeSubArray.length] = (OneOffEntry)oneOffsToGo.get(l2);
                    apOneOffs[l2 + compositeSubArray.length] = this.patchesToApply[l2 + compositeSubArray.length];
                }
            }
            PatchObject[] apPatchObjects = OPatchUtilHelper.getPatchesToApply(oracleHomePath, this.patchesToApply, "NApply");
            apPatchObjects = OPatchSessionHelper.sortOnOverlay(apPatchObjects, true);
            data.setApOneOffs(apOneOffs);
            data.setApPatchObjects(apPatchObjects);
            data.setPatchesToApply(this.patchesToApply);
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public void getFinalList(NApplyData data) {
        StringBuffer myFinalList = new StringBuffer("  ");
        PatchObject[] apPatchObjects = data.getApPatchObjects();
        for (int i2 = 0; i2 < apPatchObjects.length; ++i2) {
            PatchObject po = apPatchObjects[i2];
            if (po == null) {
                StringBuffer buff = new StringBuffer("NApply: PatchObject is Null.");
                throw new RuntimeException(buff.toString());
            }
            myFinalList.append(po.getPatchID());
            myFinalList.append("  ");
        }
        data.setFinalList(myFinalList.toString());
    }
}

