/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import oracle.opatch.Bug;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.napplyhelper.BuildComposite;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.opatchlogger.OLogger;

public class PrintApplyReport {
    private NApplyData data;

    public PrintApplyReport(NApplyData data) {
        this.data = data;
    }

    public void printAppliedPatches(NApplyData data) {
        BuildComposite bc = new BuildComposite(data);
        bc.checkComposite(data);
        if (data.isComposite()) {
            OLogger.println("Composite patch " + data.getActivePatch() + " successfully applied.");
        }
        OneOffEntry[] apOneOffs = data.getApOneOffs();
        OneOffEntry[] nonCompositeSubArray = new OneOffEntry[apOneOffs.length];
        ArrayList<OneOffEntry> nonComposites = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < apOneOffs.length; ++i2) {
            if (apOneOffs[i2].getIsComposite()) continue;
            nonComposites.add(apOneOffs[i2]);
        }
        nonCompositeSubArray = new OneOffEntry[nonComposites.size()];
        nonComposites.toArray(nonCompositeSubArray);
        if (nonCompositeSubArray.length > 0) {
            String listOfPatches = "";
            for (int i3 = 0; i3 < nonCompositeSubArray.length - 1; ++i3) {
                listOfPatches = listOfPatches + nonCompositeSubArray[i3].getID() + ",";
            }
            listOfPatches = listOfPatches + nonCompositeSubArray[nonCompositeSubArray.length - 1].getID();
            String patchString = "";
            patchString = nonCompositeSubArray.length == 1 ? "Patch " : "Patches ";
            if (OPatchEnv.isRLibSuccess()) {
                OLogger.println(patchString + listOfPatches + " successfully applied.");
            }
        }
    }

    public void printBugsReport(NApplyData data) {
        OneOffEntry[] before = data.getBeforePohs();
        OneOffEntry[] after = data.getAfterPohs();
        HashSet bugsBefore = this.getAllBugs(before);
        bugsBefore.addAll(this.getAllBugs(data.getArbPatchObjects()));
        HashSet bugsAfter = this.getAllBugs(after);
        boolean safe = bugsAfter.containsAll(bugsBefore);
        if (safe) {
            OLogger.println("N-Apply process is complete. No bug fixes are lost.");
        } else {
            HashSet lost = new HashSet();
            lost.addAll(bugsBefore);
            lost.removeAll(bugsAfter);
            StringBuffer buff = new StringBuffer("");
            Iterator iterator = lost.iterator();
            while (iterator.hasNext()) {
                buff.append((String)iterator.next());
                buff.append(" ");
            }
            OLogger.println("N-Apply process is complete. Bugs [ " + buff.toString() + " ] are lost. Please verify and re-run.");
        }
    }

    private HashSet getAllBugs(OneOffEntry[] Pohs) {
        HashSet<String> bugs = new HashSet<String>();
        for (OneOffEntry poh : Pohs) {
            for (String str : poh.getBugIDsFixed()) {
                bugs.add(str);
            }
        }
        return bugs;
    }

    private HashSet getAllBugs(PatchObject[] patches) {
        HashSet<String> bugs = new HashSet<String>();
        for (PatchObject ph : patches) {
            for (Bug b2 : ph.getBugsToFix()) {
                bugs.add(b2.getBugID());
            }
        }
        return bugs;
    }
}

