/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.wrappers.WrapperFactory;

public class NApplyDataSerializer {
    public void serializeFileVersion(String serialFilePath, Map<String, String> FV) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.appendFileName(serialFilePath, buffer);
        for (String filename : FV.keySet()) {
            String escapedFilename = new String(filename.replace(" ", "\\ "));
            buffer.append(escapedFilename);
            buffer.append("=");
            buffer.append(FV.get(filename));
            buffer.append("\n");
        }
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    private void appendFileName(String serialFilePath, StringBuffer buffer) {
        String fileName = serialFilePath.substring(serialFilePath.lastIndexOf(File.separator) + 1);
        buffer.append("fv_file_name");
        buffer.append("=");
        buffer.append(fileName);
        buffer.append("\n");
    }

    public void serializeFileVersionList(String serialFilePath, Map<String, List<String>> FV) throws IOException {
        StringBuffer buffer = new StringBuffer();
        this.appendFileName(serialFilePath, buffer);
        for (String filename : FV.keySet()) {
            String escapedFilename = new String(filename.replace(" ", "\\ "));
            List<String> verionList = FV.get(filename);
            if (verionList.isEmpty()) continue;
            StringBuilder verBuff = new StringBuilder();
            for (int i2 = 0; i2 < verionList.size(); ++i2) {
                verBuff.append(verionList.get(i2));
                if (i2 == verionList.size() - 1) continue;
                verBuff.append(",");
            }
            buffer.append(escapedFilename);
            buffer.append("=");
            buffer.append(verBuff.toString());
            buffer.append("\n");
        }
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    public void serializeUnzipActionLoc(String serialFilePath, Map<String, String> fileMap) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (String hash : fileMap.keySet()) {
            String escapedFilename = new String(hash.replace(" ", "\\ "));
            String fileName = fileMap.get(hash);
            if (OPatchEnv.isWindows()) {
                fileName = fileName.replace(File.separator, "\\\\");
            }
            buffer.append(escapedFilename);
            buffer.append("=");
            buffer.append(fileName);
            buffer.append("\n");
        }
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
        writer.write(buffer.toString());
        writer.close();
    }

    public void serializeUnchangedFile(String serialFilePath, Map<String, Boolean> fileMap) throws IOException {
        StringBuffer buffer = new StringBuffer();
        Set<Map.Entry<String, Boolean>> entrySet = fileMap.entrySet();
        for (Map.Entry<String, Boolean> entry : entrySet) {
            String fileName = entry.getKey();
            if (OPatchEnv.isWindows()) {
                fileName = fileName.replace(File.separator, "\\\\");
            }
            buffer.append(fileName);
            buffer.append("=");
            buffer.append(fileMap.get(entry.getKey()));
            buffer.append("\n");
        }
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.flush();
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> deserializeFileVersion(String serialFilePath) throws IOException {
        HashMap<String, String> FV = new HashMap<String, String>();
        InputStream fis = null;
        Properties prop = new Properties();
        try {
            fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), new OpenOption[0]);
            prop.load(fis);
            for (Object filename : prop.keySet()) {
                if ("fv_file_name".equals(filename)) continue;
                String version = prop.getProperty((String)filename);
                FV.put((String)filename, version);
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return FV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, List<String>> deserializeFileVersionList(String serialFilePath) throws IOException {
        HashMap<String, List<String>> FV = new HashMap<String, List<String>>();
        InputStream fis = null;
        Properties prop = new Properties();
        try {
            fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), new OpenOption[0]);
            prop.load(fis);
            for (Object filename : prop.keySet()) {
                if ("fv_file_name".equals(filename)) continue;
                String versionStr = prop.getProperty((String)filename);
                String[] versions = versionStr.split(",");
                List<String> versionList = Arrays.asList(versions);
                FV.put((String)filename, versionList);
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return FV;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> deserializeUnzipActionLoc(String serialFilePath) throws IOException {
        HashMap<String, String> fileMap = new HashMap<String, String>();
        InputStream fis = null;
        Properties prop = new Properties();
        try {
            fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), new OpenOption[0]);
            prop.load(fis);
            for (Object filename : prop.keySet()) {
                String version = prop.getProperty((String)filename);
                fileMap.put((String)filename, version);
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return fileMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Boolean> deserializeUnchangedFile(String serialFilePath) throws IOException {
        HashMap<String, Boolean> fileMap = new HashMap<String, Boolean>();
        InputStream fis = null;
        Properties prop = new Properties();
        try {
            Path serialPath = WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]);
            if (!serialFilePath.equals("") && Files.exists(serialPath, new LinkOption[0])) {
                fis = Files.newInputStream(serialPath, new OpenOption[0]);
                prop.load(fis);
                for (Object filename : prop.keySet()) {
                    Boolean flag = Boolean.parseBoolean(prop.getProperty((String)filename));
                    fileMap.put((String)filename, flag);
                }
            } else {
                OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return fileMap;
    }

    public void serializePrereqResult(String serialFilePath, HashMap PR) throws IOException {
        StringBuilder buffer = new StringBuilder(512);
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        for (Object prereqname : PR.keySet()) {
            String sep;
            OPatchPatchPrereq pr = (OPatchPatchPrereq)prereqname;
            String pValue = String.valueOf(pr.getValue());
            OPatchTarget.StatusCheck sc = (OPatchTarget.StatusCheck)PR.get(pr);
            String rStatus = String.valueOf(sc.getStatusCode());
            String rResult = sc.getResult();
            if (rResult.contains(sep = System.getProperty("line.separator"))) {
                StringBuilder rResultBuilder = new StringBuilder();
                String[] rResultLines = rResult.split("\\r?\\n");
                for (int i2 = 0; i2 < rResultLines.length - 1; ++i2) {
                    rResultBuilder.append(rResultLines[i2]);
                    rResultBuilder.append("\\n");
                }
                rResultBuilder.append(rResultLines[rResultLines.length - 1]);
                rResult = rResultBuilder.toString();
                if (buffer.length() > 0) {
                    writer.write(buffer.toString());
                    buffer.setLength(0);
                }
                writer.write(pValue + "=" + rStatus + ";" + rResult + "\n");
                continue;
            }
            buffer.append(pValue);
            buffer.append("=");
            buffer.append(rStatus);
            buffer.append(";");
            buffer.append(rResult);
            buffer.append("\n");
        }
        if (buffer.length() > 0) {
            writer.write(buffer.toString());
            writer.flush();
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap deserializePrereqResult(String serialFilePath) throws IOException {
        HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck> PR = new HashMap<OPatchPatchPrereq, OPatchTarget.StatusCheck>();
        Properties prop = new Properties();
        InputStream fis = null;
        try {
            fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), new OpenOption[0]);
            prop.load(fis);
            for (Object prereqname : prop.keySet()) {
                int pValue = Integer.parseInt((String)prereqname);
                if (pValue < 0 || pValue > 42) {
                    HashMap hashMap = null;
                    return hashMap;
                }
                OPatchPatchPrereq prereq = OPatchPatchPrereq.getInstance((int)pValue);
                String[] results = prop.getProperty((String)prereqname).split(";");
                int rStatus = Integer.parseInt(results[0]);
                String rResult = results[1];
                OPatchTarget.StatusCheck sc = new OPatchTarget.StatusCheck(rStatus, rResult);
                PR.put(prereq, sc);
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return PR;
    }

    public void serializeHashValue(String serialFilePath, IndexPair hash) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Poh_hash=");
        buffer.append(hash.getFirstKey());
        buffer.append("\n");
        buffer.append("Pi_hash=");
        buffer.append(hash.getSecondKey());
        buffer.append("\n");
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexPair deserializeHashValue(String serialFilePath) throws IOException {
        Path p2 = WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]);
        if (!Files.exists(p2, new LinkOption[0])) {
            return null;
        }
        IndexPair hash = null;
        Properties prop = new Properties();
        InputStream fis = null;
        try {
            fis = Files.newInputStream(p2, new OpenOption[0]);
            prop.load(fis);
            hash = new IndexPair(prop.getProperty("Poh_hash"), prop.getProperty("Pi_hash"));
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return hash;
    }

    public void serializeOhHashValue(String serialFilePath, String hash) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Poh_hash=");
        buffer.append(hash);
        buffer.append("\n");
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deserializeOhHashValue(String serialFilePath) throws IOException {
        Path p2 = WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]);
        if (!Files.exists(p2, new LinkOption[0])) {
            return null;
        }
        String hash = null;
        Properties prop = new Properties();
        InputStream fis = null;
        try {
            fis = Files.newInputStream(p2, new OpenOption[0]);
            prop.load(fis);
            hash = prop.getProperty("Poh_hash");
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return hash;
    }

    public void serializeNoOpCheckResult(String serialFilePath, Vector noOps) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("noOp_oneoffs=");
        for (int i2 = 0; i2 < noOps.size(); ++i2) {
            String noopPatchID = (String)noOps.get(i2);
            buffer.append(noopPatchID);
            buffer.append(";");
        }
        buffer.append("\n");
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] deserializeNoOpCheckResult(String serialFilePath) throws IOException {
        Properties prop = new Properties();
        InputStream fis = null;
        String[] noopPatchIDs = new String[]{};
        try {
            fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), new OpenOption[0]);
            prop.load(fis);
            noopPatchIDs = prop.getProperty("noOp_oneoffs").split(";");
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return noopPatchIDs;
    }

    public void serializePiComponents(String serialFilePath, HashSet<IndexPair> comps) throws IOException {
        StringBuffer buffer = new StringBuffer();
        for (IndexPair comp : comps) {
            buffer.append(comp.getFirstKey());
            buffer.append("=");
            buffer.append(comp.getSecondKey());
            buffer.append("\n");
        }
        buffer.append("\n");
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet<IndexPair> deserializePiComponents(String serialFilePath) throws IOException {
        Properties prop = new Properties();
        InputStream fis = null;
        HashSet<IndexPair> comps = new HashSet<IndexPair>();
        try {
            fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), new OpenOption[0]);
            prop.load(fis);
            for (Object compName : prop.keySet()) {
                String compVer = prop.getProperty((String)compName);
                IndexPair nameVer = new IndexPair((String)compName, compVer);
                comps.add(nameVer);
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return comps;
    }

    public void serializeTime(String serialFilePath) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("start_time=");
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
        String formattedDate = dateFormatter.format(new Date());
        buffer.append(formattedDate);
        buffer.append("\n");
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date deserializeTime(String serialFilePath) throws IOException {
        Properties prop = new Properties();
        InputStream fis = null;
        Date date = null;
        try {
            fis = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), new OpenOption[0]);
            prop.load(fis);
            String s = prop.getProperty("start_time");
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa");
            try {
                date = dateFormatter.parse(s);
            }
            catch (ParseException e2) {
                e2.printStackTrace();
                Date date2 = null;
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
                return date2;
            }
        }
        catch (FileNotFoundException e4) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e5) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e5);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e6) {
                    e6.printStackTrace();
                }
            }
        }
        return date;
    }

    public void serializeBackUpStatus(String serialFilePath, String s) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("do_backup=");
        buffer.append(s);
        buffer.append("\n");
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deserializeBackUpStatus(String serialFilePath) throws IOException {
        Path p2 = WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]);
        if (!Files.exists(p2, new LinkOption[0])) {
            return false;
        }
        Properties prop = new Properties();
        InputStream fis = null;
        try {
            fis = Files.newInputStream(p2, new OpenOption[0]);
            prop.load(fis);
            String s = prop.getProperty("do_backup");
            if (s.equals("true")) {
                boolean bl = true;
                return bl;
            }
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return false;
    }

    public void renameCachedFiles(String oldFilePath, String newFilePath) {
        Path nf = WrapperFactory.getNioServiceWrapper().getPath(newFilePath, new String[0]);
        Path of = WrapperFactory.getNioServiceWrapper().getPath(oldFilePath, new String[0]);
        try {
            Files.move(of, nf, new CopyOption[0]);
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
    }

    public void removeCachedFiles(String FilePath) {
        Path p2 = WrapperFactory.getNioServiceWrapper().getPath(FilePath, new String[0]);
        if (Files.exists(p2, new LinkOption[0])) {
            try {
                Files.delete(p2);
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
    }

    public void serializeStringValue(String serialFilePath, String s) throws IOException {
        StringBuffer buffer = new StringBuffer();
        buffer.append("value=");
        buffer.append(s);
        buffer.append("\n");
        BufferedWriter writer = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]), Charset.forName("UTF-8"), new OpenOption[0]);
        writer.write(buffer.toString());
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deserializeStringValue(String serialFilePath) throws IOException {
        Path p2 = WrapperFactory.getNioServiceWrapper().getPath(serialFilePath, new String[0]);
        if (!Files.exists(p2, new LinkOption[0])) {
            return null;
        }
        String s = null;
        Properties prop = new Properties();
        InputStream fis = null;
        try {
            fis = Files.newInputStream(p2, new OpenOption[0]);
            prop.load(fis);
            s = prop.getProperty("value");
        }
        catch (FileNotFoundException e2) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch cannot find cached file under {0}:", serialFilePath));
        }
        catch (IOException e3) {
            OLogger.printlnOnLog(MessageFormat.format("OPatch fails to open cached file under {0}:", serialFilePath));
            OLogger.printStackTrace(e3);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception e4) {
                    e4.printStackTrace();
                }
            }
        }
        return s;
    }
}

