/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.napplyhelper;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.napplyhelper.NApplyData;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.napplyhelper.NapplyProcessHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchutil.OPatchUtilHelper;

public class CheckMissingComps {
    private NApplyData data;

    public CheckMissingComps(NApplyData data) {
        this.data = data;
    }

    public boolean doMcCheck(String oracleHomePath, NApplyData data) {
        StringBuffer dBuff = new StringBuffer("N-Apply: Step 2: ");
        dBuff.append("  missing any required comp is an error");
        dBuff.append("  missing all optional comp is no-op, will be skipped");
        OLogger.debug(dBuff);
        OneOffEntry[] patchesToApply = data.getPatchesToApply();
        try {
            PrereqResult resultObj;
            int i2;
            ArrayList<OneOffEntry> compCheck = new ArrayList<OneOffEntry>();
            ArrayList<PatchObject> compCheckPO = new ArrayList<PatchObject>();
            int len = patchesToApply.length;
            dBuff = new StringBuffer("N-Apply: calling  OPatchUtilHelper.getPatchesToApply() ");
            dBuff.append("to convert OneOffEntry[] to PatchObject[].");
            OLogger.debug(dBuff);
            PatchObject[] patchesToCheckComp = OPatchUtilHelper.getPatchesToApply(oracleHomePath, patchesToApply, "NApply");
            OLogger.printlnOnLog("Checking if Oracle Home has components required by patches...");
            HashMap<String, OneOffEntry> patchesToApplyMap = new HashMap<String, OneOffEntry>();
            for (i2 = 0; i2 < patchesToApply.length; ++i2) {
                String patchKeyName = patchesToApply[i2].getCookedPatchID() + "+" + patchesToApply[i2].getPSENumber();
                patchesToApplyMap.put(patchKeyName, patchesToApply[i2]);
            }
            for (i2 = 0; i2 < patchesToCheckComp.length; ++i2) {
                StringBuffer buff;
                OneOffEntry patchToApply = (OneOffEntry)patchesToApplyMap.get(patchesToCheckComp[i2].getCookedPatchID() + "+" + patchesToCheckComp[i2].getPatchUniqID());
                if (patchToApply == null) {
                    patchToApply = patchesToApply[i2];
                }
                Vector missingRequiredComps = new Vector();
                PatchObject aPatch = patchesToCheckComp[i2];
                String aID = aPatch.getPatchID();
                boolean addThisPatch = true;
                dBuff = new StringBuffer("N-Apply: check if req. comp. is missing for patch ");
                dBuff.append(aID);
                OLogger.debug(dBuff);
                boolean missReqComp = PrereqAPI.isRequiredComponentMissing(oracleHomePath, aPatch, missingRequiredComps);
                if (missReqComp) {
                    dBuff = new StringBuffer("N-Apply: Patch ");
                    dBuff.append(aID);
                    dBuff.append("has missing req. comp.");
                    OLogger.debug(dBuff);
                    addThisPatch = false;
                    StringBuffer buff2 = new StringBuffer("Patch ");
                    buff2.append(aID);
                    buff2.append(" requires component(s) that are not installed in OracleHome. ");
                    if (OPatchEnv.isCUPSupported()) {
                        buff2.append(" Or don't have required patch level. ");
                    }
                    buff2.append("These not-installed components are ");
                    for (Object obj : missingRequiredComps) {
                        if (!(obj instanceof PatchComponent)) continue;
                        PatchComponent c2 = (PatchComponent)obj;
                        String cName = c2.getName();
                        String cVer = c2.getVersion();
                        buff2.append(cName).append(":").append(cVer);
                        if (OPatchEnv.isCUPSupported()) {
                            buff2.append(":patchlevel-").append(c2.getPatchLevel() + "(or higher)");
                        }
                        buff2.append(", ");
                    }
                    if (OPatchEnv.isIgnoreMissingComponent()) {
                        dBuff = new StringBuffer("N-Apply:");
                        dBuff.append("emsm");
                        dBuff.append(" is specified. Skip this patch ");
                        dBuff.append(aID);
                        OLogger.debug(dBuff);
                        buff2.append(". Skip patch ").append(aID);
                        buff2.append(" from list of patches to apply.");
                        OLogger.println(buff2.toString());
                    } else {
                        dBuff = new StringBuffer("N-Apply:");
                        dBuff.append("emsm");
                        dBuff.append(" is not specified. Throw exception. ");
                        dBuff.append(aID);
                        OLogger.debug(dBuff);
                        OPatchStateManagerFactory.getInstance().setErrorCode(219);
                        throw new RuntimeException(buff2.toString());
                    }
                }
                dBuff = new StringBuffer("N-Apply: check if at least one component in <atleast_one_components> is applicable for patch ");
                dBuff.append(aID);
                OLogger.debug(dBuff);
                ArrayList<PatchComponent> atleastOneComponentsMissing = new ArrayList<PatchComponent>();
                boolean missAtleastOneComponent = PrereqAPI.isAtleastOneComponentMissing(oracleHomePath, aPatch, atleastOneComponentsMissing);
                if (missAtleastOneComponent) {
                    dBuff = new StringBuffer("N-Apply: Patch ");
                    dBuff.append(aID);
                    dBuff.append("has missing at least one component");
                    OLogger.debug(dBuff);
                    addThisPatch = false;
                    StringBuffer buff3 = new StringBuffer("Patch ");
                    buff3.append(aID);
                    buff3.append(" requires at least one of these components: ");
                    for (PatchComponent c3 : atleastOneComponentsMissing) {
                        String cName = c3.getName();
                        String cVer = c3.getVersion();
                        buff3.append(cName).append(":").append(cVer);
                        buff3.append(", ");
                    }
                    buff3.append(" to be installed in Oracle Home");
                    if (OPatchEnv.isCUPSupported()) {
                        buff3.append(" with compatible patch level.");
                    }
                    if (OPatchEnv.isIgnoreMissingComponent()) {
                        dBuff = new StringBuffer("N-Apply:");
                        dBuff.append("emsm");
                        dBuff.append(" is specified. Skip this patch ");
                        dBuff.append(aID);
                        OLogger.debug(dBuff);
                        buff3.append(". Skip patch ").append(aID);
                        buff3.append(" from list of patches to apply.");
                        OLogger.println(buff3.toString());
                    } else {
                        dBuff = new StringBuffer("N-Apply:");
                        dBuff.append("emsm");
                        dBuff.append(" is not specified. Throw exception. ");
                        dBuff.append(aID);
                        OLogger.debug(dBuff);
                        OPatchStateManagerFactory.getInstance().setErrorCode(219);
                        throw new RuntimeException(buff3.toString());
                    }
                }
                dBuff = new StringBuffer("N-Apply: check if patch ");
                dBuff.append(aID).append(" is a no-op.");
                OLogger.debug(dBuff);
                boolean isNoOpPatch = PrereqAPI.isAllComponentsNotRequiredToProcess(oracleHomePath, aPatch);
                if (isNoOpPatch) {
                    addThisPatch = false;
                    buff = new StringBuffer("Skip patch ");
                    buff.append(aID);
                    buff.append(" from list of patches to apply: This patch is not needed because all components in OH are up-to-date");
                    OLogger.println(buff.toString());
                } else {
                    isNoOpPatch = PrereqAPI.isNoOpPatch(oracleHomePath, aPatch);
                    if (isNoOpPatch) {
                        addThisPatch = false;
                        buff = new StringBuffer("Skip patch ");
                        buff.append(aID);
                        buff.append(" from list of patches to apply: This patch is not needed.");
                        OLogger.println(buff.toString());
                    }
                }
                if (addThisPatch) {
                    dBuff = new StringBuffer("N-Apply: add patch ");
                    dBuff.append(aID).append(" to a list of patch to be applied.");
                    OLogger.debug(dBuff);
                    compCheck.add(patchToApply);
                    compCheckPO.add(patchesToCheckComp[i2]);
                    continue;
                }
                dBuff = new StringBuffer("N-Apply: patch ");
                dBuff.append(aID).append(" will be skipped.");
                OLogger.debug(dBuff);
            }
            PatchObject[] remainingPatchesToCheck = new PatchObject[compCheckPO.size()];
            compCheckPO.toArray(remainingPatchesToCheck);
            Vector snowballNoOps = new Vector();
            Vector newPatchesToGo = new Vector(compCheck);
            String[] noopPatchIDs = new String[compCheckPO.size()];
            boolean skip = OPatchEnv.hashMatches();
            if (skip) {
                OLogger.printlnOnLog("CheckMissingComps: Cached file is valid for 2-phase patching, use pre-computed result.");
                NApplyDataSerializer serializer = new NApplyDataSerializer();
                try {
                    noopPatchIDs = serializer.deserializeNoOpCheckResult(OPatchEnv.getPrereqResultFileLoc(oracleHomePath) + File.separator + "pi_noOps.txt");
                }
                catch (IOException e2) {
                    OLogger.println("OPatch failed to parse no-op patches");
                    skip = false;
                }
            }
            if (!skip) {
                OLogger.printlnOnLog("CheckMissingComps: Cached file does not exist or is invalid, re-build prereq result.");
                PrereqResult snowballNoOp = PrereqAPI.checkFileVersions(oracleHomePath, remainingPatchesToCheck, snowballNoOps);
                for (int sb = 0; sb < snowballNoOps.size(); ++sb) {
                    noopPatchIDs[sb] = (String)snowballNoOps.get(sb);
                }
            }
            if ((resultObj = PrereqAPI.checkIfRequiredDeleteActionExist(oracleHomePath, remainingPatchesToCheck)).getResult() == PrereqResult.ExecuteStatus.FAILED) {
                throw new RuntimeException(resultObj.toString());
            }
            block11: for (String noopPatchID : noopPatchIDs) {
                for (int k2 = 0; k2 < compCheck.size(); ++k2) {
                    OneOffEntry curPatch = (OneOffEntry)compCheck.get(k2);
                    if (!curPatch.getID().equals(noopPatchID)) continue;
                    OLogger.debug(new StringBuffer("Removing Patch ID \"" + noopPatchID + "\" from the list as it is a no-op " + "with respect to file versions."));
                    newPatchesToGo.remove(curPatch);
                    StringBuffer buff = new StringBuffer("Skip patch ");
                    buff.append(noopPatchID);
                    buff.append(" from list of patches to apply: This patch is not needed.");
                    OLogger.println(buff.toString());
                    continue block11;
                }
            }
            patchesToApply = new OneOffEntry[newPatchesToGo.size()];
            newPatchesToGo.toArray(patchesToApply);
            data.setPatchesToApply(patchesToApply);
        }
        catch (Exception e3) {
            dBuff = new StringBuffer("N-Apply: Exception occurs during Step 2: ");
            dBuff.append(e3.getMessage());
            OLogger.debug(dBuff);
            RuntimeException re = new RuntimeException(e3.getMessage());
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        try {
            NapplyProcessHelper.checkEmptyPatchList(patchesToApply);
        }
        catch (RuntimeException e4) {
            StringBuffer buff = new StringBuffer("");
            if (data.getModelCode() == 1) {
                buff.append("\nAfter skipping patches with missing components, there are no patches to apply.");
            } else if (data.getModelCode() == 2) {
                buff.append("\nAfter skipping patches with missing components, lower (or) equal file versions, identical patches");
                buff.append("\nthere are no patches to apply.");
            }
            OLogger.warn("OUI-67124", new Object[]{buff.toString()});
            return true;
        }
        return false;
    }
}

