/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.ipm;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Vector;
import oracle.opatch.OPatchEnv;
import oracle.opatch.StringResource;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IIPMAuxServices;
import oracle.opatch.ipm.IPMRWServices;
import oracle.opatch.ipm.OUIInventorySession;
import oracle.opatch.ipm.OUISessionManager;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;
import oracle.opatch.wrappers.WrapperFactory;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixLanguage;

public class IPMAuxServices
implements IIPMAuxServices {
    private static IPMAuxServices instance = null;
    private static String fileSeparator = File.separator;

    private IPMAuxServices() {
    }

    protected static synchronized IPMAuxServices getInstance() {
        if (instance == null) {
            instance = new IPMAuxServices();
        }
        return instance;
    }

    @Override
    public String[] symbolResolve(String componentName, String componenentVersion, String symbolName) {
        return null;
    }

    @Override
    public String getCentralInventoryLocation() {
        return null;
    }

    @Override
    public void attachHome(String oracleHomePath, String oracleHomeName, String strArgs) {
        String[] params = OiixFunctionOps.explodeString((String)strArgs, (String)" ");
        int retry = OPatchEnv.getRetry();
        int delay = OPatchEnv.getDelay();
        boolean isRetry = OPatchEnv.isRetry();
        if (isRetry) {
            OLogger.debug("IPMAuxServices::attachHome() will retry " + retry + "  times with " + delay + " second(s) interval.");
        } else {
            OLogger.debug("IPMAuxServices::attachHome() has no retry.");
        }
        int count = 0;
        long startTime = System.currentTimeMillis();
        int maxWait = OPatchEnv.getMaxLockingWait();
        while (true) {
            try {
                OLogger.debug("IPMAuxServices::attachHome() try round # " + ++count);
                boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                boolean isEnabledForAttachHome = true;
                IPMRWServices rwServices = IPMRWServices.getInstance();
                boolean wasInvLocked = false;
                try {
                    if (!isConsoleOutputDisabled) {
                        OLogger.disableConsoleOutput(false);
                        isEnabledForAttachHome = false;
                    }
                    if (wasInvLocked = rwServices.isLockedAsRW()) {
                        rwServices.release();
                    }
                    this.runAttachCmd(oracleHomePath, oracleHomeName, strArgs);
                }
                catch (Throwable th) {
                    throw th;
                }
                finally {
                    if (!isEnabledForAttachHome) {
                        OLogger.enableConsoleOutput(false);
                    }
                    if (wasInvLocked) {
                        rwServices.lock(oracleHomePath);
                    }
                }
            }
            finally {
                Throwable t;
                if (isRetry) {
                    if (--retry < 0) {
                        isRetry = false;
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        throw re;
                    }
                    long now = System.currentTimeMillis();
                    int differenceInSeconds = (int)((startTime - now) / 1000L);
                    OLogger.debug("  attachHome starts at " + startTime + ", now is " + now + ", " + differenceInSeconds + " second(s) has passed.");
                    if (differenceInSeconds >= maxWait) {
                        String log = "Cannot attach Oracle Home. Total retry time has exceeded " + maxWait + " second(s) allowed.";
                        RuntimeException re = new RuntimeException(log);
                        re.setStackTrace(t.getStackTrace());
                        OLogger.debug(log + " attachHome started at " + startTime + " and now is " + now + "(" + differenceInSeconds + " second(s) has passed)");
                        throw re;
                    }
                    OLogger.printlnOnLog("OPatch will sleep for some time, before re-trying to attach Oracle Home");
                    try {
                        OLogger.debug("IPMAuxServices::attachHome() failed.  Will sleep for " + delay + " second(s).");
                        Thread.sleep(delay * 1000);
                    }
                    catch (InterruptedException x) {}
                    continue;
                }
                RuntimeException re = new RuntimeException(t.getMessage(), t);
                re.setStackTrace(t.getStackTrace());
                throw re;
                if (isRetry) continue;
            }
            break;
        }
    }

    @Override
    public void detachHome(String oracleHomePath, String oracleHomeName, String strArgs) {
        String[] params = OiixFunctionOps.explodeString((String)strArgs, (String)" ");
        int retry = OPatchEnv.getRetry();
        int delay = OPatchEnv.getDelay();
        boolean isRetry = OPatchEnv.isRetry();
        if (isRetry) {
            OLogger.debug("IPMAuxServices::detachHome() will retry " + retry + "  times with " + delay + " second(s) interval.");
        } else {
            OLogger.debug("IPMAuxServices::detachHome() has no retry.");
        }
        int count = 0;
        long startTime = System.currentTimeMillis();
        int maxWait = OPatchEnv.getMaxLockingWait();
        while (true) {
            try {
                OLogger.debug("IPMAuxServices::detachHome() try round # " + ++count);
                boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
                boolean isEnabledForDetachHome = true;
                IPMRWServices rwServices = IPMRWServices.getInstance();
                boolean wasInvLocked = false;
                try {
                    if (!isConsoleOutputDisabled) {
                        OLogger.disableConsoleOutput(false);
                        isEnabledForDetachHome = false;
                    }
                    if (wasInvLocked = rwServices.isLockedAsRW()) {
                        rwServices.release();
                    }
                    this.runDetachCmd(oracleHomePath, oracleHomeName, strArgs);
                }
                catch (Throwable th) {
                    throw th;
                }
                finally {
                    if (!isEnabledForDetachHome) {
                        OLogger.enableConsoleOutput(false);
                    }
                }
            }
            finally {
                Throwable t;
                if (isRetry) {
                    if (--retry < 0) {
                        isRetry = false;
                        RuntimeException re = new RuntimeException(t.getMessage());
                        re.setStackTrace(t.getStackTrace());
                        throw re;
                    }
                    long now = System.currentTimeMillis();
                    int differenceInSeconds = (int)((startTime - now) / 1000L);
                    OLogger.debug("  detachHome starts at " + startTime + ", now is " + now + ", " + differenceInSeconds + " second(s) has passed.");
                    if (differenceInSeconds >= maxWait) {
                        String log = "Cannot detach Oracle Home. Total retry time has exceeded " + maxWait + " second(s) allowed.";
                        RuntimeException re = new RuntimeException(log);
                        re.setStackTrace(t.getStackTrace());
                        OLogger.debug(log + " detachHome started at " + startTime + " and now is " + now + "(" + differenceInSeconds + " second(s) has passed)");
                        throw re;
                    }
                    OLogger.printlnOnLog("OPatch will sleep for some time, before re-trying to detach Oracle Home");
                    try {
                        OLogger.debug("IPMAuxServices::detachHome() failed.  Will sleep for " + delay + " second(s).");
                        Thread.sleep(delay * 1000);
                    }
                    catch (InterruptedException x) {}
                    continue;
                }
                RuntimeException re = new RuntimeException(t.getMessage(), t);
                re.setStackTrace(t.getStackTrace());
                throw re;
                if (isRetry) continue;
            }
            break;
        }
    }

    public static void destroyObject() {
        if (instance != null) {
            instance = null;
        }
    }

    private void runAttachCmd(String oracleHomePath, String oracleHomeName, String strArgs) throws IOException, InterruptedException {
        String line;
        String attachCmdLoc;
        OLogger.printlnOnLog("Run attach command:");
        StringBuilder command = new StringBuilder();
        String invPtrPath = OPatchEnv.getOracleHome() + fileSeparator + "oraInst.loc";
        String javaHome = System.getProperty("java.home");
        String javaPath = javaHome + fileSeparator + "bin" + fileSeparator + "java";
        if (OPatchEnv.isNextGen()) {
            command.append(javaPath);
            command.append("  -jar " + OPatchEnv.getOUILocation() + fileSeparator + "modules" + fileSeparator + "ora-launcher.jar -noconsole -attachHome");
        } else if (OPatchEnv.isWindows()) {
            attachCmdLoc = OPatchEnv.getOUILocation() + fileSeparator + "bin" + fileSeparator + "setup.exe -noconsole -attachhome ";
            command.append(attachCmdLoc);
            command.append(" -jreLoc " + javaHome);
        } else {
            attachCmdLoc = OPatchEnv.getOUILocation() + fileSeparator + "bin" + fileSeparator + "runInstaller -attachhome";
            command.append(attachCmdLoc);
            command.append(" -jreLoc " + javaHome);
        }
        command.append(" ORACLE_HOME=" + oracleHomePath);
        command.append(" ORACLE_HOME_NAME=" + oracleHomeName);
        command.append(" -invPtrLoc " + invPtrPath);
        command.append(" " + strArgs);
        OLogger.printlnOnLog(command.toString());
        Process process = Runtime.getRuntime().exec(command.toString(), null, WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOUILocation() + fileSeparator + "bin", new String[0]).toFile());
        BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((line = error.readLine()) != null) {
            OLogger.printlnOnLog(line);
        }
        error.close();
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = input.readLine()) != null) {
            OLogger.printlnOnLog(line);
        }
        if (process.waitFor() != 0) {
            Path glcmHome = Paths.get(OPatchEnv.getOPatchHome(), new String[0]).getParent();
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && Files.exists(glcmHome.resolve(StringResource.nextgenOraLauncherPath), new LinkOption[0])) {
                OLogger.printlnOnLog(OLogger.WARNING, "attach command failed ... trying nextgen attach command ");
                this.runAttachWithNextGenCommand(javaPath, glcmHome, oracleHomePath, oracleHomeName, invPtrPath);
            } else {
                throw new RuntimeException("OPatch failed to attach shadow home.");
            }
        }
        if (OPatchEnv.isNextGen()) {
            OUIInventorySession iSession = OUISessionManager.getInventorySession();
            try {
                if (iSession != null) {
                    iSession.endSession();
                }
                OiiiInstallAreaControl.reset();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private void runAttachWithNextGenCommand(String javaPath, Path glcmHome, String oracleHomePath, String oracleHomeName, String invPtrPath) {
        OLogger.printlnOnLog(OLogger.WARNING, " Trying to run attach command with nextGen command as original command has failed");
        StringBuilder command = new StringBuilder();
        command.append(javaPath);
        command.append("  -jar " + glcmHome.resolve(StringResource.nextgenOraLauncherPath) + " -noconsole -attachHome ");
        command.append(" ORACLE_HOME=" + oracleHomePath);
        command.append(" ORACLE_HOME_NAME=" + oracleHomeName);
        command.append(" -invPtrLoc " + invPtrPath);
        command.append(" -force -nogenerateGUID ");
        command.append(" -paramFile " + glcmHome.toString() + File.separator + StringResource.nextgenOraparamIni);
        OLogger.printlnOnLog("Running Command:");
        OLogger.printlnOnLog(command.toString());
        SystemCall.ExecReturn ret = SystemCall.runtimeExec(command.toString());
        OLogger.printlnOnLog(ret.toString());
        if (!ret.isOK()) {
            OLogger.printlnOnLog(OLogger.SEVERE, "Attach command was not successful");
            throw new RuntimeException("ERROR : runAttachWithNextGenCommand() : OPatch failed to attach shadow home.");
        }
    }

    private void runDetachCmd(String oracleHomePath, String oracleHomeName, String strArgs) throws IOException, InterruptedException {
        String line;
        OLogger.printlnOnLog("Run detach command:");
        StringBuilder command = new StringBuilder();
        String invPtrPath = OPatchEnv.getOracleHome() + fileSeparator + "oraInst.loc";
        String javaHome = System.getProperty("java.home");
        String javaPath = javaHome + fileSeparator + "bin" + fileSeparator + "java";
        if (OPatchEnv.isNextGen()) {
            command.append(javaPath);
            command.append("  -jar " + OPatchEnv.getOUILocation() + fileSeparator + "modules" + fileSeparator + "ora-launcher.jar -noconsole -detachHome");
        } else if (OPatchEnv.isWindows()) {
            String detachCmdLoc = OPatchEnv.getOUILocation() + fileSeparator + "bin" + fileSeparator + "setup.exe -noconsole -detachhome ";
            command.append(detachCmdLoc);
            command.append(" -jreLoc " + javaHome);
        } else {
            String attachCmdLoc = OPatchEnv.getOUILocation() + fileSeparator + "bin" + fileSeparator + "runInstaller -detachhome";
            command.append(attachCmdLoc);
            command.append(" -jreLoc " + javaHome);
        }
        command.append(" ORACLE_HOME=" + oracleHomePath);
        command.append(" ORACLE_HOME_NAME=" + oracleHomeName);
        if (!OPatchEnv.isNextGen()) {
            command.append(" -invPtrLoc " + invPtrPath);
            command.append(" " + strArgs);
        }
        OLogger.printlnOnLog(command.toString());
        Process process = Runtime.getRuntime().exec(command.toString(), null, WrapperFactory.getNioServiceWrapper().getPath(OPatchEnv.getOUILocation() + fileSeparator + "bin", new String[0]).toFile());
        BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        while ((line = error.readLine()) != null) {
            OLogger.printlnOnLog(line);
        }
        error.close();
        BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
        while ((line = input.readLine()) != null) {
            OLogger.printlnOnLog(line);
        }
        if (process.waitFor() != 0) {
            Path glcmHome = Paths.get(OPatchEnv.getOPatchHome(), new String[0]).getParent();
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && Files.exists(glcmHome.resolve(StringResource.nextgenOraLauncherPath), new LinkOption[0])) {
                OLogger.printlnOnLog(OLogger.WARNING, "detach command failed ... trying nextgen detach command ");
                this.runDetachWithNextGenCommand(javaPath, glcmHome, oracleHomePath, oracleHomeName, invPtrPath);
            } else {
                throw new RuntimeException("OPatch failed to detach shadow home.");
            }
        }
    }

    private void runDetachWithNextGenCommand(String javaPath, Path glcmHome, String oracleHomePath, String oracleHomeName, String invPtrPath) {
        OLogger.printlnOnLog(OLogger.WARNING, " Trying to run Detach command with nextGen command as original command has failed");
        StringBuilder command = new StringBuilder();
        command.append(javaPath);
        command.append("  -jar " + glcmHome.resolve(StringResource.nextgenOraLauncherPath) + " -noconsole -detachHome ");
        command.append(" ORACLE_HOME=" + oracleHomePath);
        command.append(" ORACLE_HOME_NAME=" + oracleHomeName);
        command.append(" -paramFile " + glcmHome.toString() + File.separator + StringResource.nextgenOraparamIni);
        OLogger.printlnOnLog("Running Command:");
        OLogger.printlnOnLog(command.toString());
        SystemCall.ExecReturn ret = SystemCall.runtimeExec(command.toString());
        OLogger.printlnOnLog(ret.toString());
        if (!ret.isOK()) {
            OLogger.printlnOnLog(OLogger.SEVERE, "Detach command was not successful");
            throw new RuntimeException("ERROR : runAttachWithNextGenCommand() : OPatch failed to attach shadow home.");
        }
    }

    @Override
    public String convertToOUIPatchLanguage(String patchLanguage) {
        Vector langs = OiixLanguage.strToVect((String)patchLanguage);
        if (langs != null && !langs.isEmpty()) {
            patchLanguage = OiixLanguage.vectToStr((Vector)langs);
        }
        return patchLanguage;
    }
}

