/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.fmwclient;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import oracle.integration.platform.blocks.deploy.patch.PatchStatus;
import oracle.opatch.opatchfafmw.Domain;
import oracle.opatch.opatchfafmw.FMWContext;
import oracle.opatch.opatchfafmw.FMWLogger;
import oracle.opatch.opatchfafmw.FMWProductDriver;
import oracle.opatch.opatchfafmw.OPatchStepAdapter;
import oracle.opatch.opatchfafmw.SOAComposite;
import oracle.opatch.opatchfafmw.SOACompositeManager;
import oracle.opatch.opatchfafmw.TargetList;
import weblogic.management.runtime.ServerLifeCycleRuntimeMBean;
import weblogic.management.runtime.ServerLifeCycleTaskRuntimeMBean;

public final class FMWClient {
    private FMWProductDriver pd;
    private FMWContext.ContextBuilder cb;
    private boolean lifeCycleOperation;
    private boolean soaCompositeOperation;
    private boolean baseSoaCompositeOperation;
    private boolean ldiffOperation;
    private boolean bipOperation;
    private boolean soaRBOperation;
    private boolean compositeLifeCycleOperation;
    private boolean preAction = false;
    private String actionType = "Restart";
    private String logFile = "";
    public static final String COMMON_HOME_GUID = FMWContext.ConfigProperties.COMMON_HOME_GUID.name();
    public static final String TEMP_LOCATION = FMWContext.ConfigProperties.TEMP_LOCATION.name();
    public static final String STOP_ANY_SERVER = FMWContext.ConfigProperties.STOP_ANY_SERVER.name();
    public static final String TIMEOUT_SECONDS = FMWContext.ConfigProperties.TIMEOUT_SECONDS.name();
    public static final String ORACLE_HOME = FMWContext.ConfigProperties.ORACLE_HOME.name();
    public static final String PATCH_LOCATION = FMWContext.ConfigProperties.PATCH_LOCATION.name();
    public static final String PATCH_ID = FMWContext.ConfigProperties.PATCH_ID.name();
    public static final String LOG_FILE_LOCATION = FMWContext.ConfigProperties.LOG_FILE_LOCATION.name();
    public static final String APPLICATION = FMWContext.Type.APPLICATION.name();
    public static final String SERVER = FMWContext.Type.SERVER.name();
    public static final String CLUSTER = FMWContext.Type.CLUSTER.name();
    public static final String CONTAINER = FMWContext.Type.CONTAINER.name();

    public FMWClient(FMWLogger logger) {
        this.cb = new FMWContext.ContextBuilder(logger);
    }

    public List<OPatchStepAdapter> getAllExecutedSteps() {
        return this.cb.getExecutionSteps();
    }

    public void setCompositeDeployWithMultipleSteps(boolean deployFlag) {
        this.cb.setCompositeDeployWithMultipleSteps(deployFlag);
    }

    public void setNoneConfigPlan(boolean configFlag) {
        this.cb.setNoneConfigPlan(configFlag);
    }

    public String getSOAHost() {
        Domain d2 = this.cb.getDomain();
        if (d2 == null) {
            return "";
        }
        SOACompositeManager scm = d2.getSOACompositeManager();
        if (scm != null) {
            return scm.getSOAHost();
        }
        return "";
    }

    public Domain getDomain() {
        return this.cb.getDomain();
    }

    public TargetList getTarget() {
        return this.cb.getTarget();
    }

    public int getSOAPort() {
        Domain d2 = this.cb.getDomain();
        if (d2 == null) {
            return -1;
        }
        SOACompositeManager scm = d2.getSOACompositeManager();
        if (scm != null) {
            return scm.getSOAPort();
        }
        return -1;
    }

    public List<OPatchStepAdapter> getRecoverySteps() {
        return this.cb.getRecoverySteps();
    }

    public OPatchStepAdapter getFailedPrereqStep() {
        return this.cb.getFailedPrereqStep();
    }

    public Map<String, ServerLifeCycleRuntimeMBean> getServerLifeCycleRuntimeMBeanMap() {
        return this.cb.getServerLifeCycleRuntimeMBeanMap();
    }

    public Map<String, ServerLifeCycleTaskRuntimeMBean> getServerLifeCycleTaskRuntimeMBeanMap() {
        return this.cb.getServerLifeCycleTaskRuntimeMBeanMap();
    }

    public OPatchStepAdapter getExecutionStep() {
        return this.cb.getExecutionStep();
    }

    public SOAComposite getSOAComposite() {
        return this.cb.getSOAComposite();
    }

    public boolean lifeCycleOperation() {
        return this.lifeCycleOperation;
    }

    public boolean soaCompositeLifeCycleOperation() {
        return this.compositeLifeCycleOperation;
    }

    public boolean soaCompositeOperation() {
        return this.soaCompositeOperation;
    }

    public boolean soaRBOperation() {
        return this.soaRBOperation;
    }

    public boolean ldiffOperation() {
        return this.ldiffOperation;
    }

    public boolean bipOperation() {
        return this.bipOperation;
    }

    public void setActionType(String type) {
        this.actionType = type;
    }

    public String getActionType() {
        return this.actionType;
    }

    public void prereq(boolean apply) {
        this.check();
        if (this.lifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.PREREQ_LIFE_CYCLE);
        }
        if (this.compositeLifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.PREREQ_COMPOSITE_LIFECYCLE);
        }
        if (this.soaCompositeOperation && apply) {
            this.pd.run(FMWContext.OperationCode.PREREQ_SOA_COMPOSITE_DEPLOY);
        }
        if (this.baseSoaCompositeOperation && apply) {
            this.pd.run(FMWContext.OperationCode.PREREQ_BASE_SOA_COMPOSITE_DEPLOY);
        }
        if (this.soaRBOperation && apply) {
            this.pd.run(FMWContext.OperationCode.PREREQ_SOA_SERVER_AVAILABLE);
        }
        if (this.bipOperation) {
            if (apply) {
                this.pd.run(FMWContext.OperationCode.PREREQ_BIP_DEPLOY);
            } else {
                this.pd.run(FMWContext.OperationCode.PREREQ_BIP_UNDEPLOY);
            }
        }
    }

    public void prereq() {
        this.check();
        if (this.lifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.PREREQ_LIFE_CYCLE);
        }
        if (this.compositeLifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.PREREQ_COMPOSITE_LIFECYCLE);
        }
    }

    public void configure(boolean apply) {
        this.check();
        if (this.lifeCycleOperation) {
            if (this.actionType.equalsIgnoreCase("Stop")) {
                this.stop();
            }
            if (this.actionType.equalsIgnoreCase("Start")) {
                this.start();
            }
            if (this.actionType.equalsIgnoreCase("Restart")) {
                this.stop();
                this.start();
            }
        }
        if (this.soaCompositeOperation && apply) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_SOA_COMPOSITE);
        }
        if (this.baseSoaCompositeOperation && apply) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_BASE_SOA_COMPOSITE);
        }
        if (this.soaRBOperation && apply) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_SOA_RESOURCE_BUNDLE);
        }
        if (this.ldiffOperation && apply) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_LDIF);
        }
        if (this.bipOperation) {
            if (apply) {
                this.pd.run(FMWContext.OperationCode.DEPLOY_BIP);
            } else {
                this.pd.run(FMWContext.OperationCode.UNDEPLOY_BIP);
            }
        }
    }

    public void deploy() {
        this.check();
        if (this.soaCompositeOperation) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_SOA_COMPOSITE);
        }
        if (this.baseSoaCompositeOperation) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_BASE_SOA_COMPOSITE);
        }
        if (this.soaRBOperation) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_SOA_RESOURCE_BUNDLE);
        }
        if (this.ldiffOperation) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_LDIF);
        }
        if (this.bipOperation) {
            this.pd.run(FMWContext.OperationCode.DEPLOY_BIP);
        }
    }

    public void undeploy() {
        this.check();
        if (this.bipOperation) {
            this.pd.run(FMWContext.OperationCode.UNDEPLOY_BIP);
        }
    }

    public void stop() {
        this.check();
        if (this.lifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.STOP);
        }
    }

    public void checkServerAttribute() {
        this.check();
        if (this.cb.getServerAttribute() != null) {
            this.pd.run(FMWContext.OperationCode.SERVER_CONFIG_ATTRIBUTE);
        }
    }

    public boolean isSOACompositeUp() {
        this.check();
        this.pd.run(FMWContext.OperationCode.COMPOSITE_STATUS);
        return this.cb.isSOACompositeUp();
    }

    public void testSOAInfra() {
        this.check();
        if (this.cb.isSOAInfraTest()) {
            this.pd.run(FMWContext.OperationCode.PREREQ_SOA_SERVER_AVAILABLE);
        }
    }

    public void start() {
        this.check();
        if (this.lifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.START);
        }
    }

    public void startNServer() {
        this.check();
        if (this.lifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.START_NSERVER);
        }
    }

    public void stopNServer() {
        this.check();
        if (this.lifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.STOP_NSERVER);
        }
    }

    public void stopComposite() {
        this.check();
        if (this.compositeLifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.STOP_COMPOSITE);
        }
    }

    public void startComposite() {
        this.check();
        if (this.compositeLifeCycleOperation) {
            this.pd.run(FMWContext.OperationCode.START_COMPOSITE);
        }
    }

    public void listComposites() {
        this.check();
        this.pd.run(FMWContext.OperationCode.LIST_DEPLOYED_COMPOSITES);
    }

    public void done() {
        this.pd = this.cb.build();
    }

    public void close() {
        this.pd.close();
    }

    private void check() {
        if (this.pd == null) {
            throw new RuntimeException("Context not initialised yet. Call 'done()' before calling any operation.");
        }
    }

    public void setInterviewProperties(Properties prop) {
        this.cb.setInterviewProperties(prop);
    }

    public void addLDIF(String name, String path) {
        this.cb.addLDIFF(name, path);
        this.ldiffOperation = true;
    }

    public void addBIP(String name, String path, String relativePath, String biHome) {
        this.cb.addBIP(name, path, relativePath, biHome);
        this.bipOperation = true;
    }

    public void addSOAComposite(String name, String path, String revision, boolean designChanges, boolean resourceBundle) {
        this.cb.addSOAComposite(name, path, revision, designChanges, resourceBundle);
        if (resourceBundle) {
            this.soaRBOperation = true;
        } else {
            this.soaCompositeOperation = true;
        }
    }

    public void addSOAComposite(String name, String path, String revision, boolean designChanges, boolean resourceBundle, boolean baseCompositeDeployment) {
        this.cb.addSOAComposite(name, path, revision, designChanges, resourceBundle, baseCompositeDeployment);
        if (resourceBundle) {
            this.soaRBOperation = true;
        } else if (baseCompositeDeployment) {
            this.baseSoaCompositeOperation = true;
        } else {
            this.soaCompositeOperation = true;
        }
    }

    public PatchStatus getSOAOpResult() {
        return this.cb.getSOAOpResult();
    }

    public void setServerAttribute(String serverName, String attrName) {
        this.cb.setServerAttrInfo(serverName, attrName);
    }

    public void setServerAttribute(String serverName, String attrName, String attrValue, String objType, boolean errorOnPrevEdit) {
        this.cb.setServerAttrInfo(serverName, attrName, attrValue, objType, errorOnPrevEdit);
    }

    public Object getServerAttrValue() {
        return this.cb.getServerAttribute().getOutputAttrValue();
    }

    public void setSOAInfraTest(boolean in) {
        this.cb.setSOAInfraTest(in);
    }

    public void setTimeoutFlag(boolean timeout) {
        this.cb.setTimeoutFlag(timeout);
    }

    public void setLogFile(String log) {
        this.logFile = log;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void addSOAComposite(String name, String revision) {
        this.cb.addSOAComposite(name, revision);
        this.compositeLifeCycleOperation = true;
    }

    public void setRevisionToUndoDeployComposite(String[] undoDeployRevisions) {
        this.cb.setRevisionToUndoDeploy(undoDeployRevisions);
    }

    public void setTargets(String type, Set set) {
        FMWContext.Type t = FMWContext.Type.valueOf(type);
        String[] data = set.toArray(new String[0]);
        this.cb.setTargets(t, data);
        this.lifeCycleOperation = true;
    }

    public void setLDAPCredentials(String[] d2) {
        this.cb.setLDAPCredentials(d2[5], d2[6], d2[7], d2[8], d2[9]);
    }

    public void setDomain(String[] d2) {
        this.cb.setDomain(d2[0], d2[1], d2[2], d2[3], d2[4]);
    }

    public void setConfigProperties(Map map) {
        if (map != null && map.size() > 0) {
            EnumMap<FMWContext.ConfigProperties, String> cp = new EnumMap<FMWContext.ConfigProperties, String>(FMWContext.ConfigProperties.class);
            for (FMWContext.ConfigProperties c2 : FMWContext.ConfigProperties.values()) {
                if (map.get(c2.name()) == null) continue;
                cp.put(c2, (String)map.get(c2.name()));
            }
            this.cb.setConfigProperties(cp);
        }
    }

    public boolean equals(Object o2) {
        if (o2 instanceof FMWClient) {
            FMWClient client = (FMWClient)o2;
            return !(client.bipOperation ^ this.bipOperation) && !(client.lifeCycleOperation ^ this.lifeCycleOperation) && !(client.soaCompositeOperation ^ this.soaCompositeOperation) && !(client.ldiffOperation ^ this.ldiffOperation) && !(client.soaRBOperation ^ this.soaRBOperation) && !(client.compositeLifeCycleOperation ^ this.compositeLifeCycleOperation) && client.actionType.equals(this.actionType) && client.cb.equals(this.cb);
        }
        return false;
    }

    public void resetAndIgnorePreStepsForLifeCycleOperation() {
        if (this.lifeCycleOperation) {
            this.pd.resetAndIgnorePreStepsForLifeCycleOperation();
        }
    }

    public boolean operationOnAdminServer() {
        return this.cb.operationOnAdminServer();
    }

    public void setPreAction(boolean in) {
        this.preAction = in;
    }

    public boolean isPreAction() {
        return this.preAction;
    }

    public static class LoggerWrapper
    extends FMWLogger {
    }
}

