/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.diagtool;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.diagtool.OPatchDiagEnv;
import oracle.opatch.diagtool.OPatchDiagHelper;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchDiagUtility {
    public void scanOH(String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("Scanning ");
        buff.append(oracleHomePath);
        buff.append(" for irregularities...\n");
        OPatchDiagHelper.diagPrint(buff.toString());
        HashMap<String, HashSet<OPatchDiagHelper.DiagChecksumComparision>> allChecksums = OPatchDiagHelper.getChecksumsList(oracleHomePath);
        if (allChecksums.size() == 0) {
            OPatchDiagHelper.diagPrint("There is no file in checksum list for this Oracle Home: " + oracleHomePath);
            return;
        }
        Iterator<String> patchIDs = allChecksums.keySet().iterator();
        StringBuffer diffBuff = new StringBuffer();
        boolean hasDiff = false;
        ArrayList<String> diffPIDs = new ArrayList<String>();
        buff = new StringBuffer();
        while (patchIDs.hasNext()) {
            String patchID = patchIDs.next();
            boolean addDiff = false;
            boolean addSuc = false;
            HashSet<OPatchDiagHelper.DiagChecksumComparision> checksumArr = allChecksums.get(patchID);
            OPatchDiagHelper.DiagChecksumComparision[] sortedArr = new OPatchDiagHelper.DiagChecksumComparision[checksumArr.size()];
            Arrays.sort(checksumArr.toArray(sortedArr));
            for (int i2 = 0; i2 < sortedArr.length; ++i2) {
                OPatchDiagHelper.DiagChecksumComparision compare = sortedArr[i2];
                String filePath = compare.getFilePath();
                StringBuffer sb = new StringBuffer();
                sb.append("File ");
                sb.append(filePath);
                sb.append(" Current checksum is ");
                String leftBrackets = compare.isDiff() ? "[ " : "";
                String rightBrackets = compare.isDiff() ? " ]" : "";
                sb.append(leftBrackets + compare.getCurrentChecksum() + rightBrackets + ". ");
                sb.append("The checksum at install time was ");
                sb.append(leftBrackets + compare.getInstalledChecksum() + rightBrackets);
                sb.append(".\n");
                if (compare.isDiff()) {
                    if (!addDiff) {
                        diffBuff.append("Patch " + patchID + ":\n");
                        diffPIDs.add(patchID);
                        addDiff = true;
                    }
                    hasDiff = true;
                    diffBuff.append(sb);
                    continue;
                }
                if (!addSuc) {
                    buff.append("Patch " + patchID + ":\n");
                    addSuc = true;
                }
                buff.append(sb);
            }
            buff.append("\n");
            diffBuff.append("\n");
        }
        if (hasDiff) {
            diffBuff.append("\nThe list of patches that has checksum difference:\n");
            buff.append("\nFiles whose checksum has changed since install time:\n");
            for (int i3 = 0; i3 < diffPIDs.size(); ++i3) {
                diffBuff.append(((String)diffPIDs.get(i3)).toString());
                if (i3 == diffPIDs.size() - 1) continue;
                diffBuff.append(", ");
            }
            buff.append("\n" + diffBuff);
        }
        OPatchDiagHelper.diagPrint(buff.toString());
    }

    public void copy(String oracleHomePath) throws RuntimeException, ExitOPatchException {
        int i2;
        HashMap<String, HashSet<OPatchDiagHelper.DiagChecksumComparision>> allChecksums = OPatchDiagHelper.getChecksumsList(oracleHomePath);
        StringBuffer buff = null;
        String copyList = OPatchDiagEnv.getCopyList();
        String[] listFiles = copyList.split(",");
        ArrayList<String> trueFiles = new ArrayList<String>();
        try {
            for (String file : listFiles) {
                file = file.trim();
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(file, new String[0]);
                if (!Files.exists(f2, new LinkOption[0]) || Files.isDirectory(f2, new LinkOption[0])) {
                    buff = new StringBuffer("The file ");
                    buff.append(f2.toAbsolutePath().normalize().toString());
                    buff.append(" specified is not valid.");
                    OPatchDiagHelper.diagWarn(buff.toString());
                    continue;
                }
                trueFiles.add(f2.toAbsolutePath().normalize().toString());
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Get canonical path of file in copy list failed.");
        }
        if (trueFiles.size() == 0) {
            buff = new StringBuffer("Can't get useful copy list path. Please supply it and retry.");
            throw new RuntimeException(buff.toString());
        }
        Iterator<String> patchIDs = allChecksums.keySet().iterator();
        class Basket {
            private String srcFile;
            private String dstFile;
            private boolean isDiff = false;

            protected Basket(String srcFile, String dstFile, boolean isDiff) {
                this.srcFile = srcFile;
                this.dstFile = dstFile;
                this.isDiff = isDiff;
            }

            public String getSrcFile() {
                return this.srcFile;
            }

            public String getDstFile() {
                return this.dstFile;
            }

            public boolean isDiff() {
                return this.isDiff;
            }
        }
        ArrayList<Basket> baskets = new ArrayList<Basket>();
        while (patchIDs.hasNext()) {
            String patchID = patchIDs.next();
            HashSet<OPatchDiagHelper.DiagChecksumComparision> checksumArr = allChecksums.get(patchID);
            OPatchDiagHelper.DiagChecksumComparision[] allCompare = new OPatchDiagHelper.DiagChecksumComparision[checksumArr.size()];
            checksumArr.toArray(allCompare);
            for (int i3 = 0; i3 < allCompare.length; ++i3) {
                OPatchDiagHelper.DiagChecksumComparision compare = allCompare[i3];
                String filePath = compare.getFilePath();
                String wrappedPath = filePath.replace(oracleHomePath, "");
                for (int j2 = 0; j2 < trueFiles.size(); ++j2) {
                    String trueFile = (String)trueFiles.get(j2);
                    String checksumForCopy = OPatchDiagHelper.getChecksum(trueFile);
                    if (trueFile.indexOf(patchID) == -1 || trueFile.indexOf(wrappedPath) == -1 || !checksumForCopy.equals(compare.getInstalledChecksum())) continue;
                    Basket basket = new Basket(trueFile, wrappedPath, compare.isDiff());
                    baskets.add(basket);
                    trueFiles.remove(trueFile);
                    --j2;
                }
            }
        }
        if (trueFiles.size() != 0) {
            buff = new StringBuffer("Invalid file(s) : ");
            for (i2 = 0; i2 < trueFiles.size(); ++i2) {
                String trueFile = (String)trueFiles.get(i2);
                buff.append(trueFile);
                if (i2 == trueFiles.size() - 1) continue;
                buff.append(",");
            }
            buff.append(" specified in copy list. ");
            buff.append("Because its patch ID or checksum of file is not consistent with inventory.");
            OPatchDiagHelper.diagWarn(buff.toString());
        }
        buff = new StringBuffer("Copying files to ");
        buff.append(oracleHomePath);
        buff.append("\n");
        OPatchDiagHelper.diagPrint(buff.toString());
        for (i2 = 0; i2 < baskets.size(); ++i2) {
            Basket basket = (Basket)baskets.get(i2);
            String srcFile = basket.getSrcFile();
            String dstFile = basket.getDstFile();
            if (!basket.isDiff()) {
                buff = new StringBuffer("The file ");
                buff.append("$ORACLE_HOME");
                buff.append(dstFile);
                buff.append(" is not in the list of files detected with different checksums.\n");
                String promptMsg = OLogger.getString("OUI-67057", new Object[]{buff.toString(), "[y|n]"});
                boolean proceed = false;
                proceed = OPatchEnv.proceedWithOperationDefaultYes(promptMsg);
                OPatchDiagHelper.diagPrint("");
                if (!proceed) {
                    throw new ExitOPatchException("'opatchdiag' tool stops on request.");
                }
            }
            buff = new StringBuffer("Copying ");
            buff.append(srcFile);
            buff.append(" to ");
            buff.append("$ORACLE_HOME");
            buff.append(dstFile);
            OPatchDiagHelper.diagPrint(buff.toString());
            try {
                Path src = WrapperFactory.getNioServiceWrapper().getPath(srcFile, new String[0]);
                Path dst = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath + dstFile, new String[0]);
                OPatchDiagHelper.copy(src, dst);
                continue;
            }
            catch (RuntimeException e3) {
                throw new RuntimeException("Copy the file \"" + srcFile + "\" to Oracle Home failed. ");
            }
        }
    }
}

