/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.cup;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.glcm.opatch.common.api.Patch;
import oracle.glcm.opatch.common.api.install.FileState;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchingFlow;
import oracle.opatch.PrereqSession;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.cup.CUPXmlException;
import oracle.opatch.cup.CUPxmlJaxbBinder;
import oracle.opatch.cup.jaxb.ComponentInfo;
import oracle.opatch.cup.jaxb.FileInfo;
import oracle.opatch.cup.jaxb.PatchComponentInfoCUP;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class CUPFileHandler {
    private static Map<String, List<Path>> affectedConflictFilesMap = null;
    private static Map<String, List<ComponentInfo>> cupPatchComponentInfoMap = null;
    private static Map<String, List<ComponentInfo>> cupPatchComponentInfoReferencedFileMap = null;
    private PatchComponentInfoCUP cupXmlObj;

    public CUPFileHandler() {
        if (cupPatchComponentInfoMap == null) {
            try {
                this.load();
            }
            catch (Exception e2) {
                OLogger.error("CUP Loading xml Error:" + e2.getMessage());
            }
        }
    }

    public List<Path> getAffectFilesForConflictCheck(OneOffEntry oneoff) {
        String key = this.buildKey(oneoff.getPatchID(), oneoff.getID());
        if (affectedConflictFilesMap.containsKey(key)) {
            return affectedConflictFilesMap.get(key);
        }
        return new ArrayList<Path>();
    }

    public List<CUPPatchComponent> getCUPPatchComponentList(PatchObject patchobj) {
        ArrayList<CUPPatchComponent> cupPatchCompList = new ArrayList<CUPPatchComponent>();
        String key = this.buildKey(patchobj.getPatchID(), patchobj.getPatchUniqID());
        if (cupPatchComponentInfoMap.containsKey(key)) {
            List<ComponentInfo> componentXmlList = cupPatchComponentInfoMap.get(key);
            for (ComponentInfo compInfoXML : componentXmlList) {
                ArrayList<String> fileList = new ArrayList<String>();
                HashMap<FileState, List<String>> fileStateMap = new HashMap<FileState, List<String>>();
                for (FileInfo fileInfo : compInfoXML.getFile()) {
                    FileState fileState = FileState.valueOf((String)fileInfo.getStatus());
                    if (fileStateMap.containsKey(fileState)) {
                        ((List)fileStateMap.get(fileState)).add(fileInfo.getFileLoc());
                    } else {
                        ArrayList<String> fileListState = new ArrayList<String>();
                        fileListState.add(fileInfo.getFileLoc());
                        fileStateMap.put(fileState, fileListState);
                    }
                    fileList.add(fileInfo.getFileLoc());
                }
                CUPPatchComponent cupComp = new CUPPatchComponent(compInfoXML.getName(), compInfoXML.getVersion(), fileList, fileStateMap, patchobj);
                cupPatchCompList.add(cupComp);
            }
        }
        return cupPatchCompList;
    }

    public List<CUPPatchComponent> getCUPPatchComponentListForReferencedFiles(PatchObject patchobj) {
        ArrayList<CUPPatchComponent> cupPatchCompList = new ArrayList<CUPPatchComponent>();
        String key = this.buildKey(patchobj.getPatchID(), patchobj.getPatchUniqID());
        if (cupPatchComponentInfoReferencedFileMap.containsKey(key)) {
            List<ComponentInfo> componentXmlList = cupPatchComponentInfoReferencedFileMap.get(key);
            for (ComponentInfo compInfoXML : componentXmlList) {
                ArrayList<String> fileList = new ArrayList<String>();
                HashMap<FileState, List<String>> fileStateMap = new HashMap<FileState, List<String>>();
                for (FileInfo fileInfo : compInfoXML.getFile()) {
                    FileState fileState = FileState.valueOf((String)fileInfo.getStatus());
                    if (fileStateMap.containsKey(fileState)) {
                        ((List)fileStateMap.get(fileState)).add(fileInfo.getFileLoc());
                    } else {
                        ArrayList<String> fileListState = new ArrayList<String>();
                        fileListState.add(fileInfo.getFileLoc());
                        fileStateMap.put(fileState, fileListState);
                    }
                    fileList.add(fileInfo.getFileLoc());
                }
                CUPPatchComponent cupComp = new CUPPatchComponent(compInfoXML.getName(), compInfoXML.getVersion(), fileList, fileStateMap, patchobj);
                cupPatchCompList.add(cupComp);
            }
        }
        return cupPatchCompList;
    }

    private String buildKey(String patchID, String UPI) {
        return patchID + "_" + UPI;
    }

    protected void addConflictCheckFiles(Patch patch, List<Path> files) {
        String key = this.buildKey(patch.getPatchId(), patch.getPatchUpi());
        if (affectedConflictFilesMap.containsKey(key)) {
            List<Path> fileList = affectedConflictFilesMap.get(key);
            if (fileList != null) {
                fileList.addAll(files);
            }
        } else {
            affectedConflictFilesMap.put(key, files);
        }
    }

    protected void addComponentInfoMap(Patch patch, List<ComponentInfo> compInfoList) {
        String key = this.buildKey(patch.getPatchId(), patch.getPatchUpi());
        cupPatchComponentInfoMap.put(key, compInfoList);
    }

    protected void addComponentInfoReferencedFileMap(Patch patch, List<ComponentInfo> compInfoList) {
        String key = this.buildKey(patch.getPatchId(), patch.getPatchUpi());
        cupPatchComponentInfoReferencedFileMap.put(key, compInfoList);
    }

    public static Map<FileState, List<Path>> convert(Map<FileState, List<File>> map) {
        HashMap<FileState, List<Path>> mapTemp = new HashMap<FileState, List<Path>>();
        for (Map.Entry<FileState, List<File>> entry : map.entrySet()) {
            List<File> tempFile = entry.getValue();
            ArrayList<Path> listPath = new ArrayList<Path>();
            FileState tempKey = entry.getKey();
            for (File f2 : tempFile) {
                Path tempPath = f2.toPath();
                listPath.add(tempPath);
            }
            mapTemp.put(tempKey, listPath);
        }
        return mapTemp;
    }

    public void addConflictCheckFiles(Patch patch, Set<InventoryComponentInfo> compsInfoInInventoryApply) {
        ArrayList<ComponentInfo> compInfoList = new ArrayList<ComponentInfo>();
        ArrayList<ComponentInfo> compInfoList_ref = new ArrayList<ComponentInfo>();
        for (InventoryComponentInfo newInvComponentInfo : compsInfoInInventoryApply) {
            ComponentInfo componentInfo;
            InventoryComponentInfo.Action type = newInvComponentInfo.getAction();
            if (type.isAdd() || type.isRemove()) {
                Map<FileState, List<Path>> map = WrapperFactory.getCommonApiWrapper().getAffectedFiles(newInvComponentInfo);
                this.addConflictCheckFiles(patch, this.getAffectedFilesForConflictCheck(map));
                ComponentInfo componentInfo2 = this.buildComponentInfo(newInvComponentInfo.getName(), newInvComponentInfo.getVersion(), type.name(), map);
                if (!compInfoList.contains(componentInfo2)) {
                    compInfoList.add(componentInfo2);
                }
            }
            if (!OPatchEnv.isCASFlow() || compInfoList_ref.contains(componentInfo = this.buildComponentInfoForReferencedFiles(newInvComponentInfo.getName(), newInvComponentInfo.getVersion(), type.name(), newInvComponentInfo.getAffectedFiles())) || componentInfo.getFile().size() == 0) continue;
            StringBuffer strBuf = new StringBuffer("REFERENCE file details : ComponentName :" + componentInfo.getName());
            strBuf.append(",Totalfiles:" + componentInfo.getFile().size() + ",");
            compInfoList_ref.add(componentInfo);
            for (FileInfo file : componentInfo.getFile()) {
                strBuf.append(file.getFileLoc());
                strBuf.append(",");
            }
            OLogger.justlog(OLogger.INFO, strBuf.toString());
        }
        if (OPatchEnv.isCASFlow()) {
            this.addComponentInfoReferencedFileMap(patch, compInfoList_ref);
        }
        this.addComponentInfoMap(patch, compInfoList);
    }

    private ComponentInfo buildComponentInfo(String compName, String version, String status, Map<FileState, List<Path>> filesMap) {
        ComponentInfo compInfo = new ComponentInfo();
        compInfo.setName(compName);
        compInfo.setVersion(version);
        compInfo.setStatus(status);
        ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        for (Map.Entry<FileState, List<Path>> entry : filesMap.entrySet()) {
            String fileState = entry.getKey().toString();
            List<Path> fileList = entry.getValue();
            List<String> fileNameList = this.format(fileList);
            for (String file : fileNameList) {
                FileInfo fileInfo = this.buildFileInfo(fileState, file);
                fileInfoList.add(fileInfo);
            }
        }
        if (fileInfoList.size() > 0) {
            compInfo.getFile().addAll(fileInfoList);
        }
        return compInfo;
    }

    private ComponentInfo buildComponentInfoForReferencedFiles(String compName, String version, String status, Map<FileState, List<File>> filesMap) {
        try {
            ComponentInfo compInfo = new ComponentInfo();
            compInfo.setName(compName);
            compInfo.setVersion(version);
            compInfo.setStatus(status);
            ArrayList<FileInfo> fileInfoList = new ArrayList<FileInfo>();
            for (Map.Entry<FileState, List<File>> entry : filesMap.entrySet()) {
                String fileState = entry.getKey().toString();
                List<File> fileList = entry.getValue();
                if (!fileState.equalsIgnoreCase(FileState.REFERENCED.toString())) continue;
                for (File file : fileList) {
                    Path path = Paths.get(file.toString(), new String[0]);
                    String pathStr = file.toString();
                    boolean isAbsolute = path.isAbsolute();
                    if (isAbsolute) {
                        String oracleHome = OPatchEnv.getOracleHome();
                        Path ohPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHome, new String[0]);
                        Path relativePath = ohPath.relativize(path);
                        pathStr = relativePath.toString();
                    }
                    FileInfo fileInfo = this.buildFileInfo(fileState, pathStr);
                    fileInfoList.add(fileInfo);
                }
            }
            if (fileInfoList.size() > 0) {
                compInfo.getFile().addAll(fileInfoList);
            }
            return compInfo;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private List<String> format(List<Path> fileList) {
        ArrayList<String> fileNameList = new ArrayList<String>();
        String oracleHome = OPatchEnv.getOracleHome();
        Path ohPath = WrapperFactory.getNioServiceWrapper().getPath(oracleHome, new String[0]);
        for (Path file : fileList) {
            Path relativePath = ohPath.relativize(file);
            fileNameList.add(relativePath.toString());
        }
        return fileNameList;
    }

    private FileInfo buildFileInfo(String status, String file) {
        FileInfo fileInfo = new FileInfo();
        fileInfo.setStatus(status);
        fileInfo.setName("");
        fileInfo.setFileLoc(file);
        return fileInfo;
    }

    private List<Path> getAffectedFilesForConflictCheck(Map<FileState, List<Path>> map) {
        ArrayList<Path> afftedFilesForConflictCheck = new ArrayList<Path>();
        if (map == null) {
            return afftedFilesForConflictCheck;
        }
        if (map.containsKey(FileState.ADDED)) {
            afftedFilesForConflictCheck.addAll((Collection<Path>)map.get(FileState.ADDED));
        }
        if (map.containsKey(FileState.DELETED)) {
            afftedFilesForConflictCheck.addAll((Collection<Path>)map.get(FileState.DELETED));
        }
        if (map.containsKey(FileState.MODIFIED)) {
            afftedFilesForConflictCheck.addAll((Collection<Path>)map.get(FileState.MODIFIED));
        }
        return afftedFilesForConflictCheck;
    }

    private void loadFromXML(String oracleHomePath, OneOffEntry oneoff) throws CUPXmlException, Exception {
        String ouiXMLpath = this.getfilesChangeXMLPath(oracleHomePath, oneoff.getPatchObject());
        Path filesOUIXML = WrapperFactory.getNioServiceWrapper().getPath(ouiXMLpath, new String[0]);
        if (Files.exists(filesOUIXML, new LinkOption[0])) {
            this.cupXmlObj = CUPxmlJaxbBinder.getInstance().loadFromXML(filesOUIXML);
            String key = this.buildKey(this.cupXmlObj.getPatchID(), this.cupXmlObj.getUPI());
            affectedConflictFilesMap.put(key, this.getAffectedConflictFiles(this.cupXmlObj));
            cupPatchComponentInfoMap.put(key, this.cupXmlObj.getComponent());
        }
        if (OPatchEnv.isCASFlow() || OPatchEnv.getPatchingFlow().equals((Object)PatchingFlow.TWO_PHASE)) {
            String referencedFilesXMLpath = this.getReferencedfilesChangeXMLPath(oracleHomePath, oneoff.getPatchObject());
            Path referencedFilesXML = WrapperFactory.getNioServiceWrapper().getPath(referencedFilesXMLpath, new String[0]);
            if (Files.exists(referencedFilesXML, new LinkOption[0])) {
                OLogger.justlog(OLogger.INFO, "Load from referencedFilesXML Path: " + referencedFilesXML.toString());
                this.cupXmlObj = CUPxmlJaxbBinder.getInstance().loadFromXML(referencedFilesXML);
                String key = this.buildKey(this.cupXmlObj.getPatchID(), this.cupXmlObj.getUPI());
                cupPatchComponentInfoReferencedFileMap.put(key, this.cupXmlObj.getComponent());
            } else {
                OLogger.justlog(OLogger.INFO, "referencedFilesXML :" + referencedFilesXML.toString() + " not exists");
            }
        }
    }

    private List<Path> getAffectedConflictFiles(PatchComponentInfoCUP cupXMLObject) {
        ArrayList<Path> files = new ArrayList<Path>();
        String oracleHome = OPatchEnv.getOracleHome();
        for (int i2 = 0; i2 < cupXMLObject.getComponent().size(); ++i2) {
            List<FileInfo> affectedFileList = cupXMLObject.getComponent().get(i2).getFile();
            for (int j2 = 0; j2 < affectedFileList.size(); ++j2) {
                FileInfo affectedFileInfo = affectedFileList.get(j2);
                String fileLoc = affectedFileInfo.getFileLoc();
                if (affectedFileInfo.getStatus() != "ADDED" && affectedFileInfo.getStatus() != "DELETED" && affectedFileInfo.getStatus() != "MODIFIED") continue;
                files.add(WrapperFactory.getNioServiceWrapper().getPath(oracleHome + File.separator + fileLoc, new String[0]));
            }
        }
        return files;
    }

    public void load() throws Exception {
        OneOffEntry[] pohs;
        affectedConflictFilesMap = new HashMap<String, List<Path>>();
        cupPatchComponentInfoMap = new HashMap<String, List<ComponentInfo>>();
        cupPatchComponentInfoReferencedFileMap = new HashMap<String, List<ComponentInfo>>();
        String oracleHome = OPatchEnv.getOracleHome();
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHome);
        }
        catch (Throwable e2) {
            throw new RuntimeException(e2.getMessage());
        }
        for (OneOffEntry oneoff : pohs = readServices.getInstalledPatches()) {
            try {
                this.loadFromXML(oracleHome, oneoff);
            }
            catch (CUPXmlException e3) {
                throw new CUPXmlException("Loading from Poh's xml" + e3.getMessage());
            }
        }
    }

    public void save(String oracleHomePath, PatchObject patchObject) throws CUPXmlException {
        Path xmlFile;
        String upi;
        String patchID = patchObject.getPatchID();
        String key = this.buildKey(patchID, upi = patchObject.getPatchUniqID());
        if (affectedConflictFilesMap.containsKey(key)) {
            OLogger.debug("Start Saving files_change_by_oui XML.");
            this.cupXmlObj = new PatchComponentInfoCUP();
            this.cupXmlObj.setPatchID(patchID);
            this.cupXmlObj.setUPI(upi);
            this.cupXmlObj.getComponent().addAll((Collection<ComponentInfo>)cupPatchComponentInfoMap.get(key));
            try {
                xmlFile = WrapperFactory.getNioServiceWrapper().getPath(this.getfilesChangeXMLPath(oracleHomePath, patchObject), new String[0]);
                CUPxmlJaxbBinder.getInstance().saveToXML(this.cupXmlObj, xmlFile);
            }
            catch (CUPXmlException e2) {
                throw new CUPXmlException("Can not save files_change_by_oui XML. " + e2.getMessage());
            }
            catch (Exception e3) {
                throw new CUPXmlException("Can not save files_change_by_oui XML. " + e3.getMessage());
            }
        }
        if (OPatchEnv.isCASFlow()) {
            if (cupPatchComponentInfoReferencedFileMap.containsKey(key)) {
                OLogger.justlog(OLogger.INFO, "Start Saving referenced_files_by_oui XML.");
                this.cupXmlObj = new PatchComponentInfoCUP();
                this.cupXmlObj.setPatchID(patchID);
                this.cupXmlObj.setUPI(upi);
                this.cupXmlObj.getComponent().addAll((Collection<ComponentInfo>)cupPatchComponentInfoReferencedFileMap.get(key));
                try {
                    xmlFile = WrapperFactory.getNioServiceWrapper().getPath(this.getReferencedfilesChangeXMLPath(oracleHomePath, patchObject), new String[0]);
                    OLogger.justlog(OLogger.INFO, "referenced_files.toAbsolutePath():" + xmlFile.toAbsolutePath());
                    CUPxmlJaxbBinder.getInstance().saveToXML(this.cupXmlObj, xmlFile);
                }
                catch (CUPXmlException e4) {
                    e4.printStackTrace();
                    throw new CUPXmlException("Can not save referenced_files_by_oui XML. " + e4.getMessage());
                }
                catch (Exception e5) {
                    e5.printStackTrace();
                    throw new CUPXmlException("EXCEPTION Can not save referenced_files_by_oui XML. " + e5.getMessage());
                }
            } else {
                OLogger.justlog(OLogger.INFO, "Referenced File list is empty for the patch key:" + key);
            }
        }
    }

    private String getfilesChangeXMLPath(String oracleHomePath, PatchObject patchObject) {
        String ohPatchLocToSave = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchObject.getTripletPatchID());
        StringBuffer ohfilesChangeOUI = new StringBuffer(ohPatchLocToSave);
        ohfilesChangeOUI.append(File.separator);
        ohfilesChangeOUI.append("etc");
        ohfilesChangeOUI.append(File.separator);
        ohfilesChangeOUI.append("config");
        ohfilesChangeOUI.append(File.separator);
        ohfilesChangeOUI.append("files_changed_by_OUI.xml");
        return ohfilesChangeOUI.toString();
    }

    private String getReferencedfilesChangeXMLPath(String oracleHomePath, PatchObject patchObject) {
        String ohPatchLocToSave = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchObject.getTripletPatchID());
        StringBuffer ohfilesChangeOUI = new StringBuffer(ohPatchLocToSave);
        ohfilesChangeOUI.append(File.separator);
        ohfilesChangeOUI.append("etc");
        ohfilesChangeOUI.append(File.separator);
        ohfilesChangeOUI.append("config");
        ohfilesChangeOUI.append(File.separator);
        ohfilesChangeOUI.append("referenced_files_by_oui.xml");
        return ohfilesChangeOUI.toString();
    }

    public static void clear() {
        affectedConflictFilesMap = null;
        cupPatchComponentInfoMap = null;
        cupPatchComponentInfoReferencedFileMap = null;
    }
}

