/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter.cbcc;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccException;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMapping;
import oracle.opatch.opatchlogger.OLogger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileMappingImpl
implements FileMapping {
    private static final String XML_TAG_BUGS = "bugs";
    private static final String XML_TAG_BUG = "bug";
    private static final String XML_TAG_BUG_NUMBER = "bug_number";
    private static final String XML_TAG_FILES = "files";
    private static final String XML_TAG_FILE = "file";
    private static final String XML_TAG_FILENAME = "file_name";
    private static final String XML_TAG_PATH = "path";
    private static final String XML_TAG_SHAOLUE = "shaolue";
    Map<String, List<FileMapping.FileInfo>> bugFileMap = new HashMap<String, List<FileMapping.FileInfo>>();
    Map<String, Set<String>> bugFileMapRaw = new HashMap<String, Set<String>>();
    Map<String, String> fileChecksumMap = new HashMap<String, String>();
    Map<String, List<String>> fileBugsMap = new HashMap<String, List<String>>();
    PatchObject patchObj;
    String patchId = "-1";

    public FileMappingImpl(Document doc, PatchObject patchObject) throws CbccException {
        this.patchObj = patchObject;
        if (patchObject != null) {
            this.patchId = patchObject.getPatchID();
        }
        this.loadContent(doc);
    }

    @Override
    public List<FileMapping.FileInfo> getFiles(String bugId) {
        if (this.bugFileMap.containsKey(bugId)) {
            return this.bugFileMap.get(bugId);
        }
        return new ArrayList<FileMapping.FileInfo>();
    }

    @Override
    public Set<String> getUnresolvedSymbolFiles(String bugId) {
        if (this.bugFileMapRaw.containsKey(bugId)) {
            return this.bugFileMapRaw.get(bugId);
        }
        return new HashSet<String>();
    }

    @Override
    public List<String> getBugs(String filename) {
        return this.fileBugsMap.get(filename);
    }

    @Override
    public List<String> getBugs(FileMapping.FileInfo fileInfo) {
        return this.getBugs(this.getAbsPathFile(fileInfo));
    }

    @Override
    public List<String> getBugs() {
        return new ArrayList<String>(this.bugFileMap.keySet());
    }

    @Override
    public List<FileMapping.FileInfo> getFiles() {
        ArrayList<FileMapping.FileInfo> files = new ArrayList<FileMapping.FileInfo>();
        for (Map.Entry<String, List<FileMapping.FileInfo>> entry : this.bugFileMap.entrySet()) {
            files.addAll((Collection<FileMapping.FileInfo>)entry.getValue());
        }
        return files;
    }

    @Override
    public String getPatchId() {
        return this.patchId;
    }

    @Override
    public boolean hasFile(String filename) {
        return this.fileChecksumMap.containsKey(filename);
    }

    @Override
    public boolean hasBug(String bugId) {
        return this.bugFileMap.containsKey(bugId);
    }

    @Override
    public String getChecksum(String filename) {
        if (this.hasFile(filename)) {
            return this.fileChecksumMap.get(filename);
        }
        return null;
    }

    @Override
    public boolean hasSameFileSet(String bugId, Set<String> thatFileSet) throws CbccException {
        if (!this.hasBug(bugId)) {
            throw new CbccException("No-op: bug (" + bugId + ") not found in this patch (" + this.patchId + ")");
        }
        Set<String> thisFileSet = this.getUnresolvedSymbolFiles(bugId);
        if (thisFileSet.size() != thatFileSet.size()) {
            return false;
        }
        return thisFileSet.equals(thatFileSet);
    }

    public String print() {
        Iterator<String> iter = this.bugFileMap.keySet().iterator();
        StringBuffer buf = new StringBuffer();
        buf.append("Patch number: " + this.getPatchId() + "\n");
        while (iter.hasNext()) {
            String bug = iter.next();
            buf.append("==> Bug: " + bug + "\n");
            List<FileMapping.FileInfo> fileInfoList = this.bugFileMap.get(bug);
            for (FileMapping.FileInfo f2 : fileInfoList) {
                buf.append("    File: " + f2.getFilename() + ";" + f2.getRelativePath() + ";" + f2.getCheckSum() + "\n");
            }
        }
        return new String(buf);
    }

    private void loadContent(Document doc) throws CbccException {
        Element root = doc.getDocumentElement();
        if (!XML_TAG_BUGS.equals(root.getNodeName())) {
            String str = "Invalid file-mapping.xml in patch: " + this.patchId + ". Tag not support: " + root.getNodeName();
            OLogger.warn(str);
            throw new CbccException(str);
        }
        NodeList bugNodeList = root.getChildNodes();
        for (int i2 = 0; i2 < bugNodeList.getLength(); ++i2) {
            Node bugNode = bugNodeList.item(i2);
            String bugNodeName = bugNode.getNodeName();
            if (bugNodeName.equals("#text")) continue;
            if (bugNodeName.equals(XML_TAG_BUG)) {
                Element bugElement = (Element)bugNode;
                String bugNumber = bugElement.getAttribute(XML_TAG_BUG_NUMBER);
                NodeList filesNodeList = bugNode.getChildNodes();
                ArrayList<FileMapping.FileInfo> fileInfoList = new ArrayList<FileMapping.FileInfo>();
                HashSet<String> fileNameUnresolvedSymbol = new HashSet<String>();
                for (int j2 = 0; j2 < filesNodeList.getLength(); ++j2) {
                    Node fileNode = filesNodeList.item(j2);
                    String fileNodeName = fileNode.getNodeName();
                    if (fileNodeName.equals("#text")) continue;
                    if (fileNodeName.equals(XML_TAG_FILES)) {
                        NodeList fileList = fileNode.getChildNodes();
                        for (int k2 = 0; k2 < fileList.getLength(); ++k2) {
                            Node file = fileList.item(k2);
                            String fileStr = file.getNodeName();
                            if (fileStr.equals("#text") || !fileStr.equals(XML_TAG_FILE)) continue;
                            Element fileElement = (Element)file;
                            String filename = fileElement.getAttribute(XML_TAG_FILENAME);
                            String path = fileElement.getAttribute(XML_TAG_PATH);
                            String shaolue = fileElement.getAttribute(XML_TAG_SHAOLUE);
                            Set<String> resolvedPaths = this.resolveSymbolInPath(path, filename, shaolue);
                            for (String p2 : resolvedPaths) {
                                FileInfoImpl fileInfoObj = new FileInfoImpl(this.getPatchId(), bugNumber, filename, p2, shaolue);
                                fileInfoList.add(fileInfoObj);
                            }
                            fileNameUnresolvedSymbol.add(path + File.separator + filename);
                        }
                        continue;
                    }
                    String str = "Invalid file-mapping.xml in patch: " + this.patchId + ". Element not support: " + fileNodeName;
                    OLogger.warn(str);
                    throw new CbccException(str);
                }
                this.bugFileMap.put(bugNumber, fileInfoList);
                this.bugFileMapRaw.put(bugNumber, fileNameUnresolvedSymbol);
                this.buildFileList(fileInfoList);
                this.buildFileBugAssociation(bugNumber, fileInfoList);
                continue;
            }
            String str = "Invalid file-mapping.xml in patch: " + this.patchId + ". Element not support: " + bugNodeName;
            OLogger.justlog(OLogger.WARNING, str);
            throw new CbccException(str);
        }
        this.print();
    }

    private Set<String> resolveSymbolInPath(String path, String filename, String shaolue) {
        HashSet<String> resolvedFilePaths = new HashSet<String>();
        if (path.contains("%SYMBOL%") && OPatchEnv.isSymbolResolveEnabled()) {
            HashSet<String> productDirectories = new HashSet<String>();
            for (PatchComponent patchComponent : this.patchObj.getPatchComponents()) {
                productDirectories.addAll(Arrays.asList(patchComponent.getProductDirectories(OPatchEnv.getOracleHome())));
            }
            for (String prodDir : productDirectories) {
                String replacedPath = path.replace("%SYMBOL%", prodDir).replace("%ORACLE_HOME%", OPatchEnv.getOracleHome());
                if (OPatchEnv.isWindows()) {
                    resolvedFilePaths.add(replacedPath.replace('/', File.separatorChar));
                    continue;
                }
                resolvedFilePaths.add(replacedPath);
            }
            HashSet<String> removeSet = new HashSet<String>();
            for (String resolvedPath : resolvedFilePaths) {
                boolean found = false;
                ListIterator copyActions = this.patchObj.getAllIncludedCopyActions();
                while (copyActions.hasNext()) {
                    String fmFilePath;
                    CopyAction copyAction = (CopyAction)copyActions.next();
                    String cpFilePath = OPatchEnv.getOracleHome() + File.separator + copyAction.getPath() + File.separator + copyAction.getCopyName();
                    if (!cpFilePath.equals(fmFilePath = resolvedPath + File.separator + filename) || !copyAction.getHashValue().equals(shaolue)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                removeSet.add(resolvedPath);
            }
            resolvedFilePaths.removeAll(removeSet);
        } else {
            resolvedFilePaths.add(path);
        }
        return resolvedFilePaths;
    }

    private void buildFileList(List<FileMapping.FileInfo> fileInfoList) {
        for (FileMapping.FileInfo fileInfo : fileInfoList) {
            String name = fileInfo.getFilename();
            String path = fileInfo.getRelativePath();
            String replaceOHPath = path.replaceFirst("%ORACLE_HOME%", OPatchEnv.getOracleHome());
            String absPathFile = replaceOHPath + File.separator + name;
            this.fileChecksumMap.put(absPathFile, fileInfo.getCheckSum());
        }
    }

    private void buildFileBugAssociation(String bugNumber, List<FileMapping.FileInfo> fileInfoList) {
        for (FileMapping.FileInfo fileInfo : fileInfoList) {
            List<Object> bugs;
            String absPathFile = this.getAbsPathFile(fileInfo);
            if (this.fileBugsMap.containsKey(absPathFile)) {
                bugs = this.fileBugsMap.get(absPathFile);
                bugs.add(bugNumber);
            } else {
                bugs = new ArrayList<String>();
                bugs.add(bugNumber);
            }
            this.fileBugsMap.put(absPathFile, bugs);
        }
    }

    @Override
    public String getAbsPathFile(FileMapping.FileInfo fileInfo) {
        String name = fileInfo.getFilename();
        String path = fileInfo.getRelativePath();
        String replaceOHPath = path.replaceFirst("%ORACLE_HOME%", OPatchEnv.getOracleHome());
        return replaceOHPath + File.separator + name;
    }

    public static void main(String[] args) {
        if (null == args || args.length == 0 || args.length != 2) {
            System.out.println("Require <patch_location> <oracle_home>");
            System.exit(0);
        }
        String patchLocation = args[0];
        String fileMappingLoc = patchLocation + "/etc/config/file-mapping.xml";
        Path fileMappingPath = Paths.get(fileMappingLoc, new String[0]);
        String oracleHome = args[1];
        System.setProperty("OPatch.ORACLE_HOME", oracleHome);
        System.out.println("==== Test Program: file-mapping.xml ====");
        System.out.println("patch location: " + patchLocation);
        System.out.println("--------------------------------------");
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(fileMappingPath.toFile());
            PatchObject patchObj = null;
            FileMappingImpl fileMapping = new FileMappingImpl(doc, patchObj);
            System.out.println(fileMapping.print());
            System.out.println("\n-----Get all bugs------");
            System.out.println(fileMapping.getBugs());
            System.out.println("\n-----Get all files-----");
            for (FileMapping.FileInfo f2 : fileMapping.getFiles()) {
                System.out.println("==> " + f2.toString());
            }
        }
        catch (FileNotFoundException f3) {
            System.out.println(f3.getMessage());
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public class FileInfoImpl
    implements FileMapping.FileInfo {
        String patchId;
        String bugId;
        String filename;
        String relativePath;
        String hashValue;

        public FileInfoImpl(String patchId, String bugId, String filename, String relPath, String shaolue) {
            this.patchId = patchId;
            this.bugId = bugId;
            this.filename = filename;
            this.relativePath = relPath;
            this.hashValue = shaolue;
        }

        @Override
        public String getPatchId() {
            return this.patchId;
        }

        @Override
        public String getBugId() {
            return this.bugId;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public String getRelativePath() {
            return this.relativePath;
        }

        @Override
        public String getCheckSum() {
            return this.hashValue;
        }

        @Override
        public boolean sameFilename(String filename) {
            return this.filename.compareTo(filename) == 0;
        }

        @Override
        public boolean sameChecksum(String checksum) {
            return this.hashValue.compareTo(this.hashValue) == 0;
        }

        public String toString() {
            return "filename=" + this.filename + ", path=" + this.relativePath + ", shaolue=" + this.hashValue;
        }
    }
}

