/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter.cbcc;

import java.util.List;
import java.util.Set;
import oracle.opatch.PatchObject;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.Patch;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccException;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccPatch;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMapping;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMappingImpl;
import oracle.opatch.opatchlogger.OLogger;

public class CbccPatchImpl
implements CbccPatch {
    private IPatch patch;
    private FileMapping fileMapping = null;
    private boolean cbccEnabled = false;

    public CbccPatchImpl(Patch patch) {
        this.patch = patch;
        PatchObject patchObj = this.patch.getOneOffEntry().getPatchObject();
        if (patchObj.isCbccPatch()) {
            this.cbccEnabled = true;
            this.fileMapping = patchObj.getFileMappingList();
        }
        OLogger.debug("CbccPatchImpl constructor - patch id: " + patch.getPatchId() + ", CBCC enabled ? " + this.cbccEnabled);
    }

    @Override
    public boolean isCbccEnabled() {
        return this.cbccEnabled;
    }

    @Override
    public IPatch getPatch() {
        return this.patch;
    }

    @Override
    public String getPatchId() {
        return this.patch.getOneOffEntry().getPatchID();
    }

    @Override
    public FileMapping getFilesMap() {
        return this.fileMapping;
    }

    @Override
    public boolean hasFile(String filename) {
        return this.fileMapping.hasFile(filename);
    }

    @Override
    public String getChecksum(String filename) {
        return this.fileMapping.getChecksum(filename);
    }

    @Override
    public List<String> getBugs(String filename) {
        return this.fileMapping.getBugs(filename);
    }

    @Override
    public boolean hasSameFileSet(String bug, Set<String> fileSet) throws CbccException {
        return this.fileMapping.hasSameFileSet(bug, fileSet);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Patch ID: " + this.getPatchId() + "\n");
        buf.append("---\n");
        buf.append("is composite ? " + this.patch.getOneOffEntry().getPatchObject().getIsComposite() + "\n");
        buf.append("is CBCC patch ? " + this.isCbccEnabled() + "\n");
        FileMapping fm = this.getFilesMap();
        buf.append("has file-map metadata ? " + (null == fm ? "no" : "yes") + "\n");
        if (null != fm) {
            buf.append(((FileMappingImpl)fm).print());
        }
        return buf.toString();
    }
}

