/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.ConflictMapUtil;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.opatchlogger.OLogger;

public class RelationAdjustment
implements IStep {
    private IConflictMap originalMap = null;

    @Override
    public void process(IConflictMap map, INPatchPlan plan) {
        this.processSnowball(map, plan);
        this.processOverlay(map, plan);
        this.processCompositeAsEntirety(map);
    }

    private void processSnowball(IConflictMap map, INPatchPlan plan) {
        Collection<IPatch> pis = map.getPi();
        ArrayList<IPatch> mergedList = new ArrayList<IPatch>();
        mergedList.addAll(pis);
        mergedList.addAll(map.getPoh());
        for (IPatch pi : pis) {
            for (IPatch patch : mergedList) {
                if (!this.shouldIgnoreConflict(pi.getOneOffEntry(), patch.getOneOffEntry())) continue;
                ConflictMapUtil.delete(map, pi, patch);
            }
        }
    }

    private void processOverlay(IConflictMap map, INPatchPlan plan) {
        this.addCompositeOverlay(map);
        ArrayList<IPatch> pis = new ArrayList<IPatch>();
        for (IPatch pi : map.getPi()) {
            if (pi.isComposite()) {
                pis.addAll(pi.getSubPatches());
            }
            pis.add(pi);
        }
        for (IPatch pi : pis) {
            Collection<String> overlays = pi.getOverlaysID();
            for (String beOverlayID : overlays) {
                Collection beOverlayedPatches = map.getPatches(beOverlayID);
                for (IPatch beOverlayedPatch : beOverlayedPatches) {
                    ConflictMapUtil.delete(map, pi, beOverlayedPatch);
                }
            }
        }
    }

    private boolean shouldIgnoreConflict(OneOffEntry incomingPatch, OneOffEntry insidePatch) {
        boolean ignoreConflict = false;
        String incomingPatchType = incomingPatch.getPatchType();
        String insidePatchType = insidePatch.getPatchType();
        ignoreConflict = incomingPatchType.equals("snowball") && insidePatchType.equals("snowball") || incomingPatchType.equals("singleton") && insidePatchType.equals("snowball");
        return ignoreConflict;
    }

    protected void addCompositeOverlay(IConflictMap map) {
        Collection<IPatch> pis = map.getPi();
        Collection<IPatch> pohs = map.getPoh();
        ArrayList<IPatch> patches = new ArrayList<IPatch>();
        patches.addAll(pis);
        patches.addAll(pohs);
        HashSet<String> tmpOverlayIDs = new HashSet<String>();
        for (IPatch patch : patches) {
            if (patch.isComposite()) continue;
            tmpOverlayIDs.clear();
            for (String id : patch.getOverlaysID()) {
                tmpOverlayIDs.add(id);
            }
            for (String overlayID : tmpOverlayIDs) {
                Collection overlayPatches = map.getPatches(overlayID);
                for (Object obj : overlayPatches) {
                    IPatch overlayPatch = (IPatch)obj;
                    if (!overlayPatch.isComposite()) continue;
                    Collection<String> compositeOverlays = overlayPatch.getOverlaysID();
                    for (String overridUPI : overlayPatch.getOverridingUPIs()) {
                        for (IPatch overridpatch : map.getPatchByUPI(overridUPI)) {
                            compositeOverlays.addAll(overridpatch.getOverlaysID());
                        }
                    }
                    for (String compositeOverlay : compositeOverlays) {
                        OLogger.debug("Add overlay from " + patch.getPatchId() + "\t to \t " + compositeOverlay + " is in oh:" + patch.isInOh());
                        patch.addOverlay(compositeOverlay);
                    }
                }
            }
        }
    }

    private void processCompositeSubset(IConflictMap map, INPatchPlan plan) {
        Collection<IPatch> pis = map.getPi();
        for (IPatch pi : pis) {
            if (!pi.isComposite()) continue;
            Collection<NPatchRelation> subSetRelations = map.getRelations(pi).getSubsets();
            Iterator<NPatchRelation> subSetIte = subSetRelations.iterator();
            while (subSetIte.hasNext()) {
                NPatchRelation subSetRelation = subSetIte.next();
                IPatch poh = subSetRelation.to();
                IPatch pfrom = subSetRelation.from();
                ArrayList<IPatch> allSubSetOfPoh = new ArrayList<IPatch>();
                NPatchRelation relationFromOH = null;
                for (NPatchRelation nPatchRelation : map.getRelations(poh).getSupersets()) {
                    allSubSetOfPoh.add(nPatchRelation.to());
                    if (!nPatchRelation.to().getPatchId().equals(pfrom.getPatchId())) continue;
                    relationFromOH = nPatchRelation;
                }
                if (allSubSetOfPoh.containsAll(pi.getSubPatches()) && allSubSetOfPoh.contains(pi)) continue;
                map.getRelations(pi).addConflict(subSetRelation);
                map.getRelations(poh).addConflict(relationFromOH);
                subSetIte.remove();
                map.getRelations(poh).getSupersets().remove(relationFromOH);
            }
            Collection<NPatchRelation> worseRelations = map.getRelations(pi).getWorses();
            Iterator<NPatchRelation> worseIte = worseRelations.iterator();
            while (worseIte.hasNext()) {
                NPatchRelation worseRelation = worseIte.next();
                IPatch poh = worseRelation.to();
                IPatch pfrom = worseRelation.from();
                NPatchRelation relationFromOH = null;
                for (NPatchRelation relation : map.getRelations(poh).getBetters()) {
                    if (!relation.to().getPatchId().equals(pfrom.getPatchId())) continue;
                    relationFromOH = relation;
                }
                map.getRelations(pi).addConflict(worseRelation);
                map.getRelations(poh).addConflict(relationFromOH);
                worseIte.remove();
                map.getRelations(poh).getBetters().remove(relationFromOH);
            }
            Collection<NPatchRelation> duplicateRelations = map.getRelations(pi).getDuplicates();
            Iterator<NPatchRelation> duplicateIte = duplicateRelations.iterator();
            while (duplicateIte.hasNext()) {
                NPatchRelation duplicateRelation = duplicateIte.next();
                IPatch poh = duplicateRelation.to();
                IPatch iPatch = duplicateRelation.from();
                NPatchRelation relationFromOH = null;
                for (NPatchRelation relation : map.getRelations(poh).getDuplicates()) {
                    if (!relation.to().getPatchId().equals(iPatch.getPatchId())) continue;
                    relationFromOH = relation;
                }
                map.getRelations(pi).addConflict(duplicateRelation);
                map.getRelations(poh).addConflict(relationFromOH);
                duplicateIte.remove();
                map.getRelations(poh).getDuplicates().remove(relationFromOH);
            }
        }
    }

    private void createWholeCompositeRelation(IConflictMap finalMap, IPatch patch) {
        if (!patch.isComposite()) {
            return;
        }
        if (patch.isInOh() && patch.isComposite() && !patch.isTopLevelPSU()) {
            return;
        }
        HashSet<String> compositeBugs = new HashSet<String>();
        for (IPatch subPatch : patch.getSubPatches()) {
            compositeBugs.addAll(subPatch.getBugs());
        }
        compositeBugs.addAll(patch.getBugs());
        int compositeBugsLen = compositeBugs.size();
        Set<IPatch> relatedPatches = ConflictMapUtil.getAllRelatedPatches(finalMap, patch);
        if (patch.isInOh()) {
            for (IPatch subPatch : patch.getSubPatches()) {
                relatedPatches.addAll(ConflictMapUtil.getAllRelatedPatches(finalMap, subPatch));
            }
        }
        for (IPatch relatedPatch : relatedPatches) {
            if (relatedPatch.isComposite() || patch.isInOh() && relatedPatch.isInOh()) continue;
            HashSet sameBugs = new HashSet(compositeBugs);
            sameBugs.retainAll(relatedPatch.getBugs());
            Set<String> relatedBugs = relatedPatch.getBugs();
            int sameBugsLen = sameBugs.size();
            int relatedBugsLen = relatedBugs.size();
            ArrayList<String> sameBugsArr = new ArrayList<String>(sameBugs);
            if (sameBugsLen > 0) {
                if (compositeBugsLen > sameBugsLen && relatedBugsLen > sameBugsLen) {
                    finalMap.addConflictRelation(patch, relatedPatch, true, sameBugsArr, true);
                    finalMap.addConflictRelation(relatedPatch, patch, true, sameBugsArr, true);
                    if (this.originalMap == null) continue;
                    this.originalMap.addConflictRelation(patch, relatedPatch, true, sameBugsArr, true);
                    this.originalMap.addConflictRelation(relatedPatch, patch, true, sameBugsArr, true);
                    continue;
                }
                if (compositeBugsLen == relatedBugsLen) {
                    if (patch.isInOh()) {
                        finalMap.addSupersetRelation(patch, relatedPatch, sameBugsArr, true);
                        finalMap.addSubsetRelation(relatedPatch, patch, sameBugsArr, true);
                        if (this.originalMap == null) continue;
                        this.originalMap.addSupersetRelation(patch, relatedPatch, sameBugsArr, true);
                        this.originalMap.addSubsetRelation(relatedPatch, patch, sameBugsArr, true);
                        continue;
                    }
                    finalMap.addSubsetRelation(patch, relatedPatch, sameBugsArr, true);
                    finalMap.addSupersetRelation(relatedPatch, patch, sameBugsArr, true);
                    if (this.originalMap == null) continue;
                    this.originalMap.addSubsetRelation(patch, relatedPatch, sameBugsArr, true);
                    this.originalMap.addSupersetRelation(relatedPatch, patch, sameBugsArr, true);
                    continue;
                }
                if (compositeBugsLen < relatedBugsLen) {
                    finalMap.addSubsetRelation(patch, relatedPatch, sameBugsArr, true);
                    finalMap.addSupersetRelation(relatedPatch, patch, sameBugsArr, true);
                    if (this.originalMap == null) continue;
                    this.originalMap.addSubsetRelation(patch, relatedPatch, sameBugsArr, true);
                    this.originalMap.addSupersetRelation(relatedPatch, patch, sameBugsArr, true);
                    continue;
                }
                if (compositeBugsLen <= relatedBugsLen) continue;
                finalMap.addSupersetRelation(patch, relatedPatch, sameBugsArr, true);
                finalMap.addSubsetRelation(relatedPatch, patch, sameBugsArr, true);
                if (this.originalMap == null) continue;
                this.originalMap.addSupersetRelation(patch, relatedPatch, sameBugsArr, true);
                this.originalMap.addSubsetRelation(relatedPatch, patch, sameBugsArr, true);
                continue;
            }
            sameBugsArr.add("");
            finalMap.addConflictRelation(patch, relatedPatch, false, sameBugsArr, true);
            finalMap.addConflictRelation(relatedPatch, patch, false, sameBugsArr, true);
            if (this.originalMap == null) continue;
            this.originalMap.addConflictRelation(patch, relatedPatch, false, sameBugsArr, true);
            this.originalMap.addConflictRelation(relatedPatch, patch, false, sameBugsArr, true);
        }
    }

    private void processCompositeAsEntirety(IConflictMap map) {
        Collection<IPatch> pis = map.getPi();
        for (IPatch pi : pis) {
            if (!pi.isComposite()) continue;
            this.createWholeCompositeRelation(map, pi);
        }
        for (IPatch poh : map.getPoh()) {
            if (!poh.isTopLevelPSU()) continue;
            this.createWholeCompositeRelation(map, poh);
        }
    }

    public void setOriginalMap(IConflictMap map) {
        this.originalMap = map;
    }
}

