/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.Collection;
import oracle.opatch.OPatchEnv;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.SetResolution;
import oracle.opatch.opatchlogger.OLogger;

public class PolicyProcessingStep
implements IStep {
    @Override
    public void process(IConflictMap map, INPatchPlan plan) {
        OLogger.debug("Process policy option...");
        Collection<IPatch> pis = map.getPi();
        SetResolution setRes = SetResolution.getInstance();
        for (IPatch pi : pis) {
            NPatchRelations nPatchRelations = map.getRelations(pi);
            Collection<NPatchRelation> conflictRelationList = nPatchRelations.getWholeConflicts();
            for (NPatchRelation conflictRelation : conflictRelationList) {
                if (OPatchEnv.isForceConflict()) {
                    IPatch conflictPatchInOH = conflictRelation.to();
                    if (conflictPatchInOH.isComposite()) {
                        if (!OPatchEnv.isOptimize()) continue;
                        setRes.mark(pi, null);
                    }
                    setRes.mark(conflictPatchInOH, null);
                    conflictPatchInOH.setRemoveInactiveSubset(true);
                }
                if (!OPatchEnv.isIgnoreConflict()) continue;
                setRes.mark(pi, null);
            }
        }
        setRes.resolve(map, plan);
    }
}

