/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OneOffEntry;
import oracle.opatch.conflicttextualinterpreter.ConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.IConflictMapBuilder;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.NPatchRelation;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckConflictAdapter;

public class OracleHomeConflictMap {
    private static OracleHomeConflictMap instance = null;
    private IConflictMap map = null;
    private List<OneOffEntry> subsetPSUTrain = new ArrayList<OneOffEntry>();
    private List<OneOffEntry> subsetPatches = new ArrayList<OneOffEntry>();
    private List<IPatch> subsetIPatches = new ArrayList<IPatch>();
    private Map<String, Set<String>> supersetMap = new HashMap<String, Set<String>>();
    private static Map<String, String> toActivePatchMap = new HashMap<String, String>();
    private static Map<String, String> toInActivePatchMap = new HashMap<String, String>();

    public static OracleHomeConflictMap getInstance(OneOffEntry[] pohOneOffs, String oracleHome) {
        if (instance == null) {
            instance = new OracleHomeConflictMap(pohOneOffs, oracleHome);
        }
        return instance;
    }

    public static OracleHomeConflictMap getInstance() {
        return instance;
    }

    public static void clear() {
        instance = null;
    }

    private OracleHomeConflictMap(OneOffEntry[] pohOneOffs, String oracleHome) {
        boolean isInOH = false;
        boolean skipMissingComp = false;
        boolean isPoh = true;
        CheckConflictAdapter adapter = new CheckConflictAdapter();
        Collection<IPatch> pohs = adapter.convertOneOffEntryToIPatch(pohOneOffs, isInOH, isPoh, skipMissingComp, oracleHome);
        IConflictMapBuilder builder = ConflictMapBuilder.getInstance();
        this.map = instance != null && OracleHomeConflictMap.instance.map != null ? OracleHomeConflictMap.instance.map : builder.buildOH(pohs);
    }

    public HashMap<IPatch, NPatchRelations> getRelationsMap() {
        if (this.map != null) {
            return this.map.getRelationsMap();
        }
        return null;
    }

    public List<OneOffEntry> getSubsetPSUTrain() {
        if (this.subsetPSUTrain != null && !this.subsetPSUTrain.isEmpty()) {
            return this.subsetPSUTrain;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations = this.map.getRelations(poh);
            Collection<NPatchRelation> subSets = relations.getSubsetPSU();
            if (subSets.size() <= 0) continue;
            this.subsetPSUTrain.add(poh.getOneOffEntry());
            for (IPatch subpatch : poh.getSubPatches()) {
                this.subsetPSUTrain.add(subpatch.getOneOffEntry());
            }
        }
        return this.subsetPSUTrain;
    }

    public List<OneOffEntry> getSubsetPatches() {
        if (this.subsetPatches != null && !this.subsetPatches.isEmpty()) {
            return this.subsetPatches;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations;
            Collection<NPatchRelation> subSets;
            if (poh.isComposite() || (subSets = (relations = this.map.getRelations(poh)).getSubsets()).size() <= 0) continue;
            this.subsetPatches.add(poh.getOneOffEntry());
        }
        return this.subsetPatches;
    }

    public List<IPatch> getSubsetIPatches() {
        if (this.subsetIPatches != null && !this.subsetIPatches.isEmpty()) {
            return this.subsetIPatches;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations = this.map.getRelations(poh);
            Collection<NPatchRelation> subSets = relations.getSubsets();
            if (subSets.size() <= 0) continue;
            this.subsetIPatches.add(poh);
        }
        return this.subsetIPatches;
    }

    public List<IPatch> getSupersetPatches(IPatch poh) {
        ArrayList<IPatch> supersets = new ArrayList<IPatch>();
        NPatchRelations relations = this.map.getRelations(poh);
        Collection<NPatchRelation> subSets = relations.getSubsets();
        for (NPatchRelation subRelation : subSets) {
            supersets.add(subRelation.to());
        }
        return supersets;
    }

    public Map<String, Set<String>> getSupersetMap() {
        if (this.supersetMap != null && !this.supersetMap.keySet().isEmpty()) {
            return this.supersetMap;
        }
        Collection<IPatch> tpohs = this.map.getPi();
        for (IPatch poh : tpohs) {
            NPatchRelations relations = this.map.getRelations(poh);
            Collection<NPatchRelation> supersets = relations.getSupersets();
            for (NPatchRelation supersetRel : supersets) {
                String supersetID = supersetRel.from().getPatchId();
                String subsetID = supersetRel.to().getPatchId();
                if (this.supersetMap.containsKey(supersetID)) {
                    this.supersetMap.get(supersetID).add(subsetID);
                    continue;
                }
                HashSet<String> subsetSets = new HashSet<String>();
                subsetSets.add(subsetID);
                this.supersetMap.put(supersetID, subsetSets);
            }
        }
        return this.supersetMap;
    }

    public List<String> addConflictsWithToActivePatch(List<String> rollbackIds) {
        Collection<IPatch> tpohs = this.map.getPi();
        ArrayList<String> finalRollbackList = new ArrayList<String>(rollbackIds);
        OLogger.debug("Original rollback list: " + rollbackIds);
        this.setInactiveAfterRollback(tpohs, finalRollbackList);
        for (String rollbackId : rollbackIds) {
            for (IPatch poh : tpohs) {
                NPatchRelations relations;
                if (!poh.getPatchId().equals(rollbackId) || (relations = this.map.getRelations(poh)).getSupersets().isEmpty()) continue;
                for (NPatchRelation relation : relations.getSupersets()) {
                    IPatch toActivePatch = relation.to();
                    NPatchRelations toActiveRelations = this.map.getRelations(toActivePatch);
                    if (!toActivePatch.isActive()) continue;
                    if (!toActiveRelations.getConflicts().isEmpty()) {
                        for (NPatchRelation conflictRelation : toActiveRelations.getConflicts()) {
                            IPatch conflictPatch = conflictRelation.to();
                            if (this.canResolveConflict(conflictPatch, toActivePatch, finalRollbackList)) continue;
                            if (conflictPatch.isComposite()) {
                                throw new RuntimeException("Please nrollback composite patch " + conflictPatch.getPatchId() + " together with " + poh.getPatchId() + ".\n");
                            }
                            StringBuffer msg = new StringBuffer();
                            msg.append("Patch" + toActivePatch.getPatchId() + "will become active because rollback of Patch " + rollbackId);
                            msg.append("Patch " + conflictPatch.getPatchId() + "conflict with to_active patch " + toActivePatch.getPatchId());
                            OLogger.log(OLogger.FINE, msg.toString());
                            finalRollbackList.add(conflictPatch.getPatchId());
                        }
                    }
                    if (finalRollbackList.contains(toActivePatch.getPatchId())) continue;
                    toActivePatchMap.put(toActivePatch.getPatchId(), poh.getPatchId());
                }
            }
        }
        OLogger.debug("Extend rollback list: " + finalRollbackList);
        return finalRollbackList;
    }

    public static void printToActivePatchMessage() {
        StringBuffer buff = new StringBuffer("");
        if (toActivePatchMap != null && !toActivePatchMap.isEmpty() && !OPatchEnv.isReport()) {
            for (String key : toActivePatchMap.keySet()) {
                if (!toActivePatchMap.containsKey(key)) continue;
                buff.append("Inactive sub-set patch [");
                buff.append(key);
                buff.append("] has become active due to the rolling back of a super-set patch [");
                buff.append(toActivePatchMap.get(key));
                buff.append("].\n");
            }
            buff.append("Please refer to Doc ID 2161861.1 for any possible further required actions.");
            OLogger.println(buff.toString());
        }
    }

    public static void printToInActivePatchMessage() {
        StringBuffer buff = new StringBuffer("");
        if (toInActivePatchMap != null && !toInActivePatchMap.isEmpty() && !OPatchEnv.isReport()) {
            for (String key : toInActivePatchMap.keySet()) {
                if (!toInActivePatchMap.containsKey(key)) continue;
                buff.append("Sub-set patch [");
                buff.append(key);
                buff.append("] has become inactive due to the application of a super-set patch [");
                buff.append(toInActivePatchMap.get(key));
                buff.append("].\n");
            }
            buff.append("Please refer to Doc ID 2161861.1 for any possible further required actions.");
            OLogger.println(buff.toString());
        }
    }

    public Map<String, String> getToInActivePatchMap() {
        return toInActivePatchMap;
    }

    public Map<String, String> getToActivePatchMap() {
        return toActivePatchMap;
    }

    private boolean canResolveConflict(IPatch conflictPatch, IPatch toActivePatch, List<String> finalRollbackList) {
        if (finalRollbackList.contains(conflictPatch.getPatchId())) {
            if (!conflictPatch.isComposite()) {
                return true;
            }
            HashSet<String> bugs = new HashSet<String>();
            HashSet<String> files = new HashSet<String>();
            for (IPatch subPatch : conflictPatch.getSubPatches()) {
                if (finalRollbackList.contains(subPatch.getPatchId()) || toActivePatch.getOverlaysID().contains(subPatch.getPatchId())) continue;
                bugs.addAll(subPatch.getBugs());
                files.addAll(subPatch.getFiles());
            }
            bugs.retainAll(toActivePatch.getBugs());
            files.retainAll(toActivePatch.getFiles());
            if (bugs.isEmpty() && files.isEmpty()) {
                return true;
            }
        }
        boolean canResolve = false;
        if (toActivePatch.getOverlaysID().contains(conflictPatch.getPatchId()) || conflictPatch.getOverlaysID().contains(toActivePatch.getPatchId())) {
            canResolve = true;
        } else {
            if (conflictPatch.isComposite()) {
                HashSet<String> bugs = new HashSet<String>(conflictPatch.getBugs());
                HashSet<String> files = new HashSet<String>(conflictPatch.getFiles());
                for (IPatch subPatch : conflictPatch.getSubPatches()) {
                    if (!toActivePatch.getOverlaysID().contains(subPatch.getPatchId())) continue;
                    bugs.removeAll(subPatch.getBugs());
                    files.removeAll(subPatch.getFiles());
                }
                bugs.retainAll(toActivePatch.getBugs());
                files.retainAll(toActivePatch.getFiles());
                if (bugs.isEmpty() && files.isEmpty()) {
                    canResolve = true;
                }
            }
            if (!conflictPatch.isActive()) {
                canResolve = true;
            }
        }
        return canResolve;
    }

    public List<String> addSubsetsRecursively(List<String> rollbackIds) {
        Collection<IPatch> tpohs = this.map.getPi();
        HashMap<String, IPatch> pohMap = new HashMap<String, IPatch>();
        for (IPatch poh : tpohs) {
            if (poh.isComposite()) {
                for (IPatch subPatch : poh.getSubPatches()) {
                    pohMap.put(subPatch.getPatchId(), subPatch);
                }
            }
            pohMap.put(poh.getPatchId(), poh);
        }
        ArrayList<IPatch> toCheckList = new ArrayList<IPatch>();
        ArrayList<IPatch> finalRollbackList = new ArrayList<IPatch>();
        for (String rollbackId : rollbackIds) {
            IPatch toRollbackPatch = (IPatch)pohMap.get(rollbackId);
            if (toRollbackPatch != null && !toRollbackPatch.isComposite()) {
                toCheckList.add(toRollbackPatch);
            }
            if (toRollbackPatch == null) continue;
            finalRollbackList.add(toRollbackPatch);
        }
        for (IPatch patch : toCheckList) {
            this.getCompleteSubsets(patch, finalRollbackList);
        }
        ArrayList<String> finalRollbackIds = new ArrayList<String>();
        for (IPatch toRollback : finalRollbackList) {
            finalRollbackIds.add(toRollback.getPatchId());
        }
        return finalRollbackIds;
    }

    private void getCompleteSubsets(IPatch patch, List<IPatch> finalRollbackList) {
        NPatchRelations relations = this.map.getRelations(patch);
        if (!relations.getSupersets().isEmpty()) {
            for (NPatchRelation relation : relations.getSupersets()) {
                IPatch subsetPatch = relation.to();
                if (subsetPatch.isComposite()) continue;
                boolean canRollbackSubset = true;
                if (!this.map.getRelations(subsetPatch).getConflicts().isEmpty()) {
                    for (NPatchRelation conflictRelation : this.map.getRelations(subsetPatch).getConflicts()) {
                        IPatch conflictPatch = conflictRelation.to();
                        if (subsetPatch.getOverlaysID().contains(conflictPatch.getPatchId()) || conflictPatch.getOverlaysID().contains(subsetPatch.getPatchId())) continue;
                        canRollbackSubset = false;
                        break;
                    }
                }
                if (!canRollbackSubset) continue;
                for (IPatch supersetPatch : this.getSupersetPatches(subsetPatch)) {
                    if (supersetPatch.getPatchId().equals(patch.getPatchId()) || finalRollbackList.contains(supersetPatch)) continue;
                    canRollbackSubset = false;
                    break;
                }
                if (!canRollbackSubset || finalRollbackList.contains(subsetPatch)) continue;
                finalRollbackList.add(subsetPatch);
                this.getCompleteSubsets(subsetPatch, finalRollbackList);
            }
        }
    }

    public void setInactiveAfterRollback(Collection<IPatch> tpohs, List<String> finalRollbackList) {
        block0: for (IPatch poh : tpohs) {
            NPatchRelations relations = this.map.getRelations(poh);
            Collection<NPatchRelation> subsets = relations.getSubsets();
            Collection<NPatchRelation> subsetPSUs = relations.getSubsetPSU();
            ArrayList<NPatchRelation> allSubsets = new ArrayList<NPatchRelation>();
            if (!subsets.isEmpty()) {
                allSubsets.addAll(subsets);
            }
            if (!subsetPSUs.isEmpty()) {
                allSubsets.addAll(subsetPSUs);
            }
            if (allSubsets.isEmpty()) continue;
            for (NPatchRelation relation : allSubsets) {
                IPatch supersetPatch = relation.to();
                if (!finalRollbackList.contains(supersetPatch.getPatchId())) {
                    OLogger.printlnOnLog("Subset Patch " + poh.getPatchId() + " remain inactive due to active superset patch " + supersetPatch.getPatchId());
                    poh.setInActive();
                    continue block0;
                }
                if (!supersetPatch.isComposite()) continue;
                HashSet<String> bugs = new HashSet<String>();
                for (IPatch subPatch : supersetPatch.getSubPatches()) {
                    if (finalRollbackList.contains(subPatch.getPatchId())) continue;
                    bugs.addAll(subPatch.getBugs());
                }
                if (!bugs.containsAll(poh.getBugs())) continue;
                poh.setInActive();
                continue block0;
            }
        }
    }
}

