/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.opatch.conflicttextualinterpreter.IPatch;

public class MergePatch {
    private IPatch supersetPatch = null;
    private Collection<IPatch> subsetPatches = null;
    private ArrayList<IPatch> toMergePatches = new ArrayList();
    private Map<IPatch, List<IPatch>> overlayPatchesMap = new HashMap<IPatch, List<IPatch>>();
    private HashSet<String> bugs = new HashSet();

    protected MergePatch(IPatch supersetPatch, Collection<IPatch> subsetPatches) {
        this.supersetPatch = supersetPatch;
        this.subsetPatches = new ArrayList<IPatch>(subsetPatches);
    }

    public IPatch getSupersetPatch() {
        return this.supersetPatch;
    }

    public ArrayList<IPatch> getToMergePatch() {
        return this.toMergePatches;
    }

    public void addToMergePatch(IPatch patch) {
        this.toMergePatches.add(patch);
    }

    public void addOverlayPatches(IPatch patch, List<IPatch> overlayPatches) {
        this.overlayPatchesMap.put(patch, overlayPatches);
    }

    public List<IPatch> getOverlayPatches(IPatch patch) {
        return this.overlayPatchesMap.getOrDefault(patch, new ArrayList());
    }

    public Set<String> getBugs() {
        return this.bugs;
    }

    public void addBugs(Set<String> bugs) {
        this.bugs.addAll(bugs);
    }

    public boolean hasSubsetPatch(IPatch patch) {
        if (this.subsetPatches != null) {
            for (IPatch subsetPatch : this.subsetPatches) {
                if (!patch.equals(subsetPatch)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needMerge() {
        if (this.subsetPatches == null || this.toMergePatches == null) {
            return false;
        }
        return this.toMergePatches.size() > this.subsetPatches.size();
    }

    public boolean isSubPatchHasConflictingOverlay(IPatch patch) {
        if (this.hasSubsetPatch(patch)) {
            List<IPatch> overlayPatches = this.getOverlayPatches(patch);
            for (IPatch overlay : overlayPatches) {
                if (this.hasSubsetPatch(overlay)) continue;
                return true;
            }
        }
        return false;
    }
}

