/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.conflicttextualinterpreter;

import java.util.ArrayList;
import java.util.Collection;
import oracle.opatch.conflicttextualinterpreter.IConflictMap;
import oracle.opatch.conflicttextualinterpreter.INPatchPlan;
import oracle.opatch.conflicttextualinterpreter.IPatch;
import oracle.opatch.conflicttextualinterpreter.IStep;
import oracle.opatch.conflicttextualinterpreter.NPatchRelations;
import oracle.opatch.conflicttextualinterpreter.SetResolution;
import oracle.opatch.opatchlogger.OLogger;

public class Filter
implements IStep {
    @Override
    public void process(IConflictMap map, INPatchPlan plan) {
        OLogger.debug("Process subset patch ...");
        Collection<IPatch> pis = map.getPi();
        SetResolution setRes = SetResolution.getInstance();
        for (IPatch pi : pis) {
            NPatchRelations relations = map.getRelations(pi);
            if (!(relations.getWholeSubsets().isEmpty() && relations.getDuplicates().isEmpty() && relations.getWorses().isEmpty())) {
                OLogger.debug("MarkToRemove " + pi.getPatchId() + " that are the sub set/same/worse duplicate of another Pi or Poh.");
                setRes.mark(pi, new NPatchRelations(map.getRelations(pi)));
                continue;
            }
            if (!relations.getLowerPSUs().isEmpty()) {
                OLogger.debug("MarkToRemove the composite patch" + pi.getPatchId() + " that is the lower PSU of another Poh.");
                setRes.mark(pi, null);
                continue;
            }
            if (relations.getSubsetPSU().isEmpty()) continue;
            OLogger.debug("MarkToRemove the composite patch " + pi.getPatchId() + " that is subset psu train of psu in oracle home.");
            setRes.mark(pi, null);
        }
        setRes.resolve(map, plan);
        this.filterSubSetOfBigPoh(map, setRes);
        setRes.resolve(map, plan);
    }

    private void filterSubSetOfBigPoh(IConflictMap map, SetResolution res) {
        ArrayList<IPatch> conflictPis = new ArrayList<IPatch>();
        Collection allBugsInPoh = this.getBigPohBugs(map);
        for (IPatch pi : map.getPi()) {
            if (map.getRelations(pi).getWholeConflicts().isEmpty()) continue;
            conflictPis.add(pi);
        }
        boolean canFilter = true;
        for (IPatch pi : conflictPis) {
            if (pi.isComposite()) {
                for (IPatch subPatch : pi.getSubPatches()) {
                    if (allBugsInPoh.containsAll(subPatch.getBugs())) continue;
                    canFilter = false;
                    break;
                }
            }
            if (allBugsInPoh.containsAll(pi.getBugs())) continue;
            canFilter = false;
            break;
        }
        if (canFilter) {
            for (IPatch pi : conflictPis) {
                OLogger.debug("MarkToRemove " + pi.getPatchId() + " that is a sub set of the big Poh.");
                res.mark(pi, null);
                pi.setSubSetOfBigPoh(true);
            }
        }
    }

    private Collection getBigPohBugs(IConflictMap map) {
        Collection<IPatch> patches = map.getPoh();
        ArrayList<String> bugs = new ArrayList<String>();
        for (IPatch patch : patches) {
            NPatchRelations relations = map.getRelations(patch);
            if (!relations.getWholeSubsets().isEmpty() || !relations.getWorses().isEmpty()) continue;
            if (patch.isComposite()) {
                for (IPatch subpatch : patch.getSubPatches()) {
                    bugs.addAll(subpatch.getBugs());
                }
            }
            bugs.addAll(patch.getBugs());
        }
        return bugs;
    }
}

