/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;

class Version {
    static String releaseDate = "July 9, 2014";
    static final String OPATCH_RELEASE_DATE_FILE = "release_date.txt";
    static String buildNumber = "1404889200";

    Version() {
    }

    protected static String getReleaseDate() {
        return releaseDate;
    }

    protected static String getBuildNumber() {
        return buildNumber;
    }

    public String getOPatchVersion() {
        String fileName = "version.txt";
        String ver = "n/a";
        try {
            BufferedReader br;
            InputStream is;
            if (OPatchEnv.isNextGen() && this.getClass().getResource("version_ng.txt") != null) {
                is = this.getClass().getResourceAsStream("version_ng.txt");
                br = new BufferedReader(new InputStreamReader(is));
            } else {
                is = this.getClass().getResourceAsStream("version.txt");
                br = new BufferedReader(new InputStreamReader(is));
            }
            String entry = null;
            while ((entry = br.readLine()) != null) {
                StringTokenizer st;
                if (!entry.startsWith("OPATCH_VERSION") || !(st = new StringTokenizer(entry, ":")).hasMoreTokens()) continue;
                st.nextToken();
                if (!st.hasMoreTokens()) continue;
                ver = st.nextToken();
                ver = ver.trim();
                break;
            }
            br.close();
        }
        catch (Throwable t) {
            OLogger.printStackTrace(t);
            StringBuffer buff = new StringBuffer("OPatchEnv::getOPatchVersion() cannot read embed version file " + fileName);
            OLogger.debug(buff);
        }
        return ver;
    }

    static {
        int num = 1;
        try {
            InputStream is = Version.class.getResourceAsStream(OPATCH_RELEASE_DATE_FILE);
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = "";
            while ((line = br.readLine()) != null) {
                if (num == 2) {
                    buildNumber = line.trim();
                    break;
                }
                releaseDate = line.trim();
                ++num;
            }
            br.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

