/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import oracle.opatch.MakeAction;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.PatchObject;
import oracle.opatch.StringResource;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class RacFileCreator {
    private static final int COPY_FILE = 0;
    private static final int REMOVE_FILE = 1;
    private static final int COPY_DIR = 2;
    private static final int REMOVE_DIR = 3;
    private static final int AUTO_COPY_FILE = 4;
    private static final int AUTO_REMOVE_FILE = 5;
    private static final int AUTO_REMOVE_DIR = 6;
    private static final int COMMAND_FILE = 7;
    private static final int AUTO_COMMAND_FILE = 8;
    public static final int MERGE_FP = 20;
    public static final int MERGE_FR = 21;
    public static final int MERGE_DP = 22;
    public static final int MERGE_DR = 23;
    public static final int MERGE_RC = 24;
    private static final String FP_NAME = "copy_files_";
    private static final String AUTO_FP_NAME = "copy_files_autorb_";
    private static final String DP_NAME = "copy_dirs_";
    private static final String FR_NAME = "remove_files_";
    private static final String AUTO_FR_NAME = "remove_files_autorb_";
    private static final String DR_NAME = "remove_dirs_";
    private static final String AUTO_DR_NAME = "remove_dirs_autorb_";
    private static final String FP_FINAL_NAME = "copy_files";
    private static final String DP_FINAL_NAME = "copy_dirs";
    private static final String DR_FINAL_NAME = "remove_dirs";
    private static final String FR_FINAL_NAME = "remove_files";
    private static final String MP_FINAL_NAME = "make_cmds";
    private static final String RC_NAME = "remote_cmds_";
    private static final String RC_FINAL_NAME = "remote_cmds";
    private static final String AUTO_RC_NAME = "remote_cmds_autorb_";
    private static final String FILE_EXTENTION = ".txt";
    private static final String INSTANTIATED_FILE_EXTENTION = ".instantiated";

    protected static void createRacModeFile(String oracleHomePath, String cookedPatchID, boolean apply, boolean rollback, boolean auto_rb) {
        StringBuffer buff = new StringBuffer("createRacModeFile()");
        OLogger.debug(buff);
        String key = "apply";
        if (auto_rb) {
            key = "auto rolled back";
        } else if (rollback) {
            key = "rollback";
        }
        String racFileName = OPatchEnv.getPatchStorageRacModeFile(oracleHomePath, cookedPatchID);
        Path racModeFile = null;
        try {
            racModeFile = RacFileCreator.createZeroByteFile(racFileName);
            if (Files.exists(racModeFile, new LinkOption[0])) {
                BufferedWriter fw = Files.newBufferedWriter(racModeFile, Charset.forName("UTF-8"), new OpenOption[0]);
                BufferedWriter bw = new BufferedWriter(fw);
                buff = new StringBuffer("Creating mode file for ");
                buff.append(key);
                OLogger.verbose(null, buff);
                bw.write(key);
                bw.close();
                fw.close();
            }
        }
        catch (IOException e2) {
            OLogger.printStackTrace(e2);
            buff = new StringBuffer(" failed to create mode file");
            OLogger.debug(buff);
        }
    }

    protected static Path createFP(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 0);
    }

    protected static Path createAutoFP(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 4);
    }

    protected static Path createAutoRC(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 8);
    }

    protected static Path createDP(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 2);
    }

    protected static Path createFR(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 1);
    }

    protected static Path createAutoFR(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 5);
    }

    protected static Path createDR(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 3);
    }

    protected static Path createAutoDR(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 6);
    }

    protected static Path createRC(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        return RacFileCreator.createFile(oracleHomePath, cookedPatchID, patchID, 7);
    }

    private static Path createFile(String oracleHomePath, String cookedPatchID, String patchID, int mode) throws IOException {
        StringBuffer buff = new StringBuffer("RacFileCreator::createFile()");
        OLogger.debug(buff);
        if (oracleHomePath == null || cookedPatchID == null || patchID == null) {
            buff = new StringBuffer("   either oracleHomePath, cookedPatchID or patchID is null: ");
            buff.append("oracleHomePath = \"");
            buff.append(oracleHomePath);
            buff.append("\", cookedPatchID = \"");
            buff.append(cookedPatchID);
            buff.append("\", patchID = \"");
            buff.append(patchID);
            buff.append("\"");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        buff = new StringBuffer("   createFile(): ");
        buff.append("oracleHomePath = \"");
        buff.append(oracleHomePath);
        buff.append("\", cookedPatchID = \"");
        buff.append(cookedPatchID);
        buff.append("\", patchID = \"");
        buff.append(patchID);
        buff.append("\"");
        OLogger.debug(buff);
        String path = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
        buff = new StringBuffer("   creating dir. \"");
        buff.append(path);
        buff.append("\" if not exist");
        Path file = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
        boolean ok = true;
        if (!Files.exists(file, new LinkOption[0])) {
            try {
                Files.createDirectories(file, new FileAttribute[0]);
                ok = true;
            }
            catch (Exception e2) {
                ok = false;
            }
            if (!ok || !Files.exists(file, new LinkOption[0])) {
                buff = new StringBuffer(" failed to create dir \"");
                buff.append(path);
                buff.append("\"");
                OLogger.debug(buff);
                throw new IOException(buff.toString());
            }
        }
        String filePathName = null;
        switch (mode) {
            case 0: {
                filePathName = RacFileCreator.getFPName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName);
                return file;
            }
            case 4: {
                filePathName = RacFileCreator.getAutoFPName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
            case 2: {
                filePathName = RacFileCreator.getDPName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
            case 1: {
                filePathName = RacFileCreator.getFRName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
            case 5: {
                filePathName = RacFileCreator.getAutoFRName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
            case 3: {
                filePathName = RacFileCreator.getDRName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
            case 6: {
                filePathName = RacFileCreator.getAutoDRName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
            case 7: {
                filePathName = RacFileCreator.getRCName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
            case 8: {
                filePathName = RacFileCreator.getAutoRCName(path, patchID);
                file = RacFileCreator.createZeroByteFile(filePathName.toString());
                return file;
            }
        }
        buff = new StringBuffer("RacFileCreator::createFile() called with unknown option ");
        buff.append(mode);
        OLogger.debug(buff);
        throw new IOException(buff.toString());
    }

    public static String getInstantiatedFile(String fileName) throws IOException {
        if (fileName == null) {
            throw new IOException("Null filename");
        }
        String path = fileName + INSTANTIATED_FILE_EXTENTION;
        return path;
    }

    public static String getFPFinalName(String patchStorageRacDir) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(FP_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String checkPsRac(String path) throws IOException {
        if (path == null) {
            throw new IOException("Cannot get patch_storage/rac location, null value.");
        }
        Path file = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
        if (!Files.exists(file, new LinkOption[0])) {
            OPatchStateManagerFactory.getInstance().setErrorCode(203);
            throw new IOException("Dir. not exist: \"" + path + "\"");
        }
        return path;
    }

    public static String getFPFinalName() {
        StringBuffer filePathName = new StringBuffer();
        filePathName.append(FP_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getDPFinalName(String patchStorageRacDir) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(DP_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getDPFinalName() {
        StringBuffer filePathName = new StringBuffer();
        filePathName.append(DP_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getDRFinalName(String patchStorageRacDir) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(DR_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getDRFinalName() {
        StringBuffer filePathName = new StringBuffer();
        filePathName.append(DR_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getFRFinalName(String patchStorageRacDir) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(FR_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getFRFinalName() {
        StringBuffer filePathName = new StringBuffer();
        filePathName.append(FR_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    private static String getAutoDRName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(AUTO_DR_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    protected static String getDRName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(DR_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    private static String getAutoFRName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(AUTO_FR_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    protected static String getFRName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(FR_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    protected static String getFPName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(FP_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    private static String getAutoFPName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(AUTO_FP_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    private static String getAutoRCName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(AUTO_RC_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    protected static String getDPName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(DP_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    protected static String getRCName(String patchStorageRacDir, String patchID) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(RC_NAME);
        filePathName.append(patchID);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getMPFinalName(String patchStorageRacDir) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(MP_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getMPFinalName() {
        StringBuffer filePathName = new StringBuffer();
        filePathName.append(MP_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getRCFinalName(String patchStorageRacDir) {
        StringBuffer filePathName = new StringBuffer(patchStorageRacDir);
        filePathName.append(File.separator);
        filePathName.append(RC_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static String getRCFinalName() {
        StringBuffer filePathName = new StringBuffer();
        filePathName.append(RC_FINAL_NAME);
        filePathName.append(FILE_EXTENTION);
        return filePathName.toString();
    }

    public static Path createZeroByteFile(String filePathName) throws IOException {
        StringBuffer buff = new StringBuffer("RacFileCreator::createZeroByteFile(): creating zero-byte \"");
        buff.append(filePathName);
        buff.append("\"");
        OLogger.debug(buff);
        boolean ok = true;
        Path file = WrapperFactory.getNioServiceWrapper().getPath(filePathName.toString(), new String[0]);
        try {
            Files.deleteIfExists(file);
        }
        catch (Exception e1) {
            buff = new StringBuffer(" Cannot remove file \"");
            buff.append(filePathName.toString());
            buff.append("\"");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        try {
            Files.createFile(file, new FileAttribute[0]);
            ok = true;
        }
        catch (Exception e2) {
            ok = false;
        }
        if (!ok || !Files.exists(file, new LinkOption[0])) {
            buff = new StringBuffer(" Cannot create zero-byte file \"");
            buff.append(filePathName.toString());
            buff.append("\"");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        return file;
    }

    protected static void mergeMakeActions(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        StringBuffer buff = new StringBuffer("mergeMakeActions()");
        OLogger.debug(buff);
        String path = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
        if (path == null) {
            buff = new StringBuffer("Null patch_storage/<ID>/rac: cannot merge");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", patchObjects);
        }
        catch (NullPointerException e2) {
            IOException ioe = new IOException(e2.getMessage());
            ioe.setStackTrace(e2.getStackTrace());
            throw ioe;
        }
        String mpFinalName = RacFileCreator.getMPFinalName(path);
        Path file = null;
        file = RacFileCreator.createZeroByteFile(mpFinalName);
        buff = new StringBuffer("  opening file to write: \"");
        buff.append(mpFinalName);
        buff.append("\"");
        OLogger.debug(buff);
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            PatchObject po = patchObjects[i2];
            String patchLoc = po.getPatchLocation();
            String patchID = po.getPatchID();
            buff = new StringBuffer(" processing MakeAction[] of patch ");
            buff.append(patchID);
            OLogger.debug(buff);
            MakeAction[] makes = po.getAplicableMakeActions(oracleHomePath);
            boolean getMakeCmdWithEchoPostFix = true;
            for (int j2 = 0; j2 < makes.length; ++j2) {
                MakeAction applicableMake = makes[j2];
                if (applicableMake == null) {
                    buff = new StringBuffer("  NULL make action in make list returned by PatchObject. Skip.");
                    OLogger.debug(buff);
                    continue;
                }
                String remoteCmd = applicableMake.getRemoteCommand(StringResource.getLiteralOracleHome(), true, getMakeCmdWithEchoPostFix);
                buff = new StringBuffer("  checking make cmd for duplicate: \"");
                buff.append(remoteCmd);
                buff.append("\"");
                OLogger.debug(buff);
                if (!set.contains(remoteCmd)) {
                    buff = new StringBuffer(" add entry \"");
                    buff.append(remoteCmd);
                    buff.append("\" to merged make file");
                    OLogger.debug(buff);
                    set.add(remoteCmd);
                    continue;
                }
                buff = new StringBuffer(" skip dup. entry \"");
                buff.append(remoteCmd);
                buff.append("\"");
                OLogger.debug(buff);
            }
        }
        for (String remoteCmd : set) {
            if (remoteCmd == null || remoteCmd.equals("")) continue;
            bw.write(remoteCmd);
            bw.write("\n");
        }
        bw.flush();
        bw.close();
        fw.close();
        set.clear();
    }

    protected static void mergeFpFilesToFpFinal(String oracleHomePath, String cookedPatchID, String[] files) throws IOException {
        RacFileCreator.mergeFiles(oracleHomePath, cookedPatchID, files, 20);
    }

    protected static void mergeRcFilesToRcFinal(String oracleHomePath, String cookedPatchID, String[] files) throws IOException {
        RacFileCreator.mergeFiles(oracleHomePath, cookedPatchID, files, 24);
    }

    protected static void mergeDpFilesToDpFinal(String oracleHomePath, String cookedPatchID, String[] files) throws IOException {
        RacFileCreator.mergeFiles(oracleHomePath, cookedPatchID, files, 22);
    }

    protected static void mergeDrFilesToDrFinal(String oracleHomePath, String cookedPatchID, String[] files) throws IOException {
        RacFileCreator.mergeFiles(oracleHomePath, cookedPatchID, files, 23);
    }

    protected static void mergeFrFilesToFrFinal(String oracleHomePath, String cookedPatchID, String[] files) throws IOException {
        RacFileCreator.mergeFiles(oracleHomePath, cookedPatchID, files, 21);
    }

    public static void mergeFiles(String oracleHomePath, String cookedPatchID, String[] files, int code) throws IOException {
        StringBuffer buff = new StringBuffer("RacFileCreator::mergeFiles()");
        OLogger.debug(buff);
        String path = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
        String finalFile = null;
        switch (code) {
            case 20: {
                finalFile = RacFileCreator.getFPFinalName(path);
                break;
            }
            case 22: {
                finalFile = RacFileCreator.getDPFinalName(path);
                break;
            }
            case 21: {
                finalFile = RacFileCreator.getFRFinalName(path);
                break;
            }
            case 23: {
                finalFile = RacFileCreator.getDRFinalName(path);
                break;
            }
            case 24: {
                finalFile = RacFileCreator.getRCFinalName(path);
                break;
            }
            default: {
                buff = new StringBuffer("Unknown op code.  Cannot merge file.  code = ");
                buff.append(code);
                OLogger.debug(buff);
                throw new IOException(buff.toString());
            }
        }
        buff = new StringBuffer("Merging all files into \"");
        buff.append(finalFile);
        buff.append("\"");
        OLogger.debug(buff);
        Path racDir = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
        if (!Files.exists(racDir, new LinkOption[0])) {
            buff = new StringBuffer("Directory \"");
            buff.append(path);
            buff.append("\" does not exist.  Cannot merge RAC-related files.");
            OLogger.info("OUI-67011", new Object[]{path});
            OLogger.info("OUI-67124", new Object[]{buff.toString()});
            return;
        }
        if (files == null || files.length == 0) {
            buff = new StringBuffer("Null or empty file list.  Cannot merge files.");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        buff = new StringBuffer("Looping thru all files to merge into \"");
        buff.append(finalFile);
        buff.append("\"");
        OLogger.debug(buff);
        Path fFinal = null;
        fFinal = RacFileCreator.createZeroByteFile(finalFile);
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (int i2 = 0; i2 < files.length; ++i2) {
            String eachFileName = files[i2];
            Path eachFile = WrapperFactory.getNioServiceWrapper().getPath(eachFileName, new String[0]);
            if (!Files.exists(eachFile, new LinkOption[0])) {
                buff = new StringBuffer("File \"");
                buff.append(eachFileName);
                buff.append("\" does not exist, skipping.");
                OLogger.info("OUI-67011", new Object[]{eachFileName});
                OLogger.info("OUI-67124", new Object[]{buff.toString()});
                continue;
            }
            if (Files.size(eachFile) <= 0L) continue;
            BufferedReader fr = Files.newBufferedReader(eachFile, Charset.forName("UTF-8"));
            BufferedReader br = new BufferedReader(fr);
            String entry = null;
            while ((entry = br.readLine()) != null) {
                if (!set.contains(entry)) {
                    buff = new StringBuffer("  add entry \"");
                    buff.append(entry);
                    buff.append("\" to set");
                    OLogger.debug(buff);
                    set.add(entry);
                    continue;
                }
                buff = new StringBuffer("  skip dup entry \"");
                buff.append(entry);
                buff.append("\"");
                OLogger.debug(buff);
            }
            br.close();
            fr.close();
        }
        BufferedWriter fw = Files.newBufferedWriter(fFinal, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        for (String entry : set) {
            bw.write(entry);
            bw.write("\n");
        }
        bw.close();
        fw.close();
        set.clear();
    }

    protected static void createFpDpRcFinal(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        StringBuffer buff = new StringBuffer("RacFileCreator::createFpDpRcFinal()");
        OLogger.debug(buff);
        String path = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer tmpPath = new StringBuffer(path);
        tmpPath.append(File.separator);
        String fpFile = RacFileCreator.getFPName(path, patchID);
        String[] fpFiles = new String[]{fpFile};
        String dpFile = RacFileCreator.getDPName(path, patchID);
        String[] dpFiles = new String[]{dpFile};
        String rcFile = RacFileCreator.getRCName(path, patchID);
        String[] rcFiles = new String[]{rcFile};
        RacFileCreator.mergeFpFilesToFpFinal(oracleHomePath, cookedPatchID, fpFiles);
        RacFileCreator.mergeDpFilesToDpFinal(oracleHomePath, cookedPatchID, dpFiles);
        RacFileCreator.mergeRcFilesToRcFinal(oracleHomePath, cookedPatchID, rcFiles);
    }

    protected static void mergeToFpDpFrDrRcFinal(String oracleHomePath, String cookedPatchID, String patchID, PatchObject[] autorbPatches) throws IOException {
        StringBuffer buff = new StringBuffer("RacFileCreator::mergeToFpDpRcFinal()");
        OLogger.debug(buff);
        String path = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer tmpPath = new StringBuffer(path);
        tmpPath.append(File.separator);
        ArrayList<String> allAutoFp = new ArrayList<String>();
        ArrayList<String> allAutoFr = new ArrayList<String>();
        ArrayList<String> allAutoDr = new ArrayList<String>();
        ArrayList<String> allAutoRc = new ArrayList<String>();
        for (int i2 = 0; i2 < autorbPatches.length; ++i2) {
            PatchObject eachPatch = autorbPatches[i2];
            String eachID = eachPatch.getPatchID();
            String eachFpAuto = RacFileCreator.getAutoFPName(path, eachID);
            allAutoFp.add(eachFpAuto);
            String eachFrAuto = RacFileCreator.getAutoFRName(path, eachID);
            allAutoFr.add(eachFrAuto);
            String eachDrAuto = RacFileCreator.getAutoDRName(path, eachID);
            allAutoDr.add(eachDrAuto);
            String eachRcAuto = RacFileCreator.getAutoRCName(path, eachID);
            allAutoRc.add(eachRcAuto);
        }
        String applyFp = RacFileCreator.getFPName(path, patchID);
        String applyDp = RacFileCreator.getDPName(path, patchID);
        String applyRc = RacFileCreator.getRCName(path, patchID);
        int size = 1 + allAutoFp.size();
        String[] allFPs = new String[size];
        allFPs[0] = applyFp;
        for (int i3 = 0; i3 < allAutoFp.size(); ++i3) {
            String eachFpAuto;
            allFPs[i3 + 1] = eachFpAuto = (String)allAutoFp.get(i3);
        }
        size = 1 + allAutoRc.size();
        String[] allRCs = new String[size];
        allRCs[0] = applyRc;
        for (int i4 = 0; i4 < allAutoRc.size(); ++i4) {
            String eachRcAuto;
            allRCs[i4 + 1] = eachRcAuto = (String)allAutoRc.get(i4);
        }
        size = 1;
        String[] allDPs = new String[size];
        allDPs[0] = applyDp;
        size = allAutoFr.size();
        String[] allFRs = new String[size];
        for (int i5 = 0; i5 < allAutoFr.size(); ++i5) {
            String eachFrAuto;
            allFRs[i5] = eachFrAuto = (String)allAutoFr.get(i5);
        }
        size = allAutoDr.size();
        String[] allDRs = new String[size];
        for (int i6 = 0; i6 < allAutoDr.size(); ++i6) {
            String eachDrAuto;
            allDRs[i6] = eachDrAuto = (String)allAutoDr.get(i6);
        }
        RacFileCreator.mergeFpFilesToFpFinal(oracleHomePath, cookedPatchID, allFPs);
        RacFileCreator.mergeDpFilesToDpFinal(oracleHomePath, cookedPatchID, allDPs);
        RacFileCreator.mergeRcFilesToRcFinal(oracleHomePath, cookedPatchID, allRCs);
        RacFileCreator.mergeFrFilesToFrFinal(oracleHomePath, cookedPatchID, allFRs);
        RacFileCreator.mergeDrFilesToDrFinal(oracleHomePath, cookedPatchID, allDRs);
    }

    protected static void createFpDpFrDrRcFinal(String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        StringBuffer buff = new StringBuffer("RacFileCreator::createFpFrDrRcFinal()");
        OLogger.debug(buff);
        String path = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuffer tmpPath = new StringBuffer(path);
        tmpPath.append(File.separator);
        String fpFile = RacFileCreator.getFPName(path, patchID);
        String[] fpFiles = new String[]{fpFile};
        String dpFile = RacFileCreator.getDPName(path, patchID);
        String[] dpFiles = new String[]{dpFile};
        String frFile = RacFileCreator.getFRName(path, patchID);
        String[] frFiles = new String[]{frFile};
        String drFile = RacFileCreator.getDRName(path, patchID);
        String[] drFiles = new String[]{drFile};
        String rcFile = RacFileCreator.getRCName(path, patchID);
        String[] rcFiles = new String[]{rcFile};
        RacFileCreator.mergeFpFilesToFpFinal(oracleHomePath, cookedPatchID, fpFiles);
        RacFileCreator.mergeDpFilesToDpFinal(oracleHomePath, cookedPatchID, dpFiles);
        RacFileCreator.mergeFrFilesToFrFinal(oracleHomePath, cookedPatchID, frFiles);
        RacFileCreator.mergeDrFilesToDrFinal(oracleHomePath, cookedPatchID, drFiles);
        RacFileCreator.mergeRcFilesToRcFinal(oracleHomePath, cookedPatchID, rcFiles);
    }
}

