/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import oracle.glcm.opatch.common.api.install.InventoryComponentInfo;
import oracle.opatch.ActionsFileParser;
import oracle.opatch.ApplySession;
import oracle.opatch.ArchiveAction;
import oracle.opatch.Bug;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CompositePatchObject;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.ICustomizedActions;
import oracle.opatch.InitReadMeAction;
import oracle.opatch.InitScriptAction;
import oracle.opatch.InterviewContextVar;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionEntity;
import oracle.opatch.JarClassLoader;
import oracle.opatch.MakeAction;
import oracle.opatch.NoOpCustomizedAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OPatchVersionSpecific;
import oracle.opatch.OneOffEntry;
import oracle.opatch.OnlinePatchProcessor;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchInventory;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchValidationException;
import oracle.opatch.PatchingModel;
import oracle.opatch.Platform;
import oracle.opatch.PostReadMeAction;
import oracle.opatch.PostScriptAction;
import oracle.opatch.PreReadMeAction;
import oracle.opatch.PreScriptAction;
import oracle.opatch.PrereqSession;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RemoteShellPropagate;
import oracle.opatch.RemoteShellRunCommand;
import oracle.opatch.Restorable;
import oracle.opatch.RollbackSession;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SparseCopyContext;
import oracle.opatch.SparseCopyPostCustomizedAction;
import oracle.opatch.SparseCopyPreCustomizedAction;
import oracle.opatch.StringResource;
import oracle.opatch.SymbolFailureException;
import oracle.opatch.SystemCall;
import oracle.opatch.TargetEntity;
import oracle.opatch.UpdateComponent;
import oracle.opatch.WLSPatch;
import oracle.opatch.conflicttextualinterpreter.OracleHomeConflictMap;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccException;
import oracle.opatch.conflicttextualinterpreter.cbcc.CbccResult;
import oracle.opatch.conflicttextualinterpreter.cbcc.FileMapping;
import oracle.opatch.cup.CUPAdapter;
import oracle.opatch.cup.CUPPatchComponent;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.StringSubsAction;
import oracle.opatch.opatchactions.hotpatchAction;
import oracle.opatch.opatchactions.portalAction;
import oracle.opatch.opatchactions.sqlAction;
import oracle.opatch.opatchactions.sqlprocAction;
import oracle.opatch.opatchfafmw.OPatchFmwDS;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.OPS;
import oracle.opatch.patchverbs.ParserObject;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;

public class PatchObject {
    private Path actionFile;
    private Path inventoryFile;
    private Path maintenanceAilasFilePath;
    private Path padFile = null;
    private Path deployFile;
    private Path interviewFile;
    private Path checksumFile;
    private PatchInventory patchInventory;
    private Path fileMappingFilePath;
    private FileMapping patchFileMapping = null;
    private String patchLocation;
    private String tripletPatchID = null;
    private boolean allPrePostDisabled = false;
    private PreReadMeAction preReadMeAction = new PreReadMeAction();
    private PostReadMeAction postReadMeAction = new PostReadMeAction();
    private InitReadMeAction initReadMeAction = new InitReadMeAction();
    private InitScriptAction initScriptAction = new InitScriptAction();
    private PreScriptAction preScriptAction = new PreScriptAction();
    private PostScriptAction postScriptAction = new PostScriptAction();
    private JarClassLoader oextJarLoader = null;
    private boolean hasExternalJar = false;
    private ArrayList<ParserObject> parserObjects = new ArrayList();
    protected HashMap clubbedJars = new HashMap();
    protected HashMap<String, Boolean> sameFileMap = new HashMap();
    private ChecksumEntity[] cke = new ChecksumEntity[0];
    private OPatchFmwDS.DeployDS[] deployDsObj = new OPatchFmwDS.DeployDS[0];
    private InterviewContextVar[] interviewObj = new InterviewContextVar[0];
    private Set<String> maintenanceAliasKeys = null;
    private boolean isComposite = false;
    private boolean isSparseCopy = false;
    private ArrayList applicationDirs = new ArrayList();
    private String applicationVersion = "";
    private HashMap<String, String> currentAppVerDirs = new HashMap();
    boolean deleteOldDirectory = false;
    private String compositeFileLocation = "";
    private static Date initDate = new Date();
    private boolean checkFuser = true;
    private boolean checkSystemCommand = true;
    private boolean promptForShutdown = true;
    private boolean promptForStartup = true;
    private boolean createRestoreFile = true;
    private boolean invokeMakeAction = true;
    private boolean invokeRegenerateLibrary = true;
    private final String[] rawActionEntry = new String[]{"<oneoff_actions>", "</oneoff_actions>"};
    private final String TO_BE_REPLACED_PATCH_ID = "TO_BE_REPLACED_PATCH_ID";
    private final String TO_BE_REPLACED_ROLLBACK = "TO_BE_REPLACED_ROLLBACK";
    private final String TO_BE_REPLACED_XML_LOC = "TO_BE_REPLACED_XML_LOC";
    private final String TO_BE_REPLACED_ACT_INST_VER = "TO_BE_REPLACED_ACT_INST_VER";
    private final String TO_BE_REPLACED_INSTALLED_TIME = "TO_BE_REPLACED_INSTALLED_TIME";
    private final String TO_BE_REPLACED_COMP_NAME_LIST = "TO_BE_REPLACED_COMP_NAME_LIST";
    private final String TO_BE_REPLACED_BUG_LIST = "TO_BE_REPLACED_BUG_LIST";
    private final String[] COMPS_XML_ONE_OFF = new String[]{"<ONEOFF REF_ID=\"", "TO_BE_REPLACED_PATCH_ID", "\" ", "ROLLBACK=\"", "TO_BE_REPLACED_ROLLBACK", "\" ", "XML_INV_LOC=\"", "TO_BE_REPLACED_XML_LOC", "\" ", "ACT_INST_VER=\"", "TO_BE_REPLACED_ACT_INST_VER", "\" ", "INSTALL_TIME=\"", "TO_BE_REPLACED_INSTALLED_TIME", "\">", "\n", "   <DESC></DESC>", "\n", "   <REF_LIST>", "\n", "TO_BE_REPLACED_COMP_NAME_LIST", "   </REF_LIST>", "\n", "   <BUG_LIST>", "\n", "TO_BE_REPLACED_BUG_LIST", "   </BUG_LIST>", "\n", "   <FILE_LIST/>", "\n", "</ONEOFF>", "\n"};
    private final String[] COMPS_XML_PATCHSET_UPDATE = new String[]{"<PATCHSET_UPDATE REF_ID=\"", "TO_BE_REPLACED_PATCH_ID", "\" ", "ROLLBACK=\"", "TO_BE_REPLACED_ROLLBACK", "\" ", "XML_INV_LOC=\"", "TO_BE_REPLACED_XML_LOC", "\" ", "ACT_INST_VER=\"", "TO_BE_REPLACED_ACT_INST_VER", "\" ", "INSTALL_TIME=\"", "TO_BE_REPLACED_INSTALLED_TIME", "\">", "\n", "   <DESC></DESC>", "\n", "   <REF_LIST>", "\n", "TO_BE_REPLACED_COMP_NAME_LIST", "   </REF_LIST>", "\n", "   <BUG_LIST>", "\n", "TO_BE_REPLACED_BUG_LIST", "   </BUG_LIST>", "\n", "   <FILE_LIST/>", "\n", "</PATCHSET_UPDATE>", "\n"};
    private boolean isSqlRelatedActions = false;
    private boolean isOnlinePatch = false;
    private boolean isPortalPatch = false;
    private boolean isCbccPatch = false;
    private CbccResult cbccResult = null;
    LinkedList componentList = new LinkedList();
    LinkedList emptyList = new LinkedList();
    private boolean scriptsForCAS = false;
    private OneOffEntry oneOffEntry = null;
    static Map<String, PatchObject> patchMaps = new HashMap<String, PatchObject>();
    static Map<String, Integer> ohToModelMap = new HashMap<String, Integer>();
    static List<String> starredPatchObjects = new ArrayList<String>();
    Set<InventoryComponentInfo> compsInfoInInventoryApply = null;

    public void disablePrePostInit() {
        this.preReadMeAction.makeNoOp();
        this.preScriptAction.makeNoOp();
        this.postReadMeAction.makeNoOp();
        this.postScriptAction.makeNoOp();
        this.initScriptAction.makeNoOp();
        this.initReadMeAction.makeNoOp();
        this.allPrePostDisabled = true;
    }

    public boolean isAllPrePostDisabled() {
        return this.allPrePostDisabled;
    }

    public boolean getIsComposite() {
        return this.isComposite;
    }

    public void setIsComposite(boolean val) {
        this.isComposite = val;
    }

    public boolean isSparseCopy() {
        return this.isSparseCopy;
    }

    public void setSparseCopy(boolean isSparseCopy) {
        this.isSparseCopy = isSparseCopy;
    }

    public ICustomizedActions getPreCustomizedAction(List<SparseCopyContext> sccs, String oh, Set<String> leftAppDirs) {
        if (this.isSparseCopy()) {
            return new SparseCopyPreCustomizedAction(sccs, oh, this, leftAppDirs);
        }
        return new NoOpCustomizedAction();
    }

    public ICustomizedActions getPostCustomizedAction(List<SparseCopyContext> sccs, String oh) {
        if (this.isSparseCopy()) {
            return new SparseCopyPostCustomizedAction(sccs, oh, this);
        }
        return new NoOpCustomizedAction();
    }

    public PatchInventory getPatchInventory() {
        return this.patchInventory;
    }

    public boolean isOnlinePatch() {
        return this.isOnlinePatch;
    }

    public boolean isCbccPatch() {
        return this.isCbccPatch;
    }

    protected boolean isPortalPatch() {
        return this.isPortalPatch;
    }

    public FileMapping getFileMappingList() {
        return this.patchFileMapping;
    }

    public OPatchFmwDS.DeployDS[] getDeployList() {
        return this.deployDsObj;
    }

    public InterviewContextVar[] getInterviewList() {
        return this.interviewObj;
    }

    public Set<String> getMaintenanceAliasKeys() {
        return this.maintenanceAliasKeys;
    }

    public boolean hasWlsPrereqOneOffs() {
        return this.patchInventory != null && this.patchInventory.wlsPrereqOneOffs != null && this.patchInventory.wlsPrereqOneOffs.size() > 0;
    }

    public ChecksumEntity[] getChecksumList() throws Exception {
        if (this.getPatchType().equals("snowball")) {
            return new ChecksumEntity[0];
        }
        if (null != this.cke && this.cke.length == 0 && null != this.getChecksumFile()) {
            this.cke = this.loadChecksumFile(this.getChecksumFile());
        }
        return this.cke;
    }

    public boolean hasTargetEntities() {
        return this.patchInventory != null && this.patchInventory.targetEntities != null && this.patchInventory.targetEntities.size() > 0;
    }

    protected String getCreationYear() {
        return this.patchInventory.creationYear;
    }

    protected String getCreationMonth() {
        return this.patchInventory.creationMonth;
    }

    protected String getCreationDay() {
        return this.patchInventory.creationDay;
    }

    protected String getCreationTime() {
        return this.patchInventory.creationTime;
    }

    protected String getCreationZone() {
        return this.patchInventory.creationZone;
    }

    protected String getOneOffEntryInCompsXML() {
        try {
            int i2;
            String compName;
            int i3;
            String patchID = this.getPatchID();
            String rollback = this.isRollBackable() ? "T" : "F";
            StringBuffer buff = new StringBuffer("oneoffs");
            buff.append(File.separator);
            if (OPatchEnv.isWindows()) {
                buff.append(File.separator);
            }
            buff.append(patchID);
            buff.append(File.separator);
            if (OPatchEnv.isWindows()) {
                buff.append(File.separator);
            }
            String xmlInvLoc = buff.toString();
            String installTime = OPatchACL.invokeOLogger(this, "getOUIInstallTime", null).toString();
            String ouiVer = OPatchSDK.getOUIVersion();
            Bug[] bugList = this.getBugsToFix();
            StringBuffer allBugXMLEntries = new StringBuffer();
            for (int i4 = 0; i4 < bugList.length; ++i4) {
                StringBuffer bugXMLEntry = new StringBuffer("     <BUG>");
                Bug bug = bugList[i4];
                String bugID = bug.getBugID();
                bugXMLEntry.append(bugID);
                bugXMLEntry.append("</BUG>");
                bugXMLEntry.append("\n");
                allBugXMLEntries.append(bugXMLEntry.toString());
            }
            PatchComponent[] comps = this.getIncludedPatchComponents();
            ArrayList updateComps = this.getPatchInventory().getUpdateCompsList();
            StringBuffer allCompXMLEntries = new StringBuffer();
            String homeIndex = "0";
            boolean isMiniPatchset = this.getPatchInventory().isMiniPatchSet();
            if (isMiniPatchset) {
                for (i3 = 0; i3 < updateComps.size(); ++i3) {
                    UpdateComponent uc = (UpdateComponent)updateComps.get(i3);
                    compName = uc.getCompName();
                    String fromVersion = uc.getFromVersion();
                    String toVersion = uc.getToVersion();
                    StringBuffer compXMLEntry = new StringBuffer("      <REF NAME=\"");
                    compXMLEntry.append(compName);
                    compXMLEntry.append("\" FROM_VER=\"");
                    compXMLEntry.append(fromVersion);
                    compXMLEntry.append("\" TO_VER=\"");
                    compXMLEntry.append(toVersion);
                    compXMLEntry.append("\" HOME_IDX=\"");
                    compXMLEntry.append(homeIndex);
                    compXMLEntry.append("\"/>\n");
                    allCompXMLEntries.append(compXMLEntry.toString());
                }
            } else {
                for (i3 = 0; i3 < comps.length; ++i3) {
                    PatchComponent pc = comps[i3];
                    compName = pc.getName();
                    String compVer = pc.getVersion();
                    StringBuffer compXMLEntry = new StringBuffer("      <REF NAME=\"");
                    compXMLEntry.append(compName);
                    compXMLEntry.append("\" VER=\"");
                    compXMLEntry.append(compVer);
                    compXMLEntry.append("\" HOME_IDX=\"");
                    compXMLEntry.append(homeIndex);
                    compXMLEntry.append("\"/>\n");
                    allCompXMLEntries.append(compXMLEntry.toString());
                }
            }
            StringBuffer compsEntry = new StringBuffer();
            if (isMiniPatchset) {
                for (i2 = 0; i2 < this.COMPS_XML_PATCHSET_UPDATE.length; ++i2) {
                    compsEntry.append(this.COMPS_XML_PATCHSET_UPDATE[i2]);
                }
            } else {
                for (i2 = 0; i2 < this.COMPS_XML_ONE_OFF.length; ++i2) {
                    compsEntry.append(this.COMPS_XML_ONE_OFF[i2]);
                }
            }
            String tmp = compsEntry.toString();
            tmp = tmp.replaceFirst("TO_BE_REPLACED_PATCH_ID", patchID);
            tmp = tmp.replaceFirst("TO_BE_REPLACED_ROLLBACK", rollback);
            tmp = tmp.replaceFirst("TO_BE_REPLACED_XML_LOC", xmlInvLoc);
            tmp = tmp.replaceFirst("TO_BE_REPLACED_ACT_INST_VER", ouiVer);
            tmp = tmp.replaceFirst("TO_BE_REPLACED_INSTALLED_TIME", installTime);
            tmp = tmp.replaceFirst("TO_BE_REPLACED_BUG_LIST", allBugXMLEntries.toString());
            tmp = tmp.replaceFirst("TO_BE_REPLACED_COMP_NAME_LIST", allCompXMLEntries.toString());
            return tmp;
        }
        catch (Throwable t) {
            return "n/a";
        }
    }

    public String getRacFileArea(String oracleHomePath) {
        String cookedPatchID = this.getCookedPatchID();
        String path = OPatchEnv.getPatchStorageRacDirectoryPath(oracleHomePath, cookedPatchID);
        return path;
    }

    protected String[] getRawActionEntry() {
        return this.rawActionEntry;
    }

    protected PatchObject() {
    }

    public String getOriginalPatchID() {
        String patchID = "";
        if (this.patchInventory != null) {
            patchID = this.patchInventory.patchID;
        }
        if (patchID == null) {
            throw new RuntimeException("Patch ID is null.");
        }
        return patchID;
    }

    public String getPatchUniqID() {
        String uniqID = "";
        if (this.patchInventory != null) {
            uniqID = this.patchInventory.getPSENumber();
        }
        return uniqID;
    }

    public String getPatchLanguage() {
        String patchLanguage = "";
        if (this.patchInventory != null) {
            patchLanguage = this.patchInventory.getPatchLanguage();
        }
        return patchLanguage;
    }

    public String getPatchID() {
        String patchID = "";
        if (this.patchInventory != null) {
            String uniqID;
            patchID = this.patchInventory.mayBeTranslation() ? ((uniqID = this.patchInventory.getPSENumber()) == null || uniqID.equals("") ? this.patchInventory.patchID + "_" + this.patchInventory.getPatchLanguage() : this.patchInventory.patchID + "_" + this.patchInventory.getPatchLanguage() + "_" + uniqID) : this.patchInventory.patchID;
        }
        if (patchID == null) {
            throw new RuntimeException("Patch ID is null.");
        }
        return patchID;
    }

    public String getTripletPatchID() {
        if (this.tripletPatchID != null && !this.tripletPatchID.equals("")) {
            return this.tripletPatchID;
        }
        if (!this.getPatchType().equals("snowball")) {
            return this.getPatchID();
        }
        String patchID = "";
        if (this.patchInventory != null) {
            if (this.patchInventory.mayBeTranslation()) {
                return this.getPatchID();
            }
            String uniqID = this.patchInventory.getPSENumber();
            patchID = uniqID == null || uniqID.equals("") ? this.patchInventory.patchID + "_" + this.patchInventory.getPatchLanguage() : this.patchInventory.patchID + "_" + this.patchInventory.getPatchLanguage() + "_" + uniqID;
        }
        return patchID;
    }

    public String getPatchLocation() {
        if (this.patchLocation != null) {
            return this.patchLocation;
        }
        return File.separator;
    }

    public boolean isRollBackable() {
        return this.patchInventory.rollbackable;
    }

    public boolean isNotRollBackable() {
        return this.patchInventory.notRollbackable;
    }

    public boolean isCannotAutoRollback() {
        return this.patchInventory.cannotAutoRollback;
    }

    public boolean isExitIfPreScriptError() {
        return this.patchInventory.exitIfPreScriptError;
    }

    public Bug[] getBugsToFix() {
        Bug[] bugsToFix = new Bug[]{};
        ListIterator li = this.patchInventory.bugsToFix.listIterator();
        if (!li.hasNext() && !li.hasPrevious()) {
            return bugsToFix;
        }
        int size = this.patchInventory.bugsToFix.size();
        bugsToFix = new Bug[size];
        int i2 = 0;
        while (li.hasNext()) {
            Bug bug;
            Object obj = li.next();
            bugsToFix[i2] = obj instanceof Bug ? (bug = (Bug)obj) : new Bug("0", "");
            ++i2;
        }
        return bugsToFix;
    }

    public String[] getBugsToFixAsString() {
        Bug[] b2 = this.getBugsToFix();
        String[] bStr = new String[b2.length];
        for (int i2 = 0; i2 < bStr.length; ++i2) {
            bStr[i2] = b2[i2].getBugID();
        }
        return bStr;
    }

    public String[] getExecutables(String oracleHomePath) {
        String[] executables = new String[]{};
        try {
            executables = new String[this.patchInventory.executablesList.size()];
            this.patchInventory.executablesList.toArray(executables);
            for (int i2 = 0; i2 < executables.length; ++i2) {
                String tmpS = executables[i2];
                tmpS = PatchObjectUtil.filterString(tmpS);
                StringBuffer tmpSb = new StringBuffer(oracleHomePath);
                tmpSb.append(File.separator);
                tmpSb.append(tmpS);
                executables[i2] = tmpSb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return executables;
    }

    public String[] getExecutables() {
        String[] executables = new String[]{};
        try {
            executables = new String[this.patchInventory.executablesList.size()];
            this.patchInventory.executablesList.toArray(executables);
            for (int i2 = 0; i2 < executables.length; ++i2) {
                String tmpS = executables[i2];
                StringBuffer tmpSb = new StringBuffer("%ORACLE_HOME%");
                tmpSb.append(File.separator);
                tmpSb.append(tmpS);
                executables[i2] = tmpSb.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return executables;
    }

    public void disableFuserCheck() {
        this.checkFuser = false;
    }

    public String[] getPrereqOneOffs() {
        return this.patchInventory.getPrereqOneOffs();
    }

    public WLSPatch[] getWlsPrereqOneOffs() {
        return this.patchInventory.getWlsPrereqOneOffs();
    }

    public String getESysPatchID() {
        return this.patchInventory.getESysPatchID();
    }

    public TargetEntity[] getTargetEntities() {
        return this.patchInventory.getTargetEntities();
    }

    public String[] getCoreqOneOffs() {
        return this.patchInventory.getCoreqOneOffs();
    }

    public String[] getOverLayOneOffs() {
        return this.patchInventory.getOverLayOneOffs();
    }

    public Vector getBugsToFixVector() {
        Vector<String> bugsToFix = new Vector<String>();
        ListIterator li = this.patchInventory.bugsToFix.listIterator();
        if (!li.hasNext() && !li.hasPrevious()) {
            return bugsToFix;
        }
        while (li.hasNext()) {
            Object obj = li.next();
            if (!(obj instanceof Bug)) continue;
            Bug bug = (Bug)obj;
            bugsToFix.add(bug.getBugID());
        }
        return bugsToFix;
    }

    public PatchComponent[] getPatchComponents() {
        int size = this.componentList.size();
        PatchComponent[] list = new PatchComponent[size];
        ListIterator listIter = this.componentList.listIterator();
        int i2 = 0;
        while (listIter.hasNext()) {
            Object obj = listIter.next();
            if (!(obj instanceof PatchComponent)) continue;
            PatchComponent c2 = (PatchComponent)obj;
            list[i2++] = c2;
        }
        return list;
    }

    public PatchComponent[] getIncludedPatchComponents() {
        PatchComponent[] rawList = this.getPatchComponents();
        int count = 0;
        for (int i2 = 0; i2 < rawList.length; ++i2) {
            PatchComponent pc = rawList[i2];
            if (pc.isExcluded()) continue;
            ++count;
        }
        PatchComponent[] cookedList = new PatchComponent[count];
        int j2 = 0;
        for (int i3 = 0; i3 < rawList.length; ++i3) {
            PatchComponent pc = rawList[i3];
            if (pc.isExcluded()) continue;
            cookedList[j2++] = pc;
        }
        return cookedList;
    }

    public PatchComponent[] getRequiredPatchComponents() {
        PatchComponent[] list = new PatchComponent[]{};
        ListIterator listIter = this.componentList.listIterator();
        int count = 0;
        while (listIter.hasNext()) {
            PatchComponent c2;
            Object obj = listIter.next();
            if (!(obj instanceof PatchComponent) || !(c2 = (PatchComponent)obj).isRequired()) continue;
            ++count;
        }
        list = new PatchComponent[count];
        listIter = this.componentList.listIterator();
        int index = 0;
        int i2 = 0;
        while (listIter.hasNext()) {
            PatchComponent c3;
            Object obj = listIter.next();
            if (obj instanceof PatchComponent && (c3 = (PatchComponent)obj).isRequired()) {
                list[index++] = c3;
            }
            ++i2;
        }
        return list;
    }

    public PatchComponent[] getOptionalPatchComponents() {
        PatchComponent[] list = new PatchComponent[]{};
        ListIterator listIter = this.componentList.listIterator();
        int count = 0;
        while (listIter.hasNext()) {
            PatchComponent c2;
            Object obj = listIter.next();
            if (!(obj instanceof PatchComponent) || (c2 = (PatchComponent)obj).isRequired()) continue;
            ++count;
        }
        list = new PatchComponent[count];
        listIter = this.componentList.listIterator();
        int index = 0;
        int i2 = 0;
        while (listIter.hasNext()) {
            PatchComponent c3;
            Object obj = listIter.next();
            if (obj instanceof PatchComponent && !(c3 = (PatchComponent)obj).isRequired()) {
                list[index++] = c3;
            }
            ++i2;
        }
        return list;
    }

    public PatchAction[] getPatchActionsForComponent(PatchComponent c2) {
        return this.getAllActions(c2);
    }

    public PatchAction[] getImmediatePatchActionsToExecuteForComponent(PatchComponent c2) {
        return this.getAllImmediateExecutableActions(c2);
    }

    public ArrayList getDelayedExecutionActions() {
        PatchAction[] paArray = this.getAllActions();
        ArrayList<PatchAction> delayedPatchActions = new ArrayList<PatchAction>();
        for (int i2 = 0; i2 < paArray.length; ++i2) {
            if (!paArray[i2].isExecutionDelayed() || delayedPatchActions.contains(paArray[i2])) continue;
            delayedPatchActions.add(paArray[i2]);
        }
        return delayedPatchActions;
    }

    protected MakeAction[] getAplicableMakeActions(String oracleHomePath) {
        String patchLoc = this.getPatchLocation();
        ArrayList<MakeAction> makes = new ArrayList<MakeAction>();
        PatchAction[] pas = this.getAllActions();
        for (int i2 = 0; i2 < pas.length; ++i2) {
            MakeAction ma;
            PatchAction pa = pas[i2];
            if (!(pa instanceof MakeAction) || !(ma = (MakeAction)pa).applicable(oracleHomePath, patchLoc)) continue;
            makes.add(ma);
        }
        int size = makes.size();
        MakeAction[] makeActions = new MakeAction[size];
        for (int i3 = 0; i3 < size; ++i3) {
            MakeAction ma;
            makeActions[i3] = ma = (MakeAction)makes.get(i3);
        }
        return makeActions;
    }

    public boolean isRolling() {
        return this.patchInventory.rollingPatch;
    }

    protected String getRollingString() {
        if (this.patchInventory.rollingPatch) {
            return "true";
        }
        return "false";
    }

    public boolean isSqlPatch() {
        return this.patchInventory.sqlPatch;
    }

    protected String getSqlPatchString() {
        if (this.patchInventory.sqlPatch) {
            return "true";
        }
        return "false";
    }

    public String getSqlPatchDatabaseStartupMode() {
        return this.patchInventory.sqlPatchDatabaseStartupMode;
    }

    public boolean isFmwRolling() {
        return this.patchInventory.isFmwRolling;
    }

    public boolean isFmwFeatureBearing() {
        return this.patchInventory.isFmwFeatureBearing;
    }

    public boolean isSqlMigrate() {
        return this.patchInventory.isSqlMigrate();
    }

    public void disablePromptForStartup() {
        this.promptForStartup = false;
    }

    protected boolean shouldPromptForStartup() {
        StringBuffer buff = new StringBuffer("PatchObject::shouldPromptForStartup() = ");
        buff.append(this.promptForStartup);
        OLogger.debug(buff);
        return this.promptForStartup;
    }

    public void disablePromptForShutdown() {
        this.promptForShutdown = false;
    }

    protected boolean shouldPromptForShutdown() {
        StringBuffer buff = new StringBuffer("PatchObject::shouldPromptForShutdown() = ");
        buff.append(this.promptForShutdown);
        OLogger.debug(buff);
        return this.promptForShutdown;
    }

    public boolean isShutdown() {
        return this.patchInventory.instanceShutdown;
    }

    protected String getShutdownString() {
        if (this.patchInventory.instanceShutdown) {
            return "true";
        }
        return "false";
    }

    public boolean isSkipActiveFilesCheck() {
        ListIterator pa = this.getAllPluginActions();
        while (pa.hasNext()) {
            PatchAction p2 = (PatchAction)pa.next();
            if (!p2.getActionName().equals("hotpatchAction")) continue;
            StringBuffer buff = new StringBuffer("PatchObject::isSkipActiveFilesCheck() = ");
            buff.append("true");
            OLogger.debug(buff);
            return true;
        }
        return false;
    }

    public boolean forceAllNodeMode() {
        ListIterator pa = this.getAllPluginActions();
        while (pa.hasNext()) {
            PatchAction p2 = (PatchAction)pa.next();
            if (!p2.getActionName().equals("hotpatchAction")) continue;
            StringBuffer buff = new StringBuffer("PatchObject::isAllNodeMode() = ");
            buff.append("true");
            OLogger.debug(buff);
            return true;
        }
        return false;
    }

    public String getShutdownMsg() {
        return this.patchInventory.instanceShutdownMessage;
    }

    public String getPatchType() {
        return this.patchInventory.patchType;
    }

    public String getPatchSubType() {
        return this.patchInventory.subType;
    }

    protected boolean isSnowballPatch() {
        return this.patchInventory.patchType.equalsIgnoreCase("snowball");
    }

    public String getProductFamily() {
        return this.patchInventory.productFamily;
    }

    public boolean isSqlRelatedActions() {
        return this.isSqlRelatedActions;
    }

    public String getProductType() {
        return this.patchInventory.applicableProductType;
    }

    public ArrayList getSystemComponentList() {
        return this.patchInventory.systemComponentList;
    }

    public ArrayList getApplicationShutdownList() {
        return this.patchInventory.applicationShutdownList;
    }

    public ArrayList getProductsList() {
        return this.patchInventory.productsList;
    }

    protected void setProductsList(ArrayList pList) {
        this.patchInventory = new PatchInventory();
        this.patchInventory.setProductsList(pList);
    }

    protected PatchAction[] getPatchActions() {
        return this.getAllActions();
    }

    public ArrayList<ParserObject> getParserObject() {
        return this.parserObjects;
    }

    public void setParserObject(ArrayList<ParserObject> parserObjects) {
        this.parserObjects = parserObjects;
    }

    public ArrayList getApplicationDirs() {
        if (this.patchInventory != null) {
            this.applicationDirs = this.patchInventory.getApplicationDirs();
        }
        return this.applicationDirs;
    }

    public HashMap<String, String> getCurrentAppVerDirs() {
        return this.currentAppVerDirs;
    }

    public String getApplicationVersion() {
        return this.applicationVersion;
    }

    public boolean isDeleteOldDirectory() {
        return this.getPatchInventory().deleteOldDirectory;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("[PatchObject: loc.= ");
        buff.append(this.patchLocation);
        buff.append(", ");
        buff.append(", patch ID= ");
        buff.append(this.getPatchID());
        buff.append(", cooked patch ID= ");
        buff.append(this.getCookedPatchID());
        buff.append(",  ");
        PatchComponent pc = null;
        LinkedList list = this.componentList;
        String returnString = "\n";
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                pc = (PatchComponent)list.get(i2);
                returnString = returnString + pc.toString() + "\n";
            }
        }
        catch (NullPointerException e2) {
            OLogger.error("OUI-67022", new Object[]{"All of actions are empty !!!"});
        }
        buff.append(returnString);
        buff.append(" Plugin-actions=");
        buff.append(this.hasExternalJar);
        buff.append("\n");
        buff.append(this.patchInventory.toString());
        buff.append(" ]");
        return buff.toString();
    }

    public static String getEtcPath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        if (OnlinePatchProcessor.isOnlinePart(patchLocation)) {
            buff.append("etc_online");
        } else {
            buff.append("etc");
        }
        return buff.toString();
    }

    public static String getEtcConfigPath(String patchLocation) {
        String etc = PatchObject.getEtcPath(patchLocation);
        StringBuffer buff = new StringBuffer(etc);
        buff.append(File.separator);
        buff.append("config");
        return buff.toString();
    }

    public static String getActionFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("actions.xml");
        return buff.toString();
    }

    public static String getFileMappingPath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("file-mapping.xml");
        return buff.toString();
    }

    public static String getMaintenanceAliasFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("maintenance_alias.xml");
        return buff.toString();
    }

    public static String getNonXMLActionFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("actions");
        return buff.toString();
    }

    public static String getCompositeFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("composite.xml");
        return buff.toString();
    }

    public static String getDeployFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("deploy.xml");
        return buff.toString();
    }

    public static String getInterviewFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("sequence.xml");
        return buff.toString();
    }

    public static String getEmXmlFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("em.xml");
        return buff.toString();
    }

    public static String getInventoryFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("inventory.xml");
        return buff.toString();
    }

    public static String getNonXMLInventoryFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("inventory");
        return buff.toString();
    }

    public static String getPADFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("patchdeploy.xml");
        return buff.toString();
    }

    public static String getAutomationFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("automation.xml");
        return buff.toString();
    }

    public static String getApplyAutomationFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("apply_automation.xml");
        return buff.toString();
    }

    public static String getRollbackAutomationFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("rollback_automation.xml");
        return buff.toString();
    }

    public static String getChecksumFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("checksum.xml");
        return buff.toString();
    }

    public static String getActionWithOutXMLFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("actions");
        return buff.toString();
    }

    public static String getInventoryWithOutXMLFilePath(String patchLocation) {
        String etcConfig = PatchObject.getEtcConfigPath(patchLocation);
        StringBuffer buff = new StringBuffer(etcConfig);
        buff.append(File.separator);
        buff.append("inventory");
        return buff.toString();
    }

    public static String getJlibPath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(File.separator);
        buff.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
        return buff.toString();
    }

    public static String getExternalJarFilePath(String patchLocation) {
        String jlib = PatchObject.getJlibPath(patchLocation);
        StringBuffer buff = new StringBuffer(jlib);
        buff.append(File.separator);
        buff.append("oext.jar");
        return buff.toString();
    }

    public static String getInitReadMeFilePath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(StringResource.PATCH_CUSTOM_README_INIT);
        return buff.toString();
    }

    public static String getInitScriptFilePath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        if (OPatchEnv.isWindows()) {
            buff.append(StringResource.PATCH_CUSTOM_WINDOWS_INIT);
        } else {
            buff.append(StringResource.PATCH_CUSTOM_UNIX_INIT);
        }
        return buff.toString();
    }

    public static String getPreReadMeFilePath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(StringResource.PATCH_CUSTOM_README_PRE);
        return buff.toString();
    }

    public static String getPreScriptFilePath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        if (OPatchEnv.isWindows()) {
            buff.append(StringResource.PATCH_CUSTOM_WINDOWS_PRE);
        } else {
            buff.append(StringResource.PATCH_CUSTOM_UNIX_PRE);
        }
        return buff.toString();
    }

    public static String getPostReadMeFilePath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        buff.append(StringResource.PATCH_CUSTOM_README_POST);
        return buff.toString();
    }

    public static String getPostScriptFilePath(String patchLocation) {
        StringBuffer buff = new StringBuffer(patchLocation);
        if (OPatchEnv.isWindows()) {
            buff.append(StringResource.PATCH_CUSTOM_WINDOWS_POST);
        } else {
            buff.append(StringResource.PATCH_CUSTOM_UNIX_POST);
        }
        return buff.toString();
    }

    @Deprecated
    public PatchObject(String oracleHomePath, String patchID) throws IllegalAccessException, Exception {
        this(oracleHomePath, patchID, true);
    }

    @Deprecated
    public PatchObject(String oracleHomePath, String patchID, boolean search) throws IllegalAccessException, Exception {
        StringBuffer buff = new StringBuffer("PatchObject(oracleHomePath,patchID)");
        OLogger.debug(buff);
        boolean insideOH = true;
        boolean match = false;
        String tmpPatchLoc = "";
        String patchLocation = "";
        String msg = "";
        if (Rules.shouldReadPatchFromInv(patchID)) {
            boolean isTripletID = false;
            if (patchID != null && patchID.contains("_")) {
                isTripletID = true;
            }
            if (isTripletID || !search) {
                OLogger.debug("No need to search OUI to get the patch location, because the given patch Id " + patchID + " is already triplet or comes from OralceHomeInventory.load().");
                patchLocation = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchID);
                if (!search) {
                    this.tripletPatchID = patchID;
                }
            } else {
                String xmlInvLocation = null;
                IIPMReadServices readServices = null;
                try {
                    readServices = PrereqSession.getReadServices(oracleHomePath);
                    xmlInvLocation = readServices.getXMLInvLocation(patchID);
                }
                catch (Throwable t) {
                    RuntimeException re = new RuntimeException(t.getMessage());
                    re.setStackTrace(t.getStackTrace());
                    throw re;
                }
                StringBuffer buffLoc = new StringBuffer();
                buffLoc.append(oracleHomePath);
                buffLoc.append(File.separator);
                buffLoc.append("inventory");
                buffLoc.append(File.separator);
                buffLoc.append(xmlInvLocation);
                patchLocation = buffLoc.toString();
            }
        } else {
            String envPatchLoc = OPatchEnv.getPatchloc();
            if (envPatchLoc != null && !envPatchLoc.equals("")) {
                patchLocation = envPatchLoc;
                this.createPatchObject(patchLocation, false, oracleHomePath);
                String pID = this.getPatchID();
                if (!pID.equals(patchID)) {
                    msg = OLogger.getString("OUI-67274");
                    OLogger.println(msg);
                    throw new Exception(msg);
                }
                return;
            }
            insideOH = false;
        }
        this.createPatchObject(patchLocation, insideOH, oracleHomePath);
    }

    @Deprecated
    public PatchObject(String patchLocation) throws IllegalAccessException, Exception {
        OLogger.debug("PatchObject::PatchObject() Patch location is " + patchLocation);
        StringBuffer buff = new StringBuffer("PatchObject(patchLocation)");
        OLogger.debug(buff);
        OPatchEnv.setTempPatchLocation(patchLocation);
        this.createPatchObject(patchLocation, false, null);
    }

    public void createPatchObject(String patchLocation, boolean insideOH, String oracleHomePath) throws IllegalAccessException, Exception {
        try {
            ParserObject automationParser;
            ParserObject rollbackParserObject;
            ParserObject applyParserObject;
            Path maintenanceAliasFilePath;
            Path interviewFile;
            patchLocation = PatchObjectUtil.getPlatformDependentPath(patchLocation);
            OLogger.debug("PatchObject::createPatchObject() patch location is " + patchLocation);
            try {
                patchLocation = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]).toAbsolutePath().normalize().toString();
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
            }
            String actionsFileName = PatchObject.getActionFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the actions file " + actionsFileName));
            String inventoryFileName = PatchObject.getInventoryFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the inventory file " + inventoryFileName));
            String padFileName = PatchObject.getPADFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the patchdeploy file " + padFileName));
            String automationFileName = PatchObject.getAutomationFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the automation.xml file " + automationFileName));
            Path automationFile = WrapperFactory.getNioServiceWrapper().getPath(automationFileName, new String[0]);
            String applyAutomationFileName = "";
            String rollbackAutomationFileName = "";
            Path applyAutomationFile = null;
            Path rollbackAutomationFile = null;
            applyAutomationFileName = PatchObject.getApplyAutomationFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the apply_automation.xml file " + applyAutomationFileName));
            applyAutomationFile = WrapperFactory.getNioServiceWrapper().getPath(applyAutomationFileName, new String[0]);
            rollbackAutomationFileName = PatchObject.getRollbackAutomationFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the rollback_automation.xml file " + rollbackAutomationFileName));
            rollbackAutomationFile = WrapperFactory.getNioServiceWrapper().getPath(rollbackAutomationFileName, new String[0]);
            String checksumFileName = PatchObject.getChecksumFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the checksum.xml file " + checksumFileName));
            Path actionFile = WrapperFactory.getNioServiceWrapper().getPath(actionsFileName, new String[0]);
            Path inventoryFile = WrapperFactory.getNioServiceWrapper().getPath(inventoryFileName, new String[0]);
            Path padFile = WrapperFactory.getNioServiceWrapper().getPath(padFileName, new String[0]);
            Path checksumFile = WrapperFactory.getNioServiceWrapper().getPath(checksumFileName, new String[0]);
            if (automationFile == null || !Files.exists(automationFile, new LinkOption[0]) || !Files.isReadable(automationFile)) {
                OLogger.debug("PatchObject::createPatchObject() automation file " + automationFileName + " does not exist or is not readable");
            }
            if (applyAutomationFile == null || !Files.exists(applyAutomationFile, new LinkOption[0]) || !Files.isReadable(applyAutomationFile)) {
                OLogger.debug("PatchObject::createPatchObject() apply_automation file " + applyAutomationFileName + " does not exist or is not readable");
            }
            if (rollbackAutomationFile == null || !Files.exists(rollbackAutomationFile, new LinkOption[0]) || !Files.isReadable(rollbackAutomationFile)) {
                OLogger.debug("PatchObject::createPatchObject() rollback_automation file " + rollbackAutomationFileName + " does not exist or is not readable");
            }
            if (actionFile == null || !Files.exists(actionFile, new LinkOption[0]) || inventoryFile == null || !Files.exists(inventoryFile, new LinkOption[0])) {
                actionsFileName = PatchObject.getActionWithOutXMLFilePath(patchLocation);
                inventoryFileName = PatchObject.getInventoryWithOutXMLFilePath(patchLocation);
                OLogger.debug(new StringBuffer("PatchObject::createPatchObject() now looks for the actions file " + actionsFileName));
                OLogger.debug(new StringBuffer("PatchObject::createPatchObject() now looks for the inventory file " + inventoryFileName));
                actionFile = WrapperFactory.getNioServiceWrapper().getPath(actionsFileName, new String[0]);
                inventoryFile = WrapperFactory.getNioServiceWrapper().getPath(inventoryFileName, new String[0]);
            }
            if (!(actionFile != null && Files.exists(actionFile, new LinkOption[0]) && Files.isReadable(actionFile) && inventoryFile != null && Files.exists(inventoryFile, new LinkOption[0]) && Files.isReadable(inventoryFile))) {
                StringBuffer buff = new StringBuffer(OPatchEnv.getOracleHome());
                buff.append(File.separator);
                buff.append("inventory");
                buff.append(File.separator);
                buff.append("oneoffs");
                if (patchLocation.startsWith(buff.toString())) {
                    buff = new StringBuffer(OPatchEnv.getOracleHome());
                    buff.append(File.separator);
                    buff.append("inventory");
                    buff.append(File.separator);
                    buff.append("filemap");
                    Path fMap = WrapperFactory.getNioServiceWrapper().getPath(buff.toString(), new String[0]);
                    OLogger.log(OLogger.FINE, "Loading the information from inventory/filemap.");
                    if (Files.exists(fMap, new LinkOption[0]) && Files.isDirectory(fMap, new LinkOption[0])) {
                        if (patchLocation.endsWith(File.separator)) {
                            patchLocation = patchLocation.substring(0, patchLocation.length() - 1);
                        }
                        int index = patchLocation.lastIndexOf(File.separator);
                        String patchID = "";
                        if (index == -1) {
                            throw new IllegalAccessException("Unable to load the patchObject from inventory/filemap");
                        }
                        patchID = patchLocation.substring(index + 1);
                        this.loadOneOffFromInv(patchID);
                        return;
                    }
                }
                boolean hasUw = false;
                boolean hasObj = false;
                boolean hasSubMWDir = false;
                Path patchLocFile = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]);
                String patchLocName = patchLocFile.getFileName().toString();
                String subPatchLoc = "";
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(patchLocFile);){
                    Iterator<Path> iterator = stream.iterator();
                    if (!iterator.hasNext()) {
                        StringBuffer errorBuff = new StringBuffer("No Patch exists,Please check. ");
                        RuntimeException er = new RuntimeException(errorBuff.toString());
                        throw er;
                    }
                    while (iterator.hasNext()) {
                        String entry = iterator.next().toString();
                        if (entry.indexOf(patchLocName + "_MW") != -1) {
                            hasSubMWDir = true;
                            subPatchLoc = entry;
                        }
                        if (entry.indexOf("obj" + patchLocName + ".xml") != -1) {
                            hasObj = true;
                        }
                        if (entry.indexOf("uw" + patchLocName + ".xml") == -1) continue;
                        hasUw = true;
                    }
                }
                catch (IOException e3) {
                    OLogger.debug(e3.getMessage());
                }
                String parentDir = new File(patchLocation).getParent();
                boolean isOneLevelDown = false;
                if (parentDir != null) {
                    actionsFileName = PatchObject.getActionFilePath(parentDir);
                    inventoryFileName = PatchObject.getInventoryFilePath(parentDir);
                    Path pactionFile = WrapperFactory.getNioServiceWrapper().getPath(actionsFileName, new String[0]);
                    Path pinventoryFile = WrapperFactory.getNioServiceWrapper().getPath(inventoryFileName, new String[0]);
                    if (Files.exists(pactionFile, new LinkOption[0]) && Files.exists(pinventoryFile, new LinkOption[0])) {
                        isOneLevelDown = true;
                        parentDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]).getParent().toAbsolutePath().normalize().toString();
                    } else {
                        actionsFileName = PatchObject.getActionWithOutXMLFilePath(parentDir);
                        inventoryFileName = PatchObject.getInventoryWithOutXMLFilePath(parentDir);
                        pactionFile = WrapperFactory.getNioServiceWrapper().getPath(actionsFileName, new String[0]);
                        pinventoryFile = WrapperFactory.getNioServiceWrapper().getPath(inventoryFileName, new String[0]);
                        if (Files.exists(pactionFile, new LinkOption[0]) && Files.exists(pinventoryFile, new LinkOption[0])) {
                            isOneLevelDown = true;
                            parentDir = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]).getParent().toAbsolutePath().normalize().toString();
                        }
                    }
                }
                StringBuffer errorMsg = new StringBuffer("PatchObject constructor: ");
                if (actionFile == null || inventoryFile == null) {
                    errorMsg.append("Input file is null");
                } else if (!Files.exists(actionFile, new LinkOption[0]) || !Files.exists(inventoryFile, new LinkOption[0])) {
                    boolean isFAPatch = false;
                    if (hasUw && hasObj && hasSubMWDir) {
                        String faActionFileName = PatchObject.getActionFilePath(subPatchLoc);
                        String faInventoryFileName = PatchObject.getInventoryFilePath(subPatchLoc);
                        Path faActionFile = WrapperFactory.getNioServiceWrapper().getPath(faActionFileName, new String[0]);
                        Path faInventoryFile = WrapperFactory.getNioServiceWrapper().getPath(faInventoryFileName, new String[0]);
                        if (Files.exists(faActionFile, new LinkOption[0]) && Files.exists(faInventoryFile, new LinkOption[0])) {
                            isFAPatch = true;
                        }
                    }
                    if (isFAPatch) {
                        errorMsg.append("This is FA patch. Please point patch location to sub-dir \"");
                        errorMsg.append(subPatchLoc);
                        errorMsg.append("\" which is an patch singleton.");
                    } else if (isOneLevelDown) {
                        errorMsg.append("Current patch location is one-level down. Please point patch location to \"");
                        errorMsg.append(parentDir);
                        errorMsg.append("\" and retry.");
                    } else {
                        errorMsg.append("Input file \"");
                        errorMsg.append(actionFile);
                        errorMsg.append("\" or \"");
                        errorMsg.append(inventoryFile);
                        errorMsg.append("\" does not exist.");
                    }
                } else if (!Files.isReadable(actionFile) || !Files.isReadable(inventoryFile)) {
                    errorMsg.append("Input file \"");
                    errorMsg.append(actionFile);
                    errorMsg.append("\" or \"");
                    errorMsg.append(inventoryFile);
                    errorMsg.append("\" is not readable.");
                }
                throw new IllegalAccessException(errorMsg.toString());
            }
            String deployFilePath = PatchObject.getDeployFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the deploy file " + deployFilePath));
            String interviewFilePath = PatchObject.getInterviewFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the interview file " + interviewFilePath));
            String maintenanceAliasFileLocation = PatchObject.getMaintenanceAliasFilePath(patchLocation);
            OLogger.debug(new StringBuffer("PatchObject::createPatchObject() looks for the maintenance alias file " + maintenanceAliasFileLocation));
            Path deployFile = WrapperFactory.getNioServiceWrapper().getPath(deployFilePath, new String[0]);
            if (deployFile != null) {
                if (!Files.exists(deployFile, new LinkOption[0])) {
                    OLogger.debug("PatchObject::createPatchObject() deploy actions file " + deployFilePath + " does not exist");
                }
                if (!Files.isReadable(deployFile)) {
                    OLogger.debug("PatchObject::createPatchObject() deploy actions file " + deployFilePath + " unreadable");
                }
            } else {
                OLogger.debug("PatchObject::createPatchObject() deploy actions file " + deployFilePath + " (File object null)");
            }
            if ((interviewFile = WrapperFactory.getNioServiceWrapper().getPath(interviewFilePath, new String[0])) != null) {
                if (!Files.exists(interviewFile, new LinkOption[0])) {
                    OLogger.debug("PatchObject::createPatchObject() interview file " + interviewFilePath + " does not exist or is not readable");
                }
                if (!Files.isReadable(interviewFile)) {
                    OLogger.debug("PatchObject::createPatchObject() deploy actions file " + interviewFilePath + " unreadable");
                }
            } else {
                OLogger.debug("PatchObject::createPatchObject() deploy actions file " + interviewFilePath + " (File object null)");
            }
            if ((maintenanceAliasFilePath = WrapperFactory.getNioServiceWrapper().getPath(maintenanceAliasFileLocation, new String[0])) != null) {
                if (!Files.exists(maintenanceAliasFilePath, new LinkOption[0])) {
                    OLogger.debug("PatchObject::createPatchObject() maintenance alias file " + maintenanceAliasFilePath + " does not exist or is not readable");
                }
                if (!Files.isReadable(maintenanceAliasFilePath)) {
                    OLogger.debug("PatchObject::createPatchObject() maintenance alias file " + maintenanceAliasFilePath + " unreadable");
                }
            } else {
                OLogger.debug("PatchObject::createPatchObject() maintenance alias file " + maintenanceAliasFilePath + " (File object null)");
            }
            String fileMappingFilePathStr = PatchObject.getFileMappingPath(patchLocation);
            OLogger.debug("PatchObject::createPatchObject() looks for the file-mapping file: " + fileMappingFilePathStr);
            Path fileMappingFilePath = WrapperFactory.getNioServiceWrapper().getPath(fileMappingFilePathStr, new String[0]);
            if (fileMappingFilePath != null) {
                if (!Files.exists(fileMappingFilePath, new LinkOption[0])) {
                    OLogger.debug("PatchObject::createPatchObject() file-mapping file: " + fileMappingFilePathStr + " does not exist");
                } else if (!Files.isReadable(fileMappingFilePath)) {
                    OLogger.debug("file-mapping.xml exists but not readable: " + fileMappingFilePathStr);
                }
            } else {
                OLogger.debug("file-mapping Path is null: " + fileMappingFilePath);
            }
            this.deployFile = deployFile;
            this.interviewFile = interviewFile;
            this.maintenanceAilasFilePath = maintenanceAliasFilePath;
            this.fileMappingFilePath = fileMappingFilePath;
            this.actionFile = actionFile;
            this.inventoryFile = inventoryFile;
            this.padFile = padFile;
            if (applyAutomationFile != null && Files.exists(applyAutomationFile, new LinkOption[0]) && (applyParserObject = OPatchVersionSpecific.loadAutomationFile(applyAutomationFile)) != null) {
                this.parserObjects.add(applyParserObject);
            }
            if (rollbackAutomationFile != null && Files.exists(rollbackAutomationFile, new LinkOption[0]) && (rollbackParserObject = OPatchVersionSpecific.loadAutomationFile(rollbackAutomationFile)) != null) {
                this.parserObjects.add(rollbackParserObject);
            }
            if (automationFile != null && Files.exists(automationFile, new LinkOption[0]) && (automationParser = OPatchVersionSpecific.loadAutomationFile(automationFile)) != null) {
                this.parserObjects.add(automationParser);
            }
            this.patchLocation = patchLocation;
            this.loadExternalJars();
            this.loadInventoryFile();
            this.loadDeployFile();
            this.loadInterviewFile();
            this.loadMaintenanceAliasFile();
            if (!insideOH || !Rules.shouldSkipLoadChecksumXmlForOHPatches()) {
                this.setChecksumFile(checksumFile);
            }
            if (this.patchInventory.applicationDirs.size() > 0) {
                this.setSparseCopy(true);
                OPatchEnv.setSparseCopy(true);
                if (!insideOH) {
                    if (OPatchEnv.getApplicationVersion() == null) {
                        String upi = this.getPatchUniqID();
                        try {
                            OPatchEnv.setApplicationVersion(Math.abs(Long.parseLong(upi)) + "");
                        }
                        catch (NumberFormatException e4) {
                            OPatchEnv.setApplicationVersion(upi);
                        }
                    }
                    this.applicationVersion = OPatchEnv.getApplicationVersion();
                }
                if (!OPatchEnv.isApplyOrNApplySession() && !OPatchEnv.isNApplySDKSession()) {
                    for (Object applicationDirObj : this.getApplicationDirs()) {
                        String applicationDir = (String)applicationDirObj;
                        Path latestPtrFile = OPatchEnv.getLatestFileWtihStartString(oracleHomePath, applicationDir, "latest-ptr-");
                        String applicationVersion = "";
                        if (latestPtrFile != null) {
                            applicationVersion = latestPtrFile.getFileName().toString().substring("latest-ptr-".length());
                        }
                        this.currentAppVerDirs.put(applicationDir, applicationVersion);
                    }
                }
            }
            String patchFilesLocation = null;
            if (insideOH) {
                String cookedID = this.getCookedPatchID();
                patchFilesLocation = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedID);
            } else {
                patchFilesLocation = OPatchEnv.getPatchFilesDirectoryPath(patchLocation);
            }
            this.loadActionFile(patchFilesLocation);
            this.loadFileMapping();
            if (this.patchInventory.constituentActiveField != null) {
                this.isComposite = true;
            }
            if (this.isComposite) {
                this.compositeFileLocation = PatchObject.getCompositeFilePath(this.patchLocation);
            }
            PatchComponent[] pc = this.getIncludedPatchComponents();
            for (int i2 = 0; i2 < pc.length; ++i2) {
                PatchComponent indivPC = pc[i2];
                indivPC.setLanguage(this.getPatchInventory().getPatchLanguage());
            }
            String patchType = this.getPatchType();
            if (patchType.equals("snowball")) {
                ListIterator cas = this.getAllCopyActions();
                while (cas.hasNext()) {
                    CopyAction a2 = (CopyAction)cas.next();
                    a2.setSnowBallCopyAction(true);
                }
                ListIterator das = this.getAllDeleteActions();
                while (das.hasNext()) {
                    DeleteAction a3 = (DeleteAction)das.next();
                    a3.setSnowBallDeleteAction(true);
                }
            }
            for (PatchAction action : this.getAllActions()) {
                action.setPatchObject(this);
            }
            this.doProductValidation();
            this.doInHousePatchValidation();
        }
        catch (Exception e5) {
            if (e5 instanceof IllegalAccessException) {
                throw new IllegalAccessException(e5.getMessage());
            }
            if (e5 instanceof SymbolFailureException) {
                throw e5;
            }
            if (e5 instanceof PatchValidationException) {
                throw e5;
            }
            if (e5.getCause() != null) {
                throw new Exception("Unexpected error : \n" + e5.getCause().toString(), e5.getCause());
            }
            Exception e1 = new Exception(e5);
            e1.setStackTrace(e5.getStackTrace());
            throw e1;
        }
    }

    protected void doProductValidation() throws RuntimeException {
        StringBuffer buff = new StringBuffer("PatchObject::doProductValidation()");
        OLogger.debug(buff);
        PatchInventory pInv = this.getPatchInventory();
        StringBuffer errBuff = new StringBuffer("");
        StringBuffer patchBuff = new StringBuffer("Patch \"" + this.getOriginalPatchID() + "\":\n");
        if (pInv.productFamily.equalsIgnoreCase("fusionapps")) {
            String patchModel;
            String[] overlay;
            String patchType = this.getPatchType();
            if (patchType.equals("snowball") && (overlay = pInv.getOverLayOneOffs()) != null && overlay.length != 0) {
                errBuff.append("Fusion Applications patch cannot have overlay definitions.\n");
            }
            PatchAction[] pActions = this.getPatchActions();
            for (int i2 = 0; i2 < pActions.length; ++i2) {
                if (pActions[i2] instanceof CopyAction || pActions[i2] instanceof DeleteAction) continue;
                errBuff.append("Patch cannot have any other actions apart from copy and delete action(s).\n");
                break;
            }
            if (pInv.isTranslatable() && !pInv.getPatchLanguage().equals("en")) {
                errBuff.append("Base patch cannot support any other language apart from \"en\".\n");
            }
            if (patchType.equals("snowball")) {
                ListIterator cas = this.getAllCopyActions();
                while (cas.hasNext()) {
                    CopyAction a2 = (CopyAction)cas.next();
                    String ver = a2.getFileVersion();
                    if (ver != null && !ver.equals("")) continue;
                    errBuff.append("Some (or) all copy actions of this patch do not have file versions.\n");
                }
            }
            if (!(patchModel = pInv.getPatchModel()).equals("snowball")) {
                errBuff.append("Patch does not have a valid patching model.\n");
            }
            if (!patchType.equals("snowball") && !patchType.equals("singleton")) {
                errBuff.append("Patch does not have a valid patch type.\n");
            }
        }
        if (!errBuff.toString().equals("")) {
            String msg = patchBuff.toString() + errBuff.toString();
            OLogger.println(msg);
            throw new RuntimeException(msg);
        }
    }

    protected void doInHousePatchValidation() throws PatchValidationException {
        if (OPS.INSTANCE.getSupportServices().isInHouseTestingPatchWithUPI(this)) {
            String msg = "Patch \"" + this.getOriginalPatchID() + "\" is an Oracle internal product development patch; it should not be installed on customer systems. Oracle customers should contact support for a replacement patch";
            throw new PatchValidationException(msg);
        }
    }

    public void loadChecksumStream(InputStream checkStream) throws Exception {
        Document checksumDocument = PatchObjectUtil.parseXMLFile(checkStream);
        ChecksumEntity[] ckObject = PatchObjectUtil.getContentChecksum(checksumDocument);
        this.cke = ckObject;
    }

    public void loadDeployStream(InputStream deployStream) throws Exception {
        Document deployDocument = PatchObjectUtil.parseXMLFile(deployStream);
        OPatchFmwDS.DeployDS[] dsObject = PatchObjectUtil.getContentDeploy(deployDocument);
        this.deployDsObj = dsObject;
    }

    public PatchObject(InputStream inventoryStream, InputStream actionsStream, InputStream oextJarStream) throws Exception {
        JarClassLoader jarLoader;
        this.actionFile = null;
        this.inventoryFile = null;
        this.patchLocation = null;
        Document iDocument = PatchObjectUtil.parseXMLFile(inventoryStream);
        this.patchInventory = PatchObjectUtil.getContentInventory(iDocument);
        if (oextJarStream != null && (jarLoader = new JarClassLoader(oextJarStream)) != null) {
            this.hasExternalJar = true;
            this.oextJarLoader = jarLoader;
        }
        ActionsFileParser afp = new ActionsFileParser(actionsStream, this.oextJarLoader, "", this);
        this.componentList = afp.parseActionsContent();
        ListIterator pluginInformation = this.getAllPluginActions();
        while (pluginInformation.hasNext()) {
            PatchAction pa = (PatchAction)pluginInformation.next();
            if (pa instanceof sqlAction || pa instanceof sqlprocAction) {
                this.isSqlRelatedActions = true;
            }
            if (pa instanceof hotpatchAction) {
                this.isOnlinePatch = true;
            }
            if (!(pa instanceof portalAction)) continue;
            this.isPortalPatch = true;
        }
    }

    private void loadInventoryFile() throws Exception {
        try {
            Document document = PatchObjectUtil.parseXMLFile(this.inventoryFile);
            this.patchInventory = PatchObjectUtil.getContentInventory(document);
            if (OPatchEnv.isNonrollbackable()) {
                this.patchInventory.setNotRollbackable(true);
            }
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("PatchObject::loadInventoryFile() returns exception"));
            OLogger.error("OUI-67022", new Object[]{e2.getMessage()});
            throw e2;
        }
    }

    private void loadDeployFile() throws Exception {
        Path deployFile = this.deployFile;
        if (deployFile == null || !Files.exists(deployFile, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(deployFile, new LinkOption[0])) {
            OLogger.debug(new StringBuffer("PatchObject::loadDeployFile() returns exception"));
            OLogger.error("OUI-67022", new Object[]{"Deploy file of the patch is a directory."});
            throw new Exception("Deploy file of the patch is a directory.");
        }
        try {
            Document document = PatchObjectUtil.parseXMLFile(deployFile);
            OPatchFmwDS.DeployDS[] dsObject = PatchObjectUtil.getContentDeploy(document);
            this.deployDsObj = dsObject;
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("PatchObject::loadDeployFile() returns exception"));
            OLogger.error("OUI-67022", new Object[]{e2.getMessage()});
            throw e2;
        }
    }

    private void loadInterviewFile() throws Exception {
        Path interviewFile = this.interviewFile;
        if (interviewFile == null || !Files.exists(interviewFile, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(interviewFile, new LinkOption[0])) {
            OLogger.debug(new StringBuffer("PatchObject::loadInterviewFile() returns exception"));
            OLogger.error("OUI-67022", new Object[]{"Interview file of the patch is a directory."});
            throw new Exception("Interview file of the patch is a directory.");
        }
        try {
            Document document = PatchObjectUtil.parseXMLFile(interviewFile);
            InterviewContextVar[] icv = PatchObjectUtil.getContentInterview(document);
            this.interviewObj = icv;
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("PatchObject::loadInterviewFile() returns exception"));
            OLogger.error("OUI-67022", new Object[]{e2.getMessage()});
            throw e2;
        }
    }

    private void loadMaintenanceAliasFile() throws Exception {
        Path maintenanceAliasFilePath = this.maintenanceAilasFilePath;
        if (maintenanceAliasFilePath == null || !Files.exists(maintenanceAliasFilePath, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(maintenanceAliasFilePath, new LinkOption[0])) {
            OLogger.debug(new StringBuffer("PatchObject::loadMaintenanceAliasFile() returns exception"));
            OLogger.error("OUI-67022", new Object[]{"Maintenance alias file of the patch is a directory."});
            throw new Exception("Maintenance alias file of the patch is a directory.");
        }
        try {
            this.maintenanceAliasKeys = PatchObjectUtil.getContentMaintenanceAlias(maintenanceAliasFilePath);
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("PatchObject::loadMaintenanceAliasFile() returns exception"));
            OLogger.error("OUI-67022", new Object[]{e2.getMessage()});
            throw e2;
        }
    }

    private void loadActionFile(String patchFilesLocation) throws Exception {
        try {
            ActionsFileParser afp = new ActionsFileParser(this.actionFile, this.oextJarLoader, patchFilesLocation, this);
            this.componentList = afp.parseActionsContent();
            ListIterator pluginInformation = this.getAllPluginActions();
            while (pluginInformation.hasNext()) {
                PatchAction pa = (PatchAction)pluginInformation.next();
                if (pa instanceof sqlAction || pa instanceof sqlprocAction) {
                    this.isSqlRelatedActions = true;
                }
                if (pa instanceof hotpatchAction) {
                    this.isOnlinePatch = true;
                }
                if (!(pa instanceof portalAction)) continue;
                this.isPortalPatch = true;
            }
        }
        catch (Exception e2) {
            OLogger.debug(new StringBuffer("PatchObject::loadActionFile() returns exception"));
            throw e2;
        }
    }

    private ChecksumEntity[] loadChecksumFile(Path checksum) throws Exception {
        this.cke = PatchObjectUtil.loadChecksumFile(checksum);
        return this.cke;
    }

    private void loadExternalJars() {
        JarClassLoader jarLoader;
        String jarLocation = PatchObject.getExternalJarFilePath(this.patchLocation);
        Path jarFile = WrapperFactory.getNioServiceWrapper().getPath(jarLocation, new String[0]);
        if (Files.exists(jarFile, new LinkOption[0]) && (jarLoader = new JarClassLoader(jarLocation)) != null) {
            this.hasExternalJar = true;
            this.oextJarLoader = jarLoader;
        }
    }

    private void loadFileMapping() throws Exception {
        Path filemapPath = this.fileMappingFilePath;
        if (filemapPath == null || !Files.exists(filemapPath, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(filemapPath, new LinkOption[0])) {
            OLogger.error("OUI-67022", new Object[]{"file-mapping metadata is a directory."});
            throw new Exception("file-mapping metadata is a directory.");
        }
        if (this.isComposite) {
            throw new Exception("Invalid patch (" + this.getPatchID() + "): composite with file-mapping metadata.");
        }
        try {
            Document document = PatchObjectUtil.parseXMLFile(filemapPath);
            this.patchFileMapping = PatchObjectUtil.getContentFileMapping(document, this);
            this.isCbccPatch = true;
        }
        catch (Exception e2) {
            OLogger.justlog(OLogger.WARNING, "OUI-67022");
        }
    }

    private ListIterator getCopyActions(PatchComponent component) throws NullPointerException {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        return component.getCopyList().listIterator();
    }

    private ListIterator getDeleteActions(PatchComponent component) throws NullPointerException {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        return component.getDeleteList().listIterator();
    }

    private ListIterator getJarActions(PatchComponent component) throws NullPointerException {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        return component.getJarList().listIterator();
    }

    private ListIterator getDeleteJarActions(PatchComponent component) throws NullPointerException {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        return component.getDeleteJarList().listIterator();
    }

    private ListIterator getArchiveActions(PatchComponent component) throws NullPointerException {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        return component.getArchiveList().listIterator();
    }

    private ListIterator getMakeActions(PatchComponent component) {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        return component.getMakeList().listIterator();
    }

    private ListIterator getStringSubsActions(PatchComponent component) {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        return component.getStringSubsList().listIterator();
    }

    private ListIterator getPluginActions(PatchComponent component) {
        if (component == null) {
            return this.emptyList.listIterator();
        }
        LinkedList list = new LinkedList(component.getPluginList());
        list.addAll(component.getExternalPluginList());
        return list.listIterator();
    }

    private PatchAction[] getAllImmediateExecutableActions(PatchComponent patchComponent) {
        PatchAction[] paArray = this.getAllActions(patchComponent);
        PatchAction[] paImmediateExecArr = null;
        ArrayList<PatchAction> interPatchActions = new ArrayList<PatchAction>();
        for (int i2 = 0; i2 < paArray.length; ++i2) {
            PatchAction pa = paArray[i2];
            if (pa.isExecutionDelayed()) continue;
            interPatchActions.add(pa);
        }
        paImmediateExecArr = new PatchAction[interPatchActions.size()];
        interPatchActions.toArray(paImmediateExecArr);
        return paImmediateExecArr;
    }

    private PatchAction[] getAllActions(PatchComponent patchComponent) {
        int size = 0;
        if (patchComponent == null) {
            return this.emptyList.toArray(new PatchAction[size]);
        }
        size = patchComponent.actionsSize();
        Object[] arrPatchAction = new PatchAction[size];
        LinkedList copyActions = patchComponent.getCopyList();
        LinkedList jarActions = patchComponent.getJarList();
        LinkedList archiveActions = patchComponent.getArchiveList();
        LinkedList makeActions = patchComponent.getMakeList();
        LinkedList pluginActions = patchComponent.getPluginList();
        LinkedList deleteActions = patchComponent.getDeleteList();
        LinkedList deleteJarActions = patchComponent.getDeleteJarList();
        LinkedList stringSubsActions = patchComponent.getStringSubsList();
        LinkedList externalPluginActions = patchComponent.getExternalPluginList();
        LinkedList allActions = new LinkedList();
        allActions.addAll(copyActions);
        allActions.addAll(jarActions);
        allActions.addAll(archiveActions);
        allActions.addAll(makeActions);
        allActions.addAll(pluginActions);
        allActions.addAll(deleteActions);
        allActions.addAll(deleteJarActions);
        allActions.addAll(stringSubsActions);
        allActions.addAll(externalPluginActions);
        ListIterator listIterator = allActions.listIterator();
        int index = 0;
        while (listIterator.hasNext()) {
            Object obj = listIterator.next();
            if (!(obj instanceof PatchAction)) continue;
            PatchAction pa = (PatchAction)obj;
            arrPatchAction[index++] = (PatchAction)obj;
        }
        Arrays.sort(arrPatchAction);
        return arrPatchAction;
    }

    public PatchAction[] getAllActions() throws NullPointerException {
        Object obj;
        ListIterator iter = this.componentList.listIterator();
        int size = 0;
        while (iter.hasNext()) {
            Object obj2 = iter.next();
            if (!(obj2 instanceof PatchComponent)) continue;
            PatchComponent pc = (PatchComponent)obj2;
            size += pc.actionsSize();
        }
        Object[] actions = new PatchAction[size];
        ListIterator copyList = this.getAllCopyActions();
        ListIterator archiveList = this.getAllArchiveActions();
        ListIterator jarList = this.getAllJarActions();
        ListIterator makeList = this.getAllMakeActions();
        ListIterator pluginList = this.getAllPluginActions();
        ListIterator deleteList = this.getAllDeleteActions();
        ListIterator deleteJarList = this.getAllDeleteJarActions();
        ListIterator stringSubsList = this.getAllStringSubsActions();
        int index = 0;
        while (copyList.hasNext()) {
            obj = copyList.next();
            if (!(obj instanceof CopyAction)) continue;
            CopyAction ca = (CopyAction)obj;
            actions[index++] = ca;
        }
        while (jarList.hasNext()) {
            obj = jarList.next();
            if (!(obj instanceof JarAction)) continue;
            JarAction ja = (JarAction)obj;
            actions[index++] = ja;
        }
        while (archiveList.hasNext()) {
            obj = archiveList.next();
            if (!(obj instanceof ArchiveAction)) continue;
            ArchiveAction ar = (ArchiveAction)obj;
            actions[index++] = ar;
        }
        while (makeList.hasNext()) {
            obj = makeList.next();
            if (!(obj instanceof MakeAction)) continue;
            MakeAction ma = (MakeAction)obj;
            actions[index++] = ma;
        }
        while (stringSubsList.hasNext()) {
            obj = stringSubsList.next();
            if (!(obj instanceof StringSubsAction)) continue;
            StringSubsAction ssa = (StringSubsAction)obj;
            actions[index++] = ssa;
        }
        while (pluginList.hasNext()) {
            obj = pluginList.next();
            actions[index++] = (PatchAction)obj;
        }
        while (deleteList.hasNext()) {
            obj = deleteList.next();
            if (!(obj instanceof DeleteAction)) continue;
            DeleteAction da = (DeleteAction)obj;
            actions[index++] = da;
        }
        while (deleteJarList.hasNext()) {
            obj = deleteJarList.next();
            if (!(obj instanceof DeleteJarAction)) continue;
            DeleteJarAction dja = (DeleteJarAction)obj;
            actions[index++] = dja;
        }
        Arrays.sort(actions);
        return actions;
    }

    public PatchAction[] getAllIncludedActions() {
        ListIterator iter = this.componentList.listIterator();
        ArrayList<PatchAction> actions = new ArrayList<PatchAction>();
        while (iter.hasNext()) {
            PatchComponent pc;
            Object obj = iter.next();
            if (!(obj instanceof PatchComponent) || (pc = (PatchComponent)obj).isExcluded()) continue;
            PatchAction[] pActions = pc.getAllActions();
            for (int i2 = 0; i2 < pActions.length; ++i2) {
                if (!pActions[i2].isAppliedOK()) continue;
                actions.add(pActions[i2]);
            }
        }
        PatchAction[] actionsList = new PatchAction[actions.size()];
        actions.toArray(actionsList);
        return actionsList;
    }

    public ListIterator getAllIncludedCopyActions() {
        return this.getAllCopyActions();
    }

    public ListIterator getAllIncludedArchiveActions() {
        return this.getAllArchiveActions();
    }

    private ListIterator getAllCopyActions() {
        LinkedList<CopyAction> linkedList = new LinkedList<CopyAction>();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = ((PatchComponent)obj1).getCopyList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof CopyAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    public ListIterator getAllTruelyIncludedCopyActions() {
        LinkedList<CopyAction> linkedList = new LinkedList<CopyAction>();
        try {
            int length = this.getIncludedPatchComponents().length;
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                PatchComponent obj1 = this.getIncludedPatchComponents()[i2];
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = obj1.getCopyList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof CopyAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    public ListIterator getAllIncludedDeleteActions() {
        LinkedList<DeleteAction> linkedList = new LinkedList<DeleteAction>();
        try {
            int length = this.getIncludedPatchComponents().length;
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                PatchComponent obj1 = this.getIncludedPatchComponents()[i2];
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = obj1.getDeleteList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof DeleteAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    private ListIterator getAllDeleteActions() {
        LinkedList<DeleteAction> linkedList = new LinkedList<DeleteAction>();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = ((PatchComponent)obj1).getDeleteList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof DeleteAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    public ListIterator getAllIncludedJarActions() {
        return this.getAllJarActions();
    }

    private ListIterator getAllJarActions() {
        LinkedList<JarAction> linkedList = new LinkedList<JarAction>();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = ((PatchComponent)obj1).getJarList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof JarAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    public ListIterator getAllIncludedDeleteJarActions() {
        return this.getAllDeleteJarActions();
    }

    private ListIterator getAllDeleteJarActions() {
        LinkedList<DeleteJarAction> linkedList = new LinkedList<DeleteJarAction>();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = ((PatchComponent)obj1).getDeleteJarList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof DeleteJarAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    private ListIterator getAllArchiveActions() {
        LinkedList<ArchiveAction> linkedList = new LinkedList<ArchiveAction>();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = ((PatchComponent)obj1).getArchiveList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof ArchiveAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    private ListIterator getAllMakeActions() {
        LinkedList<MakeAction> linkedList = new LinkedList<MakeAction>();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = ((PatchComponent)obj1).getMakeList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof MakeAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    private MakeAction[] getAllMakeActionsNonDup() {
        MakeAction[] makes = new MakeAction[]{};
        ArrayList<MakeAction> array = new ArrayList<MakeAction>();
        ListIterator listIter = this.getAllMakeActions();
        while (listIter.hasNext()) {
            Object obj = listIter.next();
            if (!(obj instanceof MakeAction)) continue;
            MakeAction ma = (MakeAction)obj;
            array.add(ma);
        }
        if (array.size() > 0) {
            TreeSet<MakeAction> makeSet = new TreeSet<MakeAction>();
            for (int i2 = 0; i2 < array.size(); ++i2) {
                MakeAction ma = (MakeAction)array.get(i2);
                if (makeSet.contains(ma)) continue;
                makeSet.add(ma);
            }
            int setSize = makeSet.size();
            makes = new MakeAction[setSize];
            Iterator iter = makeSet.iterator();
            int i3 = 0;
            while (iter.hasNext()) {
                MakeAction ma;
                makes[i3] = ma = (MakeAction)iter.next();
                ++i3;
            }
        }
        return makes;
    }

    private ListIterator getAllStringSubsActions() {
        LinkedList<StringSubsAction> linkedList = new LinkedList<StringSubsAction>();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = ((PatchComponent)obj1).getStringSubsList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof StringSubsAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    public ListIterator getAllIncludedStringSubsActions() {
        LinkedList<StringSubsAction> linkedList = new LinkedList<StringSubsAction>();
        try {
            int length = this.getIncludedPatchComponents().length;
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                PatchComponent obj1 = this.getIncludedPatchComponents()[i2];
                if (!(obj1 instanceof PatchComponent)) continue;
                ListIterator iter = obj1.getStringSubsList().listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    if (!(obj3 instanceof StringSubsAction)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    public ListIterator getAllPluginActions() {
        LinkedList linkedList = new LinkedList();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                LinkedList list = new LinkedList();
                list.addAll(((PatchComponent)obj1).getPluginList());
                list.addAll(((PatchComponent)obj1).getExternalPluginList());
                ListIterator iter = list.listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    protected ListIterator getAllNormalPluginActions() {
        LinkedList linkedList = new LinkedList();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                LinkedList list = new LinkedList();
                list.addAll(((PatchComponent)obj1).getPluginList());
                list.addAll(((PatchComponent)obj1).getExternalPluginList());
                ListIterator iter = list.listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    PatchAction pa = (PatchAction)obj3;
                    if (!(pa instanceof PatchAction) || pa.isExecutionDelayed()) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    public ListIterator getAllDelayedPluginActions() {
        LinkedList linkedList = new LinkedList();
        try {
            int length = this.componentList.size();
            Object obj3 = null;
            for (int i2 = 0; i2 < length; ++i2) {
                Object obj1 = this.componentList.get(i2);
                if (!(obj1 instanceof PatchComponent)) continue;
                LinkedList list = new LinkedList();
                list.addAll(((PatchComponent)obj1).getPluginList());
                list.addAll(((PatchComponent)obj1).getExternalPluginList());
                ListIterator iter = list.listIterator();
                while (iter.hasNext()) {
                    obj3 = iter.next();
                    PatchAction pa = (PatchAction)obj3;
                    if (!(pa instanceof PatchAction) || !pa.isExecutionDelayed() || linkedList.contains(pa)) continue;
                    linkedList.add(obj3);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return linkedList.listIterator();
    }

    ListIterator getAllJarActionForRLib() {
        return this.getAllJarActions();
    }

    ListIterator getAllDeleteJarActionForRLib() {
        return this.getAllDeleteJarActions();
    }

    ListIterator getAllCopyActionForRLib() {
        return this.getAllCopyActions();
    }

    ListIterator getAllDeleteActionForRLib() {
        return this.getAllDeleteActions();
    }

    ListIterator getAllStringSubsActionForRLib() {
        return this.getAllStringSubsActions();
    }

    private ListIterator getComponents() {
        return this.componentList.listIterator();
    }

    public Platform[] getPlatforms() {
        Platform[] platforms = new Platform[]{};
        LinkedList plist = this.patchInventory.supportedPlatforms;
        if (plist.size() == 0) {
            return platforms;
        }
        platforms = new Platform[plist.size()];
        plist.toArray(platforms);
        return platforms;
    }

    protected PatchAction getPatchAction(int line) throws NoSuchElementException {
        PatchAction[] patchActions = this.getAllActions();
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            PatchAction p2 = patchActions[i2];
            if (p2.getLineNumber() != line) continue;
            return p2;
        }
        throw new NoSuchElementException("PatchObject::getPatchAction(line) cannot find such action");
    }

    protected String getTopLevelComponentName() throws RuntimeException {
        PatchComponent pc;
        String name;
        PatchComponent[] patchComps = this.getPatchComponents();
        if (patchComps != null && patchComps[0] != null && (name = (pc = patchComps[0]).getName()) != null) {
            return name;
        }
        String msg = "PatchObject::getTopLevelComponentName() cannot get the name of the 1st component in actions file.";
        throw new RuntimeException(msg);
    }

    protected String getTopLevelComponentVersion() throws RuntimeException {
        PatchComponent pc;
        String ver;
        PatchComponent[] patchComps = this.getPatchComponents();
        if (patchComps != null && patchComps[0] != null && (ver = (pc = patchComps[0]).getVersion()) != null) {
            return ver;
        }
        String msg = "PatchObject::getTopLevelComponentVersion() cannot get the version of the 1st component in actions file.";
        throw new RuntimeException(msg);
    }

    protected String getFormatCreationTimeString() {
        return this.patchInventory.getFormatCreationDate();
    }

    protected String getRawCreationTimeString() {
        return this.patchInventory.getRawCreationDate();
    }

    public PostReadMeAction getPostReadMeAction() {
        return this.postReadMeAction;
    }

    public void setPostReadMeAction(PostReadMeAction postReadMeAction) {
        StringBuffer tmp = new StringBuffer("PatchObject::setPostReadMeAction: ");
        if (postReadMeAction == null) {
            tmp.append(" got a null postReadMeAction, will be no-op.");
            OLogger.debug(tmp);
            return;
        }
        tmp.append(postReadMeAction.toString());
        OLogger.debug(tmp);
        this.postReadMeAction = postReadMeAction;
    }

    public PostScriptAction getPostScriptAction() {
        return this.postScriptAction;
    }

    public void setPostScriptAction(PostScriptAction postScriptAction) {
        StringBuffer tmp = new StringBuffer("PatchObject::setPostScriptAction: ");
        if (postScriptAction == null) {
            tmp.append("get a null postScriptAction, will be no-op.");
            OLogger.debug(tmp);
            return;
        }
        tmp.append(postScriptAction.toString());
        OLogger.debug(tmp);
        this.postScriptAction = postScriptAction;
    }

    public PreReadMeAction getPreReadMeAction() {
        return this.preReadMeAction;
    }

    public void setPreReadMeAction(PreReadMeAction preReadMeAction) {
        StringBuffer tmp = new StringBuffer("PatchObject::setPreReadMeAction: ");
        if (tmp == null) {
            tmp.append("get a null preReadMeAction, will be no-op.");
            OLogger.debug(tmp);
            return;
        }
        tmp.append(preReadMeAction.toString());
        OLogger.debug(tmp);
        this.preReadMeAction = preReadMeAction;
    }

    public PreScriptAction getPreScriptAction() {
        return this.preScriptAction;
    }

    public void setPreScriptAction(PreScriptAction preScriptAction) {
        StringBuffer tmp = new StringBuffer("PatchObject::setPreScriptAction: ");
        if (preScriptAction == null) {
            tmp.append("get a null preScriptAction, will be no-op.");
            OLogger.debug(tmp);
            return;
        }
        tmp.append(preScriptAction.toString());
        OLogger.debug(tmp);
        this.preScriptAction = preScriptAction;
    }

    public InitReadMeAction getInitReadMeAction() {
        return this.initReadMeAction;
    }

    public void setInitReadMeAction(InitReadMeAction initReadMeAction) {
        StringBuffer tmp = new StringBuffer("PatchObject::setInitReadMeAction: ");
        if (tmp == null) {
            tmp.append("get a null initReadMeAction, will be no-op.");
            OLogger.debug(tmp);
            return;
        }
        tmp.append(initReadMeAction.toString());
        OLogger.debug(tmp);
        this.initReadMeAction = initReadMeAction;
    }

    public InitScriptAction getInitScriptAction() {
        return this.initScriptAction;
    }

    public void setInitScriptAction(InitScriptAction initScriptAction) {
        StringBuffer tmp = new StringBuffer("PatchObject::setInitScriptAction: ");
        if (initScriptAction == null) {
            tmp.append("get a null initScriptAction, will be no-op.");
            OLogger.debug(tmp);
            return;
        }
        tmp.append(initScriptAction.toString());
        OLogger.debug(tmp);
        this.initScriptAction = initScriptAction;
    }

    protected static boolean isThereInitScript(String patchLoc) {
        String fileName = PatchObject.getInitScriptFilePath(patchLoc);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
        return Files.exists(f2, new LinkOption[0]);
    }

    protected static boolean isTherePreScript(String patchLoc) {
        String fileName = PatchObject.getPreScriptFilePath(patchLoc);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
        return Files.exists(f2, new LinkOption[0]);
    }

    protected static boolean isTherePostScript(String patchLoc) {
        String fileName = PatchObject.getPostScriptFilePath(patchLoc);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(fileName, new String[0]);
        return Files.exists(f2, new LinkOption[0]);
    }

    public String getCookedPatchID() {
        String formatTimeStamp = this.patchInventory.getFormatCreationDate();
        String patchID = this.patchInventory.patchID;
        String s = formatTimeStamp != null ? formatTimeStamp : "";
        StringBuffer buff = new StringBuffer(patchID);
        if (this.patchInventory.mayBeTranslation()) {
            buff.append("_");
            buff.append(this.patchInventory.getPatchLanguage());
        }
        if (!s.equals("")) {
            buff.append("_");
            buff.append(s);
        }
        return buff.toString();
    }

    protected boolean isNoOp() {
        PatchComponent[] reqComps = this.getRequiredPatchComponents();
        if (reqComps.length != 0) {
            return false;
        }
        PatchComponent[] optComps = this.getOptionalPatchComponents();
        boolean noOp = true;
        for (int i2 = 0; i2 < optComps.length; ++i2) {
            boolean included;
            PatchComponent pc = optComps[i2];
            boolean bl = included = !pc.excluded;
            if (!included) continue;
            noOp = false;
        }
        return noOp;
    }

    public void disableSystemCommandCheck() {
        this.checkSystemCommand = false;
    }

    protected boolean isOverlay(String patchID) {
        String[] overlayIDs = this.getOverLayOneOffs();
        for (int i2 = 0; i2 < overlayIDs.length; ++i2) {
            if (!patchID.equals(overlayIDs[i2])) continue;
            return true;
        }
        return false;
    }

    protected boolean isSuperset(PatchObject po) {
        OracleHomeConflictMap oracleHomeCP = OracleHomeConflictMap.getInstance();
        return oracleHomeCP != null && oracleHomeCP.getSupersetMap() != null && oracleHomeCP.getSupersetMap().containsKey(this.getPatchID()) && oracleHomeCP.getSupersetMap().get(this.getPatchID()).contains(po.getPatchID());
    }

    public String actionsToXML() {
        StringBuffer buff = new StringBuffer();
        String[] rawActionEntry = this.getRawActionEntry();
        String beginOneoff = rawActionEntry[0];
        String endOneoff = rawActionEntry[1];
        PatchComponent[] incComponents = this.getIncludedPatchComponents();
        buff.append(beginOneoff);
        buff.append("\n");
        for (int i2 = 0; i2 < incComponents.length; ++i2) {
            PatchComponent incComponent = incComponents[i2];
            PatchAction[] appliedActions = this.getPatchActionsForComponent(incComponent);
            String[] rawCmpEntry = incComponent.getRawActionEntry();
            String beginComp = "";
            String endComp = "";
            if (rawCmpEntry == null || rawCmpEntry[0] == null || rawCmpEntry[1] == null) continue;
            beginComp = rawCmpEntry[0];
            endComp = rawCmpEntry[1];
            buff.append("   ");
            buff.append(beginComp);
            buff.append("\n");
            TreeSet<MakeAction> set = new TreeSet<MakeAction>();
            for (int j2 = 0; j2 < appliedActions.length; ++j2) {
                PatchAction action = appliedActions[j2];
                boolean aOK = action.isAppliedOK();
                if (!aOK) continue;
                if (action instanceof MakeAction) {
                    MakeAction ma = (MakeAction)action;
                    if (set.contains(ma)) continue;
                    set.add(ma);
                }
                String rawEntry = action.getRawActionEntry();
                buff.append("      ");
                buff.append(rawEntry);
                buff.append("\n");
            }
            buff.append("   ");
            buff.append(endComp);
            buff.append("\n");
        }
        buff.append(endOneoff);
        buff.append("\n");
        return buff.toString();
    }

    public boolean hasApplicableMakeActions(String oracleHomePath) {
        String patchLocation = this.getPatchLocation();
        MakeAction[] makeActions = this.getAllMakeActionsNonDup();
        for (int i2 = 0; i2 < makeActions.length; ++i2) {
            MakeAction ma = makeActions[i2];
            if (!ma.applicable(oracleHomePath, patchLocation)) continue;
            return true;
        }
        return false;
    }

    protected String getListOfMakeCmdsOnRemoteNodes(String oracleHomePath) {
        String patchLocation = this.getPatchLocation();
        MakeAction[] makeActions = this.getAllMakeActionsNonDup();
        StringBuffer buff = new StringBuffer();
        for (int i2 = 0; i2 < makeActions.length; ++i2) {
            MakeAction ma = makeActions[i2];
            if (!ma.applicable(oracleHomePath, patchLocation)) continue;
            buff.append(ma.getRemoteCommand(oracleHomePath, true));
            buff.append("\n");
        }
        return buff.toString();
    }

    protected boolean hasArchiveButNoMakeActions() {
        int nArchiveActions = 0;
        boolean hasMake = false;
        PatchAction[] pas = this.getAllActions();
        for (int i2 = 0; i2 < pas.length; ++i2) {
            PatchAction pa = pas[i2];
            if (pa instanceof ArchiveAction) {
                ++nArchiveActions;
                continue;
            }
            if (!(pa instanceof MakeAction)) continue;
            hasMake = true;
        }
        return nArchiveActions > 0 && !hasMake;
    }

    protected void backupForRestore(String oracleHomePath, String sessionName) throws RuntimeException {
        this.backupForRestore(oracleHomePath, sessionName, this);
    }

    public void backupForRestore(String oracleHomePath, String sessionName, PatchObject b_patchObject) throws RuntimeException {
        StringBuffer buff = new StringBuffer("PatchObject::backupForRestore()");
        OLogger.debug(buff);
        String cookedPatchID = b_patchObject.getCookedPatchID();
        String patchID = this.getPatchID();
        PatchComponent[] includedPatchComponents = this.getIncludedPatchComponents();
        int nComps = includedPatchComponents.length;
        int nActions = this.getPatchActions().length;
        if (!cookedPatchID.equals(this.getCookedPatchID())) {
            OPatchEnv.setAutoRollbackPatchID(this.getCookedPatchID());
        } else {
            OPatchEnv.setAutoRollbackPatchID("");
        }
        if (Rules.shouldWarnAboutBackupForRestoreDelay(nActions) && !OPatchEnv.isNApply() && !OPatchEnv.isNRollback()) {
            OLogger.onlyLogInfo("OUI-67117", new Object[]{patchID});
        }
        TreeSet<String> set = new TreeSet<String>();
        ArrayList<Restorable> backupList = new ArrayList<Restorable>();
        ArrayList<Restorable> nonRestorableActions = new ArrayList<Restorable>();
        for (int i2 = 0; i2 < nComps; ++i2) {
            PatchComponent pc = includedPatchComponents[i2];
            PatchAction[] includedPatchActions = this.getPatchActionsForComponent(pc);
            Restorable ra = null;
            for (int j2 = 0; j2 < includedPatchActions.length; ++j2) {
                PatchAction pa = includedPatchActions[j2];
                if (!pa.isAppliedOK()) {
                    buff = new StringBuffer("  Action is not applicable, will not ");
                    buff.append("try to back it up for restore: ");
                    OLogger.debug(buff);
                    continue;
                }
                if (!(pa instanceof Restorable)) continue;
                try {
                    ra = (Restorable)((Object)pa);
                    buff = new StringBuffer("  Checking on Restorable action \"");
                    String desc = ra.getBackupForRestoreDesc(oracleHomePath, cookedPatchID);
                    buff.append(desc);
                    buff.append("\"");
                    OLogger.debug(buff);
                    String key = desc;
                    if (!set.contains(key)) {
                        buff = new StringBuffer(" Checking if action is Restorable");
                        OLogger.debug(buff);
                        if (ra.restorable(oracleHomePath, cookedPatchID)) {
                            buff = new StringBuffer("  Add Restorable action to a list to be backed up.");
                            OLogger.debug(buff);
                            backupList.add(ra);
                        } else {
                            buff = new StringBuffer("  Add non-Restorable action to error list.");
                            OLogger.debug(buff);
                            nonRestorableActions.add(ra);
                        }
                        set.add(key);
                        continue;
                    }
                    buff = new StringBuffer("  Skip duplicate Restorable action");
                    OLogger.debug(buff);
                    continue;
                }
                catch (RuntimeException e2) {
                    OLogger.printStackTrace(e2);
                    if (OPatchEnv.isNApply() || OPatchEnv.isNRollback()) {
                        if (!(pa instanceof sqlprocAction)) continue;
                        nonRestorableActions.add(ra);
                        continue;
                    }
                    nonRestorableActions.add(ra);
                }
            }
        }
        int nonRes = nonRestorableActions.size();
        if (nonRes > 0) {
            this.warnUserAboutBackupForRestoreFailure(oracleHomePath, sessionName, patchID, cookedPatchID, nonRestorableActions, "OUI-67084");
        }
        nonRestorableActions = new ArrayList();
        for (int i3 = 0; i3 < backupList.size(); ++i3) {
            Object obj = backupList.get(i3);
            PatchAction dummy = (PatchAction)obj;
            if (!(obj instanceof Restorable)) continue;
            Restorable restoreAction = (Restorable)obj;
            try {
                restoreAction.backupForRestore(oracleHomePath, cookedPatchID);
                continue;
            }
            catch (RuntimeException e3) {
                OLogger.printStackTrace(e3);
                if (OPatchEnv.isNApply() || OPatchEnv.isNRollback()) {
                    if (!(dummy instanceof sqlprocAction)) continue;
                    nonRestorableActions.add(restoreAction);
                    continue;
                }
                nonRestorableActions.add(restoreAction);
            }
        }
        CUPAdapter cupAdapter = new CUPAdapter(this);
        for (CUPPatchComponent cupComponent : cupAdapter.getCUPPatchComponentList()) {
            cupComponent.backupForRestore();
        }
        nonRes = nonRestorableActions.size();
        if (nonRes > 0) {
            this.warnUserAboutBackupForRestoreFailure(oracleHomePath, sessionName, patchID, cookedPatchID, nonRestorableActions, "OUI-67159");
        }
        if (!OPatchEnv.isNApply() && !OPatchEnv.isNRollback()) {
            StringBuffer srcScriptLoc = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID));
            if (OPatchEnv.isWindows()) {
                srcScriptLoc.append(File.separator);
                srcScriptLoc.append("rollback.bat");
            } else {
                srcScriptLoc.append(File.separator);
                srcScriptLoc.append("rollback.sh");
            }
            StringBuffer dstScriptLoc = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
            dstScriptLoc.append(File.separator);
            dstScriptLoc.append(OPatchEnv.getPatchStorageName());
            dstScriptLoc.append(File.separator);
            dstScriptLoc.append(cookedPatchID);
            if (OPatchEnv.isWindows()) {
                dstScriptLoc.append(File.separator);
                dstScriptLoc.append("rollback.bat");
            } else {
                dstScriptLoc.append(File.separator);
                dstScriptLoc.append("rollback.sh");
            }
            Path srcScriptFile = WrapperFactory.getNioServiceWrapper().getPath(srcScriptLoc.toString(), new String[0]);
            Path dstScriptFile = WrapperFactory.getNioServiceWrapper().getPath(dstScriptLoc.toString(), new String[0]);
            if (!Files.exists(srcScriptFile, new LinkOption[0]) || !Files.isReadable(srcScriptFile)) {
                buff = new StringBuffer("PatchObject::backupForRestore() source file \"");
                buff.append(srcScriptLoc.toString());
                buff.append("\" not exist, do not back up");
                OLogger.debug(buff);
            } else {
                SystemCall.backupFile(srcScriptFile, dstScriptFile);
            }
            String srcRollbackLocation = OPatchEnv.getRollbackDirectoryPath(oracleHomePath, cookedPatchID);
            StringBuffer dstRollbackLocation_sb = new StringBuffer(OPatchEnv.getBackupDirectoryPath(oracleHomePath, cookedPatchID));
            dstRollbackLocation_sb.append(File.separator);
            dstRollbackLocation_sb.append(OPatchEnv.getPatchStorageName());
            dstRollbackLocation_sb.append(File.separator);
            dstRollbackLocation_sb.append(cookedPatchID);
            dstRollbackLocation_sb.append(File.separator);
            dstRollbackLocation_sb.append("files");
            String dstRollbackLocation = dstRollbackLocation_sb.toString();
            Path srcRollback = WrapperFactory.getNioServiceWrapper().getPath(srcRollbackLocation, new String[0]);
            Path dstRollback = WrapperFactory.getNioServiceWrapper().getPath(dstRollbackLocation, new String[0]);
            buff = new StringBuffer("PatchObject::backupForRestore(): Backing up ");
            buff.append(srcRollbackLocation);
            buff.append(" to ");
            buff.append(dstRollbackLocation);
            OLogger.debug(buff);
            if (Files.isDirectory(srcRollback, new LinkOption[0]) && Files.isReadable(srcRollback)) {
                if (Files.exists(dstRollback, new LinkOption[0]) && Files.isRegularFile(dstRollback, new LinkOption[0])) {
                    try {
                        Files.delete(dstRollback);
                    }
                    catch (IOException e4) {
                        OLogger.debug(e4.getMessage());
                    }
                }
                if (!Files.exists(dstRollback, new LinkOption[0])) {
                    try {
                        Files.createDirectories(dstRollback, new FileAttribute[0]);
                    }
                    catch (IOException e5) {
                        OLogger.debug(e5.getMessage());
                    }
                }
                if (SystemCall.copyRecurse(srcRollback, dstRollback, true, true)) {
                    throw new RuntimeException("Could not backup for restore 'files' area under .patch_storage");
                }
            }
        }
        buff = new StringBuffer("PatchObject::backupForRestore() done");
        OLogger.debug(buff);
    }

    private void warnUserAboutBackupForRestoreFailure(String oracleHomePath, String sessionName, String patchID, String cookedPatchID, ArrayList nonRestorableActions, String resourceKey) throws RuntimeException {
        this.warnUserAboutBackupFailure(1, oracleHomePath, sessionName, patchID, cookedPatchID, nonRestorableActions, resourceKey);
    }

    private void warnUserAboutBackupForRollbackFailure(String oracleHomePath, String sessionName, String patchID, String cookedPatchID, ArrayList nonRollbackableActions, String resourceKey) throws RuntimeException {
        this.warnUserAboutBackupFailure(2, oracleHomePath, sessionName, patchID, cookedPatchID, nonRollbackableActions, resourceKey);
    }

    private void warnUserAboutBackupFailure(int code, String oracleHomePath, String sessionName, String patchID, String cookedPatchID, ArrayList problemActions, String resourceKey) throws RuntimeException {
        boolean ignoreBackupError;
        StringBuffer buff = new StringBuffer("PatchObject::warnUserAboutBackupFailure()");
        OLogger.debug(buff);
        int nonRes = problemActions != null ? problemActions.size() : 0;
        StringBuffer outputBuff = new StringBuffer();
        for (int i2 = 0; i2 < nonRes; ++i2) {
            String desc;
            Object obj = problemActions.get(i2);
            if (code == 1) {
                if (!(obj instanceof Restorable)) continue;
                Restorable ra = (Restorable)obj;
                desc = ra.getBackupForRestoreDesc(oracleHomePath, cookedPatchID);
                outputBuff.append(i2 + 1);
                outputBuff.append(") ");
                outputBuff.append(desc);
                outputBuff.append("\n");
                continue;
            }
            if (code != 2 || !(obj instanceof Rollbackable)) continue;
            Rollbackable rb = (Rollbackable)obj;
            desc = rb.getBackupForRollbackDesc(oracleHomePath);
            outputBuff.append(i2 + 1);
            outputBuff.append(") ");
            outputBuff.append(desc);
            outputBuff.append("\n");
        }
        OLogger.printlnOnConsole("  ");
        OLogger.warn(resourceKey, new Object[]{sessionName, patchID, outputBuff.toString()});
        buff = new StringBuffer();
        if (OPatchEnv.isSqlDBError()) {
            buff = new StringBuffer(OLogger.getString("OUI-67262"));
        }
        if (!(ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(buff))) {
            buff = new StringBuffer("User requested not to continue.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        if (OPatchEnv.isSqlDBError()) {
            OPatchEnv.setSqlDBError(false);
            OPatchEnv.setRunSql(false);
        }
    }

    public void backupForRollback(String oracleHomePath, String sessionName) throws RuntimeException {
        StringBuffer buff = new StringBuffer("PatchObject::backupForRollback()");
        OLogger.debug(buff);
        String cookedPatchID = this.getCookedPatchID();
        String patchID = this.getPatchID();
        PatchComponent[] includedPatchComponents = this.getIncludedPatchComponents();
        int nComps = includedPatchComponents.length;
        int nActions = this.getPatchActions().length;
        if (Rules.shouldWarnAboutBackupForRollbackDelay(nActions)) {
            OLogger.justlog(OLogger.INFO, OLogger.getString("OUI-67161", new Object[]{patchID}));
        }
        TreeSet<String> set = new TreeSet<String>();
        ArrayList<Rollbackable> backupList = new ArrayList<Rollbackable>();
        ArrayList<Rollbackable> nonRollbackableActions = new ArrayList<Rollbackable>();
        for (int i2 = 0; i2 < nComps; ++i2) {
            PatchComponent pc = includedPatchComponents[i2];
            PatchAction[] includedPatchActions = this.getPatchActionsForComponent(pc);
            Rollbackable ra = null;
            for (int j2 = 0; j2 < includedPatchActions.length; ++j2) {
                PatchAction pa = includedPatchActions[j2];
                if (!pa.isAppliedOK()) {
                    buff = new StringBuffer("  Action is not applicable, will not ");
                    buff.append("try to back it up for roll-back: ");
                    OLogger.debug(buff);
                    continue;
                }
                if (!(pa instanceof Rollbackable)) continue;
                try {
                    ra = (Rollbackable)((Object)pa);
                    buff = new StringBuffer("  Checking on Rollbackable action \"");
                    String desc = ra.getRollbackableDesc(oracleHomePath, cookedPatchID);
                    buff.append(desc);
                    buff.append("\"");
                    OLogger.debug(buff);
                    String key = desc;
                    if (!set.contains(key)) {
                        buff = new StringBuffer(" Checking if action is Rollbackable");
                        OLogger.debug(buff);
                        buff = new StringBuffer("  Add action to a list to be backed up for rollback.");
                        OLogger.debug(buff);
                        backupList.add(ra);
                        set.add(key);
                        continue;
                    }
                    buff = new StringBuffer("  Skip duplicate Rollbackable action");
                    OLogger.debug(buff);
                    continue;
                }
                catch (RuntimeException e2) {
                    nonRollbackableActions.add(ra);
                }
            }
        }
        int nonRes = nonRollbackableActions.size();
        if (nonRes > 0) {
            this.warnUserAboutBackupForRollbackFailure(oracleHomePath, sessionName, patchID, cookedPatchID, nonRollbackableActions, "OUI-67088");
        }
        nonRollbackableActions = new ArrayList();
        for (int i3 = 0; i3 < backupList.size(); ++i3) {
            Object obj = backupList.get(i3);
            if (!(obj instanceof Rollbackable)) continue;
            Rollbackable rollbackAction = (Rollbackable)obj;
            if (obj instanceof JarAction || obj instanceof DeleteJarAction) {
                JarActionEntity jae = (JarActionEntity)obj;
                HashMap failedObj = new HashMap();
                failedObj = jae.isTriedToBackUp() ? new HashMap() : jae.backupForRollback(oracleHomePath, cookedPatchID, this);
                for (String key : failedObj.keySet()) {
                    JarActionEntity jarActionEntity = (JarActionEntity)failedObj.get(key);
                    if (jarActionEntity instanceof JarAction) {
                        JarAction jarAction = (JarAction)jarActionEntity;
                        nonRollbackableActions.add(jarAction);
                        continue;
                    }
                    if (!(jarActionEntity instanceof DeleteJarAction)) continue;
                    DeleteJarAction deleteJarAction = (DeleteJarAction)jarActionEntity;
                    nonRollbackableActions.add(deleteJarAction);
                }
                continue;
            }
            if (obj instanceof CopyAction) {
                CopyAction ca = (CopyAction)obj;
                ca.backupForRollback(oracleHomePath, cookedPatchID);
                if (!ca.getIsSame()) continue;
                this.sameFileMap.put(ca.getFilename(), true);
                continue;
            }
            rollbackAction.backupForRollback(oracleHomePath, cookedPatchID);
            continue;
        }
        CUPAdapter cupAdapter = new CUPAdapter(this);
        for (CUPPatchComponent cupComponent : cupAdapter.getCUPPatchComponentList()) {
            cupComponent.backupForRollback();
        }
        if (this.sameFileMap != null && !this.sameFileMap.isEmpty()) {
            NApplyDataSerializer serializer = new NApplyDataSerializer();
            String fileLoc = OPatchEnv.getUnchangedFilePath(oracleHomePath, cookedPatchID);
            try {
                serializer.serializeUnchangedFile(fileLoc, this.sameFileMap);
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
        }
        if ((nonRes = nonRollbackableActions.size()) > 0) {
            this.warnUserAboutBackupForRollbackFailure(oracleHomePath, sessionName, patchID, cookedPatchID, nonRollbackableActions, "OUI-67160");
        }
        buff = new StringBuffer("PatchObject::backupForRollback() done");
        OLogger.debug(buff);
    }

    protected void createDP(ApplySession session, String oracleHomePath, String cookedPatchID, String patchID, String oneOffsIDLoc, String patchStorageIDLoc) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createDP()");
        OLogger.debug(buff);
        Path file = RacFileCreator.createDP(oracleHomePath, cookedPatchID, patchID);
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        if (Rules.OUIWrite_continue()) {
            bw.write(oneOffsIDLoc);
            bw.write("\n");
        }
        bw.write(patchStorageIDLoc);
        bw.write("\n");
        bw.flush();
        bw.close();
        fw.close();
    }

    protected void createDP(RollbackSession session, String oracleHomePath, String cookedPatchID, String patchID, String patchStorageIDLoc) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createDP()");
        OLogger.debug(buff);
        Path file = RacFileCreator.createDP(oracleHomePath, cookedPatchID, patchID);
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        bw.write(patchStorageIDLoc);
        bw.write("\n");
        bw.flush();
        bw.close();
        fw.close();
    }

    protected void createDR(RollbackSession session, String oracleHomePath, String cookedPatchID, String patchID, String oneOffsIDLoc) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createDR()");
        OLogger.debug(buff);
        Path file = RacFileCreator.createDR(oracleHomePath, cookedPatchID, patchID);
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        if (Rules.OUIWrite_continue()) {
            bw.write(oneOffsIDLoc);
        }
        bw.write("\n");
        bw.flush();
        bw.close();
        fw.close();
    }

    protected void createAutoDR(ApplySession session, String oracleHomePath, String cookedPatchID, String patchID, String oneOffsIDLoc, boolean autoRB) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createAutoDR()");
        OLogger.debug(buff);
        buff = new StringBuffer("  calling createAutoDR()");
        OLogger.debug(buff);
        Path file = RacFileCreator.createAutoDR(oracleHomePath, cookedPatchID, patchID);
        if (!autoRB) {
            buff = new StringBuffer(" there is no auto-rollback.  Do not write anything to the file.");
            OLogger.debug(buff);
            return;
        }
        if (oneOffsIDLoc == null) {
            buff = new StringBuffer("Null oneoffs/<ID> location");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        if (Rules.OUIWrite_continue()) {
            bw.write(oneOffsIDLoc);
        }
        bw.write("\n");
        bw.flush();
        bw.close();
        fw.close();
    }

    protected void createFP(OPatchSession session, String oracleHomePath, String cookedPatchID, String patchID, String compsXML) throws IOException {
        String[] patchIDs;
        String compositePatchLocation;
        Path file = null;
        StringBuffer buff = new StringBuffer("PatchObject::createFP()");
        OLogger.debug(buff);
        PatchAction[] patchActions = this.getPatchActions();
        file = RacFileCreator.createFP(oracleHomePath, cookedPatchID, patchID);
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        StringBuffer interimLine = new StringBuffer();
        interimLine.append(StringResource.getLiteralOracleHome());
        interimLine.append(File.separator);
        interimLine.append(OPatchEnv.getPatchStorageName());
        interimLine.append(File.separator);
        interimLine.append("interim_inventory.txt");
        interimLine.append("\n");
        bw.write(interimLine.toString());
        TreeSet<String> set = new TreeSet<String>();
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            PatchAction pa = patchActions[i2];
            boolean write = false;
            StringBuffer filePath = new StringBuffer("");
            buff = new StringBuffer(" Checking on PatchAction::isAppliedOK()");
            OLogger.debug(buff);
            if (!pa.isAppliedOK()) {
                buff = new StringBuffer(" Skip non-applicable PatchAction \"");
                buff.append(pa.getRawActionEntry());
                buff.append("\"");
                OLogger.debug(buff);
                continue;
            }
            if (pa instanceof CopyAction) {
                CopyAction ca = (CopyAction)pa;
                buff = new StringBuffer(" serialize Copy Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(ca.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                if (session instanceof RollbackSession) {
                    buff = new StringBuffer(" caller is RollbackSession: checking \"");
                    buff.append(filePath.toString());
                    buff.append("\" if this is a file (new file will not be copied to remote nodes).");
                    OLogger.debug(buff);
                    boolean newFile = ca.isNewFile(oracleHomePath, cookedPatchID, false);
                    if (newFile) {
                        buff = new StringBuffer(" skip new file");
                        continue;
                    }
                }
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Copy Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof DeleteAction) {
                DeleteAction da = (DeleteAction)pa;
                buff = new StringBuffer("  serialize Delete Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(da.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Delete Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof ArchiveAction) {
                ArchiveAction aa = (ArchiveAction)pa;
                buff = new StringBuffer(" serialize Archive Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(aa.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Archive Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof JarAction) {
                JarAction ja = (JarAction)pa;
                buff = new StringBuffer(" serialize Jar Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(ja.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Jar Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof DeleteJarAction) {
                DeleteJarAction dja = (DeleteJarAction)pa;
                buff = new StringBuffer(" serialize Delete Jar Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(dja.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Delete Jar Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof RemoteShellPropagate) {
                RemoteShellPropagate ra = (RemoteShellPropagate)((Object)pa);
                buff = new StringBuffer(" serialize plugin patch Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(ra.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate plugin patch Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            }
            if (!write || !Rules.SystemWrite_continue()) continue;
            set.add(filePath.toString());
            buff = new StringBuffer(" - write Patch Action entry \"");
            buff.append(filePath.toString());
            buff.append("\" to file");
            OLogger.debug(buff);
            filePath.append("\n");
            bw.write(filePath.toString());
            bw.flush();
            write = false;
        }
        if (compsXML != null && !compsXML.equals("") && Rules.OUIWrite_continue()) {
            bw.write(compsXML);
            bw.write("\n");
        }
        if (this.getIsComposite() && (compositePatchLocation = PatchObject.getCompositeFilePath(this.getPatchLocation())) != null && !compositePatchLocation.equals("") && (patchIDs = CompositePatchObject.getConstituentList(compositePatchLocation)) != null) {
            for (int i3 = 0; i3 < patchIDs.length; ++i3) {
                String fileMapLoc = OPatchEnv.getPatchFilemapInfoLoc(oracleHomePath, patchIDs[i3]);
                String inventoryXMLLocation = PatchObject.getInventoryFilePath(fileMapLoc);
                bw.write(inventoryXMLLocation);
                bw.write("\n");
            }
        }
        bw.flush();
        bw.close();
        fw.close();
    }

    protected void createAutoFP(ApplySession session, String oracleHomePath, String cookedPatchID, String patchID, String patchBeingRollbackWithTimeStamp, boolean autoRB) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createAutoFP()");
        OLogger.debug(buff);
        PatchAction[] patchActions = this.getPatchActions();
        Path file = RacFileCreator.createAutoFP(oracleHomePath, cookedPatchID, patchID);
        if (!autoRB) {
            buff = new StringBuffer(" there is no auto-rollback.  Do not write anything to the file.");
            OLogger.debug(buff);
            return;
        }
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        TreeSet<String> set = new TreeSet<String>();
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            PatchAction pa = patchActions[i2];
            boolean write = false;
            StringBuffer filePath = new StringBuffer("");
            buff = new StringBuffer(" Checking on PatchAction::isAppliedOK()");
            OLogger.debug(buff);
            if (!pa.isAppliedOK()) {
                buff = new StringBuffer(" Skip non-applicable PatchAction \"");
                buff.append(pa.getRawActionEntry());
                buff.append("\"");
                OLogger.debug(buff);
                continue;
            }
            if (pa instanceof CopyAction) {
                CopyAction ca = (CopyAction)pa;
                buff = new StringBuffer(" serialize Copy Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(ca.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" if this is a file (new file will not be copied to remote nodes).");
                OLogger.debug(buff);
                boolean newFile = ca.isNewFile(oracleHomePath, patchBeingRollbackWithTimeStamp, false);
                if (newFile) {
                    buff = new StringBuffer(" skip new file");
                    continue;
                }
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Copy Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof DeleteAction) {
                DeleteAction da = (DeleteAction)pa;
                buff = new StringBuffer(" serialize Delete Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(da.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" if this is a file (new file will not be copied to remote nodes).");
                OLogger.debug(buff);
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Copy Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof ArchiveAction) {
                ArchiveAction aa = (ArchiveAction)pa;
                buff = new StringBuffer(" serialize Archive Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(aa.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Archive Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof JarAction) {
                JarAction ja = (JarAction)pa;
                buff = new StringBuffer(" serialize Jar Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(ja.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Jar Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof DeleteJarAction) {
                DeleteJarAction dja = (DeleteJarAction)pa;
                buff = new StringBuffer(" serialize Delete Jar Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(dja.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate Delete Jar Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            } else if (pa instanceof RemoteShellPropagate) {
                RemoteShellPropagate ra = (RemoteShellPropagate)((Object)pa);
                buff = new StringBuffer(" serialize plugin patch Action");
                OLogger.debug(buff);
                filePath = new StringBuffer(ra.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                buff = new StringBuffer(" checking \"");
                buff.append(filePath.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(filePath.toString())) {
                    buff = new StringBuffer(" skip duplicate plugin patch Action \"");
                    buff.append(filePath.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            }
            if (!write || !Rules.SystemWrite_continue()) continue;
            set.add(filePath.toString());
            buff = new StringBuffer(" - write Patch Action entry \"");
            buff.append(filePath.toString());
            buff.append("\" to file");
            OLogger.debug(buff);
            filePath.append("\n");
            bw.write(filePath.toString());
            bw.flush();
            write = false;
        }
        bw.flush();
        bw.close();
        fw.close();
    }

    protected void createAutoRC(ApplySession session, String oracleHomePath, String cookedPatchID, String patchID, String patchBeingRollbackWithTimeStamp, boolean autoRB) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createAutoRC()");
        OLogger.debug(buff);
        PatchAction[] patchActions = this.getPatchActions();
        Path file = RacFileCreator.createAutoRC(oracleHomePath, cookedPatchID, patchID);
        if (!autoRB) {
            buff = new StringBuffer(" there is no auto-rollback.  Do not write anything to the file.");
            OLogger.debug(buff);
            return;
        }
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        TreeSet<String> set = new TreeSet<String>();
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            PatchAction pa = patchActions[i2];
            boolean write = false;
            StringBuffer cmd = new StringBuffer("");
            buff = new StringBuffer(" Checking on PatchAction::isAppliedOK()");
            OLogger.debug(buff);
            if (!pa.isAppliedOK()) {
                buff = new StringBuffer(" Skip non-applicable PatchAction \"");
                buff.append(pa.getRawActionEntry());
                buff.append("\"");
                OLogger.debug(buff);
                continue;
            }
            if (pa instanceof MakeAction) {
                buff = new StringBuffer(" nothing to do for make Action");
                OLogger.debug(buff);
            } else if (pa instanceof RemoteShellRunCommand) {
                RemoteShellRunCommand rc = (RemoteShellRunCommand)((Object)pa);
                buff = new StringBuffer(" serialize plugin patch Action");
                OLogger.debug(buff);
                cmd = new StringBuffer(rc.getRemoteCommand(StringResource.getLiteralOracleHome(), false));
                buff = new StringBuffer(" checking \"");
                buff.append(cmd.toString());
                buff.append("\" for duplicate.");
                OLogger.debug(buff);
                if (set.contains(cmd.toString())) {
                    buff = new StringBuffer(" skip duplicate plugin patch Action \"");
                    buff.append(cmd.toString());
                    buff.append("\"");
                    OLogger.debug(buff);
                    write = false;
                    continue;
                }
                write = true;
            }
            if (!write || !Rules.SystemWrite_continue()) continue;
            set.add(cmd.toString());
            buff = new StringBuffer(" - write Patch Action entry \"");
            buff.append(cmd.toString());
            buff.append("\" to file");
            OLogger.debug(buff);
            cmd.append("\n");
            bw.write(cmd.toString());
            bw.flush();
            write = false;
        }
        String patchgenCmd = "";
        try {
            patchgenCmd = OPatchSessionHelper.getPatchgenCommand(oracleHomePath, patchID, false, false);
        }
        catch (NoSuchMethodException e2) {
            RuntimeException re = new RuntimeException(e2.getMessage());
            re.setStackTrace(e2.getStackTrace());
        }
        buff = new StringBuffer("Get patchgen command line is as " + patchgenCmd);
        OLogger.debug(buff);
        if (!patchgenCmd.equals("")) {
            if (OPatchEnv.isWindows()) {
                bw.write("set ORACLE_HOME=" + oracleHomePath + "&&");
            }
            bw.write(patchgenCmd);
            bw.flush();
        }
        bw.flush();
        bw.close();
        fw.close();
    }

    protected void createFR(RollbackSession session, String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createFR()");
        OLogger.debug(buff);
        PatchAction[] patchActions = this.getPatchActions();
        Path file = RacFileCreator.createFR(oracleHomePath, cookedPatchID, patchID);
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        StringBuffer interimLine = new StringBuffer();
        interimLine.append(StringResource.getLiteralOracleHome());
        interimLine.append(File.separator);
        interimLine.append(OPatchEnv.getPatchStorageName());
        interimLine.append(File.separator);
        interimLine.append("interim_inventory.txt");
        interimLine.append("\n");
        bw.write(interimLine.toString());
        TreeSet<String> set = new TreeSet<String>();
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            boolean newFile;
            PatchAction pa = patchActions[i2];
            boolean write = false;
            StringBuffer filePath = new StringBuffer("");
            buff = new StringBuffer(" Checking on PatchAction::isAppliedOK()");
            OLogger.debug(buff);
            if (!pa.isAppliedOK()) {
                buff = new StringBuffer(" Skip non-applicable PatchAction \"");
                buff.append(pa.getRawActionEntry());
                buff.append("\"");
                OLogger.debug(buff);
                continue;
            }
            if (pa instanceof CopyAction) {
                CopyAction ca = (CopyAction)pa;
                buff = new StringBuffer(" serialize Copy Action");
                OLogger.debug(buff);
                newFile = ca.isNewFile(oracleHomePath, cookedPatchID, false);
                buff = new StringBuffer(" checking if \"");
                buff.append(filePath.toString());
                buff.append("\" to see if it's a new file.");
                write = false;
                if (newFile) {
                    filePath = new StringBuffer(ca.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                    buff = new StringBuffer(" checking \"");
                    buff.append(filePath);
                    buff.append("\" for duplicate.");
                    OLogger.debug(buff);
                    if (set.contains(filePath.toString())) {
                        buff = new StringBuffer(" skip duplicate Copy Action \"");
                        buff.append(filePath);
                        buff.append("\"");
                        OLogger.debug(buff);
                        continue;
                    }
                    write = true;
                }
            } else if (pa instanceof RemoteShellPropagate) {
                RemoteShellPropagate ra = (RemoteShellPropagate)((Object)pa);
                buff = new StringBuffer(" serialize plugin patch Action");
                OLogger.debug(buff);
                newFile = pa.isNewFile(oracleHomePath, cookedPatchID, false);
                buff = new StringBuffer(" checking if \"");
                buff.append(filePath.toString());
                buff.append("\" to see if it's a new file.");
                write = false;
                if (newFile) {
                    filePath = new StringBuffer(ra.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                    buff = new StringBuffer(" checking \"");
                    buff.append(filePath);
                    buff.append("\" for duplicate.");
                    OLogger.debug(buff);
                    if (set.contains(filePath.toString())) {
                        buff = new StringBuffer(" skip duplicate plugin patch Action \"");
                        buff.append(filePath);
                        buff.append("\"");
                        OLogger.debug(buff);
                        continue;
                    }
                    write = true;
                }
            }
            if (!write || !Rules.SystemWrite_continue()) continue;
            set.add(filePath.toString());
            buff = new StringBuffer(" - write Patch Action entry \"");
            buff.append(filePath.toString());
            buff.append("\" to file");
            OLogger.debug(buff);
            filePath.append("\n");
            bw.write(filePath.toString());
            bw.flush();
            write = false;
        }
        bw.flush();
        bw.close();
        fw.close();
        set.clear();
    }

    protected void createAutoFR(ApplySession session, String oracleHomePath, String cookedPatchID, String patchID, String patchBeingRollbackWithTimeStamp, boolean autoRB) throws IOException {
        StringBuffer buff = new StringBuffer("PatchObject::createAutoFR()");
        OLogger.debug(buff);
        PatchAction[] patchActions = this.getPatchActions();
        Path file = RacFileCreator.createAutoFR(oracleHomePath, cookedPatchID, patchID);
        if (!autoRB) {
            buff = new StringBuffer(" there is no auto-rollback.  Do not write anything to the file.");
            OLogger.debug(buff);
            return;
        }
        BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
        BufferedWriter bw = new BufferedWriter(fw);
        TreeSet<String> set = new TreeSet<String>();
        for (int i2 = 0; i2 < patchActions.length; ++i2) {
            boolean newFile;
            PatchAction pa = patchActions[i2];
            boolean write = false;
            StringBuffer filePath = new StringBuffer("");
            buff = new StringBuffer(" Checking on PatchAction::isAppliedOK()");
            OLogger.debug(buff);
            if (!pa.isAppliedOK()) {
                buff = new StringBuffer(" Skip non-applicable PatchAction \"");
                buff.append(pa.getRawActionEntry());
                buff.append("\"");
                OLogger.debug(buff);
                continue;
            }
            if (pa instanceof CopyAction) {
                CopyAction ca = (CopyAction)pa;
                buff = new StringBuffer(" serialize Copy Action");
                OLogger.debug(buff);
                newFile = ca.isNewFile(oracleHomePath, patchBeingRollbackWithTimeStamp, false);
                buff = new StringBuffer(" checking if \"");
                buff.append(filePath.toString());
                buff.append("\" to see if it's a new file.");
                write = false;
                if (newFile) {
                    filePath = new StringBuffer(ca.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                    buff = new StringBuffer(" checking \"");
                    buff.append(filePath);
                    buff.append("\" for duplicate.");
                    OLogger.debug(buff);
                    if (set.contains(filePath.toString())) {
                        buff = new StringBuffer(" skip duplicate Copy Action \"");
                        buff.append(filePath);
                        buff.append("\"");
                        OLogger.debug(buff);
                        continue;
                    }
                    write = true;
                }
            } else if (pa instanceof RemoteShellPropagate) {
                RemoteShellPropagate ra = (RemoteShellPropagate)((Object)pa);
                buff = new StringBuffer(" serialize plugin patch Action");
                OLogger.debug(buff);
                newFile = pa.isNewFile(oracleHomePath, patchBeingRollbackWithTimeStamp, false);
                buff = new StringBuffer(" checking if \"");
                buff.append(filePath.toString());
                buff.append("\" to see if it's a new file.");
                write = false;
                if (newFile) {
                    filePath = new StringBuffer(ra.getFilePathToPropagate(StringResource.getLiteralOracleHome()));
                    buff = new StringBuffer(" checking \"");
                    buff.append(filePath);
                    buff.append("\" for duplicate.");
                    OLogger.debug(buff);
                    if (set.contains(filePath.toString())) {
                        buff = new StringBuffer(" skip duplicate plugin patch Action \"");
                        buff.append(filePath);
                        buff.append("\"");
                        OLogger.debug(buff);
                        continue;
                    }
                    write = true;
                }
            }
            if (!write || !Rules.SystemWrite_continue()) continue;
            set.add(filePath.toString());
            buff = new StringBuffer(" - write Patch Action entry \"");
            buff.append(filePath.toString());
            buff.append("\" to file");
            OLogger.debug(buff);
            filePath.append("\n");
            bw.write(filePath.toString());
            bw.flush();
            write = false;
        }
        bw.flush();
        bw.close();
        fw.close();
        set.clear();
    }

    protected void createRC(OPatchSession session, String oracleHomePath, String cookedPatchID, String patchID) throws IOException {
        Path file = null;
        try {
            StringBuffer buff = new StringBuffer("PatchObject::createRC()");
            OLogger.debug(buff);
            PatchAction[] patchActions = this.getPatchActions();
            file = RacFileCreator.createRC(oracleHomePath, cookedPatchID, patchID);
            BufferedWriter fw = Files.newBufferedWriter(file, Charset.forName("UTF-8"), new OpenOption[0]);
            BufferedWriter bw = new BufferedWriter(fw);
            TreeSet<String> set = new TreeSet<String>();
            for (int i2 = 0; i2 < patchActions.length; ++i2) {
                PatchAction pa = patchActions[i2];
                boolean write = false;
                StringBuffer cmd = new StringBuffer("");
                buff = new StringBuffer(" Checking on PatchAction::isAppliedOK()");
                OLogger.debug(buff);
                if (!pa.isAppliedOK()) {
                    buff = new StringBuffer(" Skip non-applicable PatchAction \"");
                    buff.append(pa.getRawActionEntry());
                    buff.append("\"");
                    OLogger.debug(buff);
                    continue;
                }
                if (pa instanceof MakeAction) {
                    buff = new StringBuffer(" make actions are tracked separately.");
                    OLogger.debug(buff);
                } else if (pa instanceof RemoteShellRunCommand) {
                    RemoteShellRunCommand rc = (RemoteShellRunCommand)((Object)pa);
                    buff = new StringBuffer(" serialize plugin patch Action");
                    OLogger.debug(buff);
                    if (session instanceof ApplySession) {
                        cmd = new StringBuffer(rc.getRemoteCommand(StringResource.getLiteralOracleHome(), true));
                    } else if (session instanceof RollbackSession) {
                        cmd = new StringBuffer(rc.getRemoteCommand(StringResource.getLiteralOracleHome(), false));
                    }
                    buff = new StringBuffer(" checking \"");
                    buff.append(cmd.toString());
                    buff.append("\" for duplicate.");
                    OLogger.debug(buff);
                    if (set.contains(cmd.toString())) {
                        buff = new StringBuffer(" skip duplicate plugin patch Action \"");
                        buff.append(cmd.toString());
                        buff.append("\"");
                        OLogger.debug(buff);
                        write = false;
                        continue;
                    }
                    write = true;
                }
                if (!write || !Rules.SystemWrite_continue()) continue;
                set.add(cmd.toString());
                buff = new StringBuffer(" - write Patch Action entry \"");
                buff.append(cmd.toString());
                buff.append("\" to file");
                OLogger.debug(buff);
                cmd.append("\n");
                bw.write(cmd.toString());
                bw.flush();
                write = false;
            }
            boolean apply = session instanceof ApplySession;
            String patchgenCmd = "";
            try {
                patchgenCmd = OPatchSessionHelper.getPatchgenCommand(oracleHomePath, patchID, apply, false);
            }
            catch (NoSuchMethodException e2) {
                RuntimeException re = new RuntimeException(e2.getMessage());
                re.setStackTrace(e2.getStackTrace());
            }
            buff = new StringBuffer("Got command line is " + patchgenCmd);
            OLogger.debug(buff);
            if (!patchgenCmd.equals("")) {
                if (OPatchEnv.isWindows()) {
                    bw.write("set ORACLE_HOME=" + oracleHomePath + "&&");
                }
                bw.write(patchgenCmd);
                bw.flush();
            }
            bw.flush();
            bw.close();
            fw.close();
        }
        catch (IOException e3) {
            throw e3;
        }
        catch (RuntimeException e4) {
            throw e4;
        }
    }

    public OneOffEntry toOneOffEntry(String oracleHomePath) {
        OneOffEntry.NameVersionPair oObj;
        PatchInventory.NameVersionPair obj;
        int i2;
        if (this.patchInventory == null || this.patchInventory.bugsToFix == null) {
            RuntimeException e2 = new RuntimeException("Null member PatchInventory");
            throw e2;
        }
        if (this.oneOffEntry != null) {
            OLogger.debug("Returning and existing OneOffEnrty for patch id " + this.getPatchID());
            this.oneOffEntry.setOracleHome(oracleHomePath);
            return this.oneOffEntry;
        }
        OneOffEntry dummyOneOff = new OneOffEntry();
        String id = this.getPatchID();
        String patchID = this.getOriginalPatchID();
        String tripletID = this.getTripletPatchID();
        String pse = this.patchInventory.getPSENumber();
        String tpse = this.patchInventory.getTmpPSENumber();
        boolean auto = this.patchInventory.isAuto();
        boolean translatable = this.patchInventory.isTranslatable();
        boolean mayBeTranslation = this.patchInventory.mayBeTranslation();
        boolean exitIfPreScriptError = this.patchInventory.isExitIfPreScriptError();
        String patchDesc = this.patchInventory.getPatchDescription();
        String bundleDesc = this.patchInventory.getBundleDescription();
        String patchModel = this.patchInventory.getPatchModel();
        String minOPatchVersion = this.patchInventory.getMinOPatchVersion();
        boolean isRu = this.patchInventory.getRu();
        String ruVersion = this.patchInventory.getRUVersion();
        String initDateStr = PatchObject.getInitDateStr();
        ChecksumEntity[] cke = this.cke;
        if (patchModel == null || patchModel.equals("")) {
            patchModel = "one-off";
        }
        String patchLanguage = this.patchInventory.getPatchLanguage();
        UpdateComponent[] updateCompsList = new UpdateComponent[this.patchInventory.updateComps.size()];
        if (pse == null) {
            pse = "";
        }
        String cookedID = this.getCookedPatchID();
        Date appliedDate = new Date();
        PatchAction[] patchActions = this.getPatchActions();
        PatchComponent[] reqdComponents = this.getRequiredPatchComponents();
        PatchComponent[] optComponents = this.getOptionalPatchComponents();
        String creationZone = this.patchInventory.creationZone;
        String creationDate = this.patchInventory.getRawCreationDate();
        boolean rollbackable = this.patchInventory.rollbackable;
        Bug[] bugsFixed = new Bug[this.patchInventory.bugsToFix.size()];
        String[] prereqOneOffs = this.patchInventory.getPrereqOneOffs();
        WLSPatch[] wlsPrereqOneOffs = this.patchInventory.getWlsPrereqOneOffs();
        String esysPatchID = this.patchInventory.getESysPatchID();
        TargetEntity[] targetEntities = this.patchInventory.getTargetEntities();
        String regressedOneOff = this.patchInventory.getRegressedPatchId();
        String[] coreqOneOffs = this.patchInventory.getCoreqOneOffs();
        String[] overLayOneOffs = this.patchInventory.getOverLayOneOffs();
        String[] prereqBugs = this.patchInventory.getPrereqBugList();
        String[] executables = new String[this.patchInventory.executablesList.size()];
        Platform[] suppPlatforms = new Platform[this.patchInventory.supportedPlatforms.size()];
        boolean instanceShutdown = this.patchInventory.instanceShutdown;
        String instanceShutdownMsg = this.patchInventory.instanceShutdownMessage;
        boolean rolling = this.patchInventory.rollingPatch;
        boolean isSqlPatch = this.patchInventory.sqlPatch;
        String sqlPatchDatabaseStartupMode = this.patchInventory.sqlPatchDatabaseStartupMode;
        boolean isFmwRolling = this.patchInventory.isFmwRolling;
        boolean isFmwFeatureBearing = this.patchInventory.isFmwFeatureBearing;
        boolean isMiniPatchSet = this.patchInventory.isMiniPatchSet();
        String patchType = this.patchInventory.patchType;
        boolean cannotAutoRollback = this.patchInventory.cannotAutoRollback;
        String[] applicationDirs = new String[this.patchInventory.applicationDirs.size()];
        if (patchType == null || patchType.equals("")) {
            patchType = "singleton";
        }
        String subType = this.patchInventory.subType;
        String productFamily = this.patchInventory.productFamily;
        String productType = this.patchInventory.applicableProductType;
        String patchLocation = this.getPatchLocation();
        OPatchFmwDS.DeployDS[] deployList = this.getDeployList();
        InterviewContextVar[] interviewList = this.getInterviewList();
        OneOffEntry.NameVersionPair[] systemComponentList = new OneOffEntry.NameVersionPair[this.patchInventory.systemComponentList.size()];
        OneOffEntry.NameVersionPair[] applicationList = new OneOffEntry.NameVersionPair[this.patchInventory.applicationShutdownList.size()];
        OneOffEntry.NameVersionPair[] productsList = new OneOffEntry.NameVersionPair[this.patchInventory.productsList.size()];
        this.patchInventory.bugsToFix.toArray(bugsFixed);
        this.patchInventory.supportedPlatforms.toArray(suppPlatforms);
        this.patchInventory.updateComps.toArray(updateCompsList);
        for (i2 = 0; i2 < executables.length; ++i2) {
            String exec = (String)this.patchInventory.executablesList.get(i2);
            executables[i2] = exec = "ORACLE_HOME" + File.separator + exec;
        }
        for (int j2 = 0; j2 < applicationList.length; ++j2) {
            obj = (PatchInventory.NameVersionPair)this.patchInventory.applicationShutdownList.get(j2);
            applicationList[j2] = oObj = dummyOneOff.getNameVersionPairObject(obj.getName(), obj.getVersions(), obj.isShutdown());
        }
        for (int k2 = 0; k2 < systemComponentList.length; ++k2) {
            obj = (PatchInventory.NameVersionPair)this.patchInventory.systemComponentList.get(k2);
            systemComponentList[k2] = oObj = dummyOneOff.getNameVersionPairObject(obj.getName(), obj.getVersions(), obj.isShutdown());
        }
        for (int l2 = 0; l2 < productsList.length; ++l2) {
            obj = (PatchInventory.NameVersionPair)this.patchInventory.productsList.get(l2);
            productsList[l2] = oObj = dummyOneOff.getNameVersionPairObject(obj.getName(), obj.getVersions());
        }
        for (i2 = 0; i2 < applicationDirs.length; ++i2) {
            String appDir;
            applicationDirs[i2] = appDir = (String)this.patchInventory.applicationDirs.get(i2);
        }
        String constituentActiveField = this.patchInventory.constituentActiveField;
        boolean isComposite = this.isComposite;
        String compositeFileLocation = this.compositeFileLocation;
        boolean deleteOldDirectory = this.patchInventory.deleteOldDirectory;
        LinkedList componentList = this.componentList;
        HashMap<String, String> currentAppVerDirs = this.currentAppVerDirs;
        OneOffEntry oneOffEntry = new OneOffEntry(constituentActiveField, isComposite, patchID, id, pse, cookedID, appliedDate, bugsFixed, null, patchActions, creationZone, creationDate, rollbackable, prereqOneOffs, wlsPrereqOneOffs, coreqOneOffs, overLayOneOffs, executables, suppPlatforms, instanceShutdown, instanceShutdownMsg, rolling, isSqlPatch, sqlPatchDatabaseStartupMode, isFmwRolling, isFmwFeatureBearing, patchType, productFamily, reqdComponents, optComponents, systemComponentList, applicationList, productType, productsList, patchLocation, this.isOnlinePatch(), this.isPortalPatch(), isMiniPatchSet, updateCompsList, deployList, interviewList, auto, translatable, patchDesc, bundleDesc, patchModel, patchLanguage, prereqBugs, mayBeTranslation, null, minOPatchVersion, this.getChecksumFile(), cannotAutoRollback, exitIfPreScriptError, initDateStr, compositeFileLocation, targetEntities, esysPatchID, tpse, tripletID, applicationDirs, deleteOldDirectory, componentList, currentAppVerDirs, isRu, ruVersion, regressedOneOff);
        oneOffEntry.setPatchObject(this);
        oneOffEntry.setOracleHome(oracleHomePath);
        if (subType != null && !subType.equals("")) {
            oneOffEntry.setSubType(subType);
        }
        this.oneOffEntry = oneOffEntry;
        return oneOffEntry;
    }

    public boolean equals(Object obj) {
        if (obj instanceof PatchObject) {
            String myPatchID = this.getPatchID();
            String myCreationDate = this.getCreationDay();
            PatchObject it = (PatchObject)obj;
            String itPatchID = it.getPatchID();
            String itCreationDate = it.getCreationDay();
            if (myPatchID.equals(itPatchID) && myCreationDate.equals(itCreationDate)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getBugsToFix().length;
        result = 37 * result + this.getAllActions().length;
        result = 37 * result + this.getPatchComponents().length;
        return result;
    }

    public void disableRestoreFileCreation() {
        this.createRestoreFile = false;
    }

    protected boolean shouldCreateRestoreFile() {
        StringBuffer buff = new StringBuffer("PatchObject::shouldCreateRestoreFile() = ");
        buff.append(this.createRestoreFile);
        OLogger.debug(buff);
        return this.createRestoreFile;
    }

    public void disableMakeAction() {
        this.invokeMakeAction = false;
    }

    public void disableRegenerateLibrary() {
        this.invokeRegenerateLibrary = false;
    }

    protected void loadOneOffFromInv(String patchID) throws RuntimeException {
        String oracleHome = OPatchEnv.getOracleHome();
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHome);
            PatchInventory patchInventory = new PatchInventory();
            LinkedList compsList = new LinkedList();
            readServices.populatePatchInventoryAndComps(oracleHome, patchID, patchInventory, compsList);
            this.componentList = compsList;
            this.patchInventory = patchInventory;
        }
        catch (Throwable t) {
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
    }

    public boolean isActiveCompositeSubPatch() {
        return this.getPatchID() != null && this.getPatchID().equals(this.patchInventory.constituentActiveField);
    }

    protected boolean shouldInvokeMakeAction() {
        return this.invokeMakeAction;
    }

    protected boolean shouldInvokeRegenerateLibrary() {
        return this.invokeRegenerateLibrary;
    }

    protected static String getInitDateStr() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM_dd_yyyy_HH_mm_ss", Locale.ENGLISH);
        return dateFormat.format(initDate);
    }

    protected static String getInitDateTimestamp() {
        try {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss", Locale.ENGLISH);
            SimpleDateFormat dateFormatterLogFile = new SimpleDateFormat("yyyy-MM-dd'_'HH-mm-ssa", Locale.ENGLISH);
            String invokedTS = OPatchEnv.getInvokeTimeStamp();
            Date dateForLogFile = dateFormatterLogFile.parse(invokedTS);
            return dateFormatter.format(dateForLogFile);
        }
        catch (Throwable t) {
            return "";
        }
    }

    public void setScriptsFlagForOPatchOverCAS(boolean b2) {
        this.scriptsForCAS = b2;
    }

    public boolean getScriptsFlagForOPatchOverCAS() {
        return this.scriptsForCAS;
    }

    public Path getChecksumFile() {
        return this.checksumFile;
    }

    public void setChecksumFile(Path checksumFile) {
        this.checksumFile = checksumFile;
    }

    public void setOneOffEntryObj(OneOffEntry obj) {
        this.oneOffEntry = obj;
    }

    public OneOffEntry getOneOffEntryObj() {
        return this.oneOffEntry;
    }

    private static boolean isSnowBall() {
        try {
            if (OPatchEnv.getOracleHome() != null) {
                int modelCode;
                String oh = OPatchEnv.getOracleHome();
                if (ohToModelMap.containsKey(oh)) {
                    modelCode = ohToModelMap.get(oh);
                } else {
                    modelCode = PatchingModel.returnModelCode(OPatchEnv.getOracleHome());
                    ohToModelMap.put(oh, modelCode);
                }
                if (modelCode == 2) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            return false;
        }
        return false;
    }

    public static PatchObject getInstance(String patchLocation) throws IllegalAccessException, Exception {
        if (PatchObject.isSnowBall() && patchMaps.containsKey(patchLocation)) {
            PatchObject potmp = patchMaps.get(patchLocation);
            return potmp;
        }
        PatchObject object = new PatchObject(patchLocation);
        patchMaps.put(patchLocation, object);
        return object;
    }

    public static PatchObject getInstance(String oracleHomePath, String patchID, boolean needSearchTripletID) throws IllegalAccessException, Exception {
        String key = oracleHomePath + "_" + patchID;
        if (PatchObject.isSnowBall() && patchMaps.containsKey(key)) {
            return patchMaps.get(key);
        }
        PatchObject object = new PatchObject(oracleHomePath, patchID, needSearchTripletID);
        patchMaps.put(key, object);
        return object;
    }

    public static PatchObject getInstance(String oracleHomePath, String patchID) throws IllegalAccessException, Exception {
        return PatchObject.getInstance(oracleHomePath, patchID, true);
    }

    public static void markPatchObjectAsStarred(String patchLocation) {
        starredPatchObjects.add(patchLocation);
    }

    public static void destroyObject() {
        if (patchMaps.size() > 0) {
            ArrayList<String> keyToBeRemoved = new ArrayList<String>();
            for (String key : patchMaps.keySet()) {
                PatchObject pa;
                if (starredPatchObjects.contains(key) || (pa = patchMaps.get(key)) == null) continue;
                pa.componentList.clear();
                if (pa.oneOffEntry != null) {
                    pa.oneOffEntry.setPatchObject(null);
                    pa.oneOffEntry = null;
                    pa.patchInventory = null;
                }
                keyToBeRemoved.add(key);
            }
            for (String key : keyToBeRemoved) {
                patchMaps.remove(key);
            }
        }
    }

    public void setApplyInventoryComponents(Set<InventoryComponentInfo> compsInfoInInventoryApply) {
        this.compsInfoInInventoryApply = compsInfoInInventoryApply;
    }

    public Set<InventoryComponentInfo> getApplyInventoryComponents() {
        return this.compsInfoInInventoryApply;
    }

    public boolean hasCbccResolved(String filename) {
        if (this.cbccResult == null) {
            return false;
        }
        try {
            return this.cbccResult.hasResolvedSameFile(filename);
        }
        catch (CbccException cbccException) {
            return false;
        }
    }

    public CbccResult getCbccResult() {
        return this.cbccResult;
    }

    public void setCbccResult(CbccResult result) {
        this.cbccResult = result;
    }

    public String getRollbackFilesDirectoryPath() {
        return OPatchEnv.getRollbackDirectoryPath(OPatchEnv.getOracleHome(), this.getCookedPatchID());
    }

    public static enum HybridPatchPart {
        ONLINE,
        OFFLINE;

    }
}

