/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import oracle.glcm.opatch.common.api.Result;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchComponentCheckResult;

public class PatchComponentCheckResultImpl
implements PatchComponentCheckResult {
    private PatchComponent _component;
    private Result _result = Result.NOT_EVALUATED;
    private String _details;

    public PatchComponentCheckResultImpl(PatchComponent component) {
        if (component == null) {
            throw new IllegalArgumentException("The component provided was null.");
        }
        this._component = component;
    }

    @Override
    public PatchComponent getComponent() {
        return this._component;
    }

    @Override
    public Result getResult() {
        return this._result;
    }

    @Override
    public void setResult(Result result) {
        this._result = result != null ? result : Result.NOT_EVALUATED;
    }

    @Override
    public String getDetails() {
        return this._details;
    }

    @Override
    public void setDetails(String details) {
        this._details = details;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Component ").append(this.getComponent().getName()).append(" ").append(this.getComponent().getVersion());
        sb.append(" Result: ").append(this.getResult());
        String details = this.getDetails();
        if (details != null && !details.equals("")) {
            sb.append(" Details: ").append(details);
        }
        return sb.toString();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof PatchComponentCheckResultImpl)) {
            return false;
        }
        PatchComponentCheckResultImpl that = (PatchComponentCheckResultImpl)o2;
        PatchComponent thisComponent = this.getComponent();
        PatchComponent thatComponent = that.getComponent();
        return thisComponent.getName().equals(thatComponent.getName()) && thisComponent.getVersion().equals(thatComponent.getVersion());
    }

    public int hashCode() {
        String thisName = this.getComponent().getName();
        String thisVersion = this.getComponent().getVersion();
        int result = thisName != null ? thisName.hashCode() : 0;
        result = 31 * result + (thisVersion != null ? thisVersion.hashCode() : 0);
        return result;
    }
}

