/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import oracle.opatch.Component;
import oracle.opatch.OPatchEnv;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.XMLConverter;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public abstract class PatchAction
implements Comparable {
    static final int SIZE = 2048;
    static byte[] BUFF = new byte[2048];
    protected PatchComponent owningComp = null;
    protected boolean noOp = true;
    protected int lineNumber = 0;
    private String rawActionEntry = "n/a";
    private String hashValue = "";
    private PatchObject patchObject = null;
    private boolean delayActionExecution = false;
    protected boolean appliedOK = true;
    protected boolean rollbackOK = true;
    Component component;

    protected void makeNoOp() {
    }

    public boolean isNoOp() {
        return this.noOp;
    }

    protected String getRawActionEntry() {
        return this.rawActionEntry;
    }

    protected int getBackupForRollbackFileNumber(String oracleHomePath, String cookedPatchID) throws RuntimeException {
        return 0;
    }

    protected String getReversedRawActionEntry() {
        return XMLConverter.getXMLString(this.rawActionEntry);
    }

    protected void setRawActionEntry(String entry) {
        if (OPatchEnv.isLoadPoh()) {
            return;
        }
        this.rawActionEntry = entry;
    }

    public PatchAction() {
        this.noOp = true;
    }

    public PatchAction(PatchComponent pc, int lineNumber) {
        this.owningComp = pc;
        this.lineNumber = lineNumber;
    }

    public PatchAction(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public String getOwningComponentDesc() {
        if (this.owningComp != null) {
            String name = this.owningComp.getName();
            String ver = this.owningComp.getVersion();
            StringBuffer buff = new StringBuffer(name);
            buff.append(", ");
            buff.append(ver);
            return buff.toString();
        }
        return "No Owning Component";
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public boolean isExecutionDelayed() {
        return this.delayActionExecution;
    }

    public void setDelayExecution(boolean in) {
        this.delayActionExecution = in;
    }

    public boolean isAppliedOK() {
        return this.appliedOK;
    }

    public void setApplyFailed() {
        this.appliedOK = false;
    }

    public boolean isRollbackOK() {
        return this.rollbackOK;
    }

    public void setRollbackFailed() {
        this.rollbackOK = false;
    }

    public int compareTo(Object obj) {
        if (obj instanceof PatchAction) {
            PatchAction pa = (PatchAction)obj;
            int itsLineNumber = pa.getLineNumber();
            if (this.lineNumber == itsLineNumber) {
                return 0;
            }
            if (this.lineNumber > itsLineNumber) {
                return 1;
            }
            if (this.lineNumber < itsLineNumber) {
                return -1;
            }
        }
        return -1;
    }

    public static boolean fileCompare(InputStream s1, InputStream s2) throws IOException {
        int len = 0;
        MessageDigest md1 = null;
        MessageDigest md2 = null;
        try {
            md1 = MessageDigest.getInstance("SHA-256");
            md2 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e2) {
            StringBuffer msg = new StringBuffer("PatchAction:fileCompare() failed: ");
            msg.append(e2.getMessage());
            RuntimeException re = new RuntimeException(msg.toString());
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        while ((len = s1.read(BUFF)) >= 0) {
            md1.update(BUFF, 0, len);
        }
        while ((len = s2.read(BUFF)) >= 0) {
            md2.update(BUFF, 0, len);
        }
        byte[] b1 = md1.digest();
        byte[] b2 = md2.digest();
        String checkSum1 = PatchAction.getHex(b1);
        String checkSum2 = PatchAction.getHex(b2);
        StringBuffer buff = new StringBuffer("CheckSum of 2 streams are ");
        buff.append(checkSum1);
        buff.append(" and ");
        buff.append(checkSum2);
        buff.append(" and they are ");
        boolean equal = MessageDigest.isEqual(b1, b2);
        buff.append(equal ? "" : "not ");
        buff.append("equal");
        OLogger.debug(buff.toString());
        return equal;
    }

    public static String getHex(byte[] raw) {
        String HEXES = "0123456789ABCDEF";
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (int i2 = 0; i2 < raw.length; ++i2) {
            byte b2 = raw[i2];
            hex.append(HEXES.charAt((b2 & 0xF0) >> 4)).append(HEXES.charAt(b2 & 0xF));
        }
        return hex.toString();
    }

    public void printVerificationFailure(PatchAction pa, String src, String dst) {
        StringBuffer buff = new StringBuffer("     " + pa.getActionName() + " failed: ");
        buff.append("failed to update \"");
        buff.append(dst);
        buff.append("\" with updated \"");
        buff.append(src);
        buff.append("\"");
        OLogger.log(OLogger.FINE, buff.toString());
    }

    public abstract String getChildPath();

    public abstract String getParentFilePath(String var1);

    public ArrayList getFilesTouched(String oracleHomePath) {
        String[] s = new String[]{this.getChildPath(), this.getParentFilePath(oracleHomePath)};
        if (s[0] == "" || s[1] == "") {
            return new ArrayList();
        }
        ArrayList<String[]> a2 = new ArrayList<String[]>();
        a2.add(s);
        return a2;
    }

    public long getSpaceNeeded(String patchLocation) {
        return 0L;
    }

    public void setHashValue(String hashValue) {
        this.hashValue = hashValue;
    }

    public String getHashValue() {
        return this.hashValue;
    }

    public abstract String getActionName();

    public abstract String getActionDesc();

    public abstract boolean isNewFile(String var1, String var2, boolean var3);

    public boolean checkPatchStorageExist(String psCookedPatchIDPath) {
        Path psCookedPatchIDFile = WrapperFactory.getNioServiceWrapper().getPath(psCookedPatchIDPath, new String[0]);
        return Files.exists(psCookedPatchIDFile, new LinkOption[0]) && Files.isReadable(psCookedPatchIDFile);
    }

    public void setPatchObject(PatchObject patchObject) {
        this.patchObject = patchObject;
    }

    public PatchObject getPatchObject() {
        return this.patchObject;
    }
}

