/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.NoSuchElementException;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchSession;
import oracle.opatch.OnlinePatchException;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.wrappers.WrapperFactory;

public class OnlinePatchProcessor {
    private static HashMap<String, PatchObject.HybridPatchPart> hybridPatchMap = new HashMap();

    public static boolean isOnlinePart(String patchlocation) {
        boolean getOnlinePart = false;
        String canonicalPatchLoc = "";
        try {
            canonicalPatchLoc = WrapperFactory.getNioServiceWrapper().getPath(patchlocation, new String[0]).toAbsolutePath().normalize().toString();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return getOnlinePart;
        }
        if (hybridPatchMap.get(canonicalPatchLoc) == PatchObject.HybridPatchPart.ONLINE) {
            getOnlinePart = true;
        }
        OLogger.debug("check if " + canonicalPatchLoc + " saved in hybrid online patch map: " + getOnlinePart);
        return getOnlinePart;
    }

    public static void setHybridPatchPart(String patchLocation, PatchObject.HybridPatchPart hybridPatchPart) {
        try {
            String canonicalPatchLoc = WrapperFactory.getNioServiceWrapper().getPath(patchLocation, new String[0]).toAbsolutePath().normalize().toString();
            OLogger.debug("Add patch " + canonicalPatchLoc + " to new online patch.");
            hybridPatchMap.put(canonicalPatchLoc, hybridPatchPart);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
    }

    public static void handleOnlinePatch(String[] patchLocs) {
        String opatchVersion = OPatchSession.getVersion();
        String ohLoc = "";
        try {
            ohLoc = OPatchEnv.getOracleHome();
        }
        catch (NoSuchElementException e1) {
            // empty catch block
        }
        String patchStorageLoc = "";
        if (!"".equals(ohLoc)) {
            patchStorageLoc = OPatchEnv.getPatchStorageDirectoryPath(ohLoc);
        }
        for (int i2 = 0; i2 < patchLocs.length; ++i2) {
            boolean isUtilOnline;
            String patchloc = patchLocs[i2];
            boolean bl = isUtilOnline = OPatchEnv.getSessionType().equals("util") && (OPatchEnv.getUtilOption().equalsIgnoreCase("disableonlinepatch") || OPatchEnv.getUtilOption().equalsIgnoreCase("enableonlinepatch"));
            if (!"".equals(patchStorageLoc) && patchloc.startsWith(patchStorageLoc) && isUtilOnline || !OPatchEnv.isOnline()) continue;
            boolean isNewOnline = false;
            boolean isOldOnline = false;
            if (OnlinePatchProcessor.isHybridOnlinePatch(patchloc)) {
                try {
                    OnlinePatchProcessor.setHybridPatchPart(patchloc, PatchObject.HybridPatchPart.ONLINE);
                }
                catch (Exception e2) {
                    OLogger.printStackTrace(e2);
                }
                isNewOnline = true;
            } else {
                Path patch = WrapperFactory.getNioServiceWrapper().getPath(patchloc, new String[0]);
                if (Files.exists(patch, new LinkOption[0]) && Files.isDirectory(patch, new LinkOption[0])) {
                    if (patch.getFileName().toString().equals("online")) {
                        isOldOnline = true;
                    } else {
                        try (DirectoryStream<Path> stream = Files.newDirectoryStream(patch);){
                            for (Path ele : stream) {
                                if (!ele.getFileName().toString().equals("online")) continue;
                                patchLocs[i2] = patchLocs[i2] + File.separator + "online";
                                isOldOnline = true;
                                break;
                            }
                        }
                        catch (IOException e3) {
                            OLogger.debug(e3.getMessage());
                        }
                    }
                }
            }
            if (isNewOnline || isOldOnline) continue;
            throw new OnlinePatchException(OLogger.getString("OUI-68062", new Object[]{patchloc}));
        }
    }

    protected static boolean isHybridOnlinePatch(String patchloc) {
        Path patch = WrapperFactory.getNioServiceWrapper().getPath(patchloc, new String[0]);
        if (Files.exists(patch, new LinkOption[0]) && Files.isDirectory(patch, new LinkOption[0])) {
            boolean has_etc_online = false;
            boolean has_files_online = false;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(patch);){
                for (Path ele : stream) {
                    String entry = ele.toString();
                    if (entry.indexOf("etc_online") != -1) {
                        has_etc_online = true;
                        continue;
                    }
                    if (entry.indexOf("files_online") == -1) continue;
                    has_files_online = true;
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
            if (has_etc_online) {
                return true;
            }
        }
        return false;
    }

    protected static boolean isOnlineOnlyPatch(String patchloc) {
        boolean isOnlineOnly = false;
        Path patch = WrapperFactory.getNioServiceWrapper().getPath(patchloc, new String[0]);
        if (Files.exists(patch, new LinkOption[0]) && Files.isDirectory(patch, new LinkOption[0])) {
            boolean has_etc_online = false;
            boolean has_files_online = false;
            boolean has_etc = false;
            boolean has_files = false;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(patch);){
                for (Path ele : stream) {
                    String entry = ele.getFileName().toString();
                    if (entry.indexOf("etc_online") != -1) {
                        has_etc_online = true;
                        continue;
                    }
                    if (entry.indexOf("files_online") != -1) {
                        has_files_online = true;
                        continue;
                    }
                    if (entry.indexOf("etc") != -1) {
                        has_etc = true;
                        continue;
                    }
                    if (entry.indexOf("files") == -1) continue;
                    has_files = true;
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
            if (has_etc_online && has_files_online && !has_etc && !has_files) {
                isOnlineOnly = true;
            }
        }
        return isOnlineOnly;
    }

    protected static boolean isOldOnlinePatch(String patchloc) {
        boolean isOldOnline = false;
        boolean has_online = false;
        boolean has_etc = false;
        boolean has_files = false;
        Path patch = WrapperFactory.getNioServiceWrapper().getPath(patchloc, new String[0]);
        if (Files.exists(patch, new LinkOption[0]) && Files.isDirectory(patch, new LinkOption[0])) {
            if (patch.getFileName().toString().equals("online")) {
                has_online = true;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(patch);){
                for (Path ele : stream) {
                    String entry = ele.getFileName().toString();
                    if (entry.equals("online")) {
                        has_online = true;
                        continue;
                    }
                    if (entry.equals("etc")) {
                        has_etc = true;
                        continue;
                    }
                    if (!entry.equals("files")) continue;
                    has_files = true;
                }
            }
            catch (IOException e2) {
                OLogger.debug(e2.getMessage());
            }
        }
        if (has_online && has_etc && has_files) {
            isOldOnline = true;
        }
        return isOldOnline;
    }

    public static void cleanHybridPatchMap() {
        hybridPatchMap.clear();
    }

    private static boolean isHybridOnlineSupported(String opatchVersion) {
        int i2;
        String[] version = opatchVersion.split("\\.");
        String[] versionRef = new String[]{"12", "2"};
        boolean bigger = false;
        for (i2 = 0; i2 < 1 && version[i2].equals(versionRef[i2]); ++i2) {
        }
        int result = Integer.valueOf(version[i2]).compareTo(Integer.valueOf(versionRef[i2]));
        if (result >= 0) {
            bigger = true;
        }
        return bigger;
    }
}

