/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.util.ResourceBundle;
import oracle.opatch.opatchlogger.OLogger;
import oracle.sysman.oii.oiii.OiiiVersion;

public class OUIVersion {
    protected static OiiiVersion getVerObj(String version) {
        OiiiVersion ver = new OiiiVersion(version);
        return ver;
    }

    protected static String maskLastVersionDigit(String input) {
        return OiiiVersion.maskLastVersionDigit((String)input);
    }

    private static OiiiVersion getCurrentOUIVersion() {
        OiiiVersion ver = null;
        try {
            ResourceBundle oResBundle = ResourceBundle.getBundle("OUIVersion");
            ver = new OiiiVersion(oResBundle.getString("INSTALLER_VERSION"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ver;
    }

    public static String getOUIVersion() {
        String version = "n/a";
        try {
            OiiiVersion curVer = OUIVersion.getCurrentOUIVersion();
            if (curVer != null) {
                version = curVer.getVerString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return version;
    }

    public static boolean isOUICompatible() {
        boolean compat = false;
        StringBuffer buff = new StringBuffer("OUIVersion::isOUICompatible()\n");
        try {
            OiiiVersion reqVer = new OiiiVersion("10.2");
            OiiiVersion curVer = OUIVersion.getCurrentOUIVersion();
            buff = new StringBuffer(" reqVer = ");
            buff.append(reqVer.getVerString());
            OLogger.debug(buff);
            if (curVer != null) {
                buff = new StringBuffer(" curVer = ");
                buff.append(curVer.getVerString());
                OLogger.debug(buff);
                boolean curLaterThan = curVer.laterThan(reqVer);
                boolean curEqual = curVer.equals(reqVer);
                compat = curVer.laterThan(reqVer) || curVer.equals(reqVer);
                buff = new StringBuffer(" Current Ver later than required? :");
                buff.append(curLaterThan);
                OLogger.debug(buff);
                buff = new StringBuffer(" Current Ver equals required? :");
                buff.append(curEqual);
                OLogger.debug(buff);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return compat;
    }

    public static boolean isOUIGoodForErrEnvVar(String inputOUIVersion) {
        boolean compat = false;
        StringBuffer buff = new StringBuffer("OUIVersion::isOUIGoodForErrEnvVar()\n");
        try {
            OiiiVersion reqVer = new OiiiVersion(inputOUIVersion);
            OiiiVersion curVer = OUIVersion.getCurrentOUIVersion();
            buff = new StringBuffer(" reqVer For using getEnv() = ");
            buff.append(reqVer.getVerString());
            OLogger.debug(buff);
            if (curVer != null) {
                buff = new StringBuffer(" curVer = ");
                buff.append(curVer.getVerString());
                OLogger.debug(buff);
                boolean curLaterThan = curVer.laterThan(reqVer);
                boolean curEqual = curVer.equals(reqVer);
                compat = curVer.laterThan(reqVer) || curVer.equals(reqVer);
                buff = new StringBuffer(" Current Ver later than required? :");
                buff.append(curLaterThan);
                OLogger.debug(buff);
                buff = new StringBuffer(" Current Ver equals required? :");
                buff.append(curEqual);
                OLogger.debug(buff);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return compat;
    }
}

