/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import oracle.opatch.opatchlogger.OLogger;

public class OPatchZipInputStream
extends ZipInputStream {
    byte[] buffer = new byte[1024];
    private RandomAccessFile zipfile;

    public OPatchZipInputStream(InputStream in, String zipName) {
        super(in);
        try {
            this.zipfile = new RandomAccessFile(zipName, "r");
        }
        catch (FileNotFoundException e2) {
            OLogger.printStackTrace(e2);
        }
        if (in == null) {
            throw new NullPointerException("OPatchZipInputStream:: InputStream 'in' is null when creating object");
        }
    }

    public HashMap getPermissionInfo() {
        StringBuffer buff = new StringBuffer("OPatchZipInputStream::getPermissionInfo()");
        OLogger.debug(buff);
        HashMap<String, Integer> permissionInfo = new HashMap<String, Integer>();
        try {
            boolean found = false;
            long pos = this.zipfile.length() - 22L;
            if (pos >= 0L) {
                this.zipfile.seek(pos);
                byte[] a2 = new byte[4];
                int count = this.zipfile.read(a2);
                while (count != -1) {
                    if (OPatchZipInputStream.getLong(a2, 0) == 101010256L) {
                        found = true;
                        break;
                    }
                    this.zipfile.seek(--pos);
                    count = this.zipfile.read(a2);
                }
            }
            if (!found) {
                throw new ZipException("The unzipping file is not a ZIP archive");
            }
            this.zipfile.seek(pos + 16L);
            byte[] firstCENHeader = new byte[4];
            this.zipfile.readFully(firstCENHeader);
            this.zipfile.seek(OPatchZipInputStream.getLong(firstCENHeader, 0));
            byte[] cenData = new byte[42];
            byte[] cenHdrSig = new byte[4];
            this.zipfile.readFully(cenHdrSig);
            long sig = OPatchZipInputStream.getLong(cenHdrSig, 0);
            while (sig == 33639248L) {
                this.zipfile.readFully(cenData);
                int fileNameLen = OPatchZipInputStream.getShort(cenData, 24);
                int extraLen = OPatchZipInputStream.getShort(cenData, 26);
                int commentLen = OPatchZipInputStream.getShort(cenData, 28);
                long externalAtt = OPatchZipInputStream.getLong(cenData, 34);
                byte[] fileName = new byte[fileNameLen];
                this.zipfile.readFully(fileName);
                this.zipfile.skipBytes(extraLen + commentLen);
                int permInfo = (int)(externalAtt >> 16 & 0xFFFFL);
                String name = OPatchZipInputStream.getUTF8String(fileName, 0, fileNameLen);
                permissionInfo.put(name, permInfo);
                this.zipfile.readFully(cenHdrSig);
                sig = OPatchZipInputStream.getLong(cenHdrSig, 0);
            }
        }
        catch (IOException e2) {
            buff = new StringBuffer("Failed to get external attribute info in parsing zip file");
            OLogger.debug(buff);
            throw new RuntimeException("Zip file parsing failed ", e2);
        }
        finally {
            try {
                this.zipfile.close();
            }
            catch (IOException e3) {
                buff = new StringBuffer("Failed to close random file stream");
                OLogger.debug(buff);
                throw new RuntimeException("Close stream failed", e3);
            }
        }
        return permissionInfo;
    }

    protected static final int getShort(byte[] b2, int off) {
        return b2[off] & 0xFF | (b2[off + 1] & 0xFF) << 8;
    }

    protected static final long getLong(byte[] b2, int off) {
        return (long)OPatchZipInputStream.getShort(b2, off) | (long)OPatchZipInputStream.getShort(b2, off + 2) << 16;
    }

    private static String getUTF8String(byte[] b2, int off, int len) {
        int count = 0;
        int max = off + len;
        int i2 = off;
        block10: while (i2 < max) {
            int c2 = b2[i2++] & 0xFF;
            switch (c2 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    continue block10;
                }
                case 12: 
                case 13: {
                    if ((b2[i2++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
                case 14: {
                    if ((b2[i2++] & 0xC0) != 128 || (b2[i2++] & 0xC0) != 128) {
                        throw new IllegalArgumentException();
                    }
                    ++count;
                    continue block10;
                }
            }
            throw new IllegalArgumentException();
        }
        if (i2 != max) {
            throw new IllegalArgumentException();
        }
        char[] cs = new char[count];
        i2 = 0;
        block11: while (off < max) {
            int c3 = b2[off++] & 0xFF;
            switch (c3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cs[i2++] = (char)c3;
                    continue block11;
                }
                case 12: 
                case 13: {
                    cs[i2++] = (char)((c3 & 0x1F) << 6 | b2[off++] & 0x3F);
                    continue block11;
                }
                case 14: {
                    int t = (b2[off++] & 0x3F) << 6;
                    cs[i2++] = (char)((c3 & 0xF) << 12 | t | b2[off++] & 0x3F);
                    continue block11;
                }
            }
            throw new IllegalArgumentException();
        }
        return new String(cs, 0, count);
    }
}

