/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import oracle.opatch.PatchObject;
import oracle.opatch.opatchlogger.OLogger;

public class OPatchState {
    protected int stateOrder;
    protected String stateName;
    protected int baseErrorCode;
    protected int currentErrorCode;
    protected int maxErrorCode;
    protected int defaultLevel;
    protected boolean mandatory;
    protected boolean present = true;
    protected boolean visible = true;

    protected OPatchState(int stateOrder, int baseErrorCode, int maxErrorCode, String stateName, int defaultLevel, boolean mandatory) {
        this.stateOrder = stateOrder;
        this.baseErrorCode = baseErrorCode;
        this.currentErrorCode = baseErrorCode;
        this.stateName = stateName;
        this.maxErrorCode = maxErrorCode;
        this.defaultLevel = defaultLevel;
        this.mandatory = mandatory;
    }

    protected int getFileNumberForDlirectory(Path srcFile) {
        int fileNumber = 0;
        LinkedList<Path> list = new LinkedList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcFile);){
            for (Path entry : stream) {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    list.add(entry);
                    continue;
                }
                ++fileNumber;
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        while (!list.isEmpty()) {
            Path tmp = (Path)list.removeFirst();
            if (Files.isDirectory(tmp, new LinkOption[0])) {
                try {
                    DirectoryStream<Path> stream = Files.newDirectoryStream(tmp);
                    Object object = null;
                    try {
                        for (Path entry : stream) {
                            if (Files.isDirectory(entry, new LinkOption[0])) {
                                list.add(entry);
                                continue;
                            }
                            ++fileNumber;
                        }
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (stream == null) continue;
                        if (object != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        stream.close();
                    }
                }
                catch (IOException e3) {
                    OLogger.debug(e3.getMessage());
                }
                continue;
            }
            ++fileNumber;
        }
        return fileNumber;
    }

    protected String getStateAssociatedMessage(String oracleHome, PatchObject[] patchObject) {
        return new String("");
    }

    protected int getStateOrder() {
        return this.stateOrder;
    }

    protected int getBaseErrorCode() {
        return this.baseErrorCode;
    }

    protected String getStateName() {
        return this.stateName;
    }

    protected int getCurrentErrorCode() {
        return this.currentErrorCode;
    }

    protected void setCurrentErrorCode(int errorCode) {
        if (errorCode >= this.baseErrorCode && errorCode <= this.maxErrorCode) {
            this.currentErrorCode = errorCode;
        }
    }

    protected int getDefaultLogLevel() {
        return this.defaultLevel;
    }

    protected boolean isPresent() {
        return this.present;
    }

    protected void setPresent(PatchObject[] po) {
    }

    protected boolean isVisible() {
        return this.visible;
    }

    protected void setVisible(boolean in) {
        this.visible = in;
    }

    protected boolean isMandatory() {
        return this.mandatory;
    }

    protected void setMandatory(boolean in) {
        this.mandatory = in;
    }

    protected String getStateSpecifiedInformation(PatchObject patchObject, String extraMessage) {
        return null;
    }
}

