/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.opatch.Applicable;
import oracle.opatch.ArchiveAction;
import oracle.opatch.BaseTransReln;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CopyAction;
import oracle.opatch.DeleteJarAction;
import oracle.opatch.ExitOPatchException;
import oracle.opatch.FVData;
import oracle.opatch.InterviewContextVar;
import oracle.opatch.JarAction;
import oracle.opatch.JarActionEntityTree;
import oracle.opatch.JarActionHelper;
import oracle.opatch.LsInventorySession;
import oracle.opatch.MakeAction;
import oracle.opatch.MultiJarUtil;
import oracle.opatch.OCMException;
import oracle.opatch.OPatch;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchExternalFactory;
import oracle.opatch.OPatchOOPHelper;
import oracle.opatch.OPatchProperty;
import oracle.opatch.OPatchRestartException;
import oracle.opatch.OPatchSession;
import oracle.opatch.OPatchStateManagerFactory;
import oracle.opatch.OUIReplacer;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.PatchObjectUtil;
import oracle.opatch.PatchingFlow;
import oracle.opatch.PatchingModel;
import oracle.opatch.PrereqFailedException;
import oracle.opatch.PrereqSession;
import oracle.opatch.Rac;
import oracle.opatch.RacFileCreator;
import oracle.opatch.RacProcessor;
import oracle.opatch.RacSrvm;
import oracle.opatch.RegenerateLib;
import oracle.opatch.Restorable;
import oracle.opatch.Rollbackable;
import oracle.opatch.Rules;
import oracle.opatch.SCM;
import oracle.opatch.SQLUtilities;
import oracle.opatch.SystemCall;
import oracle.opatch.UtilSession;
import oracle.opatch.Verifiable;
import oracle.opatch.WLSPatch;
import oracle.opatch.conflicttextualinterpreter.selectbetterpatch.IndexPair;
import oracle.opatch.ipm.IIPMRWServices;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.ipm.IPMUtil;
import oracle.opatch.opatchactions.DeleteAction;
import oracle.opatch.opatchactions.OrderedPatchAction;
import oracle.opatch.opatchext.SecurePrompter;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.PrereqSet;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.OPatchPatchFactory;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchTarget;
import oracle.opatch.opatchsdk.patchrepresentation.InvalidPatchPackageException;
import oracle.opatch.opatchsdk.patchrepresentation.PatchType;
import oracle.opatch.opatchsdk.patchrepresentation.PatchVariant;
import oracle.opatch.opatchutil.OPatchUtilHelper;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.patchsdk.PatchPackageException;
import oracle.opatch.wrappers.WrapperFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class OPatchSessionHelper {
    protected static URLClassLoader loader = null;
    protected static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    public static HashSet getHigherConstituents(String constituentID, String oracleHomePath) {
        IIPMReadServices readServices;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable e2) {
            RuntimeException rt = new RuntimeException("Problem loading inventory in getHigherConstituents() function.", e2);
            rt.setStackTrace(e2.getStackTrace());
            throw rt;
        }
        OneOffEntry[] installedPatches = readServices.getInstalledPatches();
        HashSet<String> higherConstituents = new HashSet<String>();
        ArrayList<OneOffEntry> nonUniqueHigherConstituents = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < installedPatches.length; ++i2) {
            String[] overlays = installedPatches[i2].getOverLayPatchIDs();
            for (int j2 = 0; j2 < overlays.length; ++j2) {
                if (!installedPatches[i2].getIsComposite() || !overlays[j2].equals(constituentID)) continue;
                nonUniqueHigherConstituents.add(installedPatches[i2]);
            }
        }
        int currentIndex = 0;
        while (currentIndex < nonUniqueHigherConstituents.size()) {
            if (higherConstituents.contains(nonUniqueHigherConstituents.get(currentIndex))) {
                ++currentIndex;
                continue;
            }
            higherConstituents.add(((OneOffEntry)nonUniqueHigherConstituents.get(currentIndex)).getID());
            for (int i3 = 0; i3 < installedPatches.length; ++i3) {
                String[] overlays = installedPatches[i3].getOverLayPatchIDs();
                for (int j3 = 0; j3 < overlays.length; ++j3) {
                    if (!installedPatches[i3].getIsComposite() || !overlays[j3].equals(((OneOffEntry)nonUniqueHigherConstituents.get(currentIndex)).getID())) continue;
                    nonUniqueHigherConstituents.add(installedPatches[i3]);
                }
            }
            ++currentIndex;
        }
        return higherConstituents;
    }

    public static void updateHistoryFile(String oracleHomePath, String[] args) {
        String historyFilename = OPatchEnv.getHistoryFile(oracleHomePath);
        StringBuffer buff = new StringBuffer("\n");
        buff.append("Date & Time : " + new Date().toString());
        buff.append("\nOracle Home : " + oracleHomePath);
        buff.append("\nOPatch Ver. : " + OPatchSession.getVersion());
        buff.append("\nCurrent Dir : " + System.getProperty("user.dir"));
        buff.append("\nCommand     : ");
        boolean ignoreFlag = false;
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (args[i2].equalsIgnoreCase("-pre") || ignoreFlag) {
                if (!args[i2].equalsIgnoreCase("-opatch_pre_end")) {
                    ignoreFlag = true;
                    continue;
                }
                ignoreFlag = false;
                continue;
            }
            if (args[i2].equalsIgnoreCase("-post") || ignoreFlag) {
                if (!args[i2].equalsIgnoreCase("-opatch_post_end")) {
                    ignoreFlag = true;
                    continue;
                }
                ignoreFlag = false;
                continue;
            }
            if (args[i2].equalsIgnoreCase("-init") || ignoreFlag) {
                if (!args[i2].equalsIgnoreCase("-opatch_init_end")) {
                    ignoreFlag = true;
                    continue;
                }
                ignoreFlag = false;
                continue;
            }
            buff.append(args[i2]);
            buff.append(" ");
        }
        buff.append("\n");
        try {
            if (OPatchEnv.canOhWriteLog() && !OPatchEnv.isLogDisabled()) {
                Path file = WrapperFactory.getNioServiceWrapper().getPath(historyFilename, new String[0]);
                boolean isFileExist = Files.exists(file, new LinkOption[0]);
                BufferedWriter historyFile = Files.newBufferedWriter(WrapperFactory.getNioServiceWrapper().getPath(historyFilename, new String[0]), Charset.forName("UTF-8"), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                historyFile.write(buff.toString());
                historyFile.close();
                if (!isFileExist) {
                    OUIReplacer.changePermission(historyFilename, 416);
                }
            } else {
                OLogger.debug("OPatch could not create/open history file for writing.\n");
            }
        }
        catch (Exception e2) {
            OLogger.debug("OPatch could not create/open history file for writing: " + historyFilename);
        }
    }

    public static String computeChecksum(String filePath) throws IOException {
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0]);
        f2 = f2.toAbsolutePath().normalize();
        String checksum = LsInventorySession.getCheckSum(f2);
        return checksum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void commitChecksumXML(String checksumLoc, PatchObject pObject, String oracleHomePath) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::commitChecksumXML()");
        OLogger.debug(buff);
        OutputStream fout = null;
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(checksumLoc, new String[0]);
        try {
            ChecksumEntity[] cse = pObject.getChecksumList();
            if (cse == null || cse.length == 0) {
                return;
            }
            OLogger.printlnOnLogAndVerbose("Trying to compute checksum as specified in the patch");
            for (int i2 = 0; i2 < cse.length; ++i2) {
                String comPath = cse[i2].getComputeFilePath(oracleHomePath, pObject);
                Path computeObj = WrapperFactory.getNioServiceWrapper().getPath(comPath, new String[0]);
                if (Files.exists(computeObj, new LinkOption[0])) {
                    if (!cse[i2].getChecksum().equals("-1")) return;
                    cse[i2].setChecksum(oracleHomePath, pObject);
                } else if (OPatchEnv.isCASFlow()) {
                    OLogger.printlnOnLogAndVerbose("\nFile \"" + comPath + "\" does not exist. So, checksum computation for this file is skipped.");
                } else {
                    OLogger.warn("OUI-67124", new Object[]{"\nFile \"" + comPath + "\" does not exist. So, checksum computation for this file is skipped."});
                }
                OLogger.printlnOnLogAndVerbose(cse[i2].toString());
            }
            Files.createFile(f2, new FileAttribute[0]);
            DocumentBuilderFactory factoryObj = DocumentBuilderFactory.newInstance();
            DocumentBuilder builderObj = null;
            builderObj = factoryObj.newDocumentBuilder();
            Document docObj = builderObj.newDocument();
            Element myElement = docObj.createElement("checksum_info");
            docObj.appendChild(myElement);
            Element root = docObj.getDocumentElement();
            DOMSource source = new DOMSource(root);
            if (root == null) {
                throw new RuntimeException("<root node> is null for checksum computation. Failed to compute checksum");
            }
            String next = "\n";
            Text txt = null;
            for (int i3 = 0; i3 < cse.length; ++i3) {
                String path = cse[i3].getComputeFilePath(oracleHomePath, pObject);
                Path computeObj = WrapperFactory.getNioServiceWrapper().getPath(path, new String[0]);
                String checkSumObj = cse[i3].getChecksum();
                String appDir = cse[i3].getAppDir();
                Element child = docObj.createElement("file");
                child.setAttribute("path", path);
                child.setAttribute("checksum", checkSumObj);
                if (!"".equals(appDir)) {
                    child.setAttribute("app_dir", appDir);
                }
                txt = docObj.createTextNode(next);
                root.appendChild(txt);
                root.appendChild(child);
            }
            txt = docObj.createTextNode(next);
            root.appendChild(txt);
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = null;
            transformer = tFactory.newTransformer();
            fout = Files.newOutputStream(f2, new OpenOption[0]);
            StreamResult output = new StreamResult(fout);
            transformer.transform(source, output);
            return;
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            OLogger.warn("OUI-67648");
            try {
                Files.deleteIfExists(f2);
                OLogger.printlnOnLogAndVerbose("Deleted the checksum file due to failure : " + checksumLoc);
                return;
            }
            catch (IOException e1) {
                OLogger.printlnOnLogAndVerbose("Not able to remove the checksum file : " + checksumLoc + ". This file could be corrupted.");
            }
            return;
        }
        finally {
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (Exception e3) {
                OLogger.printStackTrace(e3);
            }
        }
    }

    public static BaseTransReln[] getBaseTransRelationship(String oracleHomePath, OneOffEntry[] oneoffs) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getBaseTransRelationship()");
        OLogger.debug(buff);
        BaseTransReln[] btreln = new BaseTransReln[]{};
        if (oneoffs == null) {
            return btreln;
        }
        if (oneoffs.length == 0) {
            return btreln;
        }
        ArrayList<BaseTransReln> relation = new ArrayList<BaseTransReln>();
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            if (!oneoffs[i2].couldBeTranslation()) continue;
            OLogger.debug(new StringBuffer("Checking if the patch \"" + oneoffs[i2].getPatchID() + "\" is really a translation patch?"));
            boolean anyBase = false;
            for (int j2 = 0; j2 < oneoffs.length; ++j2) {
                if (oneoffs[j2].getTripletID().equals(oneoffs[i2].getTripletID())) continue;
                OLogger.debug(new StringBuffer("Check for the patch \"" + oneoffs[j2] + "\""));
                OneOffEntry baseOneOff = null;
                if (oneoffs[j2].getPatchID().equals(oneoffs[i2].getPatchID())) {
                    baseOneOff = oneoffs[j2];
                }
                if (baseOneOff == null || !baseOneOff.isTranslatable()) continue;
                OLogger.debug(new StringBuffer("Patch ID \"" + baseOneOff.getPatchID() + "\" is translatable..."));
                BaseTransReln btr = new BaseTransReln(oneoffs[j2].getPatchID(), oneoffs[i2].getPatchID(), oneoffs[i2].getID(), oneoffs[i2].getPatchLanguage(), oneoffs[i2].getAppliedDate(), oneoffs[i2].getPSENumber());
                OLogger.debug(new StringBuffer("Added trans-base relation --> " + btr.toString()));
                relation.add(btr);
                anyBase = true;
            }
            if (anyBase) continue;
            BaseTransReln btr = new BaseTransReln("n/a", oneoffs[i2].getPatchID(), oneoffs[i2].getID(), oneoffs[i2].getPatchLanguage(), oneoffs[i2].getAppliedDate(), oneoffs[i2].getPSENumber());
            relation.add(btr);
        }
        btreln = new BaseTransReln[relation.size()];
        relation.toArray(btreln);
        return btreln;
    }

    public static void printTranslationPatches(PatchObject[] patchObjects) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::printTranslationPatches()");
        OLogger.debug(buff);
        boolean entered = false;
        if (patchObjects == null) {
            throw new RuntimeException("Input Patch Object array is null");
        }
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            if (!patchObjects[i2].getPatchInventory().mayBeTranslation()) continue;
            entered = true;
            OLogger.print("Patch \"" + patchObjects[i2].getOriginalPatchID() + "\" supports " + "language \"" + patchObjects[i2].getPatchInventory().getPatchLanguage() + "\" and will " + "be referred as \"" + patchObjects[i2].getPatchID() + "\".\n");
        }
        if (entered) {
            OLogger.println("");
        }
    }

    public static List<String> getDeleteFileVer(IIPMReadServices readServices) {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getCopyFileVer given Inventory");
        OLogger.debug(buff);
        OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
        OneOffEntry[] inactiveOneOffs = readServices.getInactivePatches();
        OneOffEntry[] totalOneOffs = new OneOffEntry[(installedOneOffs != null ? installedOneOffs.length : 0) + (inactiveOneOffs != null ? inactiveOneOffs.length : 0)];
        int interimLength = 0;
        for (i2 = 0; installedOneOffs != null && i2 < installedOneOffs.length; ++i2) {
            totalOneOffs[i2] = installedOneOffs[i2];
            ++interimLength;
        }
        for (i2 = 0; inactiveOneOffs != null && i2 < inactiveOneOffs.length; ++i2) {
            totalOneOffs[interimLength + i2] = inactiveOneOffs[i2];
        }
        buff = new StringBuffer("Constructing HashTable of all installed Snowball Copy Actions filenames with their versions...");
        OLogger.debug(buff);
        ArrayList<String> deleteFileList = new ArrayList<String>();
        for (int i3 = 0; totalOneOffs != null && i3 < totalOneOffs.length; ++i3) {
            OneOffEntry myOneOff = totalOneOffs[i3];
            PatchAction[] pa = myOneOff.getPatchActions();
            for (int j2 = 0; pa != null && j2 < pa.length; ++j2) {
                DeleteAction da;
                PatchAction paIndiv = pa[j2];
                if (!(paIndiv instanceof DeleteAction) || deleteFileList.contains((da = (DeleteAction)paIndiv).getFileName())) continue;
                deleteFileList.add(da.getFileName());
            }
        }
        return deleteFileList;
    }

    public static HashMap getCopyActionVer(IIPMReadServices readServices) {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getCopyActionVer)");
        OLogger.debug(buff);
        HashMap<OrderedPatchAction, String> copyActMap = new HashMap<OrderedPatchAction, String>();
        HashMap<String, String> copyFileMap = new HashMap<String, String>();
        OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
        OneOffEntry[] inactiveOneOffs = readServices.getInactivePatches();
        OneOffEntry[] totalOneOffs = new OneOffEntry[(installedOneOffs != null ? installedOneOffs.length : 0) + (inactiveOneOffs != null ? inactiveOneOffs.length : 0)];
        int interimLength = 0;
        for (i2 = 0; installedOneOffs != null && i2 < installedOneOffs.length; ++i2) {
            totalOneOffs[i2] = installedOneOffs[i2];
            ++interimLength;
        }
        for (i2 = 0; inactiveOneOffs != null && i2 < inactiveOneOffs.length; ++i2) {
            totalOneOffs[interimLength + i2] = inactiveOneOffs[i2];
        }
        Arrays.sort(totalOneOffs, new Comparator<OneOffEntry>(){

            @Override
            public int compare(OneOffEntry o1, OneOffEntry o2) {
                if (o1.getAppliedDate().after(o2.getAppliedDate())) {
                    return 1;
                }
                if (o1.getAppliedDate().before(o2.getAppliedDate())) {
                    return -1;
                }
                return 0;
            }
        });
        buff = new StringBuffer("Constructing HashTable of all installed Snowball Copy Actions with their versions...");
        OLogger.debug(buff);
        for (i2 = 0; totalOneOffs != null && i2 < totalOneOffs.length; ++i2) {
            OneOffEntry myOneOff = totalOneOffs[i2];
            List<OrderedPatchAction> paList = myOneOff.getOrderedActions();
            for (int j2 = 0; paList != null && j2 < paList.size(); ++j2) {
                int retVal;
                String presentValue;
                String value;
                OrderedPatchAction key;
                PatchAction paIndiv = paList.get(j2);
                if (paIndiv instanceof CopyAction) {
                    key = (CopyAction)paIndiv;
                    value = ((CopyAction)key).getFileVersion();
                    if (!((CopyAction)key).isSnowBallCopyAction() || !((CopyAction)key).isHasFileVersion()) continue;
                    if (copyActMap.containsKey(key)) {
                        presentValue = (String)copyActMap.get(key);
                        retVal = OPatchSessionHelper.isGreaterDecimal(presentValue, value);
                        if (retVal == 0 || retVal == 1) {
                            buff = new StringBuffer("Copy Action " + ((CopyAction)key).toString() + " version is already greater --> " + presentValue + ".");
                            buff.append("\nWe will no replace with this version " + value + ".");
                            OLogger.debug(buff);
                            continue;
                        }
                        buff = new StringBuffer("Replace this copy action's " + ((CopyAction)key).toString() + " with this version" + value);
                        OLogger.debug(buff);
                    }
                    copyActMap.put(key, value);
                    copyFileMap.put(((CopyAction)key).getFilename(), value);
                    buff = new StringBuffer("Updated KEY " + ((CopyAction)key).toString() + " with the version " + value + "...");
                    OLogger.debug(buff);
                }
                if (!(paIndiv instanceof DeleteAction)) continue;
                key = (DeleteAction)paIndiv;
                value = ((DeleteAction)key).getFileVersion();
                if (!((DeleteAction)key).isHasFileVersion()) {
                    value = "lemax.version";
                }
                if (!((DeleteAction)key).isSnowBallDeleteAction()) continue;
                if (copyFileMap.containsKey(((DeleteAction)key).getFileName())) {
                    presentValue = (String)copyFileMap.get(((DeleteAction)key).getFileName());
                    if (value.startsWith("le")) {
                        String updateValue;
                        int retVal2;
                        if (!value.equals("lemax.version") && (retVal2 = OPatchSessionHelper.isGreaterDecimal(presentValue, updateValue = value.substring(2))) != -1) {
                            buff = new StringBuffer("Copy Action " + ((DeleteAction)key).toString() + " version is lower than --> " + presentValue + " in the copy file map.");
                            buff.append("\nWe will no replace with this version " + value + ".");
                            OLogger.debug(buff);
                            continue;
                        }
                        buff = new StringBuffer("Replace this copy action's " + ((DeleteAction)key).toString() + " with this version" + value);
                        OLogger.debug(buff);
                    } else {
                        retVal = OPatchSessionHelper.isGreaterDecimal(presentValue, value);
                        if (retVal != 0) {
                            buff = new StringBuffer("Copy Action " + ((DeleteAction)key).toString() + " version is not equal to --> " + presentValue + " in the copy file map.");
                            buff.append("\nWe will no replace with this version " + value + ".");
                            OLogger.debug(buff);
                            continue;
                        }
                        buff = new StringBuffer("Replace this copy action's " + ((DeleteAction)key).toString() + " with this version" + value);
                        OLogger.debug(buff);
                    }
                }
                if (!copyFileMap.containsKey(((DeleteAction)key).getFileName())) continue;
                String ver = (String)copyFileMap.get(((DeleteAction)key).getFileName());
                Iterator it = copyActMap.keySet().iterator();
                while (it.hasNext()) {
                    CopyAction ca = (CopyAction)it.next();
                    if (!ca.getFilename().equals(((DeleteAction)key).getFileName()) || !ca.getFileVersion().equals(ver)) continue;
                    it.remove();
                }
                copyFileMap.remove(((DeleteAction)key).getFileName());
                buff = new StringBuffer("Updated KEY " + ((DeleteAction)key).toString() + " with the version " + value + "...");
                OLogger.debug(buff);
            }
        }
        DeleteAction.setCopyFileVer(copyFileMap);
        return copyActMap;
    }

    public static boolean isBeingIntraDeleted(PatchObject[] patches, int index, String cpFile, String cpVer) {
        boolean res = false;
        for (int i2 = index + 1; i2 < patches.length; ++i2) {
            for (PatchComponent pc : patches[i2].getIncludedPatchComponents()) {
                for (DeleteAction ai : pc.getDeleteList()) {
                    String deleteVer;
                    int retVal;
                    String file = ai.getFileName();
                    String ver = ai.getFileVersion();
                    if (!cpFile.equals(file)) continue;
                    if (!ai.isHasFileVersion()) {
                        return true;
                    }
                    if (!(ver.startsWith("le") ? (retVal = OPatchSessionHelper.isGreaterDecimal(deleteVer = ver.substring(2), cpVer)) == 1 : cpVer.equals(ver))) continue;
                    return true;
                }
            }
        }
        return res;
    }

    public static Map<String, String> getAllCopyFileVer(IIPMReadServices readServices) {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getCopyFileVerWODelete given Inventory");
        OLogger.debug(buff);
        OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
        OneOffEntry[] inactiveOneOffs = readServices.getInactivePatches();
        OneOffEntry[] totalOneOffs = new OneOffEntry[(installedOneOffs != null ? installedOneOffs.length : 0) + (inactiveOneOffs != null ? inactiveOneOffs.length : 0)];
        int interimLength = 0;
        for (i2 = 0; installedOneOffs != null && i2 < installedOneOffs.length; ++i2) {
            totalOneOffs[i2] = installedOneOffs[i2];
            ++interimLength;
        }
        for (i2 = 0; inactiveOneOffs != null && i2 < inactiveOneOffs.length; ++i2) {
            totalOneOffs[interimLength + i2] = inactiveOneOffs[i2];
        }
        HashMap<String, String> copyFileMap = new HashMap<String, String>();
        for (int i3 = 0; totalOneOffs != null && i3 < totalOneOffs.length; ++i3) {
            OneOffEntry myOneOff = totalOneOffs[i3];
            PatchAction[] paList = myOneOff.getPatchActions();
            for (int j2 = 0; paList != null && j2 < paList.length; ++j2) {
                String presentValue;
                int retVal;
                PatchAction paIndiv = paList[j2];
                if (!(paIndiv instanceof CopyAction)) continue;
                CopyAction act = (CopyAction)paIndiv;
                String file = act.getFilename();
                String value = act.getFileVersion();
                if (!act.isSnowBallCopyAction() || !act.isHasFileVersion() || copyFileMap.containsKey(file) && ((retVal = OPatchSessionHelper.isGreaterDecimal(presentValue = copyFileMap.get(file), value)) == 0 || retVal == 1)) continue;
                copyFileMap.put(file, value);
            }
        }
        return copyFileMap;
    }

    public static HashMap getCopyFileVer(IIPMReadServices readServices) {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getCopyFileVer given Inventory");
        OLogger.debug(buff);
        OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
        OneOffEntry[] inactiveOneOffs = readServices.getInactivePatches();
        OneOffEntry[] totalOneOffs = new OneOffEntry[(installedOneOffs != null ? installedOneOffs.length : 0) + (inactiveOneOffs != null ? inactiveOneOffs.length : 0)];
        int interimLength = 0;
        for (i2 = 0; installedOneOffs != null && i2 < installedOneOffs.length; ++i2) {
            totalOneOffs[i2] = installedOneOffs[i2];
            ++interimLength;
        }
        for (i2 = 0; inactiveOneOffs != null && i2 < inactiveOneOffs.length; ++i2) {
            totalOneOffs[interimLength + i2] = inactiveOneOffs[i2];
        }
        Arrays.sort(totalOneOffs, new Comparator<OneOffEntry>(){

            @Override
            public int compare(OneOffEntry o1, OneOffEntry o2) {
                if (o1.getAppliedDate().after(o2.getAppliedDate())) {
                    return 1;
                }
                if (o1.getAppliedDate().before(o2.getAppliedDate())) {
                    return -1;
                }
                return 0;
            }
        });
        buff = new StringBuffer("Constructing HashTable of all installed Snowball Copy Actions filenames with their versions...");
        OLogger.debug(buff);
        return OPatchSessionHelper.getCopyFileVer(totalOneOffs);
    }

    public static HashMap getCopyFileVer(OneOffEntry[] oneoffs) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getCopyFileVer given oneoffs");
        OLogger.debug(buff);
        HashMap<String, String> copyFileMap = new HashMap<String, String>();
        buff = new StringBuffer("Constructing HashTable of all incoming Snowball Copy Actions Filenames with their versions...");
        OLogger.debug(buff);
        for (int i2 = 0; oneoffs != null && i2 < oneoffs.length; ++i2) {
            OneOffEntry myOneOff = oneoffs[i2];
            List<OrderedPatchAction> paList = myOneOff.getOrderedActions();
            for (int j2 = 0; paList != null && j2 < paList.size(); ++j2) {
                int retVal;
                String presentValue;
                String value;
                String file;
                OrderedPatchAction act;
                PatchAction paIndiv = paList.get(j2);
                if (paIndiv instanceof CopyAction) {
                    act = (CopyAction)paIndiv;
                    file = ((CopyAction)act).getFilename();
                    value = ((CopyAction)act).getFileVersion();
                    if (!((CopyAction)act).isSnowBallCopyAction() || !((CopyAction)act).isHasFileVersion()) continue;
                    if (copyFileMap.containsKey(file)) {
                        presentValue = (String)copyFileMap.get(file);
                        retVal = OPatchSessionHelper.isGreaterDecimal(presentValue, value);
                        if (retVal == 0 || retVal == 1) {
                            buff = new StringBuffer("Copy Action " + ((CopyAction)act).toString() + " version is already greater --> " + presentValue + ".");
                            buff.append("\nWe will no replace with this version " + value + ".");
                            OLogger.debug(buff);
                            continue;
                        }
                        buff = new StringBuffer("Replace this copy action's " + ((CopyAction)act).toString() + " with this version" + value);
                        OLogger.debug(buff);
                    }
                    copyFileMap.put(file, value);
                    buff = new StringBuffer("Updated KEY(filename of this copyAction) " + file + " with the version " + value + "...");
                    OLogger.debug(buff);
                }
                if (!(paIndiv instanceof DeleteAction)) continue;
                act = (DeleteAction)paIndiv;
                file = ((DeleteAction)act).getFileName();
                value = ((DeleteAction)act).getFileVersion();
                if (!((DeleteAction)act).isSnowBallDeleteAction()) continue;
                if (!((DeleteAction)act).isHasFileVersion()) {
                    value = "lemax.version";
                }
                if (copyFileMap.containsKey(file)) {
                    presentValue = (String)copyFileMap.get(file);
                    if (value.startsWith("le")) {
                        String updateValue;
                        int retVal2;
                        if (!value.equals("lemax.version") && (retVal2 = OPatchSessionHelper.isGreaterDecimal(presentValue, updateValue = value.substring(2))) != -1) {
                            buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is less than --> " + presentValue + ".");
                            buff.append("\nWe will not delete this version " + value + ".");
                            OLogger.debug(buff);
                            continue;
                        }
                    } else {
                        retVal = OPatchSessionHelper.isGreaterDecimal(presentValue, value);
                        if (retVal != 0) {
                            buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is not equal to --> " + presentValue + ".");
                            buff.append("\nWe will skip this version " + value + ".");
                            OLogger.debug(buff);
                            continue;
                        }
                    }
                }
                if (!copyFileMap.containsKey(file)) continue;
                copyFileMap.remove(file);
                buff = new StringBuffer("Remove this copy action's " + ((DeleteAction)act).toString() + " with this version" + value);
                OLogger.debug(buff);
            }
        }
        DeleteAction.setCopyFileVer(copyFileMap);
        return copyFileMap;
    }

    public static FVData getCopyFileVerForPi(OneOffEntry[] oneoffs) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getCopyFileVer given incoming oneoffs");
        OLogger.debug(buff);
        Arrays.sort(oneoffs, new Comparator<OneOffEntry>(){

            @Override
            public int compare(OneOffEntry o1, OneOffEntry o2) {
                return o1.getRelativePatchLocation().compareTo(o2.getRelativePatchLocation());
            }
        });
        FVData data = new FVData();
        HashMap<String, String> copyFileMap = new HashMap<String, String>();
        HashMap<String, List<String>> deleteFileMap = new HashMap<String, List<String>>();
        buff = new StringBuffer("Constructing HashTable of all incoming Snowball Copy and Delete Actions Filenames with their versions...");
        OLogger.debug(buff);
        for (int i2 = 0; oneoffs != null && i2 < oneoffs.length; ++i2) {
            OneOffEntry myOneOff = oneoffs[i2];
            for (PatchComponent pc : myOneOff.getIncludedPatchComponents()) {
                List<OrderedPatchAction> paList = pc.getSnowballOrderedActions();
                for (int j2 = 0; paList != null && j2 < paList.size(); ++j2) {
                    List<String> deleteVerList;
                    String value;
                    String file;
                    OrderedPatchAction act;
                    PatchAction paIndiv = paList.get(j2);
                    if (paIndiv instanceof CopyAction) {
                        act = (CopyAction)paIndiv;
                        file = ((CopyAction)act).getFilename();
                        value = ((CopyAction)act).getFileVersion();
                        if (!((CopyAction)act).isSnowBallCopyAction() || !((CopyAction)act).isHasFileVersion()) continue;
                        if (copyFileMap.containsKey(file)) {
                            String presentValue = (String)copyFileMap.get(file);
                            int retVal = OPatchSessionHelper.isGreaterDecimal(presentValue, value);
                            if (retVal == 0 || retVal == 1) {
                                buff = new StringBuffer("Copy Action " + ((CopyAction)act).toString() + " version is already greater --> " + presentValue + ".");
                                buff.append("\nWe will no replace with this version " + value + ".");
                                OLogger.debug(buff);
                                continue;
                            }
                            buff = new StringBuffer("Replace this copy action's " + ((CopyAction)act).toString() + " with this version" + value);
                            OLogger.debug(buff);
                        }
                        copyFileMap.put(file, value);
                        buff = new StringBuffer("Updated KEY(filename of this copyAction) " + file + " with the version " + value + "...");
                        OLogger.debug(buff);
                    }
                    if (!(paIndiv instanceof DeleteAction)) continue;
                    act = (DeleteAction)paIndiv;
                    file = ((DeleteAction)act).getFileName();
                    value = ((DeleteAction)act).getFileVersion();
                    if (!((DeleteAction)act).isSnowBallDeleteAction()) continue;
                    String presentValueInCopy = (String)copyFileMap.get(file);
                    HashMap<String, String> presentValueInCopies = new HashMap<String, String>();
                    if (presentValueInCopy != null) {
                        presentValueInCopies.put(file, presentValueInCopy);
                    }
                    if (((DeleteAction)act).getIsDir()) {
                        String preFix = file + File.separator;
                        Set allFileSet = copyFileMap.keySet();
                        for (String f2 : allFileSet) {
                            if (!f2.startsWith(preFix)) continue;
                            presentValueInCopies.put(f2, (String)copyFileMap.get(f2));
                        }
                    }
                    List presentValueInDeleteList = (List)deleteFileMap.get(file);
                    boolean isPut = true;
                    if (((DeleteAction)act).isHasFileVersion()) {
                        if (value.startsWith("le")) {
                            Iterator updateValue = value.substring(2);
                            if (presentValueInDeleteList != null) {
                                Iterator<Object> iter = presentValueInDeleteList.iterator();
                                while (iter.hasNext()) {
                                    String string = (String)iter.next();
                                    if (string.startsWith("le")) {
                                        String updatePresentValueInDelete = string.substring(2);
                                        int retVal = OPatchSessionHelper.isGreaterDecimal(updatePresentValueInDelete, updateValue);
                                        if (retVal == -1) {
                                            buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is higher than --> " + string + ".");
                                            buff.append("\nWe will remove the version " + string + " in the delete map.");
                                            OLogger.debug(buff);
                                            iter.remove();
                                            continue;
                                        }
                                        isPut = false;
                                        buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is lower than --> " + string + ".");
                                        buff.append("\nWe will ignore this version " + value + ".");
                                        OLogger.debug(buff);
                                        continue;
                                    }
                                    int retVal = OPatchSessionHelper.isGreaterDecimal(string, updateValue);
                                    if (retVal != -1) continue;
                                    buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is higher version than --> " + string + ".");
                                    buff.append("\nWe will remove the version " + string + " in delete file map.");
                                    OLogger.debug(buff);
                                    iter.remove();
                                }
                            }
                            for (Map.Entry entry : presentValueInCopies.entrySet()) {
                                String copyFile = (String)entry.getKey();
                                String copyVer = (String)entry.getValue();
                                int retVal = OPatchSessionHelper.isGreaterDecimal(copyVer, updateValue);
                                if (retVal != -1) continue;
                                buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is higher than --> " + copyVer + " in the copy file map.");
                                buff.append("\nWe will remove the version " + copyVer + " from copy file map.");
                                OLogger.debug(buff);
                                copyFileMap.remove(copyFile);
                            }
                        } else {
                            if (presentValueInDeleteList != null) {
                                for (String presentValueInDelete : presentValueInDeleteList) {
                                    if (presentValueInDelete.startsWith("le")) {
                                        String string = presentValueInDelete.substring(2);
                                        int retVal = OPatchSessionHelper.isGreaterDecimal(string, value);
                                        if (retVal != 1) continue;
                                        buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is lower than --> " + presentValueInDelete + " in the delete file map.");
                                        buff.append("\nWe will ignore this version " + presentValueInDelete + " in the delete file map.");
                                        OLogger.debug(buff);
                                        isPut = false;
                                        continue;
                                    }
                                    int n2 = OPatchSessionHelper.isGreaterDecimal(presentValueInDelete, value);
                                    if (n2 != 0) continue;
                                    buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is equal to --> " + presentValueInDelete + " in the delete file map.");
                                    buff.append("\nWe will ignore this version " + value + ".");
                                    OLogger.debug(buff);
                                    isPut = false;
                                }
                            }
                            for (Map.Entry entry : presentValueInCopies.entrySet()) {
                                String string = (String)entry.getKey();
                                String copyVer = (String)entry.getValue();
                                int retVal = OPatchSessionHelper.isGreaterDecimal(copyVer, value);
                                if (retVal != 0) continue;
                                buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is equal to --> " + copyVer + ".");
                                buff.append("\nWe will remove this version " + copyVer + " from copy file map.");
                                OLogger.debug(buff);
                                copyFileMap.remove(string);
                            }
                        }
                        if (!isPut) continue;
                        deleteVerList = (List)deleteFileMap.get(file);
                        if (deleteVerList == null) {
                            deleteVerList = new ArrayList();
                            deleteVerList.add(value);
                            deleteFileMap.put(file, deleteVerList);
                        } else {
                            deleteVerList.add(value);
                        }
                        buff = new StringBuffer("Updated KEY(filename of this deleteAction) " + ((DeleteAction)act).toString() + " with this version" + value);
                        OLogger.debug(buff);
                        continue;
                    }
                    for (Map.Entry entry : presentValueInCopies.entrySet()) {
                        String string = (String)entry.getKey();
                        String copyVer = (String)entry.getValue();
                        buff = new StringBuffer("Delete Action " + ((DeleteAction)act).toString() + " version is higher than(or has no file version) --> " + copyVer + " in the copy file map.");
                        buff.append("\nWe will remove the version " + copyVer + " from copy file map.");
                        OLogger.debug(buff);
                        copyFileMap.remove(string);
                    }
                    deleteVerList = (List)deleteFileMap.get(file);
                    if (deleteVerList == null) {
                        deleteVerList = new ArrayList<String>();
                        deleteVerList.add("lemax.version");
                        deleteFileMap.put(file, deleteVerList);
                    } else if (!deleteVerList.contains("lemax.version")) {
                        deleteVerList.clear();
                        deleteVerList.add("lemax.version");
                    }
                    buff = new StringBuffer("Updated KEY(filename of this deleteAction) " + ((DeleteAction)act).toString() + " with this version" + value);
                    OLogger.debug(buff);
                }
            }
        }
        data.setCopyMap(copyFileMap);
        data.setDeleteMap(deleteFileMap);
        return data;
    }

    public static String encryptString(String s) {
        String sha1 = "";
        try {
            MessageDigest crypt = MessageDigest.getInstance("SHA-1");
            crypt.reset();
            crypt.update(s.getBytes("UTF-8"));
            sha1 = OPatchSessionHelper.bytesToHex(crypt.digest());
        }
        catch (NoSuchAlgorithmException e2) {
            e2.printStackTrace();
        }
        catch (UnsupportedEncodingException e3) {
            e3.printStackTrace();
        }
        return sha1;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j2 = 0; j2 < bytes.length; ++j2) {
            int v = bytes[j2] & 0xFF;
            hexChars[j2 * 2] = hexArray[v >>> 4];
            hexChars[j2 * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static String getHashCode(OneOffEntry[] oneoffs) {
        Object[] ids = new String[oneoffs.length];
        for (int i2 = 0; i2 < oneoffs.length; ++i2) {
            OneOffEntry oneoff = oneoffs[i2];
            ids[i2] = oneoff.getTripletID();
        }
        Arrays.sort(ids);
        StringBuffer idList = new StringBuffer();
        for (int i3 = 0; i3 < ids.length; ++i3) {
            idList.append((String)ids[i3]);
        }
        return OPatchSessionHelper.encryptString(idList.toString());
    }

    public static IndexPair getHashCodes(String oracleHomePath, OneOffEntry[] oneoffs) throws IOException {
        String pohHash = "";
        String piHash = "";
        piHash = OPatchSessionHelper.getHashCode(oneoffs);
        String compsXML = IPMUtil.getCompsXMLLocation(oracleHomePath);
        try {
            pohHash = OPatchSessionHelper.computeChecksum(compsXML);
        }
        catch (IOException e2) {
            RuntimeException rt = new RuntimeException(e2.getMessage(), e2);
            rt.setStackTrace(e2.getStackTrace());
            throw rt;
        }
        IndexPair hash = new IndexPair(pohHash, piHash);
        return hash;
    }

    public static String getOhHash(String oracleHomePath) throws IOException {
        String pohHash = "";
        String compsXML = IPMUtil.getCompsXMLLocation(oracleHomePath);
        try {
            pohHash = OPatchSessionHelper.computeChecksum(compsXML);
        }
        catch (IOException e2) {
            RuntimeException rt = new RuntimeException(e2.getMessage(), e2);
            rt.setStackTrace(e2.getStackTrace());
            throw rt;
        }
        return pohHash;
    }

    public static int isGreaterDecimal(String firstDecimal, String secondDecimal) {
        char y;
        char x;
        int i2;
        if (firstDecimal == null) {
            firstDecimal = "";
        }
        if (secondDecimal == null) {
            secondDecimal = "";
        }
        if (firstDecimal.trim().equals(secondDecimal.trim())) {
            return 0;
        }
        if (firstDecimal.trim().equals("")) {
            return -1;
        }
        if (secondDecimal.trim().equals("")) {
            return 1;
        }
        String firstNo = firstDecimal;
        String secondNo = secondDecimal;
        String firstIntPart = "";
        String firstDecimalPart = "";
        String secondIntPart = "";
        String secondDecimalPart = "";
        String[] firstNoParts = firstNo.split("\\.");
        String[] secondNoParts = secondNo.split("\\.");
        firstIntPart = firstNoParts[0];
        firstDecimalPart = firstNoParts[1];
        secondIntPart = secondNoParts[0];
        secondDecimalPart = secondNoParts[1];
        int firstIntLength = firstIntPart.length();
        int secondIntLength = secondIntPart.length();
        String zeroStr = OPatchSessionHelper.getExtraZeroes(Math.abs(firstIntLength - secondIntLength));
        if (firstIntLength > secondIntLength) {
            secondIntPart = zeroStr + secondIntPart;
        } else if (firstIntLength < secondIntLength) {
            firstIntPart = zeroStr + firstIntPart;
        }
        int firstDecimalLength = firstDecimalPart.length();
        int secondDecimalLength = secondDecimalPart.length();
        zeroStr = OPatchSessionHelper.getExtraZeroes(Math.abs(firstDecimalLength - secondDecimalLength));
        if (firstDecimalLength > secondDecimalLength) {
            secondDecimalPart = secondDecimalPart + zeroStr;
        } else if (firstDecimalLength < secondDecimalLength) {
            firstDecimalPart = firstDecimalPart + zeroStr;
        }
        for (i2 = 0; i2 < firstIntPart.length(); ++i2) {
            int yInt;
            x = firstIntPart.charAt(i2);
            int xInt = x - 48;
            if (xInt > (yInt = (y = secondIntPart.charAt(i2)) - 48)) {
                return 1;
            }
            if (xInt >= yInt) continue;
            return -1;
        }
        for (i2 = 0; i2 < firstDecimalPart.length(); ++i2) {
            int yDecimal;
            x = firstDecimalPart.charAt(i2);
            int xDecimal = x - 48;
            if (xDecimal > (yDecimal = (y = secondDecimalPart.charAt(i2)) - 48)) {
                return 1;
            }
            if (xDecimal >= yDecimal) continue;
            return -1;
        }
        return 0;
    }

    private static String getExtraZeroes(int length) {
        String zeroStr = "";
        for (int i2 = 0; i2 < length; ++i2) {
            zeroStr = zeroStr + "0";
        }
        return zeroStr;
    }

    protected static String getHomePatchingModel(String oracleHomePath) {
        String setPatchModel = null;
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        boolean alreadyLocked = readServices.isLocked();
        try {
            if (!alreadyLocked) {
                readServices.lock(oracleHomePath);
            }
            setPatchModel = readServices.getAdditionalOracleHomeProperty("PATCHING_MODEL");
        }
        catch (Throwable t) {
            RuntimeException rt = new RuntimeException(t.getMessage(), t);
            rt.setStackTrace(t.getStackTrace());
            throw rt;
        }
        finally {
            if (!alreadyLocked) {
                readServices.release();
            }
        }
        if (setPatchModel == null || setPatchModel.equals("")) {
            return "one-off";
        }
        if (setPatchModel.equalsIgnoreCase("snowball")) {
            return setPatchModel;
        }
        return "one-off";
    }

    public static String getPatchgenCommand(String oracleHomePath, String patchID, boolean apply, boolean restore) throws NoSuchMethodException {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getPatchgenCommand");
        OLogger.debug(buff);
        if (OPatchEnv.isDesiredHome()) {
            OPatchProperty opp = new OPatchProperty();
            StringBuffer cmd = new StringBuffer();
            try {
                cmd.append(opp.getPatchgenCommand());
                cmd.append(" ");
                if (!restore) {
                    cmd.append("commit");
                    cmd.append(" ");
                } else {
                    cmd.append("recover");
                    cmd.append(" ");
                }
                if (apply) {
                    cmd.append("-");
                    cmd.append("pi");
                } else {
                    cmd.append("-");
                    cmd.append("rb");
                }
                cmd.append(" ");
                cmd.append(patchID);
            }
            catch (NoSuchMethodException e2) {
                buff = new StringBuffer("OPatchSessionHelper::getPatchgenCommand()\n");
                buff.append("    " + e2.getMessage());
                OLogger.debug(buff);
                throw e2;
            }
            return cmd.toString();
        }
        buff = new StringBuffer("OPatchSessionHelper::getPatchgenCommnad() returns empty string as a result of non-desried home");
        OLogger.debug(buff);
        return "";
    }

    public static void clubArchiveActions(PatchObject po) {
        OLogger.debug(new StringBuffer("OPatchSessionHelper::clubArchiveActions() called"));
        HashMap<String, ArchiveAction> archives = new HashMap<String, ArchiveAction>();
        PatchComponent[] includedComponents = po.getIncludedPatchComponents();
        for (int i2 = 0; i2 < includedComponents.length; ++i2) {
            PatchComponent pc = includedComponents[i2];
            PatchAction[] applicablePatchActions = po.getImmediatePatchActionsToExecuteForComponent(pc);
            for (int j2 = 0; j2 < applicablePatchActions.length; ++j2) {
                PatchAction p2 = applicablePatchActions[j2];
                if (!(p2 instanceof ArchiveAction)) continue;
                ArchiveAction aa = (ArchiveAction)p2;
                String archive = aa.getRelativeArchivePath();
                if (archives.containsKey(archive)) {
                    ((ArchiveAction)archives.get(archive)).club(aa);
                    continue;
                }
                archives.put(archive, aa);
            }
        }
    }

    public static void clubArchiveActions(PatchObject po, HashSet filteredPatchActions) {
        OLogger.debug(new StringBuffer("OPatchSessionHelper::clubArchiveActions() called"));
        HashMap<String, ArchiveAction> archives = new HashMap<String, ArchiveAction>();
        PatchComponent[] includedComponents = po.getIncludedPatchComponents();
        for (int i2 = 0; i2 < includedComponents.length; ++i2) {
            PatchComponent pc = includedComponents[i2];
            PatchAction[] applicablePatchActions = po.getImmediatePatchActionsToExecuteForComponent(pc);
            for (int j2 = 0; j2 < applicablePatchActions.length; ++j2) {
                PatchAction p2 = applicablePatchActions[j2];
                if (!(p2 instanceof ArchiveAction)) continue;
                ArchiveAction aa = (ArchiveAction)p2;
                String archive = aa.getRelativeArchivePath();
                if (filteredPatchActions.contains(aa)) continue;
                if (archives.containsKey(archive)) {
                    ((ArchiveAction)archives.get(archive)).club(aa);
                    continue;
                }
                archives.put(archive, aa);
            }
        }
    }

    public static void clubAllOneLevelJarActions(PatchObject po, String oracleHomePath, HashSet filteredPatchActions) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::clubAllOneLevelJarActions() called");
        OLogger.debug(buff);
        PatchComponent[] includedComponents = po.getIncludedPatchComponents();
        PatchAction[] applicablePatchActions = new PatchAction[]{};
        for (PatchComponent pc : includedComponents) {
            applicablePatchActions = po.getImmediatePatchActionsToExecuteForComponent(pc);
            for (int j2 = 0; j2 < applicablePatchActions.length; ++j2) {
                JarAction ja;
                PatchAction p2 = applicablePatchActions[j2];
                if (!(p2 instanceof JarAction) || filteredPatchActions.contains(ja = (JarAction)p2) || ja.isMultiLevel()) continue;
                StringBuffer key = new StringBuffer(oracleHomePath);
                key.append(File.separator);
                key.append(ja.getJarPath());
                key.append(File.separator);
                key.append(ja.getJarName());
                String jarKey = key.toString();
                if (po.clubbedJars.containsKey(jarKey)) {
                    ArrayList presentValue = (ArrayList)po.clubbedJars.get(jarKey);
                    if (!presentValue.contains(ja)) {
                        presentValue.add(ja);
                    } else {
                        ja.setDuplicate(true);
                    }
                    po.clubbedJars.put(jarKey, presentValue);
                    continue;
                }
                ArrayList<JarAction> newValue = new ArrayList<JarAction>();
                newValue.add(ja);
                po.clubbedJars.put(jarKey, newValue);
            }
        }
        Set jaSet = po.clubbedJars.keySet();
        Iterator itr = jaSet.iterator();
        OLogger.log(OLogger.FINE, "\nLet us see if we can club jar actions and patch.");
        while (itr.hasNext()) {
            String myKey = (String)itr.next();
            ArrayList listAct = (ArrayList)po.clubbedJars.get(myKey);
            OLogger.log(OLogger.FINE, "Jar Path -> " + myKey);
            OLogger.log(OLogger.FINE, "--- Clubbed Actions for this Jar Path -> ");
            for (int i2 = 0; i2 < listAct.size(); ++i2) {
                JarAction ja = (JarAction)listAct.get(i2);
                OLogger.log(OLogger.FINE, ja.getChildPath());
            }
            OLogger.log(OLogger.FINE, "\n");
        }
    }

    public static void clubAllOneLevelJarActions(PatchObject po, String oracleHomePath) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::clubAllOneLevelJarActions() called");
        OLogger.debug(buff);
        PatchComponent[] includedComponents = po.getIncludedPatchComponents();
        PatchAction[] applicablePatchActions = new PatchAction[]{};
        for (PatchComponent pc : includedComponents) {
            applicablePatchActions = po.getImmediatePatchActionsToExecuteForComponent(pc);
            for (int j2 = 0; j2 < applicablePatchActions.length; ++j2) {
                JarAction ja;
                PatchAction p2 = applicablePatchActions[j2];
                if (!(p2 instanceof JarAction) || (ja = (JarAction)p2).isMultiLevel()) continue;
                StringBuffer key = new StringBuffer(oracleHomePath);
                key.append(File.separator);
                key.append(ja.getJarPath());
                key.append(File.separator);
                key.append(ja.getJarName());
                String jarKey = key.toString();
                if (po.clubbedJars.containsKey(jarKey)) {
                    ArrayList presentValue = (ArrayList)po.clubbedJars.get(jarKey);
                    if (!presentValue.contains(ja)) {
                        presentValue.add(ja);
                    } else {
                        ja.setDuplicate(true);
                    }
                    po.clubbedJars.put(jarKey, presentValue);
                    continue;
                }
                ArrayList<JarAction> newValue = new ArrayList<JarAction>();
                newValue.add(ja);
                po.clubbedJars.put(jarKey, newValue);
            }
        }
        Set jaSet = po.clubbedJars.keySet();
        Iterator itr = jaSet.iterator();
        OLogger.log(OLogger.FINE, "\nLet us see if we can club jar actions and patch.");
        while (itr.hasNext()) {
            String myKey = (String)itr.next();
            ArrayList listAct = (ArrayList)po.clubbedJars.get(myKey);
            OLogger.log(OLogger.FINE, "Jar Path -> " + myKey);
            OLogger.log(OLogger.FINE, "--- Clubbed Actions for this Jar Path -> ");
            for (int i2 = 0; i2 < listAct.size(); ++i2) {
                JarAction ja = (JarAction)listAct.get(i2);
                OLogger.log(OLogger.FINE, ja.getChildPath());
            }
            OLogger.log(OLogger.FINE, "\n");
        }
    }

    public static void constructJarActionTree(PatchObject po, String oracleHomePath) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::constructJarActionTree() called");
        OLogger.debug(buff);
        JarActionEntityTree.getRoot().setChilds(null);
        PatchComponent[] includedComponents = po.getIncludedPatchComponents();
        PatchAction[] applicablePatchActions = new PatchAction[]{};
        int includedLen = includedComponents.length;
        JarActionHelper.initDeleteJarActionCache();
        for (int i2 = 0; i2 < includedLen; ++i2) {
            PatchComponent pc = includedComponents[i2];
            applicablePatchActions = po.getImmediatePatchActionsToExecuteForComponent(pc);
            for (int j2 = 0; j2 < applicablePatchActions.length; ++j2) {
                DeleteJarAction dja;
                PatchAction p2 = applicablePatchActions[j2];
                if (p2 instanceof JarAction) {
                    JarAction ja = (JarAction)p2;
                    if (ja.isDuplicate()) continue;
                    buff = new StringBuffer("Adding Jar Action: " + ja.toString());
                    OLogger.debug(buff.toString());
                    JarActionEntityTree.addJarActionNodes(oracleHomePath, ja, JarActionEntityTree.getRoot());
                    continue;
                }
                if (!(p2 instanceof DeleteJarAction) || (dja = (DeleteJarAction)p2).isDuplicate()) continue;
                buff = new StringBuffer("Adding Delete Jar Action: " + dja.toString());
                OLogger.debug(buff.toString());
                JarActionEntityTree.addJarActionNodes(oracleHomePath, dja, JarActionEntityTree.getRoot());
            }
        }
        MultiJarUtil.resetPatchedStatusInJarActionTree(JarActionEntityTree.getRoot());
    }

    public static void constructJarActionTree(PatchObject po, String oracleHomePath, HashSet filteredPatchActions) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::constructJarActionTree() called");
        OLogger.debug(buff);
        JarActionEntityTree.getRoot().setChilds(null);
        PatchComponent[] includedComponents = po.getIncludedPatchComponents();
        PatchAction[] applicablePatchActions = new PatchAction[]{};
        int includedLen = includedComponents.length;
        JarActionHelper.initDeleteJarActionCache();
        for (int i2 = 0; i2 < includedLen; ++i2) {
            PatchComponent pc = includedComponents[i2];
            applicablePatchActions = po.getImmediatePatchActionsToExecuteForComponent(pc);
            for (int j2 = 0; j2 < applicablePatchActions.length; ++j2) {
                DeleteJarAction dja;
                PatchAction p2 = applicablePatchActions[j2];
                if (p2 instanceof JarAction) {
                    JarAction ja = (JarAction)p2;
                    if (filteredPatchActions.contains(ja) || ja.isDuplicate()) continue;
                    buff = new StringBuffer("Adding Jar Action: " + ja.toString());
                    OLogger.debug(buff.toString());
                    JarActionEntityTree.addJarActionNodes(oracleHomePath, ja, JarActionEntityTree.getRoot());
                    continue;
                }
                if (!(p2 instanceof DeleteJarAction) || filteredPatchActions.contains(dja = (DeleteJarAction)p2) || dja.isDuplicate()) continue;
                buff = new StringBuffer("Adding DeleteJar Action: " + dja.toString());
                OLogger.debug(buff.toString());
                JarActionEntityTree.addJarActionNodes(oracleHomePath, dja, JarActionEntityTree.getRoot());
            }
        }
        MultiJarUtil.resetPatchedStatusInJarActionTree(JarActionEntityTree.getRoot());
    }

    /*
     * Exception decompiling
     */
    public static void processOCM(IIPMReadServices readServices, String oracleHomePath) throws OCMException, Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void interviewUser(InterviewContextVar[] icv, HashMap defaultVals) throws RuntimeException {
        InterviewContextVar curObj;
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::interviewUser()");
        OLogger.debug(buff);
        if (icv == null || icv.length == 0) {
            throw new RuntimeException("Got corrupt Interview Object as input.");
        }
        StringBuffer sb = null;
        Properties userProps = OPatchEnv.getOPatchProperties();
        String userConfigFile = userProps.getProperty("userConfigFile");
        String userKeyFile = userProps.getProperty("userKeyFile");
        if (userConfigFile != null && userConfigFile.trim().length() > 0) {
            if (userKeyFile != null && userKeyFile.trim().length() > 0) {
                for (int i3 = 0; i3 < icv.length; ++i3) {
                    InterviewContextVar curObj2 = icv[i3];
                    String var = curObj2.getContextVarName();
                    if ("userConfigFile".equals(var)) {
                        curObj2.setContextVarValue(userConfigFile.trim().toCharArray());
                        continue;
                    }
                    if (!"userKeyFile".equals(var)) continue;
                    curObj2.setContextVarValue(userKeyFile.trim().toCharArray());
                }
                userProps.setProperty("AdminUser", userConfigFile.trim());
                userProps.setProperty("AdmP", userKeyFile.trim());
            } else if (OPatchEnv.isSilent()) {
                sb = new StringBuffer("userKeyFile");
            }
        } else if (OPatchEnv.isSilent()) {
            sb = userKeyFile != null && userKeyFile.trim().length() > 0 ? new StringBuffer("userConfigFile") : new StringBuffer("userConfigFile").append(", ").append("userKeyFile");
        }
        String nmConfigFile = userProps.getProperty("NodeManagerConfigFile");
        String nmKeyFile = userProps.getProperty("NodeManagerKeyFile");
        String error = null;
        if (nmConfigFile != null && nmConfigFile.trim().length() > 0) {
            if (nmKeyFile != null && nmKeyFile.trim().length() > 0) {
                for (i2 = 0; i2 < icv.length; ++i2) {
                    curObj = icv[i2];
                    String var = curObj.getContextVarName();
                    if ("NodeManagerConfigFile".equals(var)) {
                        curObj.setContextVarValue(nmConfigFile.trim().toCharArray());
                        continue;
                    }
                    if (!"NodeManagerKeyFile".equals(var)) continue;
                    curObj.setContextVarValue(nmKeyFile.trim().toCharArray());
                }
                userProps.setProperty("NodeManagerUsername", nmConfigFile.trim());
                userProps.setProperty("NMP", nmKeyFile.trim());
            } else if (OPatchEnv.isSilent()) {
                error = "NodeManagerKeyFile";
            }
        } else if (OPatchEnv.isSilent()) {
            error = nmKeyFile != null && nmKeyFile.trim().length() > 0 ? "NodeManagerConfigFile" : "NodeManagerConfigFile, NodeManagerKeyFile";
        }
        if (error != null) {
            sb = sb == null ? new StringBuffer(error) : sb.append(",").append(error);
        }
        for (i2 = 0; i2 < icv.length; ++i2) {
            curObj = icv[i2];
            String val = new String(curObj.getContextVarValue());
            String var = curObj.getContextVarName();
            String desc = curObj.getContextVarDesc();
            boolean isVisible = curObj.isVisible();
            if (curObj.isEnv() && val.equals("")) {
                OLogger.println("Trying to get value for \"" + var + "\" from the environment...");
                val = OUIReplacer.getEnv(curObj.getContextVarName());
                curObj.setContextVarValue(val.toCharArray());
            }
            if (curObj.isPrompt() && val.equals("")) {
                String valueFromUserProps = userProps.getProperty(var);
                if (valueFromUserProps != null && valueFromUserProps.trim().length() > 0) {
                    curObj.setContextVarValue(valueFromUserProps.trim().toCharArray());
                } else if (OPatchEnv.isSilent()) {
                    if (!("AdminUser".equals(var) || "AdmP".equals(var) || "NodeManagerUsername".equals(var) || "NMP".equals(var))) {
                        if (sb == null) {
                            sb = new StringBuffer(var);
                        } else {
                            sb.append(", ").append(var);
                        }
                    }
                } else {
                    char[] secureStr = SecurePrompter.readResponse(desc, defaultVals != null ? (String)defaultVals.get(var) : null, isVisible);
                    curObj.setContextVarValue(secureStr);
                }
            }
            char[] secureVal = curObj.getContextVarValue();
            if (!curObj.isRequired() || secureVal != null && secureVal.length != 0) continue;
            throw new RuntimeException("\nYou cannot have a null (or) empty value for this variable \"" + var + "\"");
        }
        if (sb != null) {
            throw new RuntimeException(OLogger.getString("OUI-67715", new Object[]{sb.toString()}));
        }
    }

    private static boolean compareVersion(String s1, String s2) throws Exception {
        String[] va2;
        if (s1 == null || s1.trim().length() == 0) {
            throw new Exception("Current OPatch version is invalid.");
        }
        if (s2 == null || s2.trim().length() == 0) {
            return true;
        }
        String[] va1 = s1.split("\\.");
        int min = va1.length < (va2 = s2.split("\\.")).length ? va1.length : va2.length;
        for (int i2 = 0; i2 < min; ++i2) {
            int y;
            int x = Integer.parseInt(va1[i2]);
            if (x > (y = Integer.parseInt(va2[i2]))) {
                return true;
            }
            if (x >= y) continue;
            return false;
        }
        return va1.length >= va2.length;
    }

    public static void checkMinOPatchVersions(PatchObject[] patchObjects) throws RuntimeException {
        OPatchSessionHelper.checkMinOPatchVersions(patchObjects, OPatchEnv.getCallerVersion());
    }

    public static void checkMinOPatchVersions(PatchObject[] patchObjects, String rawCurVersion) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::checkMinOPatchVersions()");
        OLogger.debug(buff);
        if (patchObjects == null) {
            throw new RuntimeException("Got null array of Patch Objects as input");
        }
        String[] patchIDs = new String[patchObjects.length];
        String[] minVersions = new String[patchObjects.length];
        long[] longVal = new long[patchObjects.length];
        StringBuffer sb = null;
        String[] versionList = new String[patchObjects.length];
        StringBuffer requiredVersions = new StringBuffer();
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            String minOPatchVersion;
            if (patchObjects[i2] == null) {
                throw new RuntimeException("\nGot a null patch object");
            }
            patchIDs[i2] = patchObjects[i2].getPatchID();
            versionList[i2] = minOPatchVersion = patchObjects[i2].getPatchInventory().getMinOPatchVersion();
            if (minOPatchVersion == null || minOPatchVersion.equals("")) {
                minVersions[i2] = "";
                continue;
            }
            minVersions[i2] = minOPatchVersion.replaceAll("\\.", "");
            try {
                long x;
                longVal[i2] = x = Long.parseLong(minVersions[i2]);
            }
            catch (NumberFormatException e2) {
                OLogger.printStackTrace(e2);
                RuntimeException rt = new RuntimeException("\nPatch ID " + patchIDs[i2] + " has an invalid minimum OPatch version.", e2);
                rt.setStackTrace(e2.getStackTrace());
                throw rt;
            }
            requiredVersions.append("Patch ").append(patchIDs[i2]);
            requiredVersions.append(" requires OPatch version ");
            requiredVersions.append(minOPatchVersion).append(".\n");
        }
        String curVersion = rawCurVersion.replaceAll("\\.", "");
        try {
            long curLongVersion = Long.parseLong(curVersion);
        }
        catch (NumberFormatException e3) {
            OLogger.printStackTrace(e3);
            RuntimeException rt = new RuntimeException("\nCurrent OPatch version is invalid.", e3);
            rt.setStackTrace(e3.getStackTrace());
            throw rt;
        }
        boolean errFlag = false;
        List<String> failedPatches = PrereqAPI.getFailedPatches();
        for (int i3 = 0; i3 < minVersions.length; ++i3) {
            try {
                if (OPatchSessionHelper.compareVersion(rawCurVersion, versionList[i3])) continue;
                if (sb == null) {
                    sb = new StringBuffer("\n");
                } else {
                    sb.append("\n");
                }
                sb.append("Patch ").append(patchIDs[i3]).append(" requires OPatch version ");
                sb.append(versionList[i3]).append(" or later.");
                failedPatches.add(patchIDs[i3]);
                errFlag = true;
                continue;
            }
            catch (Exception e4) {
                OLogger.printStackTrace(e4);
                RuntimeException rt = new RuntimeException("\nError while comparing the versions.", e4);
                rt.setStackTrace(e4.getStackTrace());
                throw rt;
            }
        }
        if (errFlag) {
            StringBuffer err = new StringBuffer("\n\n");
            err.append("The OPatch being used is version ");
            err.append(rawCurVersion).append(" while ");
            err.append("the following patch(es) require higher versions: ").append(sb.toString()).append("\n");
            err.append("Please download the latest OPatch from My Oracle Support.\n");
            throw new RuntimeException(err.toString());
        }
    }

    /*
     * Exception decompiling
     */
    public static void getWlsPatchProfile(PatchObject[] patchObjects) throws RuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void writeRecordedEntries(Path interimInvObj, String session, IIPMReadServices readServices) {
        if (interimInvObj == null) {
            return;
        }
        if (!readServices.isInventoryLoaded() && !readServices.isLocked()) {
            return;
        }
        BufferedWriter fw = null;
        BufferedWriter interimWrite = null;
        try {
            fw = Files.newBufferedWriter(interimInvObj, Charset.forName("UTF-8"), new OpenOption[0]);
            interimWrite = new BufferedWriter(fw);
            String comment = "# " + session + ": list of patches installed in Oracle Home.\n";
            interimWrite.write(comment);
            OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
            for (int i2 = 0; i2 < installedOneOffs.length; ++i2) {
                StringBuffer line = new StringBuffer();
                OneOffEntry po = installedOneOffs[i2];
                String id = po.getID();
                line.append(id).append(":recorded:");
                String[] bugs = po.getBugIDsFixed();
                for (int j2 = 0; j2 < bugs.length; ++j2) {
                    String bID = bugs[j2];
                    line.append(bID);
                    if (j2 >= bugs.length - 1) continue;
                    line.append(",");
                }
                line.append("\n");
                interimWrite.write(line.toString());
                interimWrite.flush();
            }
            interimWrite.close();
            fw.close();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
    }

    public static void validateOCMOption(String oracleHomePath, IIPMReadServices readServices) throws OCMException {
        boolean shouldValidateFirstLevel;
        StringBuffer buff = new StringBuffer("OPatchSesionHelper::validateOCMOption()");
        OLogger.debug(buff);
        if (OPatchEnv.isOPatchSDKMode()) {
            OLogger.justlog(OLogger.INFO, "OCM validation is skipped for SDK mode.");
            return;
        }
        int homePatchingModel = PatchingModel.returnModelCode(oracleHomePath);
        if (homePatchingModel == 2) {
            OLogger.justlog(OLogger.INFO, "OCM validation is skipped for 'snowball' OH model.");
            return;
        }
        boolean bl = shouldValidateFirstLevel = OPatchEnv.isSilent() && !OPatchEnv.isOCMResponseFile() && !OPatchEnv.isReport() && !OPatchEnv.isEmOcmSkip();
        if (!Rules.shouldDoMiddlewareHomeOCM()) {
            shouldValidateFirstLevel = shouldValidateFirstLevel && !SCM.isEBSHome(oracleHomePath);
        } else if (SCM.needToConfigureOHInMiddleware(readServices)) {
            boolean bl2 = shouldValidateFirstLevel = shouldValidateFirstLevel && !SCM.isEBSHome(oracleHomePath);
        }
        if (shouldValidateFirstLevel) {
            String runningDir = System.getProperty("OPatch.RUNNING_DIR");
            boolean shouldValidateSecondLevel = true;
            if (!Rules.shouldDoMiddlewareHomeOCM()) {
                shouldValidateSecondLevel = shouldValidateSecondLevel && (!SCM.isInstalled(oracleHomePath) || !SCM.isConfigured(oracleHomePath));
            } else {
                String parentCCR = OPatchEnv.getMiddlewareHome() + File.separator + "utils";
                boolean bl3 = shouldValidateSecondLevel = shouldValidateSecondLevel && (!SCM.isInstalled(parentCCR) || !SCM.isConfigured(parentCCR));
                if (!shouldValidateSecondLevel && SCM.needToConfigureOHInMiddleware(readServices)) {
                    boolean bl4 = shouldValidateSecondLevel = !SCM.isInstalled(oracleHomePath) || !SCM.isConfigured(oracleHomePath);
                }
            }
            if (shouldValidateSecondLevel && SCM.isOCMBundledOPatch(runningDir, oracleHomePath)) {
                String utilityPath = SCM.getRespUtilityPath(runningDir);
                buff = new StringBuffer(OLogger.getString("OUI-67300", new Object[]{utilityPath}));
                OCMException re = new OCMException(buff.toString());
                throw re;
            }
        }
    }

    public static String getInitScriptActionArgument(String patchID) {
        StringBuffer tmpSb = new StringBuffer("-apply");
        tmpSb.append(" ");
        tmpSb.append(patchID);
        tmpSb.append(" ");
        tmpSb.append(OPatchEnv.getInitopt());
        return tmpSb.toString();
    }

    public static String getInitScriptActionArgumentForRollBack(String patchID) {
        StringBuffer tmpSb = new StringBuffer("-rollback");
        tmpSb.append(" ");
        tmpSb.append(patchID);
        tmpSb.append(" ");
        tmpSb.append(OPatchEnv.getInitopt());
        return tmpSb.toString();
    }

    public static String getPreScriptActionArgument(String patchID) {
        StringBuffer tmpSb = new StringBuffer("-apply");
        tmpSb.append(" ");
        tmpSb.append(patchID);
        tmpSb.append(" ");
        tmpSb.append(OPatchEnv.getPreopt());
        return tmpSb.toString();
    }

    public static String getPreScriptActionArgumentForRollBack(String patchID) {
        StringBuffer tmpSb = new StringBuffer("-rollback");
        tmpSb.append(" ");
        tmpSb.append(patchID);
        tmpSb.append(" ");
        tmpSb.append(OPatchEnv.getPreopt());
        return tmpSb.toString();
    }

    public static String getPostScriptActionArgument(String patchID) {
        StringBuffer tmpSb = new StringBuffer("-apply");
        tmpSb.append(" ");
        tmpSb.append(patchID);
        tmpSb.append(" ");
        tmpSb.append(OPatchEnv.getPostopt());
        return tmpSb.toString();
    }

    public static String getPostScriptActionArgumentForRollBack(String patchID) {
        StringBuffer tmpSb = new StringBuffer("-rollback");
        tmpSb.append(" ");
        tmpSb.append(patchID);
        tmpSb.append(" ");
        tmpSb.append(OPatchEnv.getPostopt());
        return tmpSb.toString();
    }

    public static String getPostScriptActionArgumentForDeploy(String patchID) {
        StringBuffer tmpSb = new StringBuffer("-deploy");
        tmpSb.append(" ");
        tmpSb.append(patchID);
        tmpSb.append(" ");
        tmpSb.append(OPatchEnv.getPostopt());
        return tmpSb.toString();
    }

    protected static String getInstancesPatched(String oracleHomePath, String patchID, boolean install, String nodeName) {
        StringBuffer buff = new StringBuffer();
        Properties p2 = null;
        boolean continueForRAC = true;
        Rac rac = OPatchExternalFactory.getRac(oracleHomePath);
        if (nodeName.equals("")) {
            p2 = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        } else {
            continueForRAC = false;
            String srcOnlineFile = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
            String destOnlineFile = "";
            buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath));
            buff.append(File.separator);
            buff.append(nodeName);
            buff.append("_");
            buff.append("OnlinePatch.properties");
            destOnlineFile = buff.toString();
            RacSrvm racSrvm = OPatchExternalFactory.getRacSrvm(oracleHomePath);
            try {
                boolean isFileExists = racSrvm.isFileExistsOnNode(nodeName, srcOnlineFile);
                if (!isFileExists) {
                    return "";
                }
                racSrvm.transferFileFromNode(nodeName, srcOnlineFile, destOnlineFile);
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(destOnlineFile, new String[0]);
                p2 = OPatchSessionHelper.getOnlinePropertyFromSpecifiedFileObj(f2, destOnlineFile);
                boolean ok = Files.deleteIfExists(f2);
                if (!ok) {
                    OLogger.printlnOnLog(OLogger.INFO, "Not able to delete file \"" + destOnlineFile + "\"");
                }
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
                return "Not able to get Instances patched for this online patch";
            }
        }
        if (p2 == null) {
            if (install) {
                return "Not able to get Instances patched for this online patch";
            }
            return "";
        }
        StringBuffer sidKey = new StringBuffer(patchID);
        sidKey.append("_ONLINE_SID");
        String sids = p2.getProperty(sidKey.toString());
        if (sids == null || sids.equals("")) {
            if (install) {
                return "There are no Instances patched for this online patch";
            }
            return "";
        }
        ArrayList<String> sidList = new ArrayList<String>();
        ArrayList<String> cleanList = new ArrayList<String>();
        ArrayList<String> finalList = new ArrayList<String>();
        String[] sidStr = sids.split(",");
        for (int i2 = 0; i2 < sidStr.length; ++i2) {
            sidList.add(sidStr[i2]);
        }
        int tempLength = nodeName != null ? nodeName.length() + 2 : 0;
        int maxScreenLength = 74;
        for (int j2 = 0; j2 < sidList.size(); ++j2) {
            String sid = (String)sidList.get(j2);
            if (cleanList.contains(sid)) continue;
            cleanList.add(sid);
            tempLength += sid.length();
            if (j2 != sidList.size()) {
                tempLength += 3;
            }
            if (tempLength > maxScreenLength) {
                buff = new StringBuffer("\n     ");
                buff.append(sid);
                sid = buff.toString();
                tempLength = 0;
            }
            finalList.add(sid);
        }
        String returnList = finalList.toString();
        returnList = returnList.replace('[', ' ');
        returnList = returnList.replace(']', ' ');
        returnList = returnList.trim();
        if (!nodeName.equals("")) {
            buff = new StringBuffer(nodeName);
            buff.append(": ");
            buff.append(returnList);
            returnList = buff.toString();
        }
        if (!continueForRAC) {
            return returnList;
        }
        Rac.RacType racType = null;
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
            racType = rac.getInstance(readServices);
        }
        catch (RuntimeException e3) {
            OLogger.printStackTrace(e3);
            return returnList;
        }
        catch (Throwable t) {
            OLogger.printStackTrace(t);
            return returnList;
        }
        if (racType == Rac.RacType.NO_RAC || racType == Rac.RacType.SINGLE_NODE) {
            return returnList;
        }
        String[] remoteNodes = racType.getRemoteNodes();
        buff = new StringBuffer(racType.getLocalNode());
        buff.append(": ");
        buff.append(returnList);
        for (int i3 = 0; remoteNodes != null && i3 < remoteNodes.length; ++i3) {
            String rNodesOnlineInfo = OPatchSessionHelper.getInstancesPatched(oracleHomePath, patchID, install, remoteNodes[i3]);
            if (rNodesOnlineInfo == null || rNodesOnlineInfo.equals("")) continue;
            buff.append("\n     ");
            buff.append(rNodesOnlineInfo);
        }
        returnList = buff.toString();
        return returnList;
    }

    protected static String getInstancesPatchedForRolledBackPatches(String oracleHomePath, ArrayList installedIDs) {
        StringBuffer buff = new StringBuffer("");
        Properties p2 = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        if (p2 == null) {
            return "";
        }
        String onlineIDs = p2.getProperty("PATCH_ID");
        if (onlineIDs == null || onlineIDs.equals("")) {
            return "";
        }
        ArrayList<String> onlineIdList = new ArrayList<String>();
        String[] onlinePatches = onlineIDs.split(",");
        for (int i2 = 0; i2 < onlinePatches.length; ++i2) {
            onlineIdList.add(onlinePatches[i2]);
        }
        ArrayList notInstalledOnlineIDs = new ArrayList();
        onlineIdList.removeAll(installedIDs);
        notInstalledOnlineIDs = onlineIdList;
        for (int i3 = 0; notInstalledOnlineIDs != null && i3 < notInstalledOnlineIDs.size(); ++i3) {
            String id = (String)notInstalledOnlineIDs.get(i3);
            String sidInfo = OPatchSessionHelper.getInstancesPatched(oracleHomePath, id, false, "");
            if (sidInfo == null || sidInfo.equals("")) continue;
            buff.append("\n   Patch ID : " + id);
            buff.append("\n   Instances:");
            buff.append("\n     " + sidInfo);
            buff.append("\n");
        }
        StringBuffer tag = new StringBuffer("");
        if (!buff.toString().equals("")) {
            tag.append("\nList of Instances patched for the following rolled back online patch(es):");
        }
        tag.append(buff);
        return tag.toString();
    }

    public static String readTextFile(String fileName) throws RuntimeException {
        StringBuffer buff = new StringBuffer();
        BufferedReader readFile = null;
        try {
            readFile = new BufferedReader(new FileReader(fileName));
        }
        catch (Exception e2) {
            RuntimeException rt = new RuntimeException(e2.getMessage(), e2);
            rt.setStackTrace(e2.getStackTrace());
            throw rt;
        }
        char[] charArray = new char[1024];
        int numChars = 0;
        try {
            while ((numChars = readFile.read(charArray)) > -1) {
                buff.append(String.valueOf(charArray, 0, numChars));
            }
        }
        catch (IOException e3) {
            RuntimeException rt = new RuntimeException(e3.getMessage(), e3);
            rt.setStackTrace(e3.getStackTrace());
            throw rt;
        }
        finally {
            try {
                readFile.close();
            }
            catch (IOException e4) {
                OLogger.printStackTrace(e4);
            }
        }
        return buff.toString();
    }

    public static String getPtlToolLocation() throws Exception {
        OPatchProperty prop = new OPatchProperty();
        String ptlToolLoc = "";
        ptlToolLoc = prop.getPtlpatchCommand();
        return ptlToolLoc;
    }

    public static Properties getSqlPropertyFromFile(String oracleHomePath, String cookedPatchID) {
        String sqlPropertyFilePath = OPatchEnv.getSqlPropertyFilePath(oracleHomePath, cookedPatchID);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFilePath, new String[0]);
        if (!Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) {
            return null;
        }
        Properties p2 = new Properties();
        try {
            InputStream fin = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFilePath, new String[0]), new OpenOption[0]);
            p2.load(fin);
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return null;
        }
        return p2;
    }

    public static Properties getOnlinePropertyFromFile(String oracleHomePath) {
        String onlinePropertyFilePath = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(onlinePropertyFilePath, new String[0]);
        if (!Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) {
            return null;
        }
        Properties p2 = new Properties();
        try {
            InputStream fin = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(onlinePropertyFilePath, new String[0]), new OpenOption[0]);
            p2.load(fin);
            fin.close();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return null;
        }
        return p2;
    }

    public static Properties getOnlinePropertyFromSpecifiedFileObj(Path f2, String filePath) {
        if (!Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) {
            return null;
        }
        Properties p2 = new Properties();
        try {
            InputStream fin = Files.newInputStream(WrapperFactory.getNioServiceWrapper().getPath(filePath, new String[0]), new OpenOption[0]);
            p2.load(fin);
            fin.close();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            return null;
        }
        return p2;
    }

    public static void setOnlinePropertyToFile(String oracleHomePath, Properties p2, String nodeName) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::setOnlinePropertyToFile()");
        OLogger.debug(buff);
        String onlinePropertyFilePath = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(onlinePropertyFilePath, new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            return;
        }
        try {
            OutputStream fout = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(onlinePropertyFilePath, new String[0]), new OpenOption[0]);
            p2.store(fout, null);
            fout.close();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            buff = new StringBuffer("Unable to commit changes to the online patch properties file ");
            buff.append("for the node \"" + nodeName + "\"");
            buff.append("\nThe online patch properties file is located at \"" + onlinePropertyFilePath + "\"");
            buff.append("\nPlease see log file for details.");
            OLogger.warn("OUI-67124", new Object[]{buff.toString()});
        }
    }

    public static void setOnlinePropertyToFile(String oracleHomePath, String nodeName, String patchID) throws RuntimeException {
        Properties newOnlineProp = new Properties();
        StringBuffer buff = new StringBuffer();
        Properties oldOnlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        if (oldOnlineProp == null) {
            throw new RuntimeException("Unable to setup the online properties file for the node \"" + nodeName + "\"");
        }
        String patchIDs = oldOnlineProp.getProperty("PATCH_ID");
        String[] sidArray = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        StringBuffer sidValue = new StringBuffer();
        for (int sidCount = 0; sidCount < sidArray.length; ++sidCount) {
            String localNode = OPatchEnv.getLocalNode();
            if (dbNodes[sidCount].equals(nodeName)) {
                sidValue.append(sidArray[sidCount]);
                sidValue.append(",");
                continue;
            }
            if (!dbNodes[sidCount].equals("") || !nodeName.equals(localNode)) continue;
            sidValue.append(sidArray[sidCount]);
            sidValue.append(",");
        }
        if (sidValue.toString().endsWith(",")) {
            String temp = sidValue.toString().substring(0, sidValue.toString().length() - 1);
            sidValue = new StringBuffer(temp);
        }
        String sidKey = "";
        buff = new StringBuffer(patchID);
        buff.append("_ONLINE_SID");
        sidKey = buff.toString();
        String oldSids = oldOnlineProp.getProperty(sidKey.toString());
        if (oldSids == null) {
            oldSids = "";
        }
        if (!oldSids.equals("")) {
            sidValue.append(",");
            sidValue.append(oldSids);
        }
        newOnlineProp = oldOnlineProp;
        if (patchIDs == null || patchIDs.equals("") || patchIDs.equals("unknown")) {
            newOnlineProp.setProperty("PATCH_ID", patchID);
        } else {
            String existingIDs = patchIDs;
            buff = new StringBuffer(existingIDs);
            String pattern1 = "," + patchID + ",";
            String pattern2 = "," + patchID;
            String pattern3 = patchID + ",";
            String pattern4 = patchID;
            boolean addPatchID = true;
            if (existingIDs.indexOf(",") != -1) {
                addPatchID = existingIDs.indexOf(pattern1) == -1 && existingIDs.indexOf(pattern2) == -1 && existingIDs.indexOf(pattern3) == -1;
            } else {
                boolean bl = addPatchID = existingIDs.indexOf(pattern4) == -1;
            }
            if (addPatchID) {
                buff.append(",");
                buff.append(patchID);
            }
            newOnlineProp.setProperty("PATCH_ID", buff.toString());
        }
        newOnlineProp.setProperty(sidKey, sidValue.toString());
        String onlinePropertyFilePath = OPatchEnv.getOnlinePropertyFilePath(oracleHomePath);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(onlinePropertyFilePath, new String[0]);
        if (!Files.exists(f2, new LinkOption[0])) {
            return;
        }
        try {
            OutputStream fout = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(onlinePropertyFilePath, new String[0]), new OpenOption[0]);
            newOnlineProp.store(fout, null);
            fout.close();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            buff = new StringBuffer("Unable to commit changes to the online patch properties file ");
            buff.append("for the node \"" + nodeName + "\"");
            buff.append("\nThe online patch properties file is located at \"" + onlinePropertyFilePath + "\"");
            buff.append("\nPlease see log file for details.");
            OLogger.warn("OUI-67124", new Object[]{buff.toString()});
        }
    }

    public static void removeOnlineRollbackSids(Properties oldOnlineProp, PatchObject[] po, String nodeName, String oracleHomePath) {
        StringBuffer buff = new StringBuffer();
        for (int i2 = 0; po != null && i2 < po.length; ++i2) {
            if (po[i2].isOnlinePatch() && oldOnlineProp != null) {
                StringBuffer sidKey = new StringBuffer(po[i2].getPatchID());
                sidKey.append("_ONLINE_SID");
                String sidValues = oldOnlineProp.getProperty(sidKey.toString());
                if (sidValues != null || !sidValues.equals("")) {
                    ArrayList<String> appliedSet = new ArrayList<String>();
                    StringTokenizer strTok = new StringTokenizer(sidValues, ",");
                    while (strTok.hasMoreTokens()) {
                        String temp = strTok.nextToken();
                        appliedSet.add(temp);
                    }
                    ArrayList<String> rollbackSet = new ArrayList<String>();
                    String[] dbSids = OPatchEnv.getDBSIDs();
                    String[] dbNodes = OPatchEnv.getDBNodes();
                    String localNode = OPatchEnv.getLocalNode();
                    for (int j2 = 0; dbSids != null && j2 < dbSids.length; ++j2) {
                        if (dbNodes[j2] == null) continue;
                        if (dbNodes[j2].equals(nodeName)) {
                            rollbackSet.add(dbSids[j2]);
                            continue;
                        }
                        if (!dbNodes[j2].equals("") || !localNode.equals(nodeName)) continue;
                        rollbackSet.add(dbSids[j2]);
                    }
                    if (rollbackSet.size() == 0) continue;
                    appliedSet.removeAll(rollbackSet);
                    StringBuffer newSids = new StringBuffer("");
                    for (int j3 = 0; j3 < appliedSet.size(); ++j3) {
                        newSids.append((String)appliedSet.get(j3));
                        if (j3 == appliedSet.size() - 1) continue;
                        newSids.append(",");
                    }
                    oldOnlineProp.setProperty(sidKey.toString(), newSids.toString());
                    OPatchSessionHelper.setOnlinePropertyToFile(oracleHomePath, oldOnlineProp, nodeName);
                    continue;
                }
                buff = new StringBuffer("Not able to remove SIDs from online patch properties file ");
                buff.append("for node " + nodeName);
                OLogger.printlnOnLog(OLogger.INFO, buff.toString());
                continue;
            }
            if (oldOnlineProp != null) continue;
            buff = new StringBuffer("Got online patch property as NULL for the node " + nodeName);
            OLogger.printlnOnLog(OLogger.INFO, buff.toString());
        }
    }

    public static void setSqlPropertyToFile(Properties p2, String oracleHomePath, String cookedPatchID) {
        Path f2;
        String futureRunSql;
        boolean isFutureRunSql;
        String sqlPropertyFilePath = OPatchEnv.getSqlPropertyFilePath(oracleHomePath, cookedPatchID);
        Properties presentProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
        String sid = "";
        if (presentProp != null) {
            sid = presentProp.getProperty("SID");
        }
        if (sid != null && !sid.equals("") && !(isFutureRunSql = Boolean.valueOf(futureRunSql = p2.getProperty("RUNSQL")).booleanValue())) {
            p2.setProperty("SID", sid);
        }
        if (!Files.exists(f2 = WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFilePath, new String[0]), new LinkOption[0])) {
            return;
        }
        try {
            OutputStream fout = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFilePath, new String[0]), new OpenOption[0]);
            p2.store(fout, null);
            fout.close();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
        }
    }

    public static void removeSidFromSqlPropertyFile(String oracleHomePath, String cookedPatchID) {
        Properties presentProp = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, cookedPatchID);
        String sid = "";
        if (presentProp == null) {
            return;
        }
        sid = presentProp.getProperty("SID");
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        ArrayList<String> rollbackSet = new ArrayList<String>();
        for (int j2 = 0; dbSids != null && j2 < dbSids.length; ++j2) {
            if (!dbNodes[j2].equals(localNode) && !dbNodes[j2].equals("")) continue;
            rollbackSet.add(dbSids[j2]);
        }
        ArrayList<String> appliedSet = new ArrayList<String>();
        if (sid != null && !sid.equals("")) {
            StringTokenizer strTok = new StringTokenizer(sid, ",");
            while (strTok.hasMoreTokens()) {
                String temp = strTok.nextToken();
                appliedSet.add(temp);
            }
        }
        if (rollbackSet.size() != 0) {
            appliedSet.removeAll(rollbackSet);
            StringBuffer newSids = new StringBuffer("");
            for (int j3 = 0; j3 < appliedSet.size(); ++j3) {
                newSids.append((String)appliedSet.get(j3));
                if (j3 == appliedSet.size() - 1) continue;
                newSids.append(",");
            }
            presentProp.setProperty("SID", newSids.toString());
            String sqlPropertyFilePath = OPatchEnv.getSqlPropertyFilePath(oracleHomePath, cookedPatchID);
            Path f2 = WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFilePath, new String[0]);
            if (!Files.exists(f2, new LinkOption[0])) {
                return;
            }
            try {
                OutputStream fout = Files.newOutputStream(WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFilePath, new String[0]), new OpenOption[0]);
                presentProp.store(fout, null);
                fout.close();
            }
            catch (Exception e2) {
                OLogger.printStackTrace(e2);
            }
        }
    }

    public static void runSqlScript(String sqlFilePath, boolean sqlMigrate) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::runSqlScript()");
        OLogger.debug(buff);
        if (!OPatchEnv.isRunSql()) {
            return;
        }
        if (Rules.SystemWrite_continue()) {
            String[] dbSids = OPatchEnv.getDBSIDs();
            String[] dbUsers = OPatchEnv.getDBUsers();
            String[] dbPasswds = OPatchEnv.getDBPasswds();
            String[] dbNodes = OPatchEnv.getDBNodes();
            if (dbSids == null || dbSids.length < 1) {
                RuntimeException re = new RuntimeException("Custom sql script execution : Database SIDs are not provided.");
                throw re;
            }
            String localNode = OPatchEnv.getLocalNode();
            for (int sidIter = 0; sidIter < dbSids.length; ++sidIter) {
                if (dbNodes[sidIter] != null && !dbNodes[sidIter].equals("") && !dbNodes[sidIter].equals(localNode)) continue;
                SystemCall.ExecReturn ret = null;
                String oracleHomePath = OPatchEnv.getOracleHome();
                try {
                    if (!SQLUtilities.startupDB(oracleHomePath, OPatchEnv.isSqlMigrate(), dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter])) {
                        RuntimeException re = new RuntimeException("Unable to startup the DB \"" + dbSids[sidIter] + "\"");
                        throw re;
                    }
                    ret = SQLUtilities.runSqlScript(oracleHomePath, sqlFilePath, dbUsers[sidIter], dbPasswds[sidIter], dbSids[sidIter]);
                    continue;
                }
                catch (Exception e2) {
                    buff = new StringBuffer(e2.getMessage());
                    OLogger.debug(buff);
                    buff.append("\n");
                    buff.append("Failed to execute the sql script \"" + sqlFilePath + "\"" + " on db instance \"" + dbSids[sidIter] + "\"");
                    RuntimeException rt = new RuntimeException(buff.toString(), e2);
                    rt.setStackTrace(e2.getStackTrace());
                    throw rt;
                }
            }
        }
    }

    public static void setFileEncodingValue(Transformer trans, String inFilePath) {
        if (trans == null) {
            return;
        }
        String defaultEncodingName = System.getProperty("file.encoding");
        if (defaultEncodingName == null || defaultEncodingName.equals("")) {
            OLogger.printlnOnLog(OLogger.INFO, "Failed to get Encoding Value from machine before writing " + inFilePath);
        } else {
            OLogger.printlnOnLog(OLogger.INFO, "Registered Encoding value is : " + defaultEncodingName + " for the " + "file " + inFilePath);
            trans.setOutputProperty("encoding", defaultEncodingName);
        }
    }

    public static void performPatchApplicableProductPrereq(String oracleHomePath, PatchObject patchObject) throws PrereqFailedException {
        OLogger.log(OLogger.FINE, "Running Prerequisite check \"CheckApplicableProduct\"...\n");
        PrereqResult resObj = PrereqAPI.checkApplicableProduct(oracleHomePath, patchObject);
        OLogger.debug(new StringBuffer("OPatch checks if the patch is applicable on this home product type"));
        if (resObj.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            StringBuffer buff = new StringBuffer("Prerequisite check \"CheckApplicableProduct\" failed.\n");
            buff.append(resObj.toString());
            buff.append("\n");
            throw new PrereqFailedException(buff.toString());
        }
        if (resObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            StringBuffer buff = new StringBuffer("Prerequisite check \"CheckApplicableProduct\" could not be executed.\n");
            buff.append(resObj.toString());
            buff.append("\n");
            throw new PrereqFailedException(buff.toString());
        }
    }

    public static void cleanupPatchStorage(String oracleHomePath, String cookedPatchID) {
        StringBuffer backup = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID));
        backup.append(File.separator);
        StringBuffer scratch = new StringBuffer(backup.toString());
        scratch.append("scratch");
        backup.append("backup");
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(scratch.toString(), new String[0]);
        boolean debug = true;
        if (Files.exists(f2, new LinkOption[0])) {
            SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, f2, debug);
        }
        if (Files.exists(f2 = WrapperFactory.getNioServiceWrapper().getPath(backup.toString(), new String[0]), new LinkOption[0])) {
            SystemCall.deleteRecurse(oracleHomePath, cookedPatchID, f2, debug);
        }
    }

    public static void releaseInventory(IIPMRWServices rwServices) {
        if (rwServices.isLocked()) {
            try {
                StringBuilder dBuff = new StringBuilder("N-Apply: release() the home");
                OLogger.debug(dBuff.toString());
                rwServices.release();
            }
            catch (Throwable t) {
                RuntimeException re = new RuntimeException(t.getMessage(), t);
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
    }

    public static IIPMRWServices lockInventory(String oracleHomePath) {
        StringBuilder dBuff = new StringBuilder("N-Apply: lock Oracle Home to get inventory.");
        OLogger.debug(dBuff.toString());
        IIPMRWServices rwServices = null;
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "Lock the home to access inventory.");
            try {
                rwServices = UtilSession.getRWServices(oracleHomePath);
            }
            catch (Throwable t) {
                RuntimeException e2 = new RuntimeException(t.getMessage(), t);
                e2.setStackTrace(t.getStackTrace());
                throw e2;
            }
            if (!rwServices.isInventoryLoaded()) {
                StringBuilder buff = new StringBuilder("NApply was not able to get an Inventory Session.");
                throw new RuntimeException(buff.toString());
            }
        } else {
            dBuff = new StringBuilder("N-Apply: IOC Converted or OUIRead_continue = false, ");
            dBuff.append("No home locking, Inventory not created.");
            OLogger.debug(dBuff.toString());
        }
        return rwServices;
    }

    public static MakeAction[] getIncludedMakeActions(String oracleHomePath, PatchObject[] patchObjects) {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getIncludedMakeAction()");
        OLogger.debug(buff);
        ArrayList<MakeAction> orderedList = new ArrayList<MakeAction>();
        int size = patchObjects != null ? patchObjects.length : 0;
        MakeAction[] includedMakeActions = new MakeAction[]{};
        if (size == 0) {
            buff = new StringBuffer("PatchObject array is null or of size 0");
            OLogger.debug(buff);
            return includedMakeActions;
        }
        ArrayList<MakeAction> skipList = new ArrayList<MakeAction>();
        for (i2 = 0; i2 < size; ++i2) {
            PatchObject patchObject = patchObjects[i2];
            String patchLoc = patchObject.getPatchLocation();
            PatchComponent[] pcs = patchObject.getIncludedPatchComponents();
            for (int j2 = 0; j2 < pcs.length; ++j2) {
                PatchComponent pc = pcs[j2];
                PatchAction[] pas = patchObject.getPatchActionsForComponent(pc);
                for (int k2 = 0; k2 < pas.length; ++k2) {
                    MakeAction ma;
                    PatchAction pa = pas[k2];
                    if (!(pa instanceof MakeAction) || !(pa instanceof Applicable) || !pa.isAppliedOK() || !(ma = (MakeAction)pa).applicable(oracleHomePath, patchLoc)) continue;
                    if (!orderedList.contains(ma)) {
                        orderedList.add(ma);
                        continue;
                    }
                    skipList.add(ma);
                }
            }
        }
        size = orderedList.size();
        includedMakeActions = new MakeAction[size];
        for (i2 = 0; i2 < size; ++i2) {
            Object obj = orderedList.get(i2);
            if (!(obj instanceof MakeAction)) {
                buff = new StringBuffer("MergedPatchObject::getIncludedMakeActions() :");
                buff.append("failed to retrieve MakeAction.");
                throw new RuntimeException(buff.toString());
            }
            includedMakeActions[i2] = (MakeAction)obj;
        }
        if (skipList.size() > 0) {
            StringBuffer msg = new StringBuffer("The following re-links will ");
            msg.append("eventually be skipped because they are duplicates: ");
            for (int i3 = 0; i3 < skipList.size(); ++i3) {
                Object obj = skipList.get(i3);
                if (!(obj instanceof MakeAction)) continue;
                MakeAction ma = (MakeAction)obj;
                msg.append(ma.getMakeTarget()).append(", ");
            }
            OLogger.printlnOnLog(msg.toString());
        }
        return includedMakeActions;
    }

    public static boolean verifyPatchAction(String oracleHomePath, String patchLoc, ArrayList copyActionToVerify, ArrayList jarActionToVerify, ArrayList arActionToVerify, ArrayList pluginActionToVerify, ArrayList makeActionToVerify, ArrayList deleteJarActionToVerify, IIPMReadServices readServices) throws IOException {
        StringBuffer buff;
        boolean ok;
        ArrayList<Object> failAction = new ArrayList<Object>();
        int size = copyActionToVerify.size();
        if (size > 0) {
            OLogger.log(OLogger.FINE, "\n   verifying copy files.");
            OLogger.printlnOnLog("   verifying " + size + " copy files.");
            for (int i2 = 0; i2 < size; ++i2) {
                CopyAction ca = (CopyAction)copyActionToVerify.get(i2);
                ok = ca.verify(oracleHomePath, patchLoc);
                if (ok) continue;
                failAction.add(ca);
            }
        }
        size = jarActionToVerify.size();
        HashMap result = JarActionHelper.verify(oracleHomePath, patchLoc);
        if (size > 0) {
            for (int i3 = 0; i3 < jarActionToVerify.size(); ++i3) {
                JarAction ja = (JarAction)jarActionToVerify.get(i3);
                buff = new StringBuffer("Verifying Jar Action: ");
                buff.append(ja.toString());
                OLogger.log(OLogger.FINEST, buff.toString());
                Boolean rs = (Boolean)result.get(ja.getClassName());
                if (rs == null || rs.booleanValue()) continue;
                failAction.add(ja);
            }
        }
        size = deleteJarActionToVerify.size();
        HashMap deleteJarResult = JarActionHelper.verify(oracleHomePath, patchLoc);
        if (size > 0) {
            for (int i4 = 0; i4 < jarActionToVerify.size(); ++i4) {
                DeleteJarAction dja = (DeleteJarAction)deleteJarActionToVerify.get(i4);
                buff = new StringBuffer("Verifying Delete Jar Action: ");
                buff.append(dja.toString());
                OLogger.log(OLogger.FINEST, buff.toString());
                Boolean rs = (Boolean)deleteJarResult.get(dja.getClassName());
                if (rs == null || rs.booleanValue()) continue;
                failAction.add(dja);
            }
        }
        if ((size = arActionToVerify.size()) > 0) {
            ArchiveAction aa;
            int i5;
            OLogger.log(OLogger.FINE, "\n   verifying archive files.");
            OLogger.printlnOnLog("   verifying " + size + " archive files.");
            HashMap<String, ArchiveAction> archives = new HashMap<String, ArchiveAction>();
            for (i5 = 0; i5 < arActionToVerify.size(); ++i5) {
                aa = (ArchiveAction)arActionToVerify.get(i5);
                String archive = aa.getRelativeArchivePath();
                if (archives.containsKey(archive)) {
                    ((ArchiveAction)archives.get(archive)).club(aa);
                    continue;
                }
                archives.put(archive, aa);
            }
            for (i5 = 0; i5 < arActionToVerify.size(); ++i5) {
                int currentPlatformValue;
                aa = (ArchiveAction)arActionToVerify.get(i5);
                ok = aa.verify(oracleHomePath, patchLoc);
                if (ok) continue;
                long arSizeDiff = aa.getSizeDiff();
                boolean needToRecord = true;
                if (arSizeDiff == 4L && ((currentPlatformValue = PatchObjectUtil.getARU_ID(oracleHomePath, readServices)) == 23 || currentPlatformValue == 173 || currentPlatformValue == 267)) {
                    String msg = "Verification of 'ar' actions failed. This is a known issue for this platform. Please check the note 353150.1 on \"https://myoraclesupport.oracle.com\" for further information.";
                    OLogger.printlnOnLogAndVerbose(msg);
                    needToRecord = false;
                }
                aa.setSizeDiff(0L);
                if (!needToRecord) continue;
                failAction.add(aa);
            }
        }
        if ((size = pluginActionToVerify.size()) > 0) {
            OLogger.log(OLogger.FINE, "\n   verifying plugin actions.");
            OLogger.printlnOnLog("   verifying " + size + " plugin actions.");
            for (int i6 = 0; i6 < pluginActionToVerify.size(); ++i6) {
                Verifiable va = (Verifiable)pluginActionToVerify.get(i6);
                ok = va.verify(oracleHomePath, patchLoc);
                if (ok) continue;
                failAction.add(va);
            }
        }
        size = failAction.size();
        int nCopyFail = 0;
        int nJarFail = 0;
        int nArchiveFail = 0;
        int nPluginFail = 0;
        if (size > 0) {
            for (int i7 = 0; i7 < size; ++i7) {
                Object obj = failAction.get(i7);
                if (obj instanceof CopyAction) {
                    ++nCopyFail;
                    continue;
                }
                if (obj instanceof JarAction) {
                    ++nJarFail;
                    continue;
                }
                if (obj instanceof ArchiveAction) {
                    ++nArchiveFail;
                    continue;
                }
                if (!(obj instanceof Verifiable)) continue;
                ++nPluginFail;
            }
        }
        OPatchSessionHelper.cleanupPatchStorageVerify(oracleHomePath, nJarFail, nArchiveFail);
        if (size > 0) {
            if (nCopyFail > 0) {
                buff = new StringBuffer("There are ");
                buff.append(nCopyFail);
                buff.append(" copy files under ORACLE_HOME that are not patched.");
                OLogger.log(OLogger.SEVERE, buff.toString());
            }
            if (nJarFail > 0) {
                buff = new StringBuffer("There are ");
                buff.append(nJarFail);
                buff.append(" jar files under ORACLE_HOME that are not patched.");
                OLogger.log(OLogger.SEVERE, buff.toString());
            }
            if (nArchiveFail > 0) {
                buff = new StringBuffer("There are ");
                buff.append(nArchiveFail);
                buff.append(" archive files under ORACLE_HOME that are not patched.");
                OLogger.log(OLogger.SEVERE, buff.toString());
            }
            if (nPluginFail > 0) {
                buff = new StringBuffer("There are ");
                buff.append(nPluginFail);
                buff.append(" plugin actions that are not performed properly.");
                OLogger.log(OLogger.SEVERE, buff.toString());
            }
            return false;
        }
        return true;
    }

    private static void cleanupPatchStorageVerify(String oracleHomePath, int nJarFail, int nArchiveFail) {
        StringBuffer buff;
        Path dirToDelete;
        String verifyDir;
        String cleanDir;
        try {
            if (nJarFail == 0) {
                cleanDir = OPatchEnv.getPatchStorageVeirifyDirectoryPathForJar(oracleHomePath);
                verifyDir = "verify";
                dirToDelete = WrapperFactory.getNioServiceWrapper().getPath(cleanDir, new String[0]);
                buff = new StringBuffer("Cleaning up \"");
                buff.append(dirToDelete);
                buff.append("\" under \"");
                buff.append(oracleHomePath);
                buff.append("\", \"");
                buff.append(verifyDir);
                buff.append("\".");
                OLogger.log(OLogger.FINE, buff.toString());
                SystemCall.deleteRecurse(oracleHomePath, verifyDir, dirToDelete, true);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            if (nArchiveFail == 0) {
                cleanDir = OPatchEnv.getPatchStorageVeirifyDirectoryPathForArchive(oracleHomePath);
                verifyDir = "verify";
                dirToDelete = WrapperFactory.getNioServiceWrapper().getPath(cleanDir, new String[0]);
                buff = new StringBuffer("Cleaning up \"");
                buff.append(dirToDelete);
                buff.append("\" under \"");
                buff.append(oracleHomePath);
                buff.append("\", \"");
                buff.append(verifyDir);
                buff.append("\".");
                OLogger.log(OLogger.FINE, buff.toString());
                SystemCall.deleteRecurse(oracleHomePath, verifyDir, dirToDelete, true);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    static void promptUserForNonRollbackableActions(String oracleHomePath, String patchID, String cookedPatchID, String caller, Rollbackable[] nonRollbackableActions) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::promptUserForNonRollbackableActions().");
        OLogger.debug(buff);
        buff = new StringBuffer();
        for (int i2 = 0; i2 < nonRollbackableActions.length; ++i2) {
            Rollbackable obj = nonRollbackableActions[i2];
            if (!(obj instanceof Rollbackable)) continue;
            Rollbackable ra = obj;
            String owningComp = "";
            if (obj instanceof PatchAction) {
                PatchAction pa = (PatchAction)((Object)obj);
                owningComp = pa.getOwningComponentDesc();
            }
            String desc = ra.getRollbackableDesc(oracleHomePath, owningComp);
            buff.append(desc);
            buff.append("\n");
        }
        OLogger.println("\n--------------------------------------------------------------------------------");
        OLogger.warn("OUI-67088", new Object[]{caller, patchID, buff.toString()});
        String tmpS = OLogger.getString("OUI-67164", new Object[]{caller, patchID, buff.toString()});
        boolean ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(new StringBuffer());
        if (!ignoreBackupError) {
            throw new RuntimeException(tmpS);
        }
    }

    static void promptUserForNonRestorableActions(String oracleHomePath, String patchID, String cookedPatchID, String caller, Restorable[] nonRestorableActions) throws RuntimeException {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::promptUserForNonRestorableActions.");
        OLogger.debug(buff);
        buff = new StringBuffer();
        for (int i2 = 0; i2 < nonRestorableActions.length; ++i2) {
            Restorable obj = nonRestorableActions[i2];
            if (!(obj instanceof Restorable)) continue;
            Restorable ra = obj;
            String desc = ra.getBackupForRestoreDesc(oracleHomePath, cookedPatchID);
            buff.append(desc);
            buff.append("\n");
        }
        OLogger.warn("OUI-67084", new Object[]{caller, patchID, buff.toString()});
        String tmpS = OLogger.getString("OUI-67163", new Object[]{caller, patchID, buff.toString()});
        boolean ignoreBackupError = OPatchEnv.proceedWithOperationDefaultNo(new StringBuffer());
        if (!ignoreBackupError) {
            throw new RuntimeException(tmpS);
        }
    }

    public static void checkArrayForNull(String arrayType, Object[] array) throws NullPointerException {
        StringBuffer buff = new StringBuffer("Array of ");
        buff.append(arrayType);
        if (array == null) {
            buff.append(" is null");
            throw new NullPointerException(buff.toString());
        }
        for (int i2 = 0; i2 < array.length; ++i2) {
            if (array[i2] != null) continue;
            buff.append(" has a null element at index ");
            buff.append(i2);
            throw new NullPointerException(buff.toString());
        }
    }

    public static void createMPFinal(String oracleHomePath, String cookedPatchID, PatchObject[] patchObjects) throws IOException {
        StringBuffer buff = new StringBuffer("createMPFinal()");
        OLogger.debug(buff);
        if (patchObjects.length == 0 || cookedPatchID == null || cookedPatchID.equals("")) {
            buff = new StringBuffer("createMPFinal: null or blank cooked patch ID.");
            OLogger.debug(buff);
            throw new IOException(buff.toString());
        }
        try {
            OPatchSessionHelper.checkArrayForNull("PatchObject", patchObjects);
        }
        catch (NullPointerException e2) {
            IOException ioe = new IOException(e2.getMessage(), e2);
            ioe.setStackTrace(e2.getStackTrace());
            throw ioe;
        }
        boolean createRacFile = OPatchEnv.isCreateRacFile();
        if (!createRacFile) {
            int homePatchingModel = PatchingModel.returnModelCode(oracleHomePath);
            if (homePatchingModel != 2) {
                buff = new StringBuffer("Users request no RAC file generation.  Do not create MP files.");
                OLogger.println(buff.toString());
            }
            return;
        }
        try {
            buff = new StringBuffer(" generating merged make commands for ");
            buff.append(cookedPatchID);
            OLogger.debug(buff);
            RacFileCreator.mergeMakeActions(oracleHomePath, cookedPatchID, patchObjects);
        }
        catch (IOException e3) {
            buff = new StringBuffer("createMPFinal() failed to generate final make file: ");
            buff.append(e3.getMessage());
            OLogger.debug(buff);
            throw e3;
        }
    }

    public static void cleanupPatchUnzipArea() {
        try {
            String path = OPatchEnv.getPatchUnzipLocation();
            if (path != null && !path.equals("")) {
                StringBuffer buff = new StringBuffer("Cleaning up the directory : \"");
                buff.append(path);
                buff.append("\"...");
                OLogger.debug(buff);
                OPatchSessionHelper.deleteRecurse(path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void cleanupUnzipActionArea() {
        try {
            String path = OPatchEnv.getUnzipActionLocation();
            if (path != null && !path.equals("")) {
                StringBuffer buff = new StringBuffer("Cleaning up the directory : \"");
                buff.append(path);
                buff.append("\"...");
                OLogger.debug(buff);
                OPatchSessionHelper.deleteRecurse(path);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void deleteRecurse(String pathToBeDeleted) {
        if (pathToBeDeleted == null || pathToBeDeleted.length() == 0 || pathToBeDeleted.equals("") || !pathToBeDeleted.matches("(.*).patch_storage(.*)")) {
            OLogger.printlnOnLogAndVerbose(" Cannot delete as either pathToBeDeleted is empty or it does not contain .patch_storage :" + pathToBeDeleted);
            return;
        }
        boolean ok = true;
        StringBuffer tmpSb = new StringBuffer();
        Path fpToBeDeleted = WrapperFactory.getNioServiceWrapper().getPath(pathToBeDeleted, new String[0]);
        if (!Files.exists(fpToBeDeleted, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(fpToBeDeleted, new LinkOption[0])) {
            if (!OPatchEnv.isReport()) {
                try {
                    Files.deleteIfExists(fpToBeDeleted);
                }
                catch (IOException e2) {
                    ok = false;
                }
            }
            if (!ok) {
                OLogger.printlnOnLogAndVerbose("File \"" + pathToBeDeleted + "\" could not be deleted");
            } else {
                OLogger.printlnOnLogAndVerbose("Deleted the file \"" + pathToBeDeleted + "\"");
            }
            return;
        }
        if (Files.isDirectory(fpToBeDeleted, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(fpToBeDeleted);){
                for (Path lfiles : stream) {
                    tmpSb = new StringBuffer(fpToBeDeleted.toString());
                    tmpSb.append(File.separator);
                    tmpSb.append(lfiles.getFileName().toString());
                    OPatchSessionHelper.deleteRecurse(tmpSb.toString());
                }
            }
            catch (IOException e3) {
                OLogger.debug(e3.getMessage());
            }
            if (!OPatchEnv.isReport()) {
                try {
                    Files.deleteIfExists(fpToBeDeleted);
                }
                catch (IOException e4) {
                    ok = false;
                }
            }
            if (!ok) {
                OLogger.printlnOnLogAndVerbose("Directory \"" + pathToBeDeleted + "\" could not be deleted (FAILURE)");
            }
            return;
        }
    }

    public static void emptyDirectory(String pathToBeDeleted, boolean isRoot, List filter) {
        boolean ok = true;
        StringBuffer tmpSb = new StringBuffer();
        Path fpToBeDeleted = WrapperFactory.getNioServiceWrapper().getPath(pathToBeDeleted, new String[0]);
        if (!Files.exists(fpToBeDeleted, new LinkOption[0])) {
            return;
        }
        if (!Files.isDirectory(fpToBeDeleted, new LinkOption[0])) {
            try {
                Files.deleteIfExists(fpToBeDeleted);
            }
            catch (IOException e2) {
                ok = false;
            }
            if (!ok) {
                OLogger.printlnOnLogAndVerbose("File \"" + pathToBeDeleted + "\" could not be deleted");
            } else {
                OLogger.printlnOnLogAndVerbose("Deleted the file \"" + pathToBeDeleted + "\"");
            }
            return;
        }
        if (Files.isDirectory(fpToBeDeleted, new LinkOption[0])) {
            if (!filter.contains(fpToBeDeleted.getFileName().toString())) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(fpToBeDeleted);){
                    for (Path entry : stream) {
                        tmpSb = new StringBuffer(fpToBeDeleted.toString());
                        tmpSb.append(File.separator);
                        tmpSb.append(entry.getFileName().toString());
                        OPatchSessionHelper.emptyDirectory(tmpSb.toString(), false, filter);
                    }
                }
                catch (IOException e3) {
                    OLogger.debug(e3.getMessage());
                }
                if (!isRoot) {
                    try {
                        Files.deleteIfExists(fpToBeDeleted);
                    }
                    catch (IOException e4) {
                        ok = false;
                    }
                }
                if (!ok) {
                    OLogger.printlnOnLogAndVerbose("Directory \"" + pathToBeDeleted + "\" could not be deleted (FAILURE)");
                } else if (!isRoot) {
                    // empty if block
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void runRollbackPrereqs(String oracleHomePath, PatchObject[] rbPatchObjects) throws PrereqFailedException {
        int i2;
        StringBuffer buff = new StringBuffer();
        OneOffEntry[] rbOneOffs = new OneOffEntry[rbPatchObjects.length];
        for (int i22 = 0; i22 < rbPatchObjects.length; ++i22) {
            rbOneOffs[i22] = rbPatchObjects[i22].toOneOffEntry(oracleHomePath);
        }
        OLogger.printlnOnLog("\nRunning prerequisite checks...");
        if (Rules.SystemWrite_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckForInputValues\" ...");
            PrereqResult chkRes = PrereqAPI.checkForInputValues(oracleHomePath, rbOneOffs);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, chkRes);
            if (chkRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || chkRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(35);
                buff = new StringBuffer("Prerequisite check \"CheckForInputValues\" failed.");
                buff.append(chkRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException prereqFailedException = new PrereqFailedException("Prerequisite check \"CheckForInputValues\" failed.");
                throw prereqFailedException;
            }
            OLogger.log(OLogger.FINE, "Input values is present for the all the actions of the given patches.");
        }
        if (Rules.SystemWrite_continue() && OPatchSessionHelper.hasHotPatch(new PrereqSet(rbOneOffs))) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckDBInstanceUp\" ...");
            PrereqResult chkRes = PrereqAPI.checkDBInstanceUp(oracleHomePath, false);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_DB_INSTANCE_UP, chkRes);
            if (chkRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || chkRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(36);
                buff = new StringBuffer("Prerequisite check \"CheckDBInstanceUp\" failed.");
                buff.append(chkRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException prereqFailedException = new PrereqFailedException("Prerequisite check \"CheckDBInstanceUp\" failed.");
                throw prereqFailedException;
            }
            OLogger.log(OLogger.FINE, "The specified DB Instances are up and running.");
        }
        if (Rules.SystemWrite_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckSystemCommandAvailable\" ...");
            for (i2 = 0; i2 < rbPatchObjects.length; ++i2) {
                PrereqResult prereqResult = PrereqAPI.checkSystemCommandAvailable(oracleHomePath, rbPatchObjects[i2].toOneOffEntry(oracleHomePath), rbPatchObjects[i2].getExecutables(oracleHomePath));
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, prereqResult);
                if (prereqResult.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || prereqResult.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(37);
                    buff = new StringBuffer("Prerequisite check \"CheckSystemCommandAvailable\" failed.");
                    buff.append(prereqResult.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckSystemCommandAvailable\" failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "All the required system commands are present.");
            }
        }
        if (!(!Rules.SystemWrite_continue() || OPatchEnv.isCASFlow() || OPatchEnv.isOPATCH_NO_FUSER() || OPatchEnv.isOhInstanceUp() || OPatchEnv.isDBHome(oracleHomePath) && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1())) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckActiveFilesAndExecutables\" ...");
            for (i2 = 0; i2 < rbPatchObjects.length; ++i2) {
                if (rbPatchObjects[i2].isSkipActiveFilesCheck()) {
                    buff = new StringBuffer(rbPatchObjects[i2].getPatchID());
                    buff.append(" : Prerequisite 'checkActiveFilesAndExecutables' is skipped for this patch.");
                    OLogger.debug(buff);
                    continue;
                }
                PrereqResult prereqResult = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, rbPatchObjects[i2]);
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, prereqResult);
                if (prereqResult.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || prereqResult.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(41);
                    buff = new StringBuffer("Prerequisite check \"CheckActiveFilesAndExecutables\" failed.");
                    buff.append(prereqResult.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckActiveFilesAndExecutables\" failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "None of the executables are active.");
            }
        }
        if (Rules.OUIRead_continue() && Rules.SystemWrite_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckRollbackSid\"...");
            if (!OPatchEnv.isLocal()) {
                IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
                Rac.RacType racType = OPatchExternalFactory.getRac(oracleHomePath).getInstance(readServices);
                OPatchEnv.setLocalNode(racType.getLocalNode());
            }
            String[] dbSids = OPatchEnv.getDBSIDs();
            String[] stringArray = OPatchEnv.getDBNodes();
            String localNode = OPatchEnv.getLocalNode();
            HashSet<String> sidInfo = new HashSet<String>();
            for (int i3 = 0; dbSids != null && stringArray != null && i3 < dbSids.length; ++i3) {
                if (!stringArray[i3].equals(localNode) && !stringArray[i3].equals("")) continue;
                sidInfo.add(dbSids[i3]);
            }
            boolean isWarn = false;
            for (int i4 = 0; i4 < rbPatchObjects.length; ++i4) {
                if (!OPatchEnv.isRunSql() && !rbPatchObjects[i4].isOnlinePatch()) continue;
                OPatchEnv.setSIDSubsetValue("");
                PrereqResult sidCheck = PrereqAPI.checkRollbackSid(oracleHomePath, rbPatchObjects[i4], sidInfo, false);
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_ROLLBACK_SID, sidCheck);
                if (sidCheck.getResult() == PrereqResult.ExecuteStatus.FAILED || sidCheck.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    buff = new StringBuffer("Prerequisite check \"CheckRollbackSid\" failed.\n");
                    buff.append("\nPatch ID: " + rbPatchObjects[i4].getPatchID() + "\n");
                    buff.append(sidCheck.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckRollbackSid\" failed.");
                    throw pe;
                }
                String getSid = OPatchEnv.getSIDSubsetValue();
                if (getSid.equals("")) continue;
                OLogger.println("");
                OLogger.println("PatchID: " + rbPatchObjects[i4].getPatchID());
                if (rbPatchObjects[i4].isOnlinePatch()) {
                    OLogger.warn("OUI-67287", new Object[]{getSid});
                    isWarn = true;
                    continue;
                }
                OLogger.warn("OUI-67264", new Object[]{getSid});
                isWarn = true;
            }
            if (isWarn) {
                boolean yesNo = false;
                yesNo = OPatchEnv.isForce() ? OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer("")) : OPatchEnv.proceedWithOperationDefaultNo(new StringBuffer(""));
                if (!yesNo) {
                    PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckRollbackSid\" failed as per user request");
                    throw pe;
                }
                OPatchEnv.setSIDSubsetValue("");
            }
        }
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckRollbackable\" ...");
            PrereqResult fAppsResObj = null;
            fAppsResObj = PrereqAPI.checkRollbackableForFusionApps(oracleHomePath, rbPatchObjects);
            if (fAppsResObj.getResult() == PrereqResult.ExecuteStatus.FAILED || fAppsResObj.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(43);
                buff = new StringBuffer("Prerequisite check \"CheckRollbackable\" failed on input rollback patch list.");
                buff.append(fAppsResObj.toString());
                OLogger.println(buff.toString());
                PrereqFailedException prereqFailedException = new PrereqFailedException("\nPrerequisite check \"CheckRollbackable\" failed on input rollback patch list.");
                throw prereqFailedException;
            }
            OLogger.log(OLogger.FINE, "All the input rollback patches can be rolled back together.");
            for (PatchObject patchObject : rbPatchObjects) {
                OPatchSessionHelper.constructJarActionTree(patchObject, oracleHomePath);
            }
            PrereqResult prereqResult = PrereqAPI.checkRollbackable(oracleHomePath, rbPatchObjects);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_ROLLBACKABLE, prereqResult);
            if (prereqResult.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || prereqResult.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(43);
                buff = new StringBuffer("Prerequisite check \"CheckRollbackable\" failed.\n");
                buff.append("Possible causes are:\n");
                buff.append(" The patch can not be rolled back \n");
                buff.append(" No read or write permission to ORACLE_HOME/.patch _storage \n");
                buff.append(" The ORACLE_HOME/.patch_storage file may have been removed.");
                buff.append(prereqResult.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckRollbackable\" failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the actions of the given patches are rollbackable.");
        }
        if (Rules.OUIRead_continue()) {
            void var5_26;
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchRollbackDependents\" ...");
            String[] oneOffIDs = new String[rbPatchObjects.length];
            boolean bl = false;
            while (var5_26 < rbPatchObjects.length) {
                oneOffIDs[var5_26] = rbPatchObjects[var5_26].getPatchID();
                ++var5_26;
            }
            PrereqResult prereqResult = PrereqAPI.checkPatchRollbackDependents(oracleHomePath, oneOffIDs);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCH_ROLLBACK_DEPENDENTS, prereqResult);
            if (prereqResult.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || prereqResult.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(43);
                buff = new StringBuffer("Prerequisite check \"CheckPatchRollbackDependents\" failed.");
                buff.append(prereqResult.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckPatchRollbackDependents\" failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the required patch(es) are present in the Oracle Home.");
            int patchingModel = PatchingModel.returnModelCode(oracleHomePath);
            if (patchingModel == 2) {
                PrereqResult prereqResult2 = PrereqAPI.checkSupersetRollbacks(oracleHomePath, rbOneOffs);
                if (prereqResult2.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || prereqResult2.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(43);
                    buff = new StringBuffer("Prerequisite check \"CheckPatchSupersetRollbacks\" failed.");
                    buff.append(prereqResult2.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckPatchSupersetRollbacks\" failed.");
                    throw pe;
                }
                OLogger.log(OLogger.FINE, "There are no superset - subset combinations to be rolled back.");
            }
        }
        OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckMinimumOPatchVersion\" ...");
        PrereqResult pr = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, rbPatchObjects);
        OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, pr);
        if (pr.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            OPatchStateManagerFactory.getInstance().setErrorCode(31);
            buff = new StringBuffer("Prerequisite check \"CheckMinimumOPatchVersion\" failed.");
            buff.append(pr.toString());
            OLogger.println(buff.toString());
            throw new PrereqFailedException("Prerequisite check \"CheckMinimumOPatchVersion\" failed.");
        }
        OLogger.log(OLogger.FINE, "Prerequisite check \"CheckMinimumOPatchVersion\" passed.");
        if (!OPatchEnv.isOPatchSDKMode() && OLogger.isOPatchCmdLineMode() && OPatchEnv.getOOPStatus() && !OPatchEnv.isRestarted() && !PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
            try {
                OLogger.enableConsoleOutput();
                OLogger.printlnOnConsole("\n--------------------------------------------------------------------------------");
                if (OPatchEnv.getOOPStartMode().equals("OOP_cmd")) {
                    OLogger.printlnOnLog(OLogger.INFO, "Rollback:Lanching oop by -oop option");
                    OLogger.printlnOnConsole("Start OOP by -oop cmd.");
                } else if (OPatchEnv.getOOPStartMode().equals("OOP_prereq")) {
                    OLogger.printlnOnConsole("Start OOP by Prereq process.");
                }
                OLogger.printlnOnConsole("Launch OOP...\n");
                OPatchOOPHelper.launchOOP();
            }
            catch (IOException iOException) {
                throw new PrereqFailedException("Errors occured while launching OOP.", iOException);
            }
            catch (OPatchRestartException oPatchRestartException) {
                try {
                    OPatchOOPHelper.invokeOPatch(oPatchRestartException.getTempOracleHome(), oPatchRestartException.getTempOpatchHome(), oPatchRestartException.getTempJavaHome(), Arrays.asList(OPatchOOPHelper.getArgs()));
                    OPatch.exit(0);
                }
                catch (IOException e1) {
                    throw new PrereqFailedException("Errors occured while launching OOP.", e1);
                }
            }
        }
    }

    private static String checkIfSidAdditionForOnlinePatches(PatchObject[] apPatchObjects, HashSet sidInfo, OneOffEntry[] oneoffs, String oracleHomePath) {
        StringBuffer consMessage = new StringBuffer("");
        StringBuffer buff = new StringBuffer();
        String invokeUtil = "enableOnlinePatch";
        Properties onlineProp = OPatchSessionHelper.getOnlinePropertyFromFile(oracleHomePath);
        if (onlineProp == null) {
            return consMessage.toString();
        }
        for (int i2 = 0; i2 < apPatchObjects.length; ++i2) {
            if (!apPatchObjects[i2].isOnlinePatch()) continue;
            for (int j2 = 0; oneoffs != null && j2 < oneoffs.length; ++j2) {
                if (!oneoffs[j2].getCookedPatchID().equals(apPatchObjects[i2].getCookedPatchID())) continue;
                String patchID = apPatchObjects[i2].getPatchID();
                StringBuffer sidKey = new StringBuffer(patchID);
                sidKey.append("_ONLINE_SID");
                String appliedSid = onlineProp.getProperty(sidKey.toString());
                if (appliedSid == null) {
                    appliedSid = "";
                }
                HashSet<String> applySet = new HashSet<String>();
                if (appliedSid != null) {
                    StringTokenizer strTok = new StringTokenizer(appliedSid, ",");
                    while (strTok.hasMoreTokens()) {
                        String temp = strTok.nextToken();
                        applySet.add(temp);
                    }
                }
                if (sidInfo.size() == 0 || sidInfo.equals(applySet) || applySet.size() == 0) continue;
                buff = new StringBuffer(OLogger.getString("OUI-67288", new Object[]{apPatchObjects[i2].getPatchID(), appliedSid, invokeUtil}));
                consMessage.append(buff);
                consMessage.append("\n");
            }
        }
        return consMessage.toString();
    }

    private static String checkIfSidAddtionForSqlPatches(PatchObject[] apPatchObjects, HashSet sidInfo, OneOffEntry[] oneoffs, String oracleHomePath) {
        StringBuffer consMessage = new StringBuffer("");
        StringBuffer buff = new StringBuffer();
        String invokeUtil = "applySql";
        if (!OPatchEnv.isRunSql()) {
            return consMessage.toString();
        }
        block0: for (int i2 = 0; i2 < apPatchObjects.length; ++i2) {
            if (!apPatchObjects[i2].isSqlRelatedActions()) continue;
            for (int j2 = 0; oneoffs != null && j2 < oneoffs.length; ++j2) {
                if (!oneoffs[j2].getCookedPatchID().equals(apPatchObjects[i2].getCookedPatchID())) continue;
                String sqlPropertyFile = OPatchEnv.getSqlPropertyFilePath(oracleHomePath, apPatchObjects[i2].getCookedPatchID());
                Path f2 = WrapperFactory.getNioServiceWrapper().getPath(sqlPropertyFile, new String[0]);
                if (!Files.exists(f2, new LinkOption[0]) || !Files.isReadable(f2)) continue;
                Properties p2 = OPatchSessionHelper.getSqlPropertyFromFile(oracleHomePath, apPatchObjects[i2].getCookedPatchID());
                if (p2 == null) continue block0;
                boolean sqlpropValue = Boolean.valueOf(p2.getProperty("RUNSQL"));
                if (!sqlpropValue) continue;
                String appliedSid = p2.getProperty("SID");
                if (appliedSid == null) {
                    appliedSid = "";
                }
                HashSet<String> applySet = new HashSet<String>();
                StringTokenizer strTok = new StringTokenizer(appliedSid, ",");
                while (strTok.hasMoreTokens()) {
                    String temp = strTok.nextToken();
                    applySet.add(temp);
                }
                if (sidInfo.size() == 0 || sidInfo.equals(applySet)) continue;
                buff = new StringBuffer(OLogger.getString("OUI-67288", new Object[]{apPatchObjects[i2].getPatchID(), appliedSid, invokeUtil}));
                consMessage.append(buff);
                consMessage.append("\n");
            }
        }
        return consMessage.toString();
    }

    public static void checkIfSidAddition(String oracleHomePath, PatchObject[] apPatchObjects) throws RuntimeException {
        StringBuffer buff = new StringBuffer("checkIfSidAddition()");
        OLogger.debug(buff);
        String[] dbSids = OPatchEnv.getDBSIDs();
        String[] dbNodes = OPatchEnv.getDBNodes();
        String localNode = OPatchEnv.getLocalNode();
        HashSet<String> sidInfo = new HashSet<String>();
        for (int i2 = 0; dbSids != null && dbNodes != null && i2 < dbSids.length; ++i2) {
            if (!dbNodes[i2].equals(localNode) && !dbNodes[i2].equals("")) continue;
            sidInfo.add(dbSids[i2]);
        }
        OneOffEntry[] oneoffs = null;
        try {
            oneoffs = PrereqAPI.getInstalledOneOff(oracleHomePath);
        }
        catch (Throwable t) {
            OLogger.printStackTrace(t);
            RuntimeException rt = new RuntimeException(t.getMessage(), t);
            rt.setStackTrace(t.getStackTrace());
            throw rt;
        }
        StringBuffer consMessage = new StringBuffer("");
        String sqlError = OPatchSessionHelper.checkIfSidAddtionForSqlPatches(apPatchObjects, sidInfo, oneoffs, oracleHomePath);
        consMessage.append(sqlError);
        String onlineError = OPatchSessionHelper.checkIfSidAdditionForOnlinePatches(apPatchObjects, sidInfo, oneoffs, oracleHomePath);
        consMessage.append(onlineError);
        if (!consMessage.toString().equals("")) {
            throw new RuntimeException(consMessage.toString());
        }
    }

    public static void runAutoRollbackPrereqs(String oracleHomePath, OneOffEntry[] autorbOneOffs, PatchObject[] rbPatchObjects, OneOffEntry[] apOneOffs) throws PrereqFailedException {
        PrereqFailedException pe;
        PrereqResult result;
        int i2;
        StringBuffer buff = new StringBuffer();
        PrereqResult autoRollbackCheck = PrereqAPI.checkAutoRollbackablePatch(oracleHomePath, rbPatchObjects);
        OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_AUTO_ROLLBACK_PREREQS, autoRollbackCheck);
        if (autoRollbackCheck.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("Prerequisite check \"CheckAutoRollbackablePatch\" for auto-rollback patches failed.");
            buff.append(autoRollbackCheck.toString());
            OLogger.println(buff.toString());
            PrereqFailedException pe2 = new PrereqFailedException("Prerequisite check \"CheckAutoRollbackablePatch\" for auto-rollback patches failed.");
            throw pe2;
        }
        OLogger.log(OLogger.FINE, "All the patch(es) can be auto rolled back.");
        if (Rules.OUIRead_continue() && Rules.SystemWrite_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckRollbackSid\" on auto-rollback patches...");
            String[] dbSids = OPatchEnv.getDBSIDs();
            String[] dbNodes = OPatchEnv.getDBNodes();
            String localNode = OPatchEnv.getLocalNode();
            HashSet<String> sidInfo = new HashSet<String>();
            for (int i3 = 0; dbSids != null && dbNodes != null && i3 < dbSids.length; ++i3) {
                if (!dbNodes[i3].equals(localNode) && !dbNodes[i3].equals("")) continue;
                sidInfo.add(dbSids[i3]);
            }
            boolean isWarn = false;
            for (i2 = 0; i2 < rbPatchObjects.length; ++i2) {
                if (!OPatchEnv.isRunSql() && !rbPatchObjects[i2].isOnlinePatch()) continue;
                OPatchEnv.setSIDSubsetValue("");
                PrereqResult sidCheck = PrereqAPI.checkRollbackSid(oracleHomePath, rbPatchObjects[i2], sidInfo, false);
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_AUTO_ROLLBACK_PREREQS, sidCheck);
                if (sidCheck.getResult() == PrereqResult.ExecuteStatus.FAILED || sidCheck.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                    buff = new StringBuffer("Prerequisite check \"CheckRollbackSid\" failed.");
                    buff.append(sidCheck.toString());
                    OLogger.println(buff.toString());
                    PrereqFailedException pe3 = new PrereqFailedException("Prerequisite check \"CheckRollbackSid\" failed.");
                    throw pe3;
                }
                String getSid = OPatchEnv.getSIDSubsetValue();
                if (getSid.equals("")) continue;
                OLogger.println("");
                OLogger.println("PatchID: " + rbPatchObjects[i2].getPatchID());
                if (rbPatchObjects[i2].isOnlinePatch()) {
                    OLogger.warn("OUI-67287", new Object[]{getSid});
                    isWarn = true;
                    continue;
                }
                OLogger.warn("OUI-67264", new Object[]{getSid});
                isWarn = true;
            }
            if (isWarn) {
                boolean yesNo = false;
                yesNo = OPatchEnv.isForce() ? OPatchEnv.proceedWithOperationDefaultYes(new StringBuffer("")) : OPatchEnv.proceedWithOperationDefaultNo(new StringBuffer(""));
                if (!yesNo) {
                    PrereqFailedException pe4 = new PrereqFailedException("Prerequisite check \"CheckRollbackSid\" on auto-rollback failed as per user request");
                    throw pe4;
                }
                OPatchEnv.setSIDSubsetValue("");
            }
        }
        if (Rules.OUIRead_continue() && Rules.SystemWrite_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckRollbackable\" on auto-rollback patches ...");
            PrereqResult applicableRes = PrereqAPI.checkRollbackable(oracleHomePath, rbPatchObjects);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_AUTO_ROLLBACK_PREREQS, applicableRes);
            if (applicableRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || applicableRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("Prerequisite check \"CheckRollbackable\" on auto-rollback patches failed.");
                buff.append(applicableRes.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe5 = new PrereqFailedException("Prerequisite check \"CheckRollbackable\" on auto-rollback patches failed.");
                throw pe5;
            }
            OLogger.log(OLogger.FINE, "All the actions of the given patches are rollbackable.");
        }
        if (Rules.OUIRead_continue() && autorbOneOffs != null && autorbOneOffs.length > 0) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchRollbackDependents\" for auto-rollback patches ...");
            String[] oneOffIDs = new String[autorbOneOffs.length];
            for (int i4 = 0; i4 < autorbOneOffs.length; ++i4) {
                oneOffIDs[i4] = autorbOneOffs[i4].getID();
            }
            result = PrereqAPI.checkPatchRollbackDependents(oracleHomePath, oneOffIDs);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_AUTO_ROLLBACK_PREREQS, result);
            if (result.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || result.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("Prerequisite check \"CheckPatchRollbackDependents\" for auto-rollback patches failed.");
                buff.append(result.toString());
                OLogger.println(buff.toString());
                pe = new PrereqFailedException("Prerequisite check \"CheckPatchRollbackDependents\" for auto-rollback patches failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the required patch(es) are present in the Oracle Home.");
        }
        OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckMinimumOPatchVersion\" ...");
        PrereqResult pr2 = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, rbPatchObjects);
        OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCH_ROLLBACK_DEPENDENTS, pr2);
        if (pr2.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            buff = new StringBuffer("Prerequisite check \"CheckMinimumOPatchVersion\" failed.");
            buff.append(pr2.toString());
            OLogger.println(buff.toString());
            throw new PrereqFailedException("Prerequisite check \"CheckMinimumOPatchVersion\" failed.");
        }
        OLogger.log(OLogger.FINE, "Prerequisite check \"CheckMinimumOPatchVersion\" passed.");
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchApplyDependents\" ...");
            result = PrereqAPI.checkPatchApplyDependents(oracleHomePath, apOneOffs);
            if (result.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || result.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("Prerequisite check \"CheckPatchApplyDependents\" failed.");
                buff.append(result.toString());
                OLogger.println(buff.toString());
                pe = new PrereqFailedException("Prerequisite check \"CheckPatchApplyDependents\" failed.");
                throw pe;
            }
            StringBuffer wlsMsg = new StringBuffer("\n");
            StringBuffer wlsOneOff = new StringBuffer(" ");
            boolean hasMissingWlsPrereqs = false;
            for (i2 = 0; i2 < apOneOffs.length; ++i2) {
                WLSPatch[] wp = apOneOffs[i2].getWlsPrereqPatchIDs();
                boolean curRndMissing = false;
                wlsOneOff = new StringBuffer(" ");
                for (int j2 = 0; wp != null && j2 < wp.length; ++j2) {
                    if (wp[j2].isRequired() || !wp[j2].isMissing()) continue;
                    hasMissingWlsPrereqs = true;
                    curRndMissing = true;
                    wlsOneOff.append(wp[j2].getPatchID() + " ");
                }
                if (!curRndMissing) continue;
                wlsMsg.append("The patch [ " + apOneOffs[i2].getID() + " ] " + "needs optional WLS patch(es) [" + wlsOneOff.toString() + "] that are not installed.");
                wlsMsg.append("\n");
            }
            if (hasMissingWlsPrereqs) {
                StringBuffer informMsg = new StringBuffer();
                informMsg.append(wlsMsg);
                boolean YesNo = OPatchEnv.proceedWithOperationDefaultYes(informMsg);
                if (!YesNo) {
                    throw new RuntimeException("");
                }
            }
            ArrayList<String> prereqIds = new ArrayList<String>();
            for (int i5 = 0; i5 < apOneOffs.length; ++i5) {
                String[] pOneOffs = apOneOffs[i5].getPrereqPatchIDs();
                for (int c2 = 0; c2 < pOneOffs.length; ++c2) {
                    prereqIds.add(pOneOffs[c2]);
                }
            }
            String[] prereqOneOffs = new String[prereqIds.size()];
            prereqIds.toArray(prereqOneOffs);
            StringBuffer commonIDs = new StringBuffer();
            boolean foundCommon = false;
            for (int j3 = 0; j3 < prereqOneOffs.length; ++j3) {
                for (int k2 = 0; k2 < autorbOneOffs.length; ++k2) {
                    if (!prereqOneOffs[j3].equals(autorbOneOffs[k2].getID())) continue;
                    foundCommon = true;
                    commonIDs.append(prereqOneOffs[j3]);
                    commonIDs.append(" ");
                }
                if (foundCommon) {
                    OLogger.println("The following prerequisite patch(es) are having conflicts or are subsets of the given patch(es). Please contact Oracle Support Services.");
                    OLogger.println(commonIDs.toString());
                    PrereqFailedException pe6 = new PrereqFailedException("Prerequisite check \"CheckPatchApplyDependents\" failed.");
                    throw pe6;
                }
                OLogger.log(OLogger.FINE, "All the required patch(es) are present in the Oracle Home.");
            }
        }
    }

    public static void runApplyPrereqs(String oracleHomePath, OneOffEntry[] apOneOffs, PatchObject[] apPatchObjects, String[] apPatchLocs) throws PrereqFailedException, FailedPrereqException {
        PrereqResult chkRes;
        StringBuffer buff = new StringBuffer();
        OLogger.printlnOnLog("\nRunning prerequisite checks...");
        if (Rules.OUIRead_continue()) {
            PrereqResult fAppsCompat;
            PrereqResult pr2;
            PrereqResult pr1;
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckMinimumOPatchVersion\" ...");
            if (OPatchSessionHelper.isCASReportSDK()) {
                pr1 = PQSession.checkMinimumOpatchVersionAndPrint(oracleHomePath);
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, pr1);
            } else {
                pr1 = PrereqAPI.checkOPatchMinVersionRequirement(oracleHomePath, apPatchObjects);
            }
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, pr1);
            if (pr1.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("Prerequisite check \"CheckMinimumOPatchVersion\" failed.");
                buff.append(pr1.toString());
                OLogger.println(buff.toString());
                OPatchStateManagerFactory.getInstance().setErrorCode(31);
                throw new PrereqFailedException("Prerequisite check \"CheckMinimumOPatchVersion\" failed.");
            }
            OLogger.log(OLogger.FINE, "Prerequisite check \"CheckMinimumOPatchVersion\" passed.");
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchingModel\" ...");
            if (OPatchSessionHelper.isCASReportSDK()) {
                pr2 = PQSession.checkPatchingModelAndPrint(oracleHomePath);
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_PATCHING_MODEL, pr2);
            } else {
                pr2 = PrereqAPI.checkPatchingModel(oracleHomePath, apPatchObjects);
            }
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCHING_MODEL, pr2);
            if (pr2.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                buff = new StringBuffer("Prerequisite check \"CheckPatchingModel\" failed.");
                buff.append(pr2.toString());
                OLogger.println(buff.toString());
                OPatchStateManagerFactory.getInstance().setErrorCode(32);
                throw new PrereqFailedException("Prerequisite check \"CheckPatchingModel\" failed.");
            }
            OLogger.log(OLogger.FINE, "Prerequisite check \"CheckPatchingModel\" passed.");
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchsetUpdateCompatible\" ...");
            PrereqResult patchsetCompat = PrereqAPI.checkPatchsetUpdateCompatible(oracleHomePath, apPatchObjects);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPATIBLE, patchsetCompat);
            if (patchsetCompat.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(33);
                buff = new StringBuffer("Prerequisite check \"CheckPatchsetUpdateCompatible\" failed.");
                buff.append(patchsetCompat.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckPatchsetUpdateCompatible\" failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the Patch Set Updates are compatible.");
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchsetUpdateComponents\" ...");
            PrereqResult updateCompResult = PrereqAPI.checkPatchsetUpdateComponents(oracleHomePath, apPatchObjects);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCHSET_UPDATE_COMPONENTS, updateCompResult);
            if (updateCompResult.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(33);
                buff = new StringBuffer("Prerequisite check \"CheckPatchsetUpdateComponents\" failed.");
                buff.append(updateCompResult.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckPatchsetUpdateComponents\" failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "All the Patchset Updates have proper components to be upgraded..");
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckFusionAppsCompatible\" ...");
            if (OPatchSessionHelper.isCASReportSDK()) {
                fAppsCompat = PQSession.checkFusionAppsCompatibleAndPrint(oracleHomePath);
                OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_IF_OUI_FUSION_APPLICATIONS_COMPATIBLE, fAppsCompat);
            } else {
                fAppsCompat = PrereqAPI.checkFusionAppsCompatible(oracleHomePath);
            }
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_IF_OUI_FUSION_APPLICATIONS_COMPATIBLE, fAppsCompat);
            if (fAppsCompat.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(34);
                buff = new StringBuffer("Prerequisite check \"CheckFusionAppsCompatible\" failed.");
                buff.append(fAppsCompat.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"CheckFusionAppsCompatible\" failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "OPatch is compatible with OUI for Fusion Apps patching.");
        }
        boolean errFlag = false;
        StringBuffer errBuff = new StringBuffer();
        if (Rules.SystemWrite_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckForInputValues\" ...");
            chkRes = PrereqAPI.checkForInputValues(oracleHomePath, apOneOffs);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, chkRes);
            if (chkRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || chkRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(35);
                buff = new StringBuffer("Prerequisite check \"CheckForInputValues\" failed.");
                buff.append(chkRes.toString());
                OLogger.println(buff.toString());
                errFlag = true;
                errBuff.append("Prerequisite check \"CheckForInputValues\" failed.");
            } else {
                OLogger.log(OLogger.FINE, "Input values is present for the all the actions of the given patches.");
            }
        }
        if (Rules.SystemWrite_continue() && OPatchSessionHelper.hasHotPatch(new PrereqSet(apOneOffs))) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckDBInstanceUp\" ...");
            chkRes = PrereqAPI.checkDBInstanceUp(oracleHomePath, true);
            OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_DB_INSTANCE_UP, chkRes);
            if (chkRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || chkRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(36);
                buff = new StringBuffer("Prerequisite check \"CheckDBInstanceUp\" failed.");
                buff.append(chkRes.toString());
                OLogger.println(buff.toString());
                errFlag = true;
                errBuff.append("\nPrerequisite check \"CheckDBInstanceUp\" failed.");
            } else {
                OLogger.log(OLogger.FINE, "The specified DB Instances are up and running.");
            }
        }
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckSystemSpace\" ...");
            if (OPatchEnv.isOPATCH_SKIP_VERIFY_SPACE()) {
                OLogger.log(OLogger.FINE, "Skip checking for system space.");
            } else {
                PrereqResult sysSpaceRes;
                if (OPatchSessionHelper.isCASReportSDK()) {
                    try {
                        sysSpaceRes = PQSession.checkSystemSpaceAndPrint(oracleHomePath);
                    }
                    catch (Throwable e2) {
                        sysSpaceRes = PrereqResult.getPrereqResult(PrereqResult.ExecuteStatus.NOT_EXECUTED, e2.getMessage());
                    }
                    OUSession.addApplyPrereqResult(OPatchPatchPrereq.CHECK_SYSTEM_SPACE, sysSpaceRes);
                } else {
                    sysSpaceRes = PrereqAPI.checkSystemSpace(oracleHomePath, apOneOffs, apPatchLocs);
                }
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_SYSTEM_SPACE, sysSpaceRes);
                if (sysSpaceRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || sysSpaceRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    buff = new StringBuffer("Prerequisite check \"CheckSystemSpace\" failed.");
                    buff.append(sysSpaceRes.toString());
                    OLogger.println(buff.toString());
                    errFlag = true;
                    errBuff.append("\nPrerequisite check \"CheckSystemSpace\" failed.");
                } else {
                    OLogger.log(OLogger.FINE, "Enough system space is available.");
                }
            }
        }
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckSystemCommandAvailable\" ...");
            if (OPatchSessionHelper.isCASReportSDK()) {
                try {
                    ArrayList combinedStatus = PQSession.checkSystemCommandAvailableAndPrint(oracleHomePath);
                    OUSession.addPrereqResultArray(OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, combinedStatus);
                }
                catch (Throwable t) {
                    OPatchTarget.StatusCheck checkResult = new OPatchTarget.StatusCheck(2, t.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, checkResult);
                }
            } else {
                for (int i2 = 0; i2 < apOneOffs.length; ++i2) {
                    PrereqResult sysCmdRes = PrereqAPI.checkSystemCommandAvailable(oracleHomePath, apOneOffs[i2], apPatchObjects[i2].getExecutables(oracleHomePath));
                    OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, sysCmdRes);
                    if (sysCmdRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || sysCmdRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                        OPatchStateManagerFactory.getInstance().setErrorCode(37);
                        buff = new StringBuffer("Prerequisite check \"CheckSystemCommandAvailable\" failed.");
                        buff.append(sysCmdRes.toString());
                        OLogger.println(buff.toString());
                        errFlag = true;
                        errBuff.append("\nPrerequisite check \"CheckSystemCommandAvailable\" failed.");
                        continue;
                    }
                    OLogger.log(OLogger.FINE, "All the required system commands are present.");
                }
            }
        }
        if (errFlag) {
            throw new PrereqFailedException(errBuff.toString());
        }
        boolean isDbhome = OPatchEnv.isDBHome(oracleHomePath);
        if (!(!Rules.OUIRead_continue() || OPatchEnv.isOhInstanceUp() || isDbhome && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1())) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchApplicableOnCurrentPlatform\" ...");
            if (OPatchSessionHelper.isCASReportSDK()) {
                try {
                    ArrayList resultArray = PQSession.checkPatchApplicableOnCurrentPlatformAndPrint(oracleHomePath);
                    OUSession.addPrereqResultArray(OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, resultArray);
                }
                catch (Throwable t) {
                    OPatchTarget.StatusCheck checkResult = new OPatchTarget.StatusCheck(2, t.getMessage());
                    OUSession.addApplyPrereqResultStatus(OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, checkResult);
                }
            } else {
                PrereqResult platRes = PrereqAPI.checkPatchApplicableOnCurrentPlatform(oracleHomePath, apPatchObjects);
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, platRes);
                if (platRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || platRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(38);
                    buff = new StringBuffer("Prerequisite check \"CheckPatchApplicableOnCurrentPlatform\" failed.");
                    buff.append(platRes.toString());
                    OLogger.println(buff.toString());
                    errFlag = true;
                    errBuff.append("Prerequisite check \"CheckPatchApplicableOnCurrentPlatform\" failed.");
                } else {
                    OLogger.log(OLogger.FINE, "All the given patches are applicable on the current platform.");
                }
            }
        }
        if (!(!Rules.OUIRead_continue() || OPatchEnv.isOhInstanceUp() || isDbhome && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1())) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckApplicable\" ...");
            boolean applicableFlag = true;
            buff = new StringBuffer("");
            for (int pIter = 0; pIter < apPatchObjects.length; ++pIter) {
                PatchObject patchObject = apPatchObjects[pIter];
                OPatchSessionHelper.constructJarActionTree(patchObject, oracleHomePath, new HashSet());
                PrereqResult applicableRes = PrereqAPI.checkApplicable(oracleHomePath, new PatchObject[]{patchObject});
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, applicableRes);
                if (applicableRes.getResult() != PrereqResult.ExecuteStatus.NOT_EXECUTED && applicableRes.getResult() != PrereqResult.ExecuteStatus.FAILED) continue;
                applicableFlag = false;
                buff.append(applicableRes.toString());
            }
            if (applicableFlag) {
                OLogger.log(OLogger.FINE, "All the components & actions of the given patches are applicable.");
            } else {
                StringBuffer finalErrorBuff = new StringBuffer("Prerequisite check \"CheckApplicable\" failed.");
                finalErrorBuff.append(buff.toString());
                OLogger.println(finalErrorBuff.toString());
                errFlag = true;
                errBuff.append("\nPrerequisite check \"CheckApplicable\" failed.");
            }
        }
        if (errFlag) {
            OPatchStateManagerFactory.getInstance().setErrorCode(39);
            throw new PrereqFailedException(errBuff.toString());
        }
        if (Rules.OUIRead_continue()) {
            PrereqResult autoRollbackResult = PrereqAPI.checkConflictWithPatchsetUpdate(oracleHomePath, apPatchObjects, OPatchEnv.getSessionType());
            if (autoRollbackResult.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                OPatchStateManagerFactory.getInstance().setErrorCode(40);
                buff = new StringBuffer("Prerequisite check \"checkConflictWithPatchsetUpdate\" failed.");
                buff.append(autoRollbackResult.toString());
                OLogger.println(buff.toString());
                PrereqFailedException pe = new PrereqFailedException("Prerequisite check \"checkConflictWithPatchsetUpdate\" failed.");
                throw pe;
            }
            OLogger.log(OLogger.FINE, "No auto-rollback of Patchset Updates due to oneoffs has been checked.");
        }
        if (!(!Rules.SystemWrite_continue() || OPatchEnv.isOPATCH_NO_FUSER() || OPatchEnv.isOhInstanceUp() || isDbhome && OPatchEnv.isCASFlow() && OPatchEnv.isCASPhase1())) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckActiveFilesAndExecutables\" ...");
            for (int i3 = 0; i3 < apPatchObjects.length; ++i3) {
                if (apPatchObjects[i3].isSkipActiveFilesCheck()) {
                    buff = new StringBuffer(apPatchObjects[i3].getPatchID());
                    buff.append(" : Prerequisite 'checkActiveFilesAndExecutables' is skipped for this patch.");
                    OLogger.debug(buff);
                    continue;
                }
                PrereqResult activeFilesRes = PrereqAPI.checkActiveFilesAndExecutables(oracleHomePath, apPatchObjects[i3]);
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, activeFilesRes);
                if (activeFilesRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || activeFilesRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(41);
                    buff = new StringBuffer("Prerequisite check \"CheckActiveFilesAndExecutables\" failed.");
                    buff.append(activeFilesRes.toString());
                    OLogger.println(buff.toString());
                    errFlag = true;
                    errBuff.append("Prerequisite check \"CheckActiveFilesAndExecutables\" failed.");
                    continue;
                }
                OLogger.log(OLogger.FINE, "None of the executables are active.");
            }
        }
        if (Rules.OUIRead_continue()) {
            OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckPatchApplyDependents\" ...");
            if (OPatchSessionHelper.isCASReportSDK()) {
                String beaHomePath = OPatchEnv.getBeaHomePath();
                if (beaHomePath != null && !beaHomePath.equals("")) {
                    Path f2 = null;
                    try {
                        f2 = WrapperFactory.getNioServiceWrapper().getPath(beaHomePath, new String[0]);
                    }
                    catch (NullPointerException e3) {
                        RuntimeException oe = new RuntimeException("Argument for BEA Home is null", e3);
                        oe.setStackTrace(e3.getStackTrace());
                        throw oe;
                    }
                    if (f2.isAbsolute() && Files.isDirectory(f2, new LinkOption[0]) && Files.isReadable(f2)) {
                        OPatchEnv.setBeaHomePath(beaHomePath);
                        OPatchEnv.setBeaHome(true);
                    } else {
                        throw new RuntimeException("Invalid argument beaHomePath. Possible causes are: beaHomePath is not an absolute path, beaHomePath is not a path to a directory, beaHomePath is not readable. ");
                    }
                }
                ArrayList resultArray = PQSession.checkPatchApplyDependentsAndPrint(oracleHomePath);
                OUSession.addPrereqResultArray(OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS, resultArray);
            } else {
                PrereqResult result = PrereqAPI.checkPatchApplyDependents(oracleHomePath, apOneOffs);
                OUSession.addPrereqResultToReport(OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS, result);
                if (result.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED || result.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                    OPatchStateManagerFactory.getInstance().setErrorCode(42);
                    buff = new StringBuffer("Prerequisite check \"CheckPatchApplyDependents\" failed.");
                    buff.append(result.toString());
                    OLogger.println(buff.toString());
                    errFlag = true;
                    errBuff.append("Prerequisite check \"CheckPatchApplyDependents\" failed.");
                } else {
                    StringBuffer wlsMsg = new StringBuffer("\n");
                    StringBuffer wlsOneOff = new StringBuffer(" ");
                    boolean hasMissingWlsPrereqs = false;
                    for (int i4 = 0; i4 < apOneOffs.length; ++i4) {
                        WLSPatch[] wp = apOneOffs[i4].getWlsPrereqPatchIDs();
                        boolean curRndMissing = false;
                        wlsOneOff = new StringBuffer(" ");
                        for (int j2 = 0; wp != null && j2 < wp.length; ++j2) {
                            if (wp[j2].isRequired() || !wp[j2].isMissing()) continue;
                            hasMissingWlsPrereqs = true;
                            curRndMissing = true;
                            wlsOneOff.append(wp[j2].getPatchID() + " ");
                        }
                        if (!curRndMissing) continue;
                        wlsMsg.append("The patch [ " + apOneOffs[i4].getID() + " ] " + "needs optional WLS patch(es) [" + wlsOneOff.toString() + "] that are not installed.");
                        wlsMsg.append("\n");
                    }
                    if (hasMissingWlsPrereqs) {
                        StringBuffer informMsg = new StringBuffer();
                        informMsg.append(wlsMsg);
                        boolean YesNo = OPatchEnv.proceedWithOperationDefaultYes(informMsg);
                        if (!YesNo) {
                            throw new RuntimeException("");
                        }
                    } else {
                        OLogger.log(OLogger.FINE, "All the required patch(es) are present in the Oracle Home.");
                    }
                }
            }
        }
        OLogger.log(OLogger.FINE, "\nRunning prerequisite check \"CheckMultipleTranslationPatches\" ...");
        if (errFlag) {
            throw new PrereqFailedException(errBuff.toString());
        }
        if (!OPatchEnv.isOPatchSDKMode() && OLogger.isOPatchCmdLineMode() && OPatchEnv.getOOPStatus() && !OPatchEnv.isRestarted() && !PatchingFlow.CAS_REPO.equals((Object)OPatchEnv.getPatchingFlow())) {
            try {
                OLogger.enableConsoleOutput();
                OLogger.printlnOnConsole("\n--------------------------------------------------------------------------------");
                if (OPatchEnv.getOOPStartMode().equals("OOP_cmd")) {
                    OLogger.printlnOnLog(OLogger.INFO, "Apply:Lanching oop by -oop option");
                    OLogger.printlnOnConsole("Start OOP by -oop cmd.");
                } else if (OPatchEnv.getOOPStartMode().equals("OOP_prereq")) {
                    OLogger.printlnOnConsole("Start OOP by Prereq process.");
                }
                OLogger.printlnOnConsole("Launch OOP...\n");
                OPatchOOPHelper.launchOOP();
            }
            catch (IOException e4) {
                throw new FailedPrereqException(e4.getMessage());
            }
            catch (OPatchRestartException e5) {
                try {
                    OPatchOOPHelper.invokeOPatch(e5.getTempOracleHome(), e5.getTempOpatchHome(), e5.getTempJavaHome(), Arrays.asList(OPatchOOPHelper.getArgs()));
                    OPatch.exit(0);
                }
                catch (IOException e1) {
                    throw new FailedPrereqException(e1.getMessage());
                }
            }
        }
    }

    public static boolean hasMiniPatchset(PrereqSet patches) {
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (!oneoff.isMiniPatchSet()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNormalOneoffs(PrereqSet patches) {
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (oneoff.isMiniPatchSet()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHotPatch(PrereqSet patches) {
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (!oneoff.isOnlinePatch()) continue;
            return true;
        }
        return false;
    }

    public static boolean hasNonHotPatch(PrereqSet patches) {
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (oneoff.isOnlinePatch()) continue;
            return true;
        }
        return false;
    }

    public static String getMiniPatchSetIDs(PrereqSet patches) {
        StringBuffer str = new StringBuffer();
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (!oneoff.isMiniPatchSet()) continue;
            str.append(" ");
            str.append(patches.getElement(i2).getID());
        }
        return str.toString();
    }

    public static String getNonMiniPatchSetIDs(PrereqSet patches) {
        StringBuffer str = new StringBuffer();
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (oneoff.isMiniPatchSet()) continue;
            str.append(" ");
            str.append(patches.getElement(i2).getID());
        }
        return str.toString();
    }

    public static String getHotPatchIDs(PrereqSet patches) {
        StringBuffer str = new StringBuffer();
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (!oneoff.isOnlinePatch()) continue;
            str.append(" ");
            str.append(patches.getElement(i2).getID());
        }
        return str.toString();
    }

    public static String getPatchIDs(PrereqSet patches) {
        StringBuffer str = new StringBuffer();
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            str.append(" ");
            str.append(patches.getElement(i2).getID());
        }
        return str.toString();
    }

    public static String getNonHotPatchIDs(PrereqSet patches) {
        StringBuffer str = new StringBuffer();
        for (int i2 = 0; i2 < patches.size(); ++i2) {
            OneOffEntry oneoff = patches.getElement(i2);
            if (oneoff.isOnlinePatch()) continue;
            str.append(" ");
            str.append(patches.getElement(i2).getID());
        }
        return str.toString();
    }

    public static OneOffEntry[] getCompleteDependentRollbackList(OneOffEntry[] oneOffs, OneOffEntry[] installedOneOffs) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getCompleteDependentRollbackList()");
        OLogger.debug(buff);
        ArrayList<OneOffEntry> finalList = new ArrayList<OneOffEntry>();
        ArrayList<OneOffEntry> intermediateList = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < oneOffs.length; ++i2) {
            intermediateList.add(oneOffs[i2]);
        }
        for (int ilIter = 0; ilIter < intermediateList.size(); ++ilIter) {
            OneOffEntry entry = (OneOffEntry)intermediateList.get(ilIter);
            OneOffEntry[] dependents = OPatchSessionHelper.getDependentOneOffs(entry, installedOneOffs);
            if (dependents.length == 1 && entry.getID().equals(dependents[0].getID())) {
                finalList.add(entry);
                continue;
            }
            for (int dIter = 0; dIter < dependents.length; ++dIter) {
                if (intermediateList.contains(dependents[dIter]) || finalList.contains(dependents[dIter])) continue;
                intermediateList.add(dependents[dIter]);
            }
            int size = intermediateList.size();
            intermediateList.remove(ilIter);
            if (size != 1 && size - 1 == ilIter) {
                --ilIter;
            }
            finalList.add(entry);
            if (--ilIter + 1 != intermediateList.size()) continue;
            ilIter = -1;
        }
        if (finalList.size() == 0) {
            RuntimeException re = new RuntimeException("Unable to determine the patch dependents.");
            throw re;
        }
        OneOffEntry[] returnOneOffs = new OneOffEntry[finalList.size()];
        finalList.toArray(returnOneOffs);
        return returnOneOffs;
    }

    public static OneOffEntry[] getCompleteDependentRollbackList(String oracleHomePath, String[] rbPatchObjects) throws RuntimeException {
        OneOffEntry[] installedOneOffs = null;
        try {
            IIPMReadServices readServices = PrereqSession.getReadServices(oracleHomePath);
            installedOneOffs = readServices.getInstalledPatchesIncludeInactive();
        }
        catch (Throwable t) {
            RuntimeException rt = new RuntimeException(t.getMessage(), t);
            rt.setStackTrace(t.getStackTrace());
            throw rt;
        }
        ArrayList<OneOffEntry> arrListOfOneOffs = new ArrayList<OneOffEntry>();
        block2: for (OneOffEntry installedOneOff : installedOneOffs) {
            for (String rbPatchObject : rbPatchObjects) {
                if (!rbPatchObject.equals(installedOneOff.getID())) continue;
                arrListOfOneOffs.add(installedOneOff);
                continue block2;
            }
        }
        OneOffEntry[] listOfOneOffs = arrListOfOneOffs.toArray(new OneOffEntry[arrListOfOneOffs.size()]);
        return OPatchSessionHelper.getCompleteDependentRollbackList(listOfOneOffs, installedOneOffs);
    }

    private static OneOffEntry[] getDependentOneOffs(OneOffEntry oneOff, OneOffEntry[] installedOneOffs) {
        ArrayList<OneOffEntry> dependents = new ArrayList<OneOffEntry>();
        for (int i2 = 0; i2 < installedOneOffs.length; ++i2) {
            String[] prereqOneOffIDs = installedOneOffs[i2].getPrereqPatchIDs();
            String[] overLayOneOffIDs = installedOneOffs[i2].getOverLayPatchIDs();
            String[] installedBugs = installedOneOffs[i2].getPrereqBugIDs();
            for (int j2 = 0; j2 < prereqOneOffIDs.length; ++j2) {
                if (!prereqOneOffIDs[j2].equals(oneOff.getID()) || dependents.contains(installedOneOffs[i2])) continue;
                dependents.add(installedOneOffs[i2]);
            }
            for (int k2 = 0; k2 < overLayOneOffIDs.length; ++k2) {
                if (!overLayOneOffIDs[k2].equals(oneOff.getID()) || dependents.contains(installedOneOffs[i2])) continue;
                dependents.add(installedOneOffs[i2]);
            }
            String[] rollbackBugList = oneOff.getBugIDsFixed();
            for (int l2 = 0; l2 < rollbackBugList.length; ++l2) {
                for (int m2 = 0; m2 < installedBugs.length; ++m2) {
                    if (!rollbackBugList[l2].equals(installedBugs[m2]) || dependents.contains(installedOneOffs[i2])) continue;
                    dependents.add(installedOneOffs[i2]);
                }
            }
        }
        OneOffEntry[] returnOneOffs = new OneOffEntry[dependents.size()];
        dependents.toArray(returnOneOffs);
        return returnOneOffs;
    }

    protected static boolean isIdentical(OneOffEntry o1, OneOffEntry o2) {
        return o1.equals(o2);
    }

    public static OneOffEntry[] sortForRollbackSnowballs(OneOffEntry[] oneoffs) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::sortForRollbackSnowballs()");
        OLogger.debug(buff);
        if (oneoffs == null || oneoffs.length == 0 || oneoffs.length == 1) {
            buff.append(" oneoffs is null or 0 or 1, so no sorting.");
            OLogger.debug(buff);
            return oneoffs;
        }
        Arrays.sort(oneoffs);
        return oneoffs;
    }

    public static PatchObject[] sortForApplySnowballs(PatchObject[] pObjs) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::sortForApplySnowballs()");
        if (pObjs == null || pObjs.length == 0 || pObjs.length == 1) {
            buff.append(" pObjs is null or 0 or 1, so no sorting.");
            OLogger.debug(buff);
            return pObjs;
        }
        ArrayList<PatchObject> pList = new ArrayList<PatchObject>();
        buff.append(" Given list - ");
        for (int pIter = 0; pIter < pObjs.length; ++pIter) {
            pList.add(pObjs[pIter]);
            buff.append("  ").append(pObjs[pIter].getPatchID());
        }
        OLogger.debug(buff);
        ArrayList newList = new ArrayList();
        ArrayList<PatchObject> transList = new ArrayList<PatchObject>();
        ArrayList<PatchObject> langList = new ArrayList<PatchObject>();
        ArrayList<PatchObject> otherList = new ArrayList<PatchObject>();
        ArrayList<PatchObject> singletonTransList = new ArrayList<PatchObject>();
        ArrayList<PatchObject> singletonOtherList = new ArrayList<PatchObject>();
        ArrayList<PatchObject> singletonLangList = new ArrayList<PatchObject>();
        for (int i2 = 0; i2 < pList.size(); ++i2) {
            PatchObject po = (PatchObject)pList.get(i2);
            if (po.isSnowballPatch() && po.getPatchInventory().isTranslatable()) {
                transList.add(po);
                continue;
            }
            if (po.isSnowballPatch() && !po.getPatchInventory().mayBeTranslation()) {
                otherList.add(po);
                continue;
            }
            if (po.isSnowballPatch() && po.getPatchInventory().mayBeTranslation()) {
                langList.add(po);
                continue;
            }
            if (!po.isSnowballPatch() && po.getPatchInventory().isTranslatable()) {
                singletonTransList.add(po);
                continue;
            }
            if (!po.isSnowballPatch() && !po.getPatchInventory().mayBeTranslation()) {
                singletonOtherList.add(po);
                continue;
            }
            singletonLangList.add(po);
        }
        newList.addAll(transList);
        newList.addAll(otherList);
        newList.addAll(langList);
        newList.addAll(singletonTransList);
        newList.addAll(singletonOtherList);
        newList.addAll(singletonLangList);
        PatchObject[] sortList = new PatchObject[newList.size()];
        buff = new StringBuffer("Sorted list (after snowball order) is : ");
        for (int i3 = 0; i3 < newList.size(); ++i3) {
            sortList[i3] = (PatchObject)newList.get(i3);
            buff.append(" ").append(sortList[i3].getPatchID());
        }
        OLogger.debug(buff);
        return sortList;
    }

    public static void groupCompositeByNeighbor(PatchObject[] sortedPatches) {
        int i2 = 0;
        int j2 = sortedPatches.length - 1;
        while (i2 < j2) {
            if (sortedPatches[i2].getIsComposite() && !sortedPatches[j2].getIsComposite()) {
                PatchObject temp = sortedPatches[j2];
                for (int k2 = j2; k2 > i2; --k2) {
                    sortedPatches[k2] = sortedPatches[k2 - 1];
                }
                sortedPatches[i2] = temp;
                ++i2;
                continue;
            }
            if (!sortedPatches[j2].getIsComposite()) {
                ++i2;
                continue;
            }
            --j2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static PatchObject[] sortOnOverlay(PatchObject[] pObjs, boolean forApply) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::sortOnOverlay()");
        if (pObjs == null || pObjs.length == 0 || pObjs.length == 1) {
            buff.append(" Sorting is not needed");
            OLogger.justlog(OLogger.INFO, new String(buff));
            return pObjs;
        }
        PatchObject[] ans = new PatchObject[pObjs.length];
        HashMap<String, PatchObject> patchMap = new HashMap<String, PatchObject>();
        buff.append(" Given list : ");
        for (PatchObject tObj : pObjs) {
            patchMap.put(tObj.getPatchID(), tObj);
            buff.append("  ").append(tObj.getPatchID());
        }
        OLogger.justlog(OLogger.INFO, new String(buff));
        HashMap<String, List<String>> patchGraph = new HashMap<String, List<String>>();
        HashMap<String, Integer> patchIndegree = new HashMap<String, Integer>();
        int rc = OPatchSessionHelper.buildPatchObjectGraph(patchGraph, patchIndegree, patchMap);
        if (rc == 0) {
            ans = pObjs;
        } else {
            HashMap<String, Integer> compositeIndegree = new HashMap<String, Integer>();
            HashMap<String, List<String>> compositeGraph = new HashMap<String, List<String>>();
            OPatchSessionHelper.buildCompositeGraph(compositeGraph, compositeIndegree, patchMap);
            List<String> sortedPatchList = OPatchSessionHelper.topologicalSort(patchGraph, patchIndegree);
            List<String> sortedCompositeList = OPatchSessionHelper.topologicalSort(compositeGraph, compositeIndegree);
            if (sortedCompositeList.size() == 0 || sortedPatchList.size() == 0) {
                buff = new StringBuffer("Could not sort patches on overlay. Circular overlay between patches exist");
                RuntimeException re = new RuntimeException(buff.toString());
                throw re;
            }
            HashMap bindCompositePatches = new HashMap();
            for (String string : sortedPatchList) {
                List<String> constituentActives = OPatchSessionHelper.getConstituentActives((PatchObject)patchMap.get(string));
                List<String> list = null;
                if (constituentActives != null && constituentActives.size() > 0) {
                    for (String composite : constituentActives) {
                        list = (List)bindCompositePatches.get(composite);
                        if (list == null) {
                            list = new ArrayList();
                        }
                        list.add(string);
                        bindCompositePatches.put(composite, list);
                    }
                    continue;
                }
                list = (ArrayList<String>)bindCompositePatches.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(string);
                bindCompositePatches.put(string, list);
            }
            ans = new PatchObject[pObjs.length];
            int idx = 0;
            for (String temp : sortedCompositeList) {
                List patchList = (List)bindCompositePatches.get(temp);
                if (patchList == null || patchList.size() <= 0) continue;
                for (String pid : patchList) {
                    if (!patchMap.containsKey(pid)) continue;
                    ans[idx++] = (PatchObject)patchMap.remove(pid);
                }
            }
            if (!forApply) {
                void var14_20;
                boolean bl = false;
                while (var14_20 < ans.length / 2) {
                    PatchObject t = ans[var14_20];
                    ans[var14_20] = ans[ans.length - var14_20 - 1];
                    ans[ans.length - var14_20 - 1] = t;
                    ++var14_20;
                }
            }
            buff = new StringBuffer("Sorted list : ");
            for (PatchObject pObj : ans) {
                buff.append(" ").append(pObj.getPatchID());
            }
            OLogger.justlog(OLogger.INFO, new String(buff));
        }
        return ans;
    }

    private static List<String> topologicalSort(Map<String, List<String>> graph, Map<String, Integer> indegree) {
        ArrayList<String> list = new ArrayList<String>();
        LinkedList<String> queue = new LinkedList<String>();
        HashMap<String, Boolean> visited = new HashMap<String, Boolean>();
        for (String key : graph.keySet()) {
            if (indegree.get(key) == 0) {
                queue.add(key);
                visited.put(key, true);
                continue;
            }
            visited.put(key, false);
        }
        int n2 = graph.size();
        while (!queue.isEmpty()) {
            String node = (String)queue.poll();
            --n2;
            list.add(node);
            for (String neighbor : graph.keySet()) {
                if (((Boolean)visited.get(neighbor)).booleanValue() || !graph.get(neighbor).contains(node)) continue;
                indegree.put(neighbor, indegree.get(neighbor) - 1);
                if (indegree.get(neighbor) != 0) continue;
                queue.offer(neighbor);
                visited.put(neighbor, true);
            }
        }
        return n2 == 0 ? list : new ArrayList<String>();
    }

    private static int buildPatchObjectGraph(Map<String, List<String>> patchGraph, Map<String, Integer> patchIndegree, Map<String, PatchObject> patchMap) {
        int res = 0;
        for (PatchObject pObj : patchMap.values()) {
            String pObjId = pObj.getPatchID();
            String[] temp = pObj.getOverLayOneOffs();
            ArrayList<String> overlays = new ArrayList<String>();
            if (temp != null && temp.length > 0) {
                for (String overlay : temp) {
                    if (!patchMap.containsKey(overlay)) continue;
                    overlays.add(overlay);
                    ++res;
                }
            }
            patchGraph.put(pObjId, overlays);
            patchIndegree.put(pObjId, overlays.size());
        }
        return res;
    }

    private static void buildCompositeGraph(Map<String, List<String>> compositeGraph, Map<String, Integer> compositeIndegree, Map<String, PatchObject> patchMap) {
        for (PatchObject pObj : patchMap.values()) {
            List<String> overlayComposites = OPatchSessionHelper.getOverlayComposites(pObj, patchMap);
            int overlayCompositesSize = overlayComposites.size();
            if (pObj.getIsComposite()) {
                List<String> constituentActives = OPatchSessionHelper.getConstituentActives(pObj);
                for (String composite : constituentActives) {
                    compositeGraph.put(composite, overlayComposites);
                    compositeIndegree.put(composite, overlayCompositesSize);
                }
                continue;
            }
            compositeGraph.put(pObj.getPatchID(), overlayComposites);
            compositeIndegree.put(pObj.getPatchID(), overlayCompositesSize);
        }
    }

    private static List<String> getOverlayComposites(PatchObject pObj, Map<String, PatchObject> patchMap) {
        ArrayList<String> resultList = new ArrayList<String>();
        HashSet<String> resultSet = new HashSet<String>();
        String pObjId = pObj.getPatchID();
        List<String> pObjActiveConstituentsList = OPatchSessionHelper.getConstituentActives(pObj);
        String[] overlayPatchList = pObj.getOverLayOneOffs();
        if (overlayPatchList != null && overlayPatchList.length > 0) {
            for (String overlayPatch : overlayPatchList) {
                PatchObject overlayPatchObj = patchMap.get(overlayPatch);
                ArrayList overlayConstituentActives = new ArrayList();
                if (overlayPatchObj == null) continue;
                if (overlayPatchObj.getIsComposite()) {
                    for (String overlay : OPatchSessionHelper.getConstituentActives(overlayPatchObj)) {
                        if (pObjActiveConstituentsList.contains(overlay)) continue;
                        resultSet.add(overlay);
                    }
                    continue;
                }
                String overlay = overlayPatchObj.getPatchID();
                if (pObjActiveConstituentsList.contains(overlay)) continue;
                resultSet.add(overlay);
            }
        }
        resultList.addAll(resultSet);
        return resultList;
    }

    private static List<String> getConstituentActives(PatchObject pObj) {
        ArrayList<String> resultList = new ArrayList<String>();
        String temp = pObj.getPatchInventory().constituentActiveField;
        if (temp != null && temp.length() > 0) {
            for (String part : temp.split(",")) {
                resultList.add(part);
            }
        }
        return resultList;
    }

    public static PatchObject[] sortOnOverlay_old(PatchObject[] pObjs, boolean forApply) {
        boolean isOverlay = false;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::sortOnOverlay()");
        ArrayList<PatchObject> pList = new ArrayList<PatchObject>();
        if (pObjs == null || pObjs.length == 0 || pObjs.length == 1) {
            buff.append(" pObjs is null or 0 or 1, so no sorting.");
            OLogger.debug(buff);
            return pObjs;
        }
        buff.append(" Given list - ");
        for (int pIter = 0; pIter < pObjs.length; ++pIter) {
            pList.add(pObjs[pIter]);
            buff.append("  ").append(pObjs[pIter].getPatchID());
        }
        OLogger.justlog(OLogger.INFO, new String(buff));
        String activeConstituentId = OPatchSessionHelper.hasOneComposite(pList);
        int i2 = 0;
        while (i2 < pList.size()) {
            int moveTo = -1;
            for (int j2 = 0; j2 < pList.size(); ++j2) {
                PatchObject q2;
                PatchObject p2 = (PatchObject)pList.get(i2);
                if (p2.equals(q2 = (PatchObject)pList.get(j2)) || !p2.isOverlay(q2.getPatchID()) && !p2.isSuperset(q2)) continue;
                isOverlay = true;
                moveTo = i2 > j2 ? -1 : j2;
                if (!q2.isOverlay(p2.getPatchID()) && !q2.isSuperset(p2)) continue;
                buff = new StringBuffer("Circular overlay between patch ");
                buff.append(p2.getPatchID());
                buff.append(" and patch ");
                buff.append(q2.getPatchID());
                RuntimeException re = new RuntimeException(buff.toString());
                throw re;
            }
            if (moveTo != -1) {
                PatchObject removeAtIndex = (PatchObject)pList.get(i2);
                PatchObject moveToIndex = (PatchObject)pList.get(moveTo);
                if (activeConstituentId != null && !OPatchSessionHelper.isSubPatchOfComposite(removeAtIndex, activeConstituentId)) {
                    if (!OPatchSessionHelper.isSubPatchOfComposite(moveToIndex, activeConstituentId)) continue;
                    int indexOfActivePatch = OPatchSessionHelper.getIndexOfActivePatchInComposite(pList, activeConstituentId);
                    OLogger.justlog(OLogger.INFO, "Will move after end of PSU, index: " + indexOfActivePatch);
                    PatchObject p3 = (PatchObject)pList.remove(i2);
                    pList.add(indexOfActivePatch, p3);
                    continue;
                }
                PatchObject p4 = (PatchObject)pList.remove(i2);
                pList.add(moveTo, p4);
                continue;
            }
            ++i2;
        }
        if (isOverlay) {
            int i3;
            PatchObject[] sortList = new PatchObject[pList.size()];
            buff = new StringBuffer("Final sorted list is : ");
            if (forApply) {
                for (i3 = 0; i3 < pList.size(); ++i3) {
                    sortList[i3] = (PatchObject)pList.get(i3);
                    buff.append(" ").append(sortList[i3].getPatchID());
                }
            } else {
                i3 = pList.size() - 1;
                int j3 = 0;
                while (i3 >= 0) {
                    sortList[j3] = (PatchObject)pList.get(i3);
                    buff.append(" ").append(sortList[j3].getPatchID());
                    --i3;
                    ++j3;
                }
            }
            OLogger.justlog(OLogger.INFO, new String(buff));
            return sortList;
        }
        return pObjs;
    }

    public static OneOffEntry[] sortOnOverlay(OneOffEntry[] pObjs) {
        boolean isOverlay = false;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::sortOnOverlay()");
        ArrayList<OneOffEntry> pList = new ArrayList<OneOffEntry>();
        if (pObjs == null || pObjs.length == 0 || pObjs.length == 1) {
            buff.append(" pObjs is null or 0 or 1, so no sorting.");
            OLogger.debug(buff);
            return pObjs;
        }
        buff.append(" Given list - ");
        for (int pIter = 0; pIter < pObjs.length; ++pIter) {
            pList.add(pObjs[pIter]);
            buff.append("  ").append(pObjs[pIter].getID());
        }
        OLogger.debug(buff);
        int i2 = 0;
        while (i2 < pList.size()) {
            int moveTo = -1;
            for (int j2 = 0; j2 < pList.size(); ++j2) {
                OneOffEntry q2;
                OneOffEntry p2 = (OneOffEntry)pList.get(i2);
                if (p2.equals(q2 = (OneOffEntry)pList.get(j2)) || !p2.isOverlay(q2.getID())) continue;
                isOverlay = true;
                moveTo = i2 > j2 ? -1 : j2;
                if (!q2.isOverlay(p2.getID())) continue;
                buff = new StringBuffer("Circular overlay between patch ");
                buff.append(p2.getID());
                buff.append(" and patch ");
                buff.append(q2.getID());
                RuntimeException re = new RuntimeException(buff.toString());
                throw re;
            }
            if (moveTo != -1) {
                OneOffEntry p3 = (OneOffEntry)pList.remove(i2);
                pList.add(moveTo, p3);
                continue;
            }
            ++i2;
        }
        if (isOverlay) {
            OneOffEntry[] sortList = new OneOffEntry[pList.size()];
            buff = new StringBuffer("Final sorted list is : ");
            for (int i3 = 0; i3 < pList.size(); ++i3) {
                sortList[i3] = (OneOffEntry)pList.get(i3);
                buff.append(" ").append(sortList[i3].getID());
            }
            OLogger.debug(buff);
            return sortList;
        }
        return pObjs;
    }

    public static PatchObject[] sortOnApplyTime(PatchObject[] pObjs, String oracleHomePath) {
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            RuntimeException e2 = new RuntimeException(t.getMessage());
            e2.setStackTrace(e2.getStackTrace());
            throw e2;
        }
        OneOffEntry[] oneOffs = readServices.getInstalledPatchesIncludeInactive();
        ArrayList sortList = new ArrayList();
        PatchObject[] sortArrays = new PatchObject[pObjs.length];
        HashMap<String, PatchObject> rObjMap = new HashMap<String, PatchObject>();
        for (PatchObject po : pObjs) {
            rObjMap.put(po.getPatchID(), po);
        }
        for (int i2 = oneOffs.length - 1; i2 >= 0; --i2) {
            OneOffEntry oneOff = oneOffs[i2];
            if (!rObjMap.containsKey(oneOff.getPatchID())) continue;
            sortList.add(rObjMap.get(oneOff.getPatchID()));
        }
        sortList.toArray(sortArrays);
        return sortArrays;
    }

    public static String[] getDBHomes(String crsHome) {
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::getDBHomes() call");
        OLogger.debug(buff);
        ArrayList<String> dbHomes = new ArrayList<String>();
        String srvctlCmd = crsHome + File.separator + "bin" + File.separator + "srvctl";
        Path srvctl = WrapperFactory.getNioServiceWrapper().getPath(srvctlCmd, new String[0]);
        if (!Files.exists(srvctl, new LinkOption[0])) {
            buff = new StringBuffer("Command 'srvctl' does not exist in CRS home. Please provide valid CRS home.");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        String getinstancesCmd = srvctlCmd + " config";
        SystemCall.ExecReturn rs = SystemCall.runtimeExec(getinstancesCmd);
        if (rs.isOK()) {
            String[] instances = rs.getNormalMessage().split("\n");
            for (int i2 = 0; i2 < instances.length; ++i2) {
                int j2;
                if (instances[i2] == null || instances[i2].equals("")) continue;
                String getdbhomesCmd = getinstancesCmd + " database -d " + instances[i2];
                SystemCall.ExecReturn dbhomesRs = SystemCall.runtimeExec(getdbhomesCmd);
                if (dbhomesRs.isOK()) {
                    String[] sentences = dbhomesRs.getNormalMessage().split("\n");
                    for (j2 = 0; j2 < sentences.length; ++j2) {
                        if (!sentences[j2].startsWith("Oracle home:")) continue;
                        dbHomes.add(sentences[j2].substring(13));
                    }
                    if (dbHomes.size() != 0) continue;
                    for (j2 = 0; j2 < sentences.length; ++j2) {
                        TreeSet<String> set = new TreeSet<String>();
                        String[] parts = sentences[j2].split("\\s+");
                        if (parts.length == 3 && parts[2] != null && !parts[2].trim().equals("")) {
                            set.add(parts[j2]);
                        }
                        if (set.size() == 0) continue;
                        dbHomes.addAll(set);
                    }
                    continue;
                }
                getdbhomesCmd = getinstancesCmd + " database -v";
                dbhomesRs = SystemCall.runtimeExec(getdbhomesCmd);
                if (!dbhomesRs.isOK()) continue;
                String[] outputs = dbhomesRs.getNormalMessage().split("\n");
                for (j2 = 0; j2 < outputs.length; ++j2) {
                    dbHomes.add(outputs[j2].split("\\s+")[1]);
                }
            }
        }
        String[] allDBHomes = new String[dbHomes.size()];
        dbHomes.toArray(allDBHomes);
        return allDBHomes;
    }

    public static void createSessionProperties(String oracleHomePath, String session, String sessionID, String[] patchID, String[] triggeredPatchID) throws RuntimeException {
        int i2;
        StringBuffer buff = new StringBuffer("OPatchSessionHelper::createSessionProperties()");
        OLogger.debug(buff);
        String propertiesPath = OPatchEnv.getSessionProperties(oracleHomePath);
        StringBuffer combinedpatchID = new StringBuffer();
        StringBuffer combinedTriggeredPatchID = new StringBuffer();
        if (patchID == null || patchID.length == 0) {
            throw new RuntimeException("PatchID not specified");
        }
        combinedpatchID.append(patchID[0]);
        for (i2 = 1; i2 < patchID.length; ++i2) {
            combinedpatchID.append(",");
            combinedpatchID.append(patchID[i2]);
        }
        if (triggeredPatchID != null && triggeredPatchID.length > 0) {
            combinedTriggeredPatchID.append(triggeredPatchID[0]);
            for (i2 = 1; i2 < triggeredPatchID.length; ++i2) {
                combinedTriggeredPatchID.append(",");
                combinedTriggeredPatchID.append(triggeredPatchID[i2]);
            }
        }
        StringBuffer fileContents = new StringBuffer("SessionName=");
        fileContents.append(session);
        fileContents.append("\nSessionID=");
        fileContents.append(sessionID);
        fileContents.append("\nPatchID=");
        fileContents.append(combinedpatchID);
        fileContents.append("\nTriggeredPatchID=");
        fileContents.append(combinedTriggeredPatchID);
        buff = new StringBuffer("Writing the session properties file with the following :\n");
        buff.append(fileContents);
        OLogger.debug(buff);
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(propertiesPath, new String[0]);
        try {
            Files.deleteIfExists(f2);
        }
        catch (IOException e2) {
            buff = new StringBuffer("Unable to delete the existing file \"");
            buff.append(propertiesPath);
            buff.append("\"");
            OLogger.debug(buff);
            throw new RuntimeException(buff.toString());
        }
        try {
            SystemCall.createNewFile(propertiesPath);
            OutputStream fop = Files.newOutputStream(f2, new OpenOption[0]);
            PrintStream ps = new PrintStream(fop);
            ps.println(fileContents);
            ps.close();
            fop.close();
        }
        catch (FileNotFoundException e3) {
            RuntimeException re = new RuntimeException(e3);
            re.setStackTrace(e3.getStackTrace());
            throw re;
        }
        catch (IOException ioe) {
            RuntimeException re = new RuntimeException(ioe);
            re.setStackTrace(ioe.getStackTrace());
            throw re;
        }
    }

    public static void loadExternalLibFile(String libFilePath) {
    }

    public static void cleanupWithoutLog(String oracleHomePath) {
        try {
            OPatchACL.invokeOLogger(new OPatchSessionHelper(), "setLogFileLevel", new Object[]{Level.OFF.intValue()});
            OPatchSessionHelper.cleanup(oracleHomePath);
            OPatchACL.invokeOLogger(new OPatchSessionHelper(), "setLogFileLevel", new Object[]{Level.INFO.intValue()});
        }
        catch (IllegalAccessException e2) {
            OLogger.printStackTrace(e2);
        }
    }

    public static void cleanup(String oracleHomePath) {
        if (Rules.SystemWrite_continue() || Rules.OUIRead_continue()) {
            try {
                boolean isSilent = OPatchEnv.isSilent();
                OPatchEnv.setSilent(true);
                OPatchACL.invokeOLogger(new OPatchSessionHelper(), "disableConsoleOutput", null);
                JarActionHelper.cleanUpDeleteJarActionCache();
                OUSession.cleanup(oracleHomePath);
                OPatchEnv.setSilent(isSilent);
            }
            catch (ExitOPatchException e2) {
                OLogger.printStackTrace(e2);
            }
            catch (RuntimeException e3) {
                OLogger.printStackTrace(e3);
            }
            catch (IllegalAccessException e4) {
                OLogger.printStackTrace(e4);
            }
            finally {
                try {
                    OPatchACL.invokeOLogger(new OPatchSessionHelper(), "enableConsoleOutput", null);
                }
                catch (IllegalAccessException e5) {
                    OLogger.printStackTrace(e5);
                }
            }
        }
    }

    private static Method initAddMethod() {
        try {
            Method add = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            add.setAccessible(true);
            return add;
        }
        catch (Exception e2) {
            RuntimeException rt = new RuntimeException(e2);
            rt.setStackTrace(e2.getStackTrace());
            throw rt;
        }
    }

    public static void loadFMWRelatedLibFile() {
        Properties prop = System.getProperties();
        boolean isWindows = OPatchEnv.isWindows();
        if (prop != null) {
            String oh = prop.getProperty("OPatch.ORACLE_HOME");
            String fmwComponentHome = prop.getProperty("OPatch.FMW_COMPONENT_HOME");
            String commonComponentsHome = prop.getProperty("OPatch.COMMON_COMPONENTS_HOME");
            String weblogicClasspath = prop.getProperty("OPatch.WEBLOGIC_CLASSPATH");
            String opatchClasspath = prop.getProperty("OPatch.OPATCH_CLASSPATH");
            String classpath = prop.getProperty("java.class.path");
            StringTokenizer st1 = null;
            if (null != weblogicClasspath) {
                if (isWindows) {
                    classpath = classpath + ";" + weblogicClasspath;
                    st1 = new StringTokenizer(weblogicClasspath, ";");
                } else {
                    classpath = classpath + ":" + weblogicClasspath;
                    st1 = new StringTokenizer(weblogicClasspath, ":");
                }
                prop.setProperty("java.class.path", classpath);
            }
            StringTokenizer st2 = null;
            if (null != classpath) {
                if (isWindows) {
                    classpath = classpath + ";" + opatchClasspath;
                    st2 = new StringTokenizer(opatchClasspath, ";");
                } else {
                    classpath = classpath + ":" + opatchClasspath;
                    st2 = new StringTokenizer(opatchClasspath, ":");
                }
            }
            ArrayList<String> fmwRelatedLibFileList = new ArrayList<String>();
            StringBuffer libFile = new StringBuffer("");
            libFile.append(fmwComponentHome);
            libFile.append(File.separator);
            libFile.append("soa");
            libFile.append(File.separator);
            libFile.append("modules");
            libFile.append(File.separator);
            libFile.append("oracle.soa.fabric_11.1.1");
            libFile.append(File.separator);
            libFile.append("oracle.soa.wlstman.jar");
            fmwRelatedLibFileList.add(libFile.toString());
            classpath = isWindows ? classpath + ";" + libFile.toString() : classpath + ":" + libFile.toString();
            libFile = new StringBuffer("");
            libFile.append(commonComponentsHome);
            libFile.append(File.separator);
            libFile.append("modules");
            libFile.append(File.separator);
            libFile.append("oracle.ldap_11.1.1");
            libFile.append(File.separator);
            libFile.append("ldifloadtool.jar");
            fmwRelatedLibFileList.add(libFile.toString());
            classpath = isWindows ? classpath + ";" + libFile.toString() : classpath + ":" + libFile.toString();
            libFile = new StringBuffer("");
            libFile.append(oh);
            libFile.append(File.separator);
            libFile.append("biapps");
            libFile.append(File.separator);
            libFile.append("patch");
            libFile.append(File.separator);
            libFile.append("biappspatch.jar");
            fmwRelatedLibFileList.add(libFile.toString());
            classpath = isWindows ? classpath + ";" + libFile.toString() : classpath + ":" + libFile.toString();
            prop.setProperty("java.class.path", classpath);
            OPatchOOPHelper.updateClassPath();
            while (st1 != null && st1.hasMoreTokens()) {
                fmwRelatedLibFileList.add(st1.nextToken());
            }
            while (st2 != null && st2.hasMoreTokens()) {
                fmwRelatedLibFileList.add(st2.nextToken());
            }
            for (int i2 = 0; i2 < fmwRelatedLibFileList.size(); ++i2) {
                OPatchSessionHelper.loadExternalLibFile((String)fmwRelatedLibFileList.get(i2));
                OPatchOOPHelper.loadExternalLibs((String)fmwRelatedLibFileList.get(i2));
            }
        }
    }

    public static void loadRACRelatedLibFile() {
        Properties prop = System.getProperties();
        boolean isWindows = OPatchEnv.isWindows();
        if (prop != null) {
            String oui = prop.getProperty("OPatch.OUI_LOCATION");
            String oh = prop.getProperty("OPatch.ORACLE_HOME");
            String classpath = prop.getProperty("java.class.path");
            StringBuffer srvm_lib_location = new StringBuffer("");
            if (oui == null || oui.equals("")) {
                srvm_lib_location.append(oh);
                srvm_lib_location.append(File.separator);
                srvm_lib_location.append("oui");
            } else {
                srvm_lib_location.append(oui);
            }
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append("srvm.jar");
            classpath = isWindows ? classpath + ";" + srvm_lib_location.toString() : classpath + ":" + srvm_lib_location.toString();
            prop.setProperty("java.class.path", classpath);
            OPatchOOPHelper.updateClassPath();
            OPatchSessionHelper.loadExternalLibFile(srvm_lib_location.toString());
            OPatchOOPHelper.loadExternalLibs(srvm_lib_location.toString());
        }
    }

    public static void loadRACRelatedLibFile(String oh) {
        Properties prop = System.getProperties();
        boolean isWindows = OPatchEnv.isWindows();
        if (prop != null) {
            String oui = "";
            String classpath = prop.getProperty("java.class.path");
            StringBuffer srvm_lib_location = new StringBuffer("");
            if (oui == null || oui.equals("")) {
                srvm_lib_location.append(oh);
                srvm_lib_location.append(File.separator);
                srvm_lib_location.append("oui");
            } else {
                srvm_lib_location.append(oui);
            }
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append(OPatchEnv.isNextGen() ? "modules" : "jlib");
            srvm_lib_location.append(File.separator);
            srvm_lib_location.append("srvm.jar");
            classpath = isWindows ? classpath + ";" + srvm_lib_location.toString() : classpath + ":" + srvm_lib_location.toString();
            prop.setProperty("java.class.path", classpath);
            OPatchOOPHelper.updateClassPath();
            OPatchSessionHelper.loadExternalLibFile(srvm_lib_location.toString());
            OPatchOOPHelper.loadExternalLibs(srvm_lib_location.toString());
        }
    }

    public static void loadCRSRelatedLibFiles(String oracleHomePath) {
        String jlibLoc = oracleHomePath + File.separator + (OPatchEnv.isNextGen() ? "modules" : "jlib");
        String srvmasm = jlibLoc + File.separator + "srvmasm.jar";
        String srvmhas = jlibLoc + File.separator + "srvmhas.jar";
        String netcfg = jlibLoc + File.separator + "netcfg.jar";
        try {
            OPatchSessionHelper.loadExternalLibFile(srvmasm);
            OPatchSessionHelper.loadExternalLibFile(srvmhas);
            OPatchSessionHelper.loadExternalLibFile(netcfg);
            OPatchOOPHelper.loadExternalLibs(srvmasm);
            OPatchOOPHelper.loadExternalLibs(srvmhas);
            OPatchOOPHelper.loadExternalLibs(netcfg);
            String classpath = System.getProperty("java.class.path");
            if (OPatchEnv.isWindows()) {
                classpath = classpath + ";" + srvmasm;
                classpath = classpath + ";" + srvmhas;
                classpath = classpath + ";" + netcfg;
            } else {
                classpath = classpath + ":" + srvmasm;
                classpath = classpath + ":" + srvmhas;
                classpath = classpath + ":" + netcfg;
            }
            System.setProperty("java.class.path", classpath);
            OPatchOOPHelper.updateClassPath();
        }
        catch (Exception e2) {
            OLogger.printStackTrace(e2);
            RuntimeException re = new RuntimeException(e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
    }

    public static void runLibraryRegeneration(PatchObject patchObject, String oracleHomePath, boolean isAutoRollback) {
        if (!OPatchEnv.isNextGen() || OPatchEnv.isCUPSupported()) {
            return;
        }
        String sessionName = "";
        if (!patchObject.shouldInvokeRegenerateLibrary() && !isAutoRollback) {
            sessionName = OPatchEnv.getSessionName();
            StringBuffer ts = new StringBuffer("In ");
            ts.append("session " + sessionName + ": ");
            ts.append("library regeneration for patch " + patchObject.getPatchID() + " is delayed. It will be done in the end.");
            OLogger.logTime(ts);
        } else {
            RegenerateLib rLib;
            StringBuffer ts = new StringBuffer("Start regenerating library files at ");
            OLogger.logTime(ts);
            sessionName = OPatchEnv.getSessionName();
            if (sessionName != null && sessionName.equals("apply")) {
                PatchObject[] arbPatches = OPatchEnv.getArbPatchObjectsForRLib();
                PatchObject[] mergedPatches = new PatchObject[arbPatches.length + 1];
                ts = new StringBuffer("Patches proceed for library regeneration checking from apply session are\n");
                ts.append("[");
                for (int i2 = 0; i2 < arbPatches.length; ++i2) {
                    mergedPatches[i2] = arbPatches[i2];
                    ts.append(mergedPatches[i2].getPatchID() + ", ");
                }
                mergedPatches[arbPatches.length] = patchObject;
                ts.append(mergedPatches[arbPatches.length].getPatchID() + ", ");
                ts.append("]");
                OLogger.logTime(ts);
                rLib = new RegenerateLib(mergedPatches, oracleHomePath);
            } else {
                ts = new StringBuffer("Patches proceed for library regeneration checking from rollback session are\n");
                ts.append("[");
                rLib = new RegenerateLib(patchObject, oracleHomePath);
                ts.append(patchObject.getPatchID() + ", ");
                ts.append("]");
                OLogger.logTime(ts);
            }
            try {
                rLib.regenerate();
            }
            catch (Throwable t) {
                ts = new StringBuffer(t.getMessage());
                OLogger.logTime(ts);
                OLogger.printStackTrace(t);
                RuntimeException re = new RuntimeException(t.getMessage(), t);
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
            ts = new StringBuffer("Finish regenerating library files at ");
            OLogger.logTime(ts);
        }
    }

    public static void runLibraryRegeneration(PatchObject[] patchObjects, String oracleHomePath) {
        if (!OPatchEnv.isNextGen() || OPatchEnv.isCUPSupported()) {
            return;
        }
        StringBuffer ts = new StringBuffer("Start the delayed library regeneration at ");
        OLogger.logTime(ts);
        ts = new StringBuffer("Patches proceed for library regeneration checking from napply/nrollback session are\n");
        ts.append("[");
        for (int i2 = 0; i2 < patchObjects.length; ++i2) {
            ts.append(patchObjects[i2].getPatchID() + ", ");
        }
        ts.append("]");
        OLogger.logTime(ts);
        RegenerateLib rLib = new RegenerateLib(patchObjects, oracleHomePath);
        try {
            rLib.regenerate();
        }
        catch (Throwable t) {
            ts = new StringBuffer(t.getMessage());
            OLogger.logTime(ts);
            OLogger.printStackTrace(t);
            RuntimeException re = new RuntimeException(t.getMessage(), t);
            re.setStackTrace(t.getStackTrace());
            throw re;
        }
        ts = new StringBuffer("Finish the delayed library regeneration at ");
        OLogger.logTime(ts);
    }

    public static void setupRLibBackupDir(String oracleHomePath, String cookedPatchID) {
        String patchStorageDir = OPatchEnv.getPatchStorageDirectoryPath(oracleHomePath, cookedPatchID);
        StringBuilder sb = new StringBuilder(patchStorageDir);
        sb.append(File.separator);
        sb.append("library_backup");
        OPatchEnv.setRLibBackupDir(sb.toString());
    }

    public static boolean CanWrite(String oracleHomePath, Path dst) {
        int platformID;
        IIPMReadServices readServices = null;
        try {
            readServices = PrereqSession.getReadServices(oracleHomePath);
        }
        catch (Throwable t) {
            OLogger.printlnOnLog("Throwable occured: " + t.getMessage());
            RuntimeException rt = new RuntimeException("Error in Load IIPMReadServices.", t);
            rt.setStackTrace(t.getStackTrace());
            throw rt;
        }
        try {
            platformID = PatchObjectUtil.getARU_ID(oracleHomePath, readServices);
        }
        catch (Throwable t) {
            platformID = 0;
        }
        if (platformID == 59 || platformID == 2 || platformID == 278 || platformID == 197) {
            boolean canWrite = OUIReplacer.canWriteForHpPlatform(dst.toAbsolutePath().toString());
            if (!canWrite) {
                canWrite = Files.isWritable(dst);
            }
            return canWrite;
        }
        return Files.isWritable(dst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkIsEsysPatch(String patchLoc) {
        boolean isConsoleOutputDisabled = OLogger.isConsoleOutputDisabled();
        boolean hasBundle = false;
        Path f2 = WrapperFactory.getNioServiceWrapper().getPath(patchLoc, new String[0]);
        if (f2 != null && Files.exists(f2, new LinkOption[0]) && !Files.isDirectory(f2, new LinkOption[0])) {
            return false;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(f2);){
            Iterator<Path> iterator = stream.iterator();
            if (!iterator.hasNext()) {
                boolean bl = false;
                return bl;
            }
            while (iterator.hasNext()) {
                String entry = iterator.next().toString();
                if (entry.indexOf("bundle.xml") == -1) continue;
                hasBundle = true;
            }
        }
        catch (IOException e2) {
            OLogger.debug(e2.getMessage());
        }
        if (!hasBundle) return false;
        try {
            PatchVariant pv;
            if (!isConsoleOutputDisabled) {
                OLogger.disableConsoleOutput(true);
            }
            if ((pv = OPatchPatchFactory.getPatchInstance((String)patchLoc)).getPatchType() != PatchType.ENGSYSTEM) return false;
            boolean bl = true;
            return bl;
        }
        catch (PatchPackageException e3) {
            return false;
        }
        catch (InvalidPatchPackageException e4) {
            return false;
        }
        finally {
            if (!isConsoleOutputDisabled) {
                OLogger.enableConsoleOutput(true);
            }
        }
    }

    public static boolean checkApplyHasCompositePatch(String oracleHomePath) {
        try {
            OneOffEntry[] patchesToApply;
            for (OneOffEntry patchToApply : patchesToApply = OPatchUtilHelper.getPatchesToApply(oracleHomePath, OPatchEnv.getNApplySessionName())) {
                if (!patchToApply.getIsComposite()) continue;
                return true;
            }
        }
        catch (Exception e2) {
            RuntimeException re = new RuntimeException(e2.getMessage(), e2);
            re.setStackTrace(e2.getStackTrace());
            throw re;
        }
        return false;
    }

    private static boolean isCASReportSDK() {
        return OPatchEnv.isReport() && OPatchEnv.isCASFlow() && OPatchEnv.isOPatchSDKMode() && OUSession.isPhaseOneReport();
    }

    public static boolean validateRollbackOrder(PatchObject[] pObjs) {
        boolean isCorrect = true;
        for (int i2 = pObjs.length - 1; i2 > 0; --i2) {
            for (int j2 = i2 - 1; j2 >= 0; --j2) {
                if (!pObjs[i2].isOverlay(pObjs[j2].getPatchID()) && !pObjs[i2].isSuperset(pObjs[j2])) continue;
                isCorrect = false;
                return isCorrect;
            }
        }
        return isCorrect;
    }

    private static String hasOneComposite(List<PatchObject> pList) {
        if (pList == null) {
            return null;
        }
        int size = pList.size();
        OLogger.justlog(OLogger.INFO, "size of PatchObject list: " + size);
        String activeId = null;
        for (int i2 = 0; i2 < size; ++i2) {
            PatchObject po = pList.get(i2);
            if (!po.getIsComposite() || !po.isActiveCompositeSubPatch()) continue;
            String temp = po.getPatchInventory().constituentActiveField;
            OLogger.justlog(OLogger.INFO, "Constituent id: " + temp);
            if (null == activeId) {
                activeId = temp;
                continue;
            }
            if (activeId.compareToIgnoreCase(temp) == 0) continue;
            activeId = null;
            break;
        }
        return activeId;
    }

    private static boolean isSubPatchOfComposite(PatchObject po, String activeConstituentId) {
        String poActiveId;
        if (po == null || activeConstituentId == null) {
            return false;
        }
        if (po.getIsComposite() && (poActiveId = po.getPatchInventory().constituentActiveField).contains(activeConstituentId)) {
            OLogger.justlog(OLogger.INFO, "Oneoff [" + po.getPatchID() + "] is sub-patch of composite(s): " + poActiveId);
            return true;
        }
        return false;
    }

    private static int getIndexOfActivePatchInComposite(List<PatchObject> pList, String activeConstituentId) {
        if (pList == null || activeConstituentId == null) {
            return -1;
        }
        int size = pList.size();
        OLogger.justlog(OLogger.INFO, "getIndexOfActivePatchInComposite (size=" + size + ") - activeConstituent ID: " + activeConstituentId);
        for (int i2 = 0; i2 < size; ++i2) {
            PatchObject po = pList.get(i2);
            String id = po.getPatchID();
            OLogger.justlog(OLogger.INFO, "PO id: " + id);
            if (id.compareToIgnoreCase(activeConstituentId) != 0) continue;
            return i2;
        }
        OLogger.justlog(OLogger.WARNING, "Found no match of active constituent id: " + activeConstituentId);
        return -1;
    }

    public static class LocalInfo {
        private IIPMReadServices readServices;
        private PatchObject patchObject;
        private Boolean needRollback;
        private Rac.RacType racType;
        private RacProcessor.MinDowntimeNodeSelection selects;

        private LocalInfo() {
        }

        public LocalInfo(IIPMReadServices rs, PatchObject po, boolean nRb, Rac.RacType rt, RacProcessor.MinDowntimeNodeSelection sel) {
            this.readServices = rs;
            this.patchObject = po;
            this.needRollback = nRb;
            this.racType = rt;
            this.selects = sel;
        }

        protected IIPMReadServices getReadServices() {
            return this.readServices;
        }

        protected PatchObject getPatchObject() {
            return this.patchObject;
        }

        protected Boolean getNeedRollbac() {
            return this.needRollback;
        }

        protected Rac.RacType getRacType() {
            return this.racType;
        }

        protected RacProcessor.MinDowntimeNodeSelection getSelection() {
            return this.selects;
        }
    }
}

