/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import com.oracle.cie.gdr.external.InventoryException;
import com.oracle.cie.gdr.external.InventoryUtil;
import com.oracle.cie.gdr.external.OracleHomeInventory;
import java.nio.file.Path;
import oracle.opatch.NGOUIInventoryUtil;
import oracle.opatch.wrappers.WrapperFactory;

public class NGOUIInventoryFactory {
    private static InventoryUtil util = null;

    public static NGOUIInventoryUtil getInventoryUtil(String oracleHomePath) throws InventoryException {
        if (util == null) {
            Path homeDir = WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]);
            util = WrapperFactory.getNextGenApiWrapper().getInventoryUtil(homeDir);
        }
        return new NGOUIInventoryUtil(util);
    }

    protected static void setInventoryUtil(InventoryUtil util) {
        NGOUIInventoryFactory.util = util;
    }

    public static OracleHomeInventory getOracleHomeInventory(String oracleHomePath) throws InventoryException {
        return WrapperFactory.getNextGenApiWrapper().getOracleHomeInventory(WrapperFactory.getNioServiceWrapper().getPath(oracleHomePath, new String[0]));
    }
}

