/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import oracle.opatch.OPatchSession;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.ops.EnvInfo;
import oracle.opatch.wrappers.WrapperFactory;

public class DisableCasSession
extends OPatchSession {
    private static String fileSeparator = File.separator;

    protected DisableCasSession(String name, boolean readOnly) {
        super(name, readOnly);
    }

    public void process() {
        EnvInfo info = new EnvInfo();
        ArrayList<Path> casJars = info.getCasJars();
        if (null != casJars && !casJars.isEmpty()) {
            for (Path jar : casJars) {
                int index;
                String oldName = jar.toString();
                if (jar.getFileName().toString().startsWith(".") || (index = oldName.lastIndexOf(fileSeparator)) == -1) continue;
                String newName = oldName.substring(0, index) + fileSeparator + "." + jar.getFileName().toString();
                Path newFile = WrapperFactory.getNioServiceWrapper().getPath(newName, new String[0]);
                try {
                    Files.move(jar, newFile, new CopyOption[0]);
                }
                catch (IOException e2) {
                    OLogger.debug(e2.getMessage());
                }
                OLogger.justlog(OLogger.INFO, jar.toString() + " has been renamed to " + newName);
            }
        }
        OLogger.justlog(OLogger.INFO, "Complete disablecas.");
    }
}

