/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.validation;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import com.oracle.glcm.patch.auto.rhp.repository.system.ProductDriverException;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationFailureReason;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationResult;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidator;
import java.io.File;
import java.util.logging.Logger;
import oracle.sysman.oii.oiii.OiiiVersion;

public class RHPHomeInfoValidator
implements RHPValidator {
    private final Logger _logger = Logger.getLogger(RHPHomeInfoValidator.class.getName());

    @Override
    public RHPValidationResult validate(OPatchAutoRHPOptions options) {
        RHPValidationResult result = null;
        String oracleHome = null;
        OracleHomeInformationLoader homeInfoLoader = OracleHomeInformationLoader.getInstance();
        try {
            oracleHome = options.getOption("home").getValue();
            OracleHomeInformationLoader.CrsType crsType = homeInfoLoader.getCRSType();
            if (crsType == OracleHomeInformationLoader.CrsType.SIHA || crsType == OracleHomeInformationLoader.CrsType.SOFTWARE_INSTALLATION_ONLY) {
                this._logger.fine("Unsupported CRS type of home " + oracleHome + " :" + (Object)((Object)crsType));
                result = new RHPValidationResult(RHPValidator.ValidatorID.SYSTEMINFO_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.RHP_FEATURE_NOT_AVALIABLE, new Object[0]);
            } else {
                OiiiVersion baseVersionObj;
                String haVersion = homeInfoLoader.getCrsVersion(homeInfoLoader.isStackRunning());
                OiiiVersion versionToCompareObj = new OiiiVersion(haVersion);
                if (!versionToCompareObj.equals(baseVersionObj = new OiiiVersion("12.2.0.2")) && !versionToCompareObj.laterThan(baseVersionObj)) {
                    result = new RHPValidationResult(RHPValidator.ValidatorID.SYSTEMINFO_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.UNSUPPORTED_PRODUCT_VERSION, versionToCompareObj.toString());
                }
            }
        }
        catch (OPatchAutoException e) {
        }
        catch (ProductDriverException e) {
            result = new RHPValidationResult(RHPValidator.ValidatorID.SYSTEMINFO_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.SYSTEM_INFO_LOAD_FAILED, e.getMessage());
        }
        if (result == null) {
            if (StringUtil.isNullOrEmpty((String)oracleHome)) {
                result = new RHPValidationResult(RHPValidator.ValidatorID.SYSTEMINFO_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.NO_HOME_SELECTED, new Object[0]);
            } else {
                String rhpClientHome = OPatchautoRHPHelper.removeTrailingFileSeperator(OracleHomeInformationLoader.getInstance().getGridHome());
                File rhpBinary = new File(rhpClientHome + File.separator + "bin", "rhpctl");
                if (!rhpBinary.exists()) {
                    this._logger.fine("RHP executable file doesn't exist in the grid home " + rhpClientHome);
                    result = new RHPValidationResult(RHPValidator.ValidatorID.SYSTEMINFO_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.RHP_FEATURE_NOT_AVALIABLE, new Object[0]);
                } else {
                    result = new RHPValidationResult(RHPValidator.ValidatorID.SYSTEMINFO_VALIDATOR, RHPValidationResult.ValidationStatus.SUCCESS, null, new Object[0]);
                }
            }
        }
        return result;
    }
}

