/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.validation;

import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.validation.RHPHomeInfoValidator;
import com.oracle.glcm.patch.auto.rhp.validation.RHPImageValidator;
import com.oracle.glcm.patch.auto.rhp.validation.RHPOptionsValidator;
import com.oracle.glcm.patch.auto.rhp.validation.RHPPatchvalidator;
import com.oracle.glcm.patch.auto.rhp.validation.RHPProvisionedHomeValidator;
import com.oracle.glcm.patch.auto.rhp.validation.RHPSwitchbackProvisionedHomeValidator;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationResult;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class OPatchautoRHPValidationController {
    Logger _logger = Logger.getLogger(OPatchautoRHPValidationController.class.getName());

    public List<RHPValidationResult> validate(RHPOperation operation, OPatchAutoRHPOptions options) {
        ArrayList<RHPValidationResult> resultList = new ArrayList<RHPValidationResult>();
        List<RHPValidator> validatorList = null;
        switch (operation) {
            case CREATE_IMAGE: {
                validatorList = this.getCreateImageValidator();
                break;
            }
            case PROVISION_HOME: {
                validatorList = this.getProvisionHomeValidator();
                break;
            }
            case SWITCH_HOME: {
                validatorList = this.getSwitchHomeValidator();
                break;
            }
            case SWITCH_BACK_HOME: {
                validatorList = this.getSwitchbackHomeValidator();
                break;
            }
        }
        if (validatorList != null && !validatorList.isEmpty()) {
            for (RHPValidator validator : validatorList) {
                RHPValidationResult result = validator.validate(options);
                resultList.add(result);
            }
        }
        return resultList;
    }

    private List<RHPValidator> getCreateImageValidator() {
        ArrayList<RHPValidator> validatorList = new ArrayList<RHPValidator>();
        validatorList.add(new RHPHomeInfoValidator());
        validatorList.add(new RHPPatchvalidator());
        return validatorList;
    }

    private List<RHPValidator> getProvisionHomeValidator() {
        ArrayList<RHPValidator> validatorList = new ArrayList<RHPValidator>();
        validatorList.add(new RHPHomeInfoValidator());
        validatorList.add(new RHPImageValidator());
        return validatorList;
    }

    private List<RHPValidator> getSwitchHomeValidator() {
        ArrayList<RHPValidator> validatorList = new ArrayList<RHPValidator>();
        validatorList.add(new RHPHomeInfoValidator());
        validatorList.add(new RHPProvisionedHomeValidator());
        validatorList.add(new RHPOptionsValidator());
        return validatorList;
    }

    private List<RHPValidator> getSwitchbackHomeValidator() {
        ArrayList<RHPValidator> validatorList = new ArrayList<RHPValidator>();
        validatorList.add(new RHPHomeInfoValidator());
        validatorList.add(new RHPSwitchbackProvisionedHomeValidator());
        validatorList.add(new RHPOptionsValidator());
        return validatorList;
    }
}

