/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.executor;

import com.oracle.cie.common.util.reporting.Reporting;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

class ReaderThread
extends Thread {
    private static final Logger _log = Logger.getLogger(ReaderThread.class.getName());
    private InputStreamReader _inputStream;
    private String _name;
    private String _outputString;
    private boolean _logToConsole;

    public ReaderThread(InputStreamReader isr, String name, boolean logToConsole) {
        this._inputStream = isr;
        this._name = name;
        this._logToConsole = logToConsole;
    }

    @Override
    public void run() {
        try {
            BufferedReader br = new BufferedReader(this._inputStream);
            StringBuffer sb = new StringBuffer();
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
                if (!this._logToConsole) continue;
                Reporting.report((String)line);
            }
            this._outputString = sb.toString();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Failed to capture output:" + this._name, e);
        }
    }

    public String getOutput() {
        return this._outputString;
    }
}

