/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.executor;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import java.io.IOException;

public class RHPParamCreator {
    public RHPParams createParams(OPatchAutoCommand command, OPatchAutoRHPOptions options, RHPOperation operationType) throws OPatchAutoException {
        RHPParams params = new RHPParams();
        params.setCommand(command);
        params.setOperationType(operationType);
        params.setRHPClientHome(OracleHomeInformationLoader.getInstance().getGridHome());
        switch (operationType) {
            case CREATE_IMAGE: {
                params.setOracleHome(options.getOption("home").getValue());
                params.setImageID(options.getOption("image.id").getValue());
                params.setAnalyze(options.getOption("analyze").isSwitchEnabled());
                break;
            }
            case QUERY_IMAGE: {
                params.setImageID(options.getOption("image.id").getValue());
                break;
            }
            case QUERY_WORKINGCOPY: {
                params.setWorkingCopyID(options.getOption("working.copy").getValue());
                break;
            }
            case PROVISION_HOME: {
                params.setOracleHome(options.getOption("home").getValue());
                params.setImageID(options.getOption("image.id").getValue());
                params.setAnalyze(options.getOption("analyze").isSwitchEnabled());
                params.setWorkingCopyID(options.getOption("working.copy").getValue());
                params.setPath(options.getOption("path").getValue());
                break;
            }
            case SWITCH_HOME: {
                params.setOracleHome(options.getOption("home").getValue());
                params.setAnalyze(options.getOption("analyze").isSwitchEnabled());
                params.setPath(options.getOption("path").getValue());
                params.setWorkingCopyID(this.getWorkingCopyIdToSwitch(options));
                params.setNonRolling(options.getOption("nonrolling").isSwitchEnabled());
                params.setBatches(options.getOption("batches").getValue());
                params.setSAF(options.getOption("saf").getValue());
                params.setContinued(options.getOption("continue").isSwitchEnabled());
                params.setDrainTimeout(options.getOption("drain.timeout").getValue());
                params.setStopOption(options.getOption("stopoption").getValue());
                break;
            }
            case SWITCH_BACK_HOME: {
                params.setOracleHome(options.getOption("home").getValue());
                params.setAnalyze(options.getOption("analyze").isSwitchEnabled());
                params.setNonRolling(options.getOption("nonrolling").isSwitchEnabled());
                params.setBatches(options.getOption("batches").getValue());
                params.setSAF(options.getOption("saf").getValue());
                params.setContinued(options.getOption("continue").isSwitchEnabled());
                params.setDrainTimeout(options.getOption("drain.timeout").getValue());
                params.setStopOption(options.getOption("stopoption").getValue());
                break;
            }
        }
        return params;
    }

    private String getWorkingCopyIdToSwitch(OPatchAutoRHPOptions options) throws OPatchAutoException {
        String workingCopyID = null;
        workingCopyID = options.getOption("working.copy").getValue();
        if (StringUtil.isNullOrEmpty((String)workingCopyID)) {
            String path = options.getOption("path").getValue();
            try {
                workingCopyID = OPatchautoRHPHelper.findWorkingCopyID(path);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return workingCopyID;
    }
}

