/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.command;

import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.Command;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.executor.RHPCommandExecutor;
import java.util.ArrayList;
import java.util.List;

public class RHPCreateImageCommand
extends Command {
    @Override
    public List<String> generateCommand(RHPParams params) {
        StringBuilder commandBuilder = new StringBuilder();
        commandBuilder.append(this.getRHPExecutable(params.getRHPClientHome()));
        commandBuilder.append(" ");
        commandBuilder.append("import image");
        commandBuilder.append(" ");
        commandBuilder.append("-image");
        commandBuilder.append(" ");
        commandBuilder.append(params.getImageID());
        commandBuilder.append(" ");
        commandBuilder.append("-path");
        commandBuilder.append(" ");
        commandBuilder.append(params.getOracleHome());
        commandBuilder.append(" ");
        commandBuilder.append("-imagetype");
        commandBuilder.append(" ");
        commandBuilder.append(this.getImageType(params.getOracleHome()));
        if (params.isAnalyze()) {
            // empty if block
        }
        this._logger.fine("Generated command::" + commandBuilder.toString());
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(commandBuilder.toString());
        return commandList;
    }

    @Override
    public RHPOperation getOperationType() {
        return RHPOperation.CREATE_IMAGE;
    }

    @Override
    public String getStatusMessage(RHPCommandExecutor.Status status, RHPParams params) {
        String statusMsg = "";
        switch (status) {
            case START: {
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPCreateImageCommand.status.msg.start", (Object[])new Object[]{params.getOracleHome()});
                break;
            }
            case SUCCESSFUL: {
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPCreateImageCommand.status.msg.successful", (Object[])new Object[]{params.getOracleHome()});
                break;
            }
            case FAILED: {
                statusMsg = OPatchAutoHelper.getLocalizedString((String)"RHPCreateImageCommand.status.msg.failed", (Object[])new Object[]{params.getOracleHome()});
            }
        }
        return statusMsg;
    }
}

