/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionGroup;
import com.oracle.glcm.patch.auto.OPatchAutoOptions;
import com.oracle.glcm.patch.auto.rhp.StopOptions;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OPatchAutoRHPOptions
extends OPatchAutoOptions {
    private static final Logger _log = Logger.getLogger(OPatchAutoRHPOptions.class.getName());
    public static final String PATCH_LOCATION_KEY = "patch.location";
    public static final String PATCH_DIRECTORY_KEY = "patch.base.directory";
    public static final String PATCH_DIRECTORY_ARG = "-phBaseDir";
    public static final String PATCH_LOCATION_GROUP_KEY = "patch.location.group";
    public static final String HELP_KEY = "help";
    public static final String HELP_ARG = "-help";
    public static final String LOG_KEY = "logfile";
    public static final String LOG_ARG = "-log";
    public static final String LOG_LEVEL_KEY = "logpriority";
    public static final String LOG_LEVEL_ARG = "-loglevel";
    public static final String ANALYZE_KEY = "analyze";
    public static final String ANALYZE_ARG = "-analyze";
    public static final String RHP_KEY = "rhp";
    public static final String RHP_ARG = "-rhp";
    public static final String CREATE_IMAGE_KEY = "create.image";
    public static final String CREATE_IMAGE_ARG = "-create-image";
    public static final String IMAGE_ID_KEY = "image.id";
    public static final String IMAGE_ID_ARG = "-id";
    public static final String SESSION_KEY = "session";
    public static final String SESSION_ARG = "-session";
    public static final String HOME_KEY = "home";
    public static final String HOME_ARG = "-oh";
    public static final String HOST_KEY = "host";
    public static final String HOST_ARG = "-host";
    public static final String INV_PTR_LOC_KEY = "inventory.pointer.location";
    public static final String INV_PTR_LOC_ARG = "-invPtrLoc";
    public static final String CREATE_IMAGE_GROUP_KEY = "create.image.group";
    public static final String APPLY_IMAGE_KEY = "apply.image";
    public static final String APPLY_IMAGE_ARG = "-apply-image";
    public static final String WORKING_COPY_KEY = "working.copy";
    public static final String WORKING_COPY_ARG = "-working-copy";
    public static final String PATH_KEY = "path";
    public static final String PATH_ARG = "-path";
    public static final String APPLY_IMAGE_GROUP_KEY = "apply.image.group";
    public static final String SWITCH_KEY = "switch";
    public static final String SWITCH_ARG = "-switch";
    public static final String NONROLLING_KEY = "nonrolling";
    public static final String NONROLLING_ARG = "-nonrolling";
    public static final String BATCHES_KEY = "batches";
    public static final String BATCHES_ARG = "-batches";
    public static final String SAF_KEY = "saf";
    public static final String SAF_ARG = "-saf";
    public static final String CONTINUE_KEY = "continue";
    public static final String CONTINUE_ARG = "-continue";
    public static final String DRAIN_TIMEOUT_KEY = "drain.timeout";
    public static final String DRAIN_TIMEOUT_ARG = "-drain-timeout";
    public static final String STOP_OPTION_KEY = "stopoption";
    public static final String STOP_OPTION_ARG = "-stopoption";
    public static final String SWITCH_IMAGE_GROUP_KEY = "switch.image.group";
    public static final String CREATE_APPLY_SWITCH_IMAGE_GROUP_KEY = "create.apply.image.group";
    public static final String BATCH_SAF_GROUP_KEY = "batch.saf.group";
    public static final String CREATE_IMAGE_EXCLUDE_GROUP_KEY = "create.image.exclude.group";
    public static final String APPLY_IMAGE_EXCLUDE_GROUP_KEY = "apply.image.exclude.group";
    private Map<OPatchAutoCommand, Set<OPatchAutoOption>> _commandOptions = new HashMap<OPatchAutoCommand, Set<OPatchAutoOption>>();
    private Set<OPatchAutoOption> _globalOptions = new LinkedHashSet<OPatchAutoOption>();
    private Map<OPatchAutoCommand, OPatchAutoOption> _commandParameters = new LinkedHashMap<OPatchAutoCommand, OPatchAutoOption>();
    private Set<OPatchAutoOption> _allOptions = new LinkedHashSet<OPatchAutoOption>();
    private Set<OPatchAutoOptionGroup> _optionGroups = new LinkedHashSet<OPatchAutoOptionGroup>();
    private OPatchAutoCommand _command;
    Set<OPatchAutoOption> _populatedOptions;

    public static OPatchAutoRHPOptions getInstance() {
        return new OPatchAutoRHPOptions();
    }

    protected OPatchAutoRHPOptions() {
        this.loadOptions();
    }

    public Set<OPatchAutoOption> getPopulatedOptions() {
        return this._populatedOptions;
    }

    public void setPopulatedOptions(Set<OPatchAutoOption> populatedOptions) {
        this._populatedOptions = populatedOptions;
    }

    private void loadOptions() {
        OPatchAutoOption help = OPatchAutoOption.getGlobalOption((String)HELP_KEY, (String)HELP_ARG, (String)"opatchauto.option.help.description", (boolean)true, (boolean)false);
        help.setPerCommandGlobal(true);
        this.registerRHPOption(help);
        OPatchAutoOption patchDirectory = OPatchAutoOption.getCommandOption((String)PATCH_DIRECTORY_KEY, (String)PATCH_DIRECTORY_ARG, (String)"opatchauto.option.patchDirectory.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        patchDirectory.setValueValidator(new OPatchAutoOption.ValueValidator(){

            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true) && !new File(value).isDirectory()) {
                    throw new OPatchAutoException("68052", new Object[]{value});
                }
            }
        });
        this.registerRHPOption(patchDirectory);
        OPatchAutoOption patchLocation = OPatchAutoOption.getParameterOption((String)PATCH_LOCATION_KEY, (String)"patch-location", (String)"opatchauto.option.patchLocation.description", (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        patchLocation.setValueValidator(new OPatchAutoOption.ValueValidator(){

            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true) && !new File(value).exists()) {
                    throw new OPatchAutoException("68053", new Object[]{value});
                }
            }
        });
        this.registerRHPOption(patchLocation);
        OPatchAutoOptionGroup patchLocationGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)PATCH_LOCATION_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{patchDirectory, patchLocation});
        this.registerRHPOptionGroup(patchLocationGroup);
        OPatchAutoOption oh = OPatchAutoOption.getCommandOption((String)HOME_KEY, (String)HOME_ARG, (String)"opatchauto.option.oh.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        oh.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            public String getDefaultValue() throws OPatchAutoException {
                return OPatchAutoHelper.getOPatchAutoHome();
            }
        });
        this.registerRHPOption(oh);
        OPatchAutoOption log = OPatchAutoOption.getCommandOption((String)LOG_KEY, (String)LOG_ARG, (String)"opatchauto.option.log.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.action, OPatchAutoCommand.resume});
        log.setTracked(false);
        this.registerRHPOption(log);
        OPatchAutoOption logLevel = OPatchAutoOption.getCommandOption((String)LOG_LEVEL_KEY, (String)LOG_LEVEL_ARG, (String)"opatchauto.option.logLevel.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.action, OPatchAutoCommand.resume});
        logLevel.setDefaultValue("INFO");
        logLevel.setTracked(false);
        logLevel.setSupportedValues(new String[]{OPatchAutoHelper.getSupportedLogLevels().toString()});
        logLevel.setValueValidator(new OPatchAutoOption.ValueValidator(){

            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    try {
                        Level.parse(value.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        throw new OPatchAutoException("68054", new Object[]{value, OPatchAutoHelper.getSupportedLogLevels()});
                    }
                }
            }
        });
        this.registerRHPOption(logLevel);
        OPatchAutoOption session = OPatchAutoOption.getCommandOption((String)SESSION_KEY, (String)SESSION_ARG, (String)"opatchauto.option.session.description", (boolean)false, (boolean)true, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.rollback, OPatchAutoCommand.resume});
        this.registerRHPOption(session);
        OPatchAutoOption analyze = OPatchAutoOption.getCommandOption((String)ANALYZE_KEY, (String)ANALYZE_ARG, (String)"opatchauto.option.analyze.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        this.registerRHPOption(analyze);
        OPatchAutoOption host = OPatchAutoOption.getCommandOption((String)HOST_KEY, (String)HOST_ARG, (String)"opatchauto.option.host.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        host.setDefaultValueResolver(new OPatchAutoOption.DefaultValueResolver(){

            public String getDefaultValue() throws OPatchAutoException {
                return OPatchAutoHelper.getOPatchAutoHost();
            }
        });
        this.registerRHPOption(host);
        OPatchAutoOption inventoryPtr = OPatchAutoOption.getCommandOption((String)INV_PTR_LOC_KEY, (String)INV_PTR_LOC_ARG, (String)"opatchauto.option.inventoryPtr.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        this.registerRHPOption(inventoryPtr);
        OPatchAutoOption rhp = OPatchAutoOption.getCommandOption((String)RHP_KEY, (String)RHP_ARG, (String)"opatchauto.option.rhp.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback, OPatchAutoCommand.resume});
        this.registerRHPOption(rhp);
        OPatchAutoOption createImage = OPatchAutoOption.getCommandOption((String)CREATE_IMAGE_KEY, (String)CREATE_IMAGE_ARG, (String)"opatchauto.option.create.image.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        this.registerRHPOption(createImage);
        OPatchAutoOption imageID = OPatchAutoOption.getCommandOption((String)IMAGE_ID_KEY, (String)IMAGE_ID_ARG, (String)"opatchauto.option.image.id.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        this.registerRHPOption(imageID);
        OPatchAutoOption applyImage = OPatchAutoOption.getCommandOption((String)APPLY_IMAGE_KEY, (String)APPLY_IMAGE_ARG, (String)"opatchauto.option.apply.image.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        this.registerRHPOption(applyImage);
        OPatchAutoOption workingCopy = OPatchAutoOption.getCommandOption((String)WORKING_COPY_KEY, (String)WORKING_COPY_ARG, (String)"opatchauto.option.working.copy.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        this.registerRHPOption(workingCopy);
        OPatchAutoOption path = OPatchAutoOption.getCommandOption((String)PATH_KEY, (String)PATH_ARG, (String)"opatchauto.option.path.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        path.setValueValidator(new OPatchAutoOption.ValueValidator(){

            public void validate(String value) throws OPatchAutoException {
                if (OPatchAutoRHPOptions.this.getOption(OPatchAutoRHPOptions.SWITCH_KEY).isSwitchEnabled() && !StringUtil.isNullOrEmpty((String)value, (boolean)true) && !new File(value).exists()) {
                    throw new OPatchAutoException(Integer.toString(75056), new Object[]{value});
                }
            }
        });
        this.registerRHPOption(path);
        OPatchAutoOption switchImage = OPatchAutoOption.getCommandOption((String)SWITCH_KEY, (String)SWITCH_ARG, (String)"opatchauto.option.switch.image.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply});
        this.registerRHPOption(switchImage);
        OPatchAutoOption nonrolling = OPatchAutoOption.getCommandOption((String)NONROLLING_KEY, (String)NONROLLING_ARG, (String)"opatchauto.option.nonrolling.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        this.registerRHPOption(nonrolling);
        OPatchAutoOption batch = OPatchAutoOption.getCommandOption((String)BATCHES_KEY, (String)BATCHES_ARG, (String)"opatchauto.option.batch.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        batch.setValueValidator(new OPatchAutoOption.ValueValidator(){

            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value)) {
                    Matcher matcher = Pattern.compile("\\[(.*?)\\]").matcher(value);
                    if (matcher.find()) {
                        String firstNode = matcher.group();
                        if (firstNode.contains(",")) {
                            throw new OPatchAutoException(Integer.toString(75059), new Object[]{value});
                        }
                    } else {
                        throw new OPatchAutoException(Integer.toString(75058), new Object[]{value});
                    }
                }
            }
        });
        this.registerRHPOption(batch);
        OPatchAutoOption saf = OPatchAutoOption.getCommandOption((String)SAF_KEY, (String)SAF_ARG, (String)"opatchauto.option.saf.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        saf.setValueValidator(new OPatchAutoOption.ValueValidator(){

            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value)) {
                    if (!StringUtil.isPositiveInteger((String)value)) {
                        throw new OPatchAutoException(Integer.toString(75057), new Object[]{value});
                    }
                    Integer retValue = Integer.valueOf(value).compareTo(100);
                    if (retValue > 0) {
                        throw new OPatchAutoException(Integer.toString(75057), new Object[]{value});
                    }
                }
            }
        });
        this.registerRHPOption(saf);
        OPatchAutoOption continue_option = OPatchAutoOption.getCommandOption((String)CONTINUE_KEY, (String)CONTINUE_ARG, (String)"opatchauto.option.continue.description", (boolean)true, (boolean)false, (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        continue_option.setVisible(false);
        this.registerRHPOption(continue_option);
        OPatchAutoOption drain_timeout = OPatchAutoOption.getCommandOption((String)DRAIN_TIMEOUT_KEY, (String)DRAIN_TIMEOUT_ARG, (String)"opatchauto.option.drain.timeout.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        this.registerRHPOption(drain_timeout);
        OPatchAutoOption stopoption = OPatchAutoOption.getCommandOption((String)STOP_OPTION_KEY, (String)STOP_OPTION_ARG, (String)"opatchauto.option.stop.option.description", (OPatchAutoCommand[])new OPatchAutoCommand[]{OPatchAutoCommand.apply, OPatchAutoCommand.rollback});
        stopoption.setSupportedValues(new String[]{StopOptions.getSupportedValues().toString()});
        stopoption.setValueValidator(new OPatchAutoOption.ValueValidator(){

            public void validate(String value) throws OPatchAutoException {
                if (!StringUtil.isNullOrEmpty((String)value) && !StopOptions.isValidStopOption(value)) {
                    throw new OPatchAutoException(Integer.toString(75061), new Object[]{value, StopOptions.getSupportedValues()});
                }
            }
        });
        this.registerRHPOption(stopoption);
        OPatchAutoOptionGroup createImageExclude = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)CREATE_IMAGE_EXCLUDE_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_exclude_all, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{createImage, batch, saf, analyze, drain_timeout, stopoption});
        this.registerRHPOptionGroup(createImageExclude);
        OPatchAutoOptionGroup applyImageExclude = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)APPLY_IMAGE_EXCLUDE_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_exclude_all, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{applyImage, batch, saf, drain_timeout, stopoption});
        this.registerRHPOptionGroup(applyImageExclude);
        OPatchAutoOptionGroup createApplyImageGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)CREATE_APPLY_SWITCH_IMAGE_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{createImage, applyImage, switchImage});
        this.registerRHPOptionGroup(createApplyImageGroup);
        OPatchAutoOptionGroup batchSafGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)BATCH_SAF_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.mutually_exclusive, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{batch, saf});
        this.registerRHPOptionGroup(batchSafGroup);
        OPatchAutoOptionGroup createImageGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)CREATE_IMAGE_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_all_required, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{createImage, rhp, imageID});
        this.registerRHPOptionGroup(createImageGroup);
        OPatchAutoOptionGroup applyImageGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)APPLY_IMAGE_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_all_required, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{applyImage, rhp, imageID, workingCopy, path});
        this.registerRHPOptionGroup(applyImageGroup);
        OPatchAutoOptionGroup switchImageGroup = OPatchAutoOptionGroup.getOPatchAutoOptionGroup((String)SWITCH_IMAGE_GROUP_KEY, (OPatchAutoOptionGroup.Relationship)OPatchAutoOptionGroup.Relationship.if_first_then_at_least_one_required, (boolean)false, (OPatchAutoOption[])new OPatchAutoOption[]{switchImage, workingCopy, path});
        this.registerRHPOptionGroup(switchImageGroup);
    }

    void registerRHPOption(OPatchAutoOption option) {
        OPatchAutoCommand[] commands;
        if (option == null) {
            throw new NullPointerException(OPatchAutoHelper.getPublishedMessage((String)"68055", (Object[])new Object[0]));
        }
        if (StringUtil.isNullOrEmpty((String)option.getArg())) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage((String)"68056", (Object[])new Object[0]));
        }
        try {
            OPatchAutoOption existingOption = this.geRHPOption(option.getKey(), false);
            if (existingOption != null) {
                throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage((String)"68057", (Object[])new Object[]{option, existingOption}));
            }
        }
        catch (OPatchAutoException e) {
            // empty catch block
        }
        if (option.isGlobal()) {
            this._globalOptions.add(option);
        } else if (option.isParameter()) {
            commands = option.getCommands();
            if (commands != null) {
                for (OPatchAutoCommand command : commands) {
                    if (this._commandParameters.containsKey(command)) {
                        throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage((String)"68058", (Object[])new Object[]{command}));
                    }
                    this._commandParameters.put(command, option);
                }
            }
        } else {
            commands = option.getCommands();
            if (commands != null) {
                for (OPatchAutoCommand command : commands) {
                    Set<OPatchAutoOption> options = this._commandOptions.get(command);
                    if (options == null) {
                        options = new LinkedHashSet<OPatchAutoOption>();
                        this._commandOptions.put(command, options);
                    }
                    options.add(option);
                }
            }
        }
        this._allOptions.add(option);
    }

    void unregisterRHPOption(OPatchAutoOption option) {
        if (option != null) {
            this._globalOptions.remove(option);
            Iterator<Map.Entry<OPatchAutoCommand, OPatchAutoOption>> it = this._commandParameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<OPatchAutoCommand, OPatchAutoOption> entry = it.next();
                if (!option.equals((Object)entry.getValue())) continue;
                it.remove();
            }
            for (Set<OPatchAutoOption> options : this._commandOptions.values()) {
                if (options == null) continue;
                options.remove(option);
            }
            this._allOptions.remove(option);
        }
    }

    public void updateOptionRegistration(OPatchAutoOption option) {
        if (option != null) {
            this.unregisterRHPOption(option);
            this.registerRHPOption(option);
        }
    }

    void registerRHPOptions(Collection<OPatchAutoOption> options) {
        if (options != null) {
            for (OPatchAutoOption option : options) {
                this.registerRHPOption(option);
            }
        }
    }

    void registerRHPOptionGroups(Collection<OPatchAutoOptionGroup> optionGroups) {
        if (optionGroups != null) {
            for (OPatchAutoOptionGroup option : optionGroups) {
                this.registerRHPOptionGroup(option);
            }
        }
    }

    public OPatchAutoCommand getCommand() {
        return this._command;
    }

    public void setCommand(OPatchAutoCommand command) {
        this._command = command;
    }

    Set<OPatchAutoOption> getRHPGlobalOptions() {
        return this._globalOptions;
    }

    public Set<OPatchAutoOption> getAllOptions() {
        return this._allOptions;
    }

    Set<OPatchAutoOption> getRHPCommandOptions(OPatchAutoCommand command) {
        Set<OPatchAutoOption> options = this._commandOptions.get(command);
        return options != null ? new LinkedHashSet<OPatchAutoOption>(options) : new LinkedHashSet();
    }

    Set<OPatchAutoOption> getRequiredRHPCommandOptions(OPatchAutoCommand command) {
        OPatchAutoOption parameter;
        LinkedHashSet<OPatchAutoOption> required = new LinkedHashSet<OPatchAutoOption>();
        Set<OPatchAutoOption> options = this.getRHPCommandOptions(command);
        if (options != null) {
            for (OPatchAutoOption option : options) {
                if (option == null || !option.isRequired()) continue;
                required.add(option);
            }
        }
        if ((parameter = this.getRHPCommandParameter(command)) != null && parameter.isRequired()) {
            required.add(parameter);
        }
        return required;
    }

    OPatchAutoOption getRHPCommandParameter(OPatchAutoCommand command) {
        return this._commandParameters.get(command);
    }

    public OPatchAutoOption getOption(String key) throws OPatchAutoException {
        return this.geRHPOption(key, false);
    }

    OPatchAutoOption geRHPOption(String name, boolean isArg) throws OPatchAutoException {
        Set<OPatchAutoOption> options;
        if (!StringUtil.isNullOrEmpty((String)name, (boolean)true) && (options = this.getAllOptions()) != null && !options.isEmpty()) {
            for (OPatchAutoOption option : options) {
                if ((!isArg || !name.equalsIgnoreCase(option.getArg())) && (isArg || !name.equalsIgnoreCase(option.getKey()))) continue;
                return option;
            }
        }
        String argOrOption = isArg ? OPatchAutoHelper.getLocalizedString((String)"OPatchAutoOptions.argument", (Object[])new Object[0]) : OPatchAutoHelper.getLocalizedString((String)"OPatchAutoOptions.option", (Object[])new Object[0]);
        throw new OPatchAutoException("68059", new Object[]{argOrOption, name});
    }

    void registerRHPOptionGroup(OPatchAutoOptionGroup group) {
        this._optionGroups.add(group);
    }

    Set<OPatchAutoOptionGroup> getRHPOptionGroups() {
        return this._optionGroups;
    }

    public OPatchAutoOptionGroup getOptionGroup(String key) throws OPatchAutoException {
        if (!StringUtil.isNullOrEmpty((String)key)) {
            for (OPatchAutoOptionGroup group : this._optionGroups) {
                if (group == null || !key.equals(group.getKey())) continue;
                return group;
            }
        }
        throw new OPatchAutoException("68060", new Object[]{key});
    }

    public boolean isOptionGroup(String key) {
        if (!StringUtil.isNullOrEmpty((String)key)) {
            for (OPatchAutoOptionGroup group : this._optionGroups) {
                if (group == null || !key.equals(group.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    public Set<OPatchAutoOptionGroup> getRequiredOptionGroups() {
        LinkedHashSet<OPatchAutoOptionGroup> required = new LinkedHashSet<OPatchAutoOptionGroup>();
        Set<OPatchAutoOptionGroup> groups = this.getRHPOptionGroups();
        if (groups != null) {
            for (OPatchAutoOptionGroup group : groups) {
                if (group == null || !group.isRequired()) continue;
                required.add(group);
            }
        }
        return required;
    }

    public void validate(OPatchAutoCommand command) throws OPatchAutoException {
        OPatchAutoOption parameter;
        Set<OPatchAutoOption> options = this.getRHPCommandOptions(command);
        if (options != null) {
            for (OPatchAutoOption option : options) {
                option.validate();
            }
        }
        if ((parameter = this.getRHPCommandParameter(command)) != null && parameter.isRequired()) {
            parameter.validate();
        }
    }

    public void logOptions() throws OPatchAutoException {
        _log.info(((Object)((Object)this)).getClass().getSimpleName() + " configured options:");
        for (OPatchAutoOption option : this.getAllOptions()) {
            String value;
            if (!option.hasValue()) continue;
            if (option.isPassword()) {
                value = "";
                char[] password = option.getPasswordValue();
                if (password != null) {
                    Arrays.fill(password, '*');
                    value = new String(password);
                }
            } else {
                value = option.getValue();
            }
            _log.info("Option: " + option + " Value:" + value);
        }
    }
}

