/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.crlf;

import java.io.File;
import java.io.FileFilter;
import java.util.StringTokenizer;

public class CRLFFileFilter
implements FileFilter {
    private CRLFFilterDef[] _filters = null;
    private boolean _recurse = false;

    public CRLFFileFilter(String filter, boolean recurse) {
        this.setVars(filter);
        this._recurse = recurse;
    }

    private void setVars(String filter) {
        if (filter.indexOf(",") != -1) {
            StringTokenizer toke = new StringTokenizer(filter, ",");
            this._filters = new CRLFFilterDef[toke.countTokens()];
            int x = 0;
            while (toke.hasMoreTokens()) {
                this._filters[x++] = this.getDef(toke.nextToken());
            }
        } else {
            this._filters = new CRLFFilterDef[1];
            this._filters[0] = this.getDef(filter);
        }
    }

    private CRLFFilterDef getDef(String filter) {
        String after;
        String before;
        int index = filter.indexOf("*");
        if (index == -1) {
            before = null;
            after = null;
        } else {
            before = filter.substring(0, index).toLowerCase();
            after = filter.substring(index + 1, filter.length()).toLowerCase();
            if (before.equals("")) {
                before = null;
            }
            if (after.equals("")) {
                after = null;
            }
        }
        return new CRLFFilterDef(filter, before, after);
    }

    @Override
    public boolean accept(File file) {
        if (this._recurse && file.isDirectory()) {
            return true;
        }
        String name = file.getName();
        if (name.equals("")) {
            return false;
        }
        for (int x = 0; x < this._filters.length; ++x) {
            if (!(this._filters[x]._before != null && this._filters[x]._after != null ? name.startsWith(this._filters[x]._before) && this._filters[x]._filter.endsWith(this._filters[x]._after) : (this._filters[x]._before != null ? name.startsWith(this._filters[x]._before) : (this._filters[x]._after != null ? name.endsWith(this._filters[x]._after) : this._filters[x]._filter != null && name.equals(this._filters[x]._filter))))) continue;
            return true;
        }
        return false;
    }

    class CRLFFilterDef {
        public String _filter = null;
        public String _before = null;
        public String _after = null;

        public CRLFFilterDef(String filter, String before, String after) {
            this._filter = filter;
            this._before = before;
            this._after = after;
        }
    }
}

