/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class Xslt {
    public static void main(String[] args) {
        if (args.length < 2) {
            Xslt.usage();
            System.exit(-1);
        }
        StreamSource xmlSource = new StreamSource(new File(args[0]));
        StreamSource xsltSource = new StreamSource(new File(args[1]));
        try {
            if (args.length > 2) {
                FileOutputStream fos = new FileOutputStream(args[2]);
                StreamResult result = new StreamResult(fos);
                Xslt.xsltTransform(xmlSource, xsltSource, result);
            } else {
                System.out.println(Xslt.xsltTransform(xmlSource, xsltSource));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void usage() {
        System.out.println(Xslt.class.getName() + " <xml file> <xsl file> <ouput file>");
    }

    public static String xsltTransform(StreamSource xmlSource, StreamSource xsltSource) throws TransformerException, UnsupportedEncodingException {
        return Xslt.xsltTransform(xmlSource, xsltSource, (Map<String, Object>)null);
    }

    public static void xsltTransform(StreamSource xmlSource, StreamSource xsltSource, Result result) throws TransformerException, UnsupportedEncodingException {
        Xslt.xsltTransform(xmlSource, xsltSource, result, null);
    }

    public static String xsltTransform(StreamSource xmlSource, StreamSource xsltSource, Map<String, Object> params) throws TransformerException, UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(baos);
        Xslt.xsltTransform(xmlSource, xsltSource, result, params);
        return baos.toString("UTF-8");
    }

    public static void xsltTransform(StreamSource xmlSource, StreamSource xsltSource, Result result, Map<String, Object> params) throws TransformerException, UnsupportedEncodingException {
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xsltSource);
        if (params != null) {
            for (String pName : params.keySet()) {
                trans.setParameter(pName, params.get(pName));
            }
        }
        trans.transform(xmlSource, result);
    }
}

