/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.ICommonConstants;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class Wildcard {
    private static final Logger _log = Logger.getLogger(Wildcard.class.getName());
    private String _wildcardRegex;
    private String _wildcardString;
    private PathMatcherSyntax _syntax = PathMatcherSyntax.glob;
    private Object _pathMatcher;
    private static Class<?> _pathMatcherClass;
    private static Object _fileSystem;
    private static Class<?> _fileSystemClass;
    private static Class<?> _pathClass;

    public Wildcard(String wildcard, String pathMatcherSyntax) {
        this(wildcard);
        ResourceBundleManager.manageBundles("comdev", ICommonConstants.COMMON_BUNDLES);
        try {
            _fileSystem = Wildcard.class.getClassLoader().loadClass("java.nio.file.FileSystems").getMethod("getDefault", new Class[0]).invoke(null, new Object[0]);
            _fileSystemClass = Wildcard.class.getClassLoader().loadClass("java.nio.file.FileSystem");
            _pathClass = Wildcard.class.getClassLoader().loadClass("java.nio.file.Path");
            _pathMatcherClass = Wildcard.class.getClassLoader().loadClass("java.nio.file.PathMatcher");
        }
        catch (ClassNotFoundException e) {
            _log.log(Level.SEVERE, "Encountered error while invoking PathMatcher.", e);
            throw new UnsupportedOperationException(ResourceBundleManager.getString("comdev", "Wildcard.error.jdk.patchMatcher"), e);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Encountered error while invoking PathMatcher.", e);
            throw new IllegalStateException(ResourceBundleManager.getString("comdev", "Wildcard.error.load.patchMatcher"), e);
        }
        PathMatcherSyntax syntax = !StringUtil.isNullOrEmpty(pathMatcherSyntax, true) ? PathMatcherSyntax.valueOf(pathMatcherSyntax) : null;
        this._wildcardString = StringUtil.isNullOrEmpty(wildcard, true) ? null : wildcard;
        this._syntax = syntax != null ? syntax : PathMatcherSyntax.glob;
        try {
            this._pathMatcher = _fileSystemClass.getMethod("getPathMatcher", String.class).invoke(_fileSystem, this._syntax.name() + ":" + this._wildcardString);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Encountered error while invoking PathMatcher.", e);
            throw new IllegalStateException(ResourceBundleManager.getString("comdev", "Wildcard.error.load.patchMatcher"), e);
        }
    }

    public Wildcard(String wildcard) {
        if (wildcard != null) {
            LinkedHashMap<Character, String> regexMap = new LinkedHashMap<Character, String>();
            regexMap.put(Character.valueOf('*'), ".*");
            regexMap.put(Character.valueOf('?'), ".");
            this._wildcardRegex = this.getWildcardRegex(wildcard, regexMap);
            if (_log.isLoggable(Level.FINEST)) {
                _log.finest("Created wildcard regex \"" + this._wildcardRegex + "\" from wildcard string \"" + wildcard + "\"");
            }
        }
    }

    private String getWildcardRegex(String wildcard, Map<Character, String> regexMap) {
        String wildcardRegex;
        if (StringUtil.isNullOrEmpty(wildcard)) {
            return wildcard;
        }
        LinkedHashMap<Integer, String> indexes = new LinkedHashMap<Integer, String>();
        char[] chars = wildcard.toCharArray();
        for (int x = 0; x < chars.length; ++x) {
            if (!regexMap.containsKey(Character.valueOf(chars[x]))) continue;
            indexes.put(x, regexMap.get(Character.valueOf(chars[x])));
        }
        if (!indexes.isEmpty()) {
            wildcardRegex = "";
            int prevIndex = 0;
            for (Map.Entry entry : indexes.entrySet()) {
                String subString = wildcard.substring(prevIndex, (Integer)entry.getKey());
                if (!subString.isEmpty()) {
                    wildcardRegex = wildcardRegex + Pattern.quote(subString);
                }
                wildcardRegex = wildcardRegex + (String)entry.getValue();
                prevIndex = (Integer)entry.getKey() + 1;
            }
            if (prevIndex < wildcard.length()) {
                wildcardRegex = wildcardRegex + Pattern.quote(wildcard.substring(prevIndex));
            }
        } else {
            wildcardRegex = Pattern.quote(wildcard);
        }
        return wildcardRegex;
    }

    public boolean matches(String name) {
        if (this._wildcardString != null && _pathMatcherClass != null) {
            try {
                Object path = _fileSystemClass.getMethod("getPath", String.class, String[].class).invoke(_fileSystem, name, new String[0]);
                return (Boolean)_pathMatcherClass.getMethod("matches", _pathClass).invoke(this._pathMatcher, path);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Encountered error while invoking PathMatcher.", e);
                throw new IllegalStateException(Wildcard.getResourceString("Wildcard.error.load.patchMatcher"), e);
            }
        }
        return name != null && this._wildcardRegex != null && name.matches(this._wildcardRegex);
    }

    public String getWildcardRegex() {
        return this._wildcardRegex;
    }

    public static String getResourceString(String key) {
        ResourceBundleManager.manageBundles("comdev", ICommonConstants.COMMON_BUNDLES);
        return ResourceBundleManager.getString("comdev", key);
    }

    public static enum PathMatcherSyntax {
        glob,
        regex;

    }
}

