/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.xml.sax.SAXException;

public class SchemaValidator {
    public static void main(String[] args) {
        try {
            SchemaValidator.validate(new File(args[0]), new File(args[1]));
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void validate(File schemaFile, File xmlFile) throws IOException, SAXException {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(schemaFile);
        StreamSource source = new StreamSource(new FileInputStream(xmlFile));
        SchemaValidator.validate(schema, source);
    }

    public static void validate(Schema schema, Source source) throws IOException, SAXException {
        if (schema == null) {
            throw new NullPointerException("Schema object was null.");
        }
        Validator validator = schema.newValidator();
        validator.validate(source);
    }
}

