/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.jni.JNIUtil;
import com.oracle.cie.common.util.threads.NullOutputThread;
import com.oracle.cie.common.util.threads.OutputThread;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RuntimeExec {
    private static String[] _envBlock = null;
    protected static final Logger s_logger = Logger.getLogger(RuntimeExec.class.getName());

    public static boolean exec(String command, OutputStream out, boolean wait) {
        return RuntimeExec.exec(command, null, null, out, wait, false);
    }

    public static boolean exec(String command, OutputStream out, boolean wait, boolean passEnv) {
        return RuntimeExec.exec(command, null, null, out, wait, passEnv);
    }

    public static boolean exec(String command, File dir, OutputStream out, boolean wait) {
        return RuntimeExec.exec(command, null, dir, out, wait, false);
    }

    public static boolean exec(String command, File dir, OutputStream out, boolean wait, boolean passEnv) {
        return RuntimeExec.exec(command, null, dir, out, wait, passEnv);
    }

    public static boolean exec(String command, String[] env, File dir, OutputStream out, boolean wait, boolean passEnv) {
        s_logger.fine("Execing: " + command);
        try {
            if (env == null && passEnv) {
                if (_envBlock == null) {
                    _envBlock = JNIUtil.getEnvBlock();
                }
                env = _envBlock;
            }
            Process p = Runtime.getRuntime().exec(command, env, dir);
            OutputThread output = new OutputThread(p.getInputStream(), "output", out);
            OutputThread error = new OutputThread(p.getErrorStream(), "error", out);
            output.start();
            error.start();
            if (wait) {
                try {
                    return p.waitFor() == 0;
                }
                catch (InterruptedException ie) {
                    s_logger.log(Level.SEVERE, "Process interrupted: " + command, ie);
                    output.interrupt();
                    error.interrupt();
                    p.destroy();
                    return true;
                }
            }
            return true;
        }
        catch (Exception e) {
            s_logger.log(Level.SEVERE, "Error execing " + command, e);
            return false;
        }
    }

    public static int exec(List<String> command, Map<String, String> env, File dir, InputStream in, OutputStream out, OutputStream err, boolean wait) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.directory(dir);
        pb.redirectErrorStream(out != null && out.equals(err));
        if (env != null) {
            Map<String, String> processEnv = pb.environment();
            processEnv.clear();
            processEnv.putAll(env);
        }
        final Process p = pb.start();
        Thread output = out != null ? new OutputThread(p.getInputStream(), "output", out) : new NullOutputThread(p.getInputStream(), "output");
        Thread error = err != null ? new OutputThread(p.getErrorStream(), "error", err) : new NullOutputThread(p.getErrorStream(), "error");
        output.start();
        error.start();
        if (in != null) {
            OutputThread input = new OutputThread(in, "input", p.getOutputStream()){

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    finally {
                        try {
                            p.getOutputStream().close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            };
            input.start();
        } else {
            p.getOutputStream().close();
        }
        if (wait) {
            try {
                output.join();
                error.join();
                return p.waitFor();
            }
            catch (InterruptedException ie) {
                output.interrupt();
                error.interrupt();
                p.destroy();
                throw new IOException(ie);
            }
        }
        return 0;
    }
}

