/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ResourceLoaderHelper {
    private static final Pattern _pattern = Pattern.compile("file:(.+)!/(.+)");

    public static InputStream getResourceAsStream(final Class aClass, String aName) {
        final String resolvedName = ResourceLoaderHelper.resolveName(aName, aClass);
        try {
            return ResourceLoaderHelper.openStream(ResourceLoaderHelper.getResource(aClass == null, resolvedName, new RLHGetResourceCommand(){

                @Override
                public URL getResource() {
                    return aClass.getResource(resolvedName);
                }
            }));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(final ClassLoader aClassLoader, final String aName) {
        try {
            return ResourceLoaderHelper.openStream(ResourceLoaderHelper.getResource(aClassLoader == null, aName, new RLHGetResourceCommand(){

                @Override
                public URL getResource() {
                    return aClassLoader.getResource(aName);
                }
            }));
        }
        catch (IOException e) {
            return null;
        }
    }

    public static InputStream openStream(URL aURL) throws IOException {
        InputStream result;
        block3: {
            if (aURL == null) {
                return null;
            }
            try {
                result = aURL.openStream();
            }
            catch (IOException e) {
                result = ResourceLoaderHelper.tryToWorkAroundJDKBug(aURL);
                if (result != null) break block3;
                throw e;
            }
        }
        return result;
    }

    public static Properties getResourceAsProperties(Class aClass, String aName) throws IOException {
        InputStream is;
        Properties props = null;
        if (aName != null) {
            String resource = ResourceLoaderHelper.resolveName(aName, aClass);
            if (!resource.startsWith("/")) {
                resource = "/" + resource;
            }
            is = ResourceLoaderHelper.getResourceAsStream(aClass, resource);
        } else if (aClass != null) {
            String resource = ResourceLoaderHelper.resolveName(aClass.getSimpleName() + ".properties", aClass);
            if (!resource.startsWith("/")) {
                resource = "/" + resource;
            }
            is = ResourceLoaderHelper.getResourceAsStream(aClass, resource);
        } else {
            throw new IllegalArgumentException("Both the class name and resource name may not be null.");
        }
        if (is != null) {
            props = new Properties();
            props.load(is);
        }
        return props;
    }

    private static URL getResource(boolean getSystemResource, String aResource, RLHGetResourceCommand RLHCommand) {
        if (getSystemResource) {
            return ClassLoader.getSystemResource(aResource);
        }
        return RLHCommand.getResource();
    }

    private static InputStream tryToWorkAroundJDKBug(URL aURL) {
        if (!"jar".equals(aURL.getProtocol())) {
            return null;
        }
        try {
            Matcher m = _pattern.matcher(URLDecoder.decode(aURL.getPath(), "UTF-8"));
            if (!m.matches()) {
                return null;
            }
            if (m.group(2).indexOf(32) == -1) {
                return null;
            }
            JarFile jf = new JarFile(m.group(1));
            JarEntry je = jf.getJarEntry(m.group(2));
            if (je == null) {
                jf.close();
                return null;
            }
            return new RLHFilterInputStream(jf.getInputStream(je), jf);
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String resolveName(String aName, Class aClass) {
        if (aName == null) {
            return aName;
        }
        if (!aName.startsWith("/")) {
            if (aClass != null) {
                while (aClass.isArray()) {
                    aClass = aClass.getComponentType();
                }
                String baseName = aClass.getName();
                int index = baseName.lastIndexOf(46);
                if (index != -1) {
                    aName = baseName.substring(0, index).replace('.', '/') + "/" + aName;
                }
            } else {
                aName = aName.substring(1);
            }
        }
        return aName;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        URL[] urls = new URL[]{new URL("file:///D:/downloads/test.jar")};
        URLClassLoader cl = new URLClassLoader(urls, ClassLoader.getSystemClassLoader());
        String res = "resources/bids/a b.xml";
        ResourceLoaderHelper.debugPrint(ResourceLoaderHelper.getResourceAsStream(cl, res));
        Class<?> clazz = cl.loadClass("Test");
        ResourceLoaderHelper.debugPrint(ResourceLoaderHelper.getResourceAsStream(clazz, res));
    }

    private static void debugPrint(InputStream is) throws IOException {
        if (is == null) {
            System.out.println("failed!!");
        } else {
            int i;
            while ((i = is.read()) != -1) {
                System.out.print((char)i);
            }
            is.close();
            System.out.println("\n");
        }
    }

    private static interface RLHGetResourceCommand {
        public URL getResource();
    }

    private static final class RLHFilterInputStream
    extends FilterInputStream {
        private final JarFile _jarFile;
        private boolean _closed;

        private RLHFilterInputStream(InputStream is, JarFile aJarFile) {
            super(is);
            this._jarFile = aJarFile;
            this._closed = false;
        }

        @Override
        public void close() throws IOException {
            if (this._closed) {
                return;
            }
            super.close();
            this._jarFile.close();
        }

        protected void finalize() throws Throwable {
            this.close();
            super.finalize();
        }
    }
}

