/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.PublishedMessage;
import com.oracle.cie.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceBundleManager {
    public static final String PUBLIC_NAMESPACE = "public";
    public static final String EXTENDED_LOGGING = "resource.extended.logging";
    private static final Logger s_log = Logger.getLogger(ResourceBundleManager.class.getName());
    private static Locale s_locale = Locale.getDefault();
    private static HashMap<String, ResourceNamespace> s_namespaces = new HashMap();
    private static ClassLoader s_loader = ResourceBundleManager.class.getClassLoader();

    public static void setClassLoader(ClassLoader loader) {
        s_loader = loader;
    }

    public static void manageBundle(String namespace, String baseName, ClassLoader loader) throws MissingResourceException {
        ResourceNamespace resourceNamespace = s_namespaces.get(namespace);
        if (resourceNamespace == null) {
            resourceNamespace = new ResourceNamespace(namespace);
            s_namespaces.put(namespace, resourceNamespace);
        }
        s_log.fine("Attempting to manage resource bundle (" + baseName + ") in namespace (" + namespace + ") in locale (" + s_locale + ").");
        if (loader != null) {
            resourceNamespace.manageBundle(baseName, loader);
        } else {
            resourceNamespace.manageBundle(baseName, s_loader);
        }
    }

    public static void manageBundle(String namespace, String baseName) throws MissingResourceException {
        ResourceBundleManager.manageBundle(namespace, baseName, s_loader);
    }

    public static void manageBundles(String namespace, String ... bundles) throws MissingResourceException {
        ResourceBundleManager.manageBundles(s_loader, namespace, bundles);
    }

    public static void manageBundles(ClassLoader loader, String namespace, String ... bundles) throws MissingResourceException {
        for (String bundle : bundles) {
            ResourceBundleManager.manageBundle(namespace, bundle, loader);
        }
    }

    public static void releaseBundle(String namespace, String baseName) throws MissingResourceException {
        ResourceNamespace resourceNamespace = s_namespaces.get(namespace);
        if (resourceNamespace == null) {
            throw new MissingResourceException("Not managing namespace: (" + namespace + ").", baseName, "");
        }
        resourceNamespace.releaseBundle(baseName);
    }

    public static void removeNamespace(String namespace) {
        s_namespaces.remove(namespace);
    }

    public static void setLocale(Locale locale) throws MissingResourceException {
        if (s_log.isLoggable(Level.FINE)) {
            s_log.fine("Locale changed from " + s_locale.getDisplayName() + " to " + locale.getDisplayName());
        }
        s_locale = locale;
        for (ResourceNamespace resourceNamespace : s_namespaces.values()) {
            resourceNamespace.changeLocale();
        }
    }

    public static Locale getLocale() {
        return s_locale;
    }

    public static List getSuppliedLocales() {
        ArrayList<Locale> localeList = new ArrayList<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        for (ResourceNamespace resourceNamespace : s_namespaces.values()) {
            ListIterator<Locale> lit = localeList.listIterator();
            while (lit.hasNext()) {
                Locale locale = lit.next();
                if (resourceNamespace.isLocaleSupported(locale)) continue;
                lit.remove();
            }
        }
        return localeList;
    }

    public static String getString(String key) throws MissingResourceException {
        return ResourceBundleManager.getString(PUBLIC_NAMESPACE, key);
    }

    public static String getString(String namespace, String key) throws MissingResourceException {
        ResourceNamespace resourceNamespace = s_namespaces.get(namespace);
        if (resourceNamespace == null) {
            s_log.fine("Not managing namespace: (" + namespace + ").");
            throw new MissingResourceException("Not managing namespace: (" + namespace + ").", namespace, key);
        }
        String value = resourceNamespace.getString(key);
        if (s_log.isLoggable(Level.FINE) && Boolean.getBoolean(EXTENDED_LOGGING)) {
            s_log.fine("Retrieved (" + value + ") under key (" + key + ") from namespace <" + namespace + ">.");
        }
        return value;
    }

    public static PublishedMessage getPublishedMessage(String code, Object ... causeParams) throws MissingResourceException {
        return ResourceBundleManager.getPublishedMessage(PUBLIC_NAMESPACE, code, causeParams);
    }

    public static PublishedMessage getPublishedMessage(String namespace, String code, Object ... causeParams) throws MissingResourceException {
        String cause;
        String text;
        ResourceNamespace resourceNamespace = s_namespaces.get(namespace);
        if (resourceNamespace == null) {
            s_log.fine("Not managing namespace: (" + namespace + ").");
            throw new MissingResourceException("Not managing namespace: (" + namespace + ").", namespace, code);
        }
        if (code == null || !StringUtil.isPositiveInteger(code)) {
            s_log.fine("The code (" + code + ") is null or not an integer.");
            return null;
        }
        StringBuilder undefinedParams = new StringBuilder();
        String prefix = resourceNamespace.getPrefix();
        PublishedMessage.Type type = ResourceBundleManager.getType(code, resourceNamespace.getString("TYPE-" + code));
        String name = resourceNamespace.getString("NAME-" + code);
        if (name == null || name.isEmpty()) {
            undefinedParams.append("NAME");
        }
        if ((text = resourceNamespace.getString("TEXT-" + code)) == null || text.isEmpty()) {
            if (undefinedParams.length() > 0) {
                undefinedParams.append(", ");
            }
            undefinedParams.append("TEXT");
        }
        if ((cause = resourceNamespace.getString("CAUSE-" + code)) == null || cause.isEmpty()) {
            if (undefinedParams.length() > 0) {
                undefinedParams.append(", ");
            }
            undefinedParams.append("CAUSE");
        }
        String action = resourceNamespace.getString("ACTION-" + code);
        if (cause == null || cause.isEmpty()) {
            if (undefinedParams.length() > 0) {
                undefinedParams.append(", ");
            }
            undefinedParams.append("ACTION");
        }
        if (undefinedParams.length() > 0) {
            s_log.warning("The message " + code + " has the following elements undefined: " + undefinedParams);
            return null;
        }
        PublishedMessage msg = new PublishedMessage(prefix, code, type, name, text, cause, action);
        if (causeParams != null && causeParams.length > 0) {
            msg.setParams(causeParams);
        }
        return msg;
    }

    private static PublishedMessage.Type getType(String number, String value) {
        if (value != null) {
            try {
                return PublishedMessage.Type.valueOf(value);
            }
            catch (Throwable ex) {
                s_log.warning("Unsupported message type: " + value);
            }
        }
        int num = -1;
        try {
            num = Integer.parseInt(number);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (num > 0 && num <= 20000) {
            return PublishedMessage.Type.TRACE;
        }
        if (num > 20000 && num <= 40000) {
            return PublishedMessage.Type.NOTIFICATION;
        }
        if (num > 40000 && num <= 60000) {
            return PublishedMessage.Type.WARNING;
        }
        if (num > 60000 && num <= 80000) {
            return PublishedMessage.Type.ERROR;
        }
        if (num > 80000 && num <= 100000) {
            return PublishedMessage.Type.ERROR;
        }
        return PublishedMessage.Type.FAULT;
    }

    public static String substitute(String str) throws MissingResourceException {
        return ResourceBundleManager.substitute(PUBLIC_NAMESPACE, str);
    }

    public static String substitute(String namespace, String str) throws MissingResourceException {
        if (str == null) {
            return "";
        }
        int firstdollar = str.indexOf(36);
        if (firstdollar == -1) {
            return str;
        }
        int seconddollar = str.indexOf(36, firstdollar + 1);
        if (seconddollar == -1) {
            return str;
        }
        String stringstart = str.substring(0, firstdollar);
        String sub = ResourceBundleManager.getString(namespace, str.substring(firstdollar + 1, seconddollar));
        String tmpstr = str.substring(seconddollar + 1, str.length());
        stringstart = tmpstr.indexOf(36) == -1 ? stringstart + sub + tmpstr : stringstart + sub + ResourceBundleManager.substitute(namespace, tmpstr);
        return stringstart;
    }

    public static void setPrefix(String namespace, String prefix) throws IllegalArgumentException {
        ResourceNamespace resourceNamespace = s_namespaces.get(namespace);
        if (resourceNamespace == null) {
            s_log.fine("Not managing namespace: (" + namespace + ").");
            throw new IllegalArgumentException("Not managing namespace: (" + namespace + ").");
        }
        resourceNamespace.setPrefix(prefix);
    }

    static {
        s_namespaces.put(PUBLIC_NAMESPACE, new ResourceNamespace(PUBLIC_NAMESPACE));
    }

    private static class ResourceNamespace {
        private static final int DEFAULT_NAMESPACE_SIZE = 50;
        private String _name = "";
        private HashMap<String, String> _map = new HashMap(50);
        private LinkedHashMap<String, ClassLoader> _managedBundles = new LinkedHashMap();
        private String _prefix;

        private ResourceNamespace(String name) {
            if (name == null) {
                throw new IllegalArgumentException("Resource Namespace must be non-null!");
            }
            this._name = name;
        }

        String getName() {
            return this._name;
        }

        void manageBundle(String baseName, ClassLoader loader) throws MissingResourceException {
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, s_locale, loader);
            String str = "".equals(bundle.getLocale().toString()) ? "base" : bundle.getLocale().toString();
            s_log.fine("Actual Resource Bundle Managed: " + str);
            Enumeration<String> enumeration = bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                this._map.put(key, bundle.getString(key));
            }
            this._managedBundles.put(baseName, loader);
        }

        void releaseBundle(String baseName) {
            ClassLoader loader = (ClassLoader)this._managedBundles.remove(baseName);
            if (loader == null) {
                return;
            }
            if (this._managedBundles.size() == 0) {
                this._map.clear();
                return;
            }
            ResourceBundle bundle = ResourceBundle.getBundle(baseName, s_locale, loader);
            Enumeration<String> enumeration = bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String key = enumeration.nextElement();
                this._map.remove(key);
            }
        }

        void changeLocale() throws MissingResourceException {
            this._map.clear();
            for (String baseName : this._managedBundles.keySet()) {
                this.manageBundle(baseName, this._managedBundles.get(baseName != null ? baseName : ""));
            }
        }

        boolean isLocaleSupported(Locale locale) {
            Iterator<String> iterator = this._managedBundles.keySet().iterator();
            while (iterator.hasNext()) {
                String baseName;
                ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale, this._managedBundles.get((baseName = iterator.next()) != null ? baseName : ""));
                if (bundle != null && bundle.getLocale().equals(locale)) continue;
                return false;
            }
            return true;
        }

        String getString(String key) {
            return this._map.get(key);
        }

        void setPrefix(String prefix) {
            this._prefix = prefix;
        }

        String getPrefix() {
            return this._prefix;
        }
    }
}

