/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestBuilder {
    public static Manifest getManifestFromStrings(Map<String, String> mainAttribsMap) throws IOException {
        return ManifestBuilder.getManifestFromStrings(mainAttribsMap, null);
    }

    public static Manifest getManifestFromStrings(Map<String, String> mainAttribsMap, Map<String, Map<String, String>> sectionAttribsMap) throws IOException {
        Attributes mainAttributes = null;
        HashMap<String, Attributes> sectionAttributes = null;
        if (mainAttribsMap != null && !mainAttribsMap.isEmpty()) {
            mainAttributes = new Attributes();
            for (String name : mainAttribsMap.keySet()) {
                mainAttributes.put(new Attributes.Name(name), mainAttribsMap.get(name));
            }
        }
        if (sectionAttribsMap != null && !sectionAttribsMap.isEmpty()) {
            sectionAttributes = new HashMap<String, Attributes>();
            for (String section : sectionAttribsMap.keySet()) {
                Map<String, String> attribs = sectionAttribsMap.get(section);
                Attributes secAttributes = new Attributes();
                for (String name : attribs.keySet()) {
                    secAttributes.put(new Attributes.Name(name), attribs.get(name));
                }
                sectionAttributes.put(section, secAttributes);
            }
        }
        return ManifestBuilder.getManifest(mainAttributes, sectionAttributes);
    }

    public static Manifest getManifest(Map<Attributes.Name, String> mainAttribsMap) throws IOException {
        return ManifestBuilder.getManifest(mainAttribsMap, null);
    }

    public static Manifest getManifest(Map<Attributes.Name, String> mainAttribsMap, Map<String, Map<Attributes.Name, String>> sectionAttribsMap) throws IOException {
        Attributes mainAttributes = null;
        HashMap<String, Attributes> sectionAttributes = null;
        if (mainAttribsMap != null && !mainAttribsMap.isEmpty()) {
            mainAttributes = new Attributes();
            for (Attributes.Name name : mainAttribsMap.keySet()) {
                mainAttributes.put(name, mainAttribsMap.get(name));
            }
        }
        if (sectionAttribsMap != null && !sectionAttribsMap.isEmpty()) {
            sectionAttributes = new HashMap<String, Attributes>();
            for (String section : sectionAttribsMap.keySet()) {
                Map<Attributes.Name, String> attribs = sectionAttribsMap.get(section);
                Attributes secAttributes = new Attributes();
                for (Attributes.Name name : attribs.keySet()) {
                    secAttributes.put(name, attribs.get(name));
                }
                sectionAttributes.put(section, secAttributes);
            }
        }
        return ManifestBuilder.getManifest(mainAttributes, sectionAttributes);
    }

    public static Manifest getManifest(Attributes mainAttribs, Map<String, Attributes> sectionAttribs) throws IOException {
        StringBuilder manifestString = null;
        if (mainAttribs != null) {
            manifestString = new StringBuilder();
            manifestString.append(ManifestBuilder.getManifestSection(mainAttribs));
        }
        if (sectionAttribs != null && !sectionAttribs.isEmpty()) {
            if (manifestString == null) {
                manifestString = new StringBuilder();
            }
            for (String name : sectionAttribs.keySet()) {
                manifestString.append("\n").append("Name: ").append(name).append("\n");
                manifestString.append(ManifestBuilder.getManifestSection(sectionAttribs.get(name)));
            }
        }
        return manifestString != null ? new Manifest(new ByteArrayInputStream(manifestString.toString().getBytes("UTF-8"))) : new Manifest();
    }

    public static String getManifestSection(Attributes attr) {
        StringBuilder manifestString = new StringBuilder();
        if (attr != null) {
            for (Object key : attr.keySet()) {
                Object obj = attr.get(key);
                String value = "";
                if (obj != null) {
                    value = obj.toString();
                }
                if (value.contains("\n ")) {
                    value = value.replaceAll("\n ", "");
                }
                if (value.contains("\n")) {
                    value = value.replaceAll("\n", "");
                }
                manifestString.append(key).append(": ").append(StringUtil.wrapString(value, 70, " ")).append("\n");
            }
        }
        return manifestString.toString();
    }
}

