/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Grep {
    private static Charset _charset = Charset.forName("ISO-8859-15");
    private static CharsetDecoder _decoder = _charset.newDecoder();
    private static Pattern _linePattern = Pattern.compile(".*\r?\n");

    public static String[] grep(File f, String pattern) throws IOException, PatternSyntaxException {
        return Grep.grep(f, Pattern.compile(pattern));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] grep(File f, Pattern pattern) throws IOException {
        FileInputStream fis = null;
        AbstractInterruptibleChannel fc = null;
        try {
            fis = new FileInputStream(f);
            fc = fis.getChannel();
            int sz = (int)((FileChannel)fc).size();
            MappedByteBuffer bb = ((FileChannel)fc).map(FileChannel.MapMode.READ_ONLY, 0L, sz);
            CharBuffer cb = _decoder.decode(bb);
            String[] stringArray = Grep.grep(cb, pattern);
            return stringArray;
        }
        finally {
            if (fc != null) {
                try {
                    fc.close();
                }
                catch (IOException iOException) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String[] grep(CharBuffer cb, Pattern pattern) {
        ArrayList<String> matches = new ArrayList<String>();
        Matcher lm = _linePattern.matcher(cb);
        Matcher pm = null;
        while (lm.find()) {
            String cs = lm.group();
            if (pm == null) {
                pm = pattern.matcher(cs);
            } else {
                pm.reset(cs);
            }
            if (pm.find()) {
                matches.add(cs.toString());
            }
            if (lm.end() != cb.limit()) continue;
            break;
        }
        return matches.toArray(new String[matches.size()]);
    }
}

