/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import com.oracle.cie.common.util.FileLister;
import com.oracle.cie.common.util.IoBridge;
import com.oracle.cie.common.util.IoBridgeImpl;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;

final class FileListerImpl
extends FileLister {
    private static final Logger _log = Logger.getLogger(FileListerImpl.class.getName());
    static final String ASTERISK = "*";
    private IoBridge _ioBridge;

    public FileListerImpl(IoBridge ioBridge) {
        this._ioBridge = ioBridge == null ? new IoBridgeImpl() : ioBridge;
    }

    public static void main(String[] args) {
        String pathWithPattern = args.length > 0 ? args[0] : "d:\\weblogic\\dev\\src*\\release\\iautils\\*";
        try {
            FileLister fl = FileLister.getInstance();
            Vector<File> vfiles = fl.getAllFilesAllowWildCards(pathWithPattern);
            System.out.println("getAllFilesAllowWildCards(\"" + pathWithPattern + "\") returns:");
            Enumeration<File> e = vfiles.elements();
            while (e.hasMoreElements()) {
                System.out.println(e.nextElement().getPath());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public Vector<String> getAllFilesAllowWildCardsStrings(String pathWithPattern) {
        Vector<String> retval = new Vector<String>();
        int indexOfWc = pathWithPattern.indexOf(ASTERISK);
        if (indexOfWc < 0) {
            return this.getAllChildFiles(pathWithPattern);
        }
        for (int numTries = 0; numTries < 2; ++numTries) {
            WildCardFilenameFilter filter;
            String[] childrenNames;
            String head = pathWithPattern.substring(0, indexOfWc);
            String tail = indexOfWc < pathWithPattern.length() - 1 ? pathWithPattern.substring(indexOfWc + 1) : "";
            String parent = this._ioBridge.getParent(head + "foo");
            if (parent == null) {
                _log.fine("parent is not specified in the head, get parent of the head's absolute file");
                parent = this._ioBridge.getParent(head + "foo", true);
            }
            String pattern = pathWithPattern;
            int nextSeparator = -1;
            if (tail.length() > 0) {
                nextSeparator = pathWithPattern.indexOf(File.separator, indexOfWc + 1);
            }
            if (nextSeparator > indexOfWc) {
                pattern = pathWithPattern.substring(0, nextSeparator);
            }
            if ((childrenNames = this._ioBridge.list(parent, filter = new WildCardFilenameFilter(pattern))) != null) {
                for (String childName : childrenNames) {
                    String path = this._ioBridge.getAbsolutePath(parent) + File.separator + childName;
                    if (nextSeparator < indexOfWc) {
                        if (!this._ioBridge.isFile(path)) continue;
                        retval.add(path);
                        continue;
                    }
                    if (!this._ioBridge.isDirectory(path)) continue;
                    if (nextSeparator == pathWithPattern.length() - 1) {
                        retval.addAll(this.getAllChildFiles(path));
                        continue;
                    }
                    String newpattern = path + File.separator + pathWithPattern.substring(nextSeparator + 1);
                    retval.addAll(this.getAllFilesAllowWildCardsStrings(newpattern));
                }
            }
            if (!retval.isEmpty() || !File.separator.equals("\\") || !pathWithPattern.contains("/")) break;
            pathWithPattern = pathWithPattern.replace("/", File.separator);
            _log.fine("detected \"/\" in pathWithPattern on Windows, replace with \"\\\"");
        }
        return retval;
    }

    public Vector<String> getAllChildFiles(String rootfile) {
        Vector<String> retFiles = new Vector<String>();
        if (this._ioBridge.exists(rootfile)) {
            if (!this._ioBridge.isDirectory(rootfile)) {
                retFiles.add(rootfile);
            } else {
                String[] files;
                for (String file : files = this._ioBridge.list(rootfile)) {
                    retFiles.addAll(this.getAllChildFiles(rootfile + File.separator + file));
                }
            }
        }
        return retFiles;
    }

    class WildCardFilenameFilter
    implements FilenameFilter {
        private String _pattern;
        private boolean _endsWithWc;

        public WildCardFilenameFilter(String pattern) {
            this._pattern = pattern;
            this._endsWithWc = this._pattern.endsWith(FileListerImpl.ASTERISK);
        }

        @Override
        public boolean accept(File dir, String name) {
            String fullpath = dir + File.separator + name;
            StringTokenizer tokenizedPattern = new StringTokenizer(this._pattern, FileListerImpl.ASTERISK);
            while (tokenizedPattern.hasMoreTokens()) {
                String subpattern = tokenizedPattern.nextToken();
                int start = fullpath.indexOf(subpattern);
                if (start < 0) {
                    return false;
                }
                fullpath = fullpath.substring(start + subpattern.length());
            }
            return fullpath.length() == 0 || this._endsWithWc;
        }
    }
}

