/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class FileDiff {
    private static final String[] binaries = new String[]{"a", "adapters", "as", "asc", "au", "bin", "bmp", "cl", "class", "crt", "db", "deploy", "der", "dll", "doc", "docx", "dylib", "ecs", "examples", "exe", "gar", "gif", "icns", "icns", "ico", "jks", "jnilib", "jpg", "jsb", "jsc", "ks", "mgmt", "nbm", "pdb", "pdf", "plugins", "png", "prm", "psp", "res", "sl", "so", "soa", "sso", "strings", "swf", "TAB", "thirdparty", "tlb", "tmp", "uue", "xls", "xlsx", "xsb"};

    private static boolean isBinary(File file) {
        String entryName = file.getName();
        String extension = entryName.substring(entryName.lastIndexOf(".") + 1);
        for (String binary : binaries) {
            if (!extension.equals(binary)) continue;
            return true;
        }
        return false;
    }

    public static String diff(File file1, File file2) throws IOException {
        return FileDiff.diff(file1, file2, false);
    }

    public static String diff(File file1, File file2, boolean showBinaryDiff) throws IOException {
        int j;
        int i;
        String binMsg = "Binary difference.";
        if (!showBinaryDiff && (FileDiff.isBinary(file1) || FileDiff.isBinary(file2))) {
            return binMsg;
        }
        StringBuilder strBuilder = new StringBuilder();
        if (showBinaryDiff) {
            strBuilder.append(binMsg + "\n");
        }
        String[] x = FileDiff.readFile(file1).split("\\n");
        String[] y = FileDiff.readFile(file2).split("\\n");
        int M = x.length;
        int N = y.length;
        if (M > 4096 || N > 4096) {
            return "Diff too large.";
        }
        byte[][] opt = new byte[M + 1][N + 1];
        for (i = M - 1; i >= 0; --i) {
            for (j = N - 1; j >= 0; --j) {
                opt[i][j] = x[i].equals(y[j]) ? (byte)(opt[i + 1][j + 1] + 1) : (byte)Math.max(opt[i + 1][j], opt[i][j + 1]);
            }
        }
        i = 0;
        j = 0;
        while (i < M && j < N) {
            if (x[i].equals(y[j])) {
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                strBuilder.append("< " + x[i++] + "\n");
                continue;
            }
            strBuilder.append("> " + y[j++] + "\n");
        }
        while (i < M || j < N) {
            if (i == M) {
                strBuilder.append("> " + y[j++] + "\n");
                continue;
            }
            if (j != N) continue;
            strBuilder.append("< " + x[i++] + "\n");
        }
        return strBuilder.toString();
    }

    static String readFile(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        FileInputStream f = new FileInputStream(file);
        f.read(buffer);
        return new String(buffer);
    }
}

